/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIBosUserRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.common.HRPIValueConstants;

public class CreatePersonUserRelTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(CreatePersonUserRelTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("createDataStart");
        try {
            this.batchHandleQueryData();
        }
        catch (Exception ec) {
            LOGGER.error("CreatePersonUserRelTaskException", (Throwable)ec);
        }
        LOGGER.info("createDataEnd");
    }

    public void batchHandleQueryData() {
        int batCount = 5000;
        List<Map<String, Object>> temList = null;
        long id = 0L;
        Map<Object, DynamicObject> labStatusMap = this.getLabStatus();
        while ((temList = HRPIEmployeeRepository.queryPersonUserRelAndEmpBySql(id, batCount, labStatusMap)) != null && temList.size() > 0) {
            Map<String, Object> tmpMap = temList.get(temList.size() - 1);
            id = (Long)tmpMap.get("employee");
            if (!this.createRelData(temList) || temList.size() >= batCount) continue;
            break;
        }
    }

    private Map<Object, DynamicObject> getLabStatus() {
        QFilter qFilter = new QFilter("labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"id", (QFilter[])new QFilter[]{qFilter, enableFilter});
        if (!CollectionUtils.isEmpty((Map)entityCfMap)) {
            return entityCfMap;
        }
        return new HashMap<Object, DynamicObject>(16);
    }

    private boolean createRelData(List<Map<String, Object>> tempList) {
        HRBaseServiceHelper personUserRelHelper = HRPIBosUserRepository.getPersonUserRelHelper();
        DynamicObjectCollection saveDys = new DynamicObjectCollection();
        List<String> numberList = tempList.stream().map(tmp -> (String)tmp.get("number")).collect(Collectors.toList());
        Map<String, DynamicObject> bosUserMap = this.getBosUserInfo(numberList);
        for (Map<String, Object> tmpMap : tempList) {
            String number = (String)tmpMap.get("number");
            if (HRMapUtils.isEmpty(bosUserMap) || bosUserMap.get(number) == null) continue;
            DynamicObject personUserRelDy = personUserRelHelper.generateEmptyDynamicObject();
            personUserRelDy.set("createtime", (Object)new Date());
            this.buildCommonDy(bosUserMap, tmpMap, number, personUserRelDy, saveDys);
        }
        if (!CollectionUtils.isEmpty((Collection)saveDys)) {
            personUserRelHelper.save(saveDys);
        }
        return true;
    }

    private void buildCommonDy(Map<String, DynamicObject> bosUserMap, Map<String, Object> tmpMap, String number, DynamicObject personUserRelDy, DynamicObjectCollection saveDys) {
        personUserRelDy.set("person", tmpMap.get("person"));
        personUserRelDy.set("personindexid", tmpMap.get("personindexid"));
        personUserRelDy.set("employee", tmpMap.get("employee"));
        personUserRelDy.set("mid", tmpMap.get("mid"));
        personUserRelDy.set("enable", tmpMap.get("labrelstatusprd"));
        personUserRelDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        DynamicObject userDy = bosUserMap.get(number);
        if (userDy != null) {
            personUserRelDy.set("user", (Object)userDy.getLong("id"));
        }
        saveDys.add((Object)personUserRelDy);
    }

    private Map<String, DynamicObject> getBosUserInfo(List<String> numberList) {
        QFilter numberFilter = new QFilter("number", "in", numberList);
        QFilter[] qFilters = new QFilter[]{numberFilter};
        DynamicObject[] bosUserDys = HRPIBosUserRepository.getBosUserInfoOrig(qFilters);
        Map<String, DynamicObject> bosNumberMap = new HashMap<String, DynamicObject>(numberList.size());
        if (bosUserDys != null && bosUserDys.length > 0) {
            bosNumberMap = Arrays.stream(bosUserDys).collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (k1, k2) -> k1));
        }
        return bosNumberMap;
    }
}

