/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRMapUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIDepempRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIManFileRepository;
import kd.hrmp.hrpi.business.helper.CodeRuleNumberHelper;

public class DepempUpgradeService
extends AbstractTask {
    private int BATCH_COUNT = 1000;
    private static final Log LOGGER = LogFactory.getLog(DepempUpgradeService.class);
    private static final HRBaseServiceHelper depHelper = new HRBaseServiceHelper("hrpi_depemp");
    private static final HRBaseServiceHelper empPosHelper = new HRBaseServiceHelper("hrpi_empposorgrel");
    private static final String UPDATE_EMPTY = "updateEmpty";
    private static final String UPDATE_ALL = "updateAll";
    private static final String UPDATE_START = "updateStart";
    private Map<Object, DynamicObject> PRD_STATUS = new HashMap<Object, DynamicObject>(16);

    private void doUpgrade(Map<String, Object> paramMap) {
        block7: {
            try {
                this.PRD_STATUS = CodeRuleNumberHelper.getInstance().getPrdStatus();
                LOGGER.info("DepempUpgradeServiceStart");
                Object upgradeAllParam = paramMap.get("upgradeAll");
                Object updateHisObj = paramMap.get("updatehis");
                Boolean upgradeAll = upgradeAllParam != null ? Boolean.valueOf((String)upgradeAllParam) : Boolean.TRUE;
                boolean updateHis = false;
                if (updateHisObj != null) {
                    updateHis = Boolean.parseBoolean((String)updateHisObj);
                }
                String employeeIds = (String)paramMap.get("employeeIds");
                if (!upgradeAll.booleanValue() && HRStringUtils.isEmpty((String)employeeIds)) {
                    LOGGER.info("DepempUpgradeService not set employeeIds");
                    return;
                }
                Object updateTypeObj = paramMap.get("updatetype");
                String updateType = UPDATE_EMPTY;
                if (updateTypeObj instanceof String) {
                    updateType = (String)updateTypeObj;
                }
                long id = 0L;
                if (upgradeAll.booleanValue()) {
                    DynamicObject[] dyArray;
                    while ((dyArray = HRPIEmployeeRepository.batchQueryEmployee(id, this.BATCH_COUNT)) != null && dyArray.length > 0) {
                        id = dyArray[dyArray.length - 1].getLong("id");
                        if (!this.doUpdateNumber(dyArray, updateType, updateHis).booleanValue() || dyArray.length >= this.BATCH_COUNT) continue;
                        break block7;
                    }
                    break block7;
                }
                String[] employees = employeeIds.split(",");
                List<Long> empIds = Arrays.asList(employees).stream().map(id1 -> Long.parseLong(id1)).collect(Collectors.toList());
                DynamicObject[] dyArray = HRPIEmployeeRepository.listEmployeeIds(empIds);
                this.doUpdateNumber(dyArray, updateType, updateHis);
            }
            catch (Exception ex) {
                LOGGER.error("handle_depemp_ex", (Throwable)ex);
            }
        }
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.doUpgrade(map);
    }

    public Boolean doUpdateNumber(DynamicObject[] dyArray, String updateType, boolean updateAllHis) {
        DynamicObject[] currentAndHisDeps;
        List<DynamicObject> empLists = Arrays.asList(dyArray);
        List<Long> ids = empLists.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        if (ids == null || ids.size() == 0) {
            return Boolean.FALSE;
        }
        Object[] fileByEmpId = HRPIManFileRepository.getFileByEmpId(ids);
        LOGGER.info("fileByEmpId=={}", fileByEmpId);
        if (fileByEmpId == null || fileByEmpId.length == 0) {
            return Boolean.FALSE;
        }
        List<Object> ermanfileDyList = Arrays.asList(fileByEmpId);
        List<Long> orgIdList = ermanfileDyList.stream().map(dy -> dy.getLong("org.id")).collect(Collectors.toList());
        Object[] recordIds = HRPIEmployeeRepository.getLabRelRecordByEmployeeIds(ids, orgIdList, Boolean.FALSE);
        LOGGER.info("recordIds=={}", recordIds);
        if (recordIds == null || recordIds.length == 0) {
            recordIds = new DynamicObject[]{};
        }
        Map<Long, List<DynamicObject>> recordGroupByEmpId = Arrays.stream(recordIds).collect(Collectors.groupingBy(record -> record.getLong("employee.id")));
        for (DynamicObject dep : currentAndHisDeps = HRPIDepempRepository.getDepEmpByEmployeeId(ids)) {
            List<DynamicObject> records = recordGroupByEmpId.get(dep.getLong("employee.id"));
            if (records == null) continue;
            Date depStartDate = dep.getDate("startdate");
            for (DynamicObject record2 : records) {
                Date recordStartDate = record2.getDate("startdate");
                Date recordEndDate = record2.getDate("enddate");
                if (recordStartDate == null || recordEndDate == null || !HRDateTimeUtils.dayEquals((Date)depStartDate, (Date)recordStartDate) && !HRDateTimeUtils.dayAfter((Date)depStartDate, (Date)recordStartDate) || !HRDateTimeUtils.dayBefore((Date)depStartDate, (Date)recordEndDate)) continue;
                dep.set("laborrelrecord", (Object)record2.getLong("id"));
            }
        }
        this.updateNumber(currentAndHisDeps, updateType, updateAllHis);
        return Boolean.TRUE;
    }

    private void updateNumber(DynamicObject[] currentAndHisDeps, String updateType, boolean updateAllHis) {
        List<DynamicObject> currentDys = Arrays.stream(currentAndHisDeps).filter(dep -> dep.getBoolean("iscurrentversion")).collect(Collectors.toList());
        if (currentDys.size() == 0) {
            return;
        }
        List<DynamicObject> dataStatusOneDys = Arrays.stream(currentAndHisDeps).filter(dep -> "1".equals(dep.getString("datastatus"))).collect(Collectors.toList());
        List<Long> depIdList = currentDys.stream().map(dep -> dep.getLong("id")).collect(Collectors.toList());
        DynamicObject[] empPoses = HRPIDepempRepository.getEmpPosByDepId(depIdList);
        Map<Long, List<DynamicObject>> depEmpGroupMap = currentDys.stream().collect(Collectors.groupingBy(val -> val.getLong("employee.id")));
        ArrayList<DynamicObject> serialList = new ArrayList<DynamicObject>(depEmpGroupMap.size());
        ArrayList<DynamicObject> assignNoList = new ArrayList<DynamicObject>(depEmpGroupMap.size());
        this.generAssignNo(depEmpGroupMap, serialList, assignNoList, currentDys, updateType);
        this.setAndUpdateRealNumber(dataStatusOneDys, empPoses, serialList, assignNoList, updateAllHis, currentAndHisDeps);
    }

    private void setAndUpdateRealNumber(List<DynamicObject> dataStatusOneDys, DynamicObject[] empPoses, List<DynamicObject> serialList, List<DynamicObject> assignNoList, boolean updateAllHis, DynamicObject[] currentAndHisDeps) {
        DynamicObjectCollection depDys = new DynamicObjectCollection();
        DynamicObjectCollection depPosDys = new DynamicObjectCollection();
        HashMap<Long, DynamicObject> depEmpIdMap = new HashMap<Long, DynamicObject>(serialList.size());
        if (!CollectionUtils.isEmpty(serialList)) {
            List numbers = CodeRuleServiceHelper.getNumbers((String)"hrpi_depemp", serialList);
            for (int idx = 0; idx < numbers.size(); ++idx) {
                String number = (String)numbers.get(idx);
                if (HRStringUtils.isEmpty((String)number)) continue;
                String[] numberSplit = number.split("-");
                String serialNo = numberSplit[numberSplit.length - 1];
                DynamicObject dynamicObject = serialList.get(idx);
                dynamicObject.set("serialno", (Object)serialNo);
                dynamicObject.set("number", (Object)number);
                long boId = dynamicObject.getLong("boid");
                depEmpIdMap.put(boId, dynamicObject);
                depDys.add((Object)dynamicObject);
            }
        }
        for (DynamicObject dy2 : assignNoList) {
            depEmpIdMap.put(dy2.getLong("boid"), dy2);
            depDys.add((Object)dy2);
        }
        if (updateAllHis) {
            this.handleDepDys(depDys, depEmpIdMap, Arrays.asList(currentAndHisDeps));
            if (HRArrayUtils.isNotEmpty((Object[])empPoses)) {
                this.handleEmpPosDys(empPoses, depPosDys, depEmpIdMap);
            }
            this.toUpdateData(depDys, depPosDys);
            return;
        }
        List<DynamicObject> hisDys = dataStatusOneDys.stream().filter(dy -> !dy.getBoolean("iscurrentversion")).collect(Collectors.toList());
        this.handleDepDys(depDys, depEmpIdMap, hisDys);
        if (HRArrayUtils.isNotEmpty((Object[])empPoses)) {
            this.handleEmpPosDys(empPoses, depPosDys, depEmpIdMap);
        }
        this.toUpdateData(depDys, depPosDys);
    }

    private void handleEmpPosDys(DynamicObject[] empPoses, DynamicObjectCollection depPosDys, Map<Long, DynamicObject> depEmpIdMap) {
        for (DynamicObject dy : empPoses) {
            long depEmpId = dy.getLong("depemp.id");
            DynamicObject depDy = depEmpIdMap.get(depEmpId);
            if (depDy == null) continue;
            dy.set("number", (Object)depDy.getString("number"));
            depPosDys.add((Object)dy);
        }
    }

    private void handleDepDys(DynamicObjectCollection depDys, Map<Long, DynamicObject> depEmpIdMap, List<DynamicObject> hisDys) {
        for (DynamicObject dy : hisDys) {
            long boId = dy.getLong("boid");
            DynamicObject tmpDy = depEmpIdMap.get(boId);
            if (tmpDy == null) continue;
            dy.set("number", (Object)tmpDy.getString("number"));
            dy.set("assignno", (Object)tmpDy.getString("assignno"));
            dy.set("serialno", (Object)tmpDy.getString("serialno"));
            depDys.add((Object)dy);
        }
    }

    private void toUpdateData(DynamicObjectCollection depDys, DynamicObjectCollection depPosDys) {
        if (!CollectionUtils.isEmpty((Collection)depDys)) {
            depHelper.updateDatas((DynamicObject[])depDys.toArray((Object[])new DynamicObject[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)depPosDys)) {
            empPosHelper.updateDatas((DynamicObject[])depPosDys.toArray((Object[])new DynamicObject[0]));
        }
    }

    private void generAssignNo(Map<Long, List<DynamicObject>> depEmpGroupMap, List<DynamicObject> serialList, List<DynamicObject> assignNoList, List<DynamicObject> currentDys, String updateType) {
        Object[] depEmpByNumber;
        HashMap<Long, String> primaryMaxAssignNoMap = new HashMap<Long, String>(depEmpGroupMap.size());
        HashMap<String, String> numberAreaMaxAssignNoMap = new HashMap<String, String>(depEmpGroupMap.size());
        Map<Object, Object> empIdAndNumberMap = new HashMap(depEmpGroupMap.size());
        Map<Object, Object> numberDepMap = new HashMap(depEmpGroupMap.size());
        Set<String> numberSet = currentDys.stream().map(dy -> dy.getString("person.number")).collect(Collectors.toSet());
        Object[] numberEmployeeDys = HRPIEmployeeRepository.listEmployeesByNombers(new ArrayList<String>(numberSet));
        if (HRArrayUtils.isNotEmpty((Object[])numberEmployeeDys)) {
            empIdAndNumberMap = Arrays.stream(numberEmployeeDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        }
        if (HRArrayUtils.isNotEmpty((Object[])(depEmpByNumber = HRPIDepempRepository.getDepEmpByNumber(numberSet)))) {
            numberDepMap = Arrays.stream(depEmpByNumber).collect(Collectors.groupingBy(dy -> dy.getString("person.number")));
        }
        Set<Map.Entry<Long, List<DynamicObject>>> entries = depEmpGroupMap.entrySet();
        for (Map.Entry<Long, List<DynamicObject>> groupDepEmp : entries) {
            Long employeeId = groupDepEmp.getKey();
            DynamicObject empDy = (DynamicObject)empIdAndNumberMap.get(employeeId);
            List<DynamicObject> depEmpDys = groupDepEmp.getValue();
            if (CollectionUtils.isEmpty(depEmpDys)) continue;
            boolean firstPrimary = true;
            if (empDy == null) continue;
            String dbNumber = empDy.getString("empnumber");
            this.getNextAssignNo((List)numberDepMap.get(dbNumber), primaryMaxAssignNoMap, numberAreaMaxAssignNoMap, employeeId, empDy, updateType);
            if (UPDATE_START.equalsIgnoreCase(updateType)) {
                int firstNumberCount = 0;
                if (HRStringUtils.isNotEmpty((String)((String)numberAreaMaxAssignNoMap.get(dbNumber)))) {
                    ++firstNumberCount;
                }
                if (firstNumberCount == 0) {
                    numberAreaMaxAssignNoMap.put(dbNumber, "1");
                    primaryMaxAssignNoMap.put(employeeId, String.valueOf(firstNumberCount));
                } else {
                    primaryMaxAssignNoMap.put(employeeId, (String)numberAreaMaxAssignNoMap.get(dbNumber));
                }
            }
            boolean firstMainEmptyNoOtherNotEmpty = this.hasNotEmptyAssignNo(depEmpDys);
            boolean firstNoMainAndEmptyNo = this.firstNoMainAndEmptyAssignNo(depEmpDys, updateType);
            for (DynamicObject depEmpDy : depEmpDys) {
                String number = depEmpDy.getString("number");
                boolean primary = depEmpDy.getBoolean("isprimary");
                String empNumber = depEmpDy.getString("employee.empnumber");
                if (primary) {
                    if (UPDATE_ALL.equalsIgnoreCase(updateType) || UPDATE_START.equalsIgnoreCase(updateType)) {
                        this.setMainAssignNo(serialList, assignNoList, firstPrimary, firstMainEmptyNoOtherNotEmpty, employeeId, depEmpDy, empNumber, primaryMaxAssignNoMap, numberAreaMaxAssignNoMap);
                        firstPrimary = false;
                        continue;
                    }
                    if (this.assignNoEmptyOrFixed(number)) {
                        firstPrimary = this.setMainAssignNo(serialList, assignNoList, firstPrimary, firstMainEmptyNoOtherNotEmpty, employeeId, depEmpDy, empNumber, primaryMaxAssignNoMap, numberAreaMaxAssignNoMap);
                        continue;
                    }
                    firstPrimary = false;
                    continue;
                }
                if (UPDATE_ALL.equalsIgnoreCase(updateType) || UPDATE_START.equalsIgnoreCase(updateType)) {
                    this.setNoMainAssignNo(assignNoList, numberAreaMaxAssignNoMap, depEmpDy, empNumber, firstNoMainAndEmptyNo, employeeId, primaryMaxAssignNoMap, firstPrimary);
                    continue;
                }
                if (!this.assignNoEmptyOrFixed(number)) continue;
                this.setNoMainAssignNo(assignNoList, numberAreaMaxAssignNoMap, depEmpDy, empNumber, firstNoMainAndEmptyNo, employeeId, primaryMaxAssignNoMap, firstPrimary);
            }
        }
    }

    private boolean firstNoMainAndEmptyAssignNo(List<DynamicObject> depEmpDys, String updateType) {
        DynamicObject firstMainDy = depEmpDys.get(0);
        boolean main = firstMainDy.getBoolean("isprimary");
        List mainNotEmptyDys = depEmpDys.stream().filter(dep -> dep.getBoolean("isprimary") && HRStringUtils.isNotEmpty((String)dep.getString("assignno"))).collect(Collectors.toList());
        if (UPDATE_ALL.equalsIgnoreCase(updateType)) {
            return !main;
        }
        return !main && HRStringUtils.isEmpty((String)firstMainDy.getString("assignno")) && mainNotEmptyDys.isEmpty();
    }

    private boolean hasNotEmptyAssignNo(List<DynamicObject> depEmpDys) {
        boolean firstMainEmptyNoOtherNotEmpty = false;
        List otherHasAssignNoDys = depEmpDys.stream().filter(dep -> HRStringUtils.isNotEmpty((String)dep.getString("assignno"))).collect(Collectors.toList());
        List emptyMainDys = depEmpDys.stream().filter(dep -> HRStringUtils.isEmpty((String)dep.getString("assignno")) && dep.getBoolean("isprimary")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(emptyMainDys) && !CollectionUtils.isEmpty(otherHasAssignNoDys)) {
            firstMainEmptyNoOtherNotEmpty = true;
        }
        return firstMainEmptyNoOtherNotEmpty;
    }

    private void setNoMainAssignNo(List<DynamicObject> assignNoList, Map<String, String> numberAreaMaxAssignNoMap, DynamicObject depEmpDy, String empNumber, boolean firstNoMainAndEmptyNo, Long employeeId, Map<Long, String> primaryMaxAssignNoMap, boolean firstPrimary) {
        String tmpMainAssignNo;
        String numberAssignNo = numberAreaMaxAssignNoMap.get(empNumber);
        String next = String.valueOf(Integer.parseInt(numberAssignNo) + 1);
        depEmpDy.set("assignno", (Object)next);
        depEmpDy.set("number", (Object)(empNumber + "-" + next));
        numberAreaMaxAssignNoMap.put(empNumber, next);
        assignNoList.add(depEmpDy);
        if (firstNoMainAndEmptyNo && firstPrimary && Integer.parseInt(tmpMainAssignNo = primaryMaxAssignNoMap.get(employeeId)) < Integer.parseInt(next)) {
            primaryMaxAssignNoMap.put(employeeId, next);
            depEmpDy.set("assignno", (Object)next);
            depEmpDy.set("number", (Object)(empNumber + "-" + next));
        }
    }

    private boolean setMainAssignNo(List<DynamicObject> serialList, List<DynamicObject> assignNoList, boolean firstPrimary, boolean firstMainEmptyNoOtherNotEmpty, Long employeeId, DynamicObject depEmpDy, String empNumber, Map<Long, String> primaryMaxAssignNoMap, Map<String, String> numberAreaMaxAssignNoMap) {
        String empIdAssignNo = primaryMaxAssignNoMap.get(employeeId);
        if (HRStringUtils.isEmpty((String)empIdAssignNo)) {
            return false;
        }
        if (firstPrimary) {
            String numberMaxNo;
            int nextAssignNo = Integer.parseInt(empIdAssignNo) + 1;
            String numStr = numberAreaMaxAssignNoMap.get(empNumber);
            if (HRStringUtils.isNotEmpty((String)numStr) && Integer.parseInt(numStr) < nextAssignNo) {
                numberAreaMaxAssignNoMap.put(empNumber, String.valueOf(nextAssignNo));
            }
            primaryMaxAssignNoMap.put(employeeId, String.valueOf(nextAssignNo));
            empIdAssignNo = String.valueOf(nextAssignNo);
            if (firstMainEmptyNoOtherNotEmpty && HRStringUtils.isNotEmpty((String)(numberMaxNo = numberAreaMaxAssignNoMap.get(empNumber)))) {
                int empIdAssignInt = Integer.parseInt(numberMaxNo) + 1;
                empIdAssignNo = String.valueOf(empIdAssignInt);
                primaryMaxAssignNoMap.put(employeeId, empIdAssignNo);
            }
            depEmpDy.set("number", (Object)(empNumber + "-" + empIdAssignNo));
            depEmpDy.set("assignno", (Object)empIdAssignNo);
            assignNoList.add(depEmpDy);
            firstPrimary = false;
        } else {
            depEmpDy.set("assignno", (Object)empIdAssignNo);
            serialList.add(depEmpDy);
        }
        return firstPrimary;
    }

    private void getNextAssignNo(List<DynamicObject> depEmpByNumber, Map<Long, String> primaryMaxAssignNoMap, Map<String, String> numberAreaMaxAssignNoMap, Long employeeId, DynamicObject empDy, String updateType) {
        String dbNumber = empDy.getString("empnumber");
        if (CollectionUtils.isEmpty(depEmpByNumber)) {
            if (HRStringUtils.isEmpty((String)primaryMaxAssignNoMap.get(employeeId))) {
                primaryMaxAssignNoMap.put(employeeId, "0");
            }
            if (HRStringUtils.isEmpty((String)numberAreaMaxAssignNoMap.get(dbNumber))) {
                numberAreaMaxAssignNoMap.put(dbNumber, "0");
            }
            return;
        }
        List<DynamicObject> numberSortedDys = depEmpByNumber.stream().filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("assignno"))).sorted(Comparator.comparing(dy -> Integer.parseInt(dy.getString("assignno")), Comparator.reverseOrder())).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> allDepEmpByNumberMap = depEmpByNumber.stream().collect(Collectors.groupingBy(dy -> dy.getLong("employee.id")));
        if (!HRMapUtils.isEmpty(allDepEmpByNumberMap)) {
            List<DynamicObject> effectMainDys = this.getEffectMainDys(allDepEmpByNumberMap.get(employeeId), empDy);
            if (!CollectionUtils.isEmpty(effectMainDys)) {
                String dbAssignNo = effectMainDys.get(0).getString("assignno");
                String contextMaxAssignNo = primaryMaxAssignNoMap.get(employeeId);
                if (HRStringUtils.isNotEmpty((String)dbAssignNo) && HRStringUtils.isEmpty((String)contextMaxAssignNo)) {
                    primaryMaxAssignNoMap.put(employeeId, dbAssignNo);
                }
            } else {
                this.putMainOrNumberAreaMap(dbNumber, primaryMaxAssignNoMap, employeeId, numberSortedDys, numberAreaMaxAssignNoMap, "1", updateType);
            }
        } else if (HRStringUtils.isEmpty((String)primaryMaxAssignNoMap.get(employeeId))) {
            primaryMaxAssignNoMap.put(employeeId, "0");
        }
        this.putMainOrNumberAreaMap(dbNumber, primaryMaxAssignNoMap, employeeId, numberSortedDys, numberAreaMaxAssignNoMap, "2", updateType);
    }

    private void putMainOrNumberAreaMap(String dbNumber, Map<Long, String> primaryMaxAssignNoMap, Long employeeId, List<DynamicObject> numberSortedDys, Map<String, String> numberAreaMaxAssignNoMap, String type, String updateType) {
        if (CollectionUtils.isEmpty(numberSortedDys)) {
            if ("1".equals(type)) {
                if (HRStringUtils.isEmpty((String)primaryMaxAssignNoMap.get(employeeId))) {
                    String maxAssignNo = numberAreaMaxAssignNoMap.get(dbNumber);
                    if (HRStringUtils.isNotEmpty((String)maxAssignNo)) {
                        primaryMaxAssignNoMap.put(employeeId, maxAssignNo);
                    } else {
                        primaryMaxAssignNoMap.put(employeeId, "0");
                    }
                }
            } else if (HRStringUtils.isEmpty((String)numberAreaMaxAssignNoMap.get(dbNumber))) {
                numberAreaMaxAssignNoMap.put(dbNumber, "0");
            }
        } else {
            String dbMaxAssignNo = numberSortedDys.get(0).getString("assignno");
            if ("1".equals(type)) {
                if (HRStringUtils.isNotEmpty((String)dbMaxAssignNo) && HRStringUtils.isEmpty((String)primaryMaxAssignNoMap.get(employeeId))) {
                    primaryMaxAssignNoMap.put(employeeId, dbMaxAssignNo);
                }
            } else if (HRStringUtils.isNotEmpty((String)dbMaxAssignNo) && HRStringUtils.isEmpty((String)numberAreaMaxAssignNoMap.get(dbNumber))) {
                numberAreaMaxAssignNoMap.put(dbNumber, dbMaxAssignNo);
            }
            if (UPDATE_ALL.equals(updateType)) {
                String contextMainAssignNo = numberAreaMaxAssignNoMap.get(dbNumber);
                if (HRStringUtils.isNotEmpty((String)contextMainAssignNo) && HRStringUtils.isNotEmpty((String)dbMaxAssignNo)) {
                    primaryMaxAssignNoMap.put(employeeId, contextMainAssignNo);
                } else {
                    primaryMaxAssignNoMap.put(employeeId, dbMaxAssignNo);
                }
            }
        }
    }

    private List<DynamicObject> getEffectMainDys(List<DynamicObject> dbDepEmpDys, DynamicObject empDy) {
        List<Object> effectMainDys = new ArrayList<DynamicObject>();
        if (CollectionUtils.isEmpty(dbDepEmpDys)) {
            return effectMainDys;
        }
        DynamicObject onBrdDy = this.PRD_STATUS.get(empDy.getLong("laborrelstatus.id"));
        effectMainDys = onBrdDy != null ? dbDepEmpDys.stream().filter(dep -> dep.getBoolean("isprimary") && HRStringUtils.isNotEmpty((String)dep.getString("assignno")) && "1".equals(dep.getString("businessstatus"))).collect(Collectors.toList()) : dbDepEmpDys.stream().filter(dep -> dep.getBoolean("isprimary") && HRStringUtils.isNotEmpty((String)dep.getString("assignno")) && HRStringUtils.isEmpty((String)dep.getString("serialno"))).sorted(Comparator.comparing(dy -> Integer.parseInt(dy.getString("assignno")), Comparator.reverseOrder())).collect(Collectors.toList());
        return effectMainDys;
    }

    private boolean assignNoEmptyOrFixed(String number) {
        return HRStringUtils.isEmpty((String)number) || "FIXED_NUMBER".equals(number);
    }
}

