/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPICallInfResultRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmpEntrelRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIManFileRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPINumberReuseInfRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.business.domian.service.impl.HRPIOperationServiceImpl;
import kd.hrmp.hrpi.business.task.DepempUpgradeService;
import kd.hrmp.hrpi.common.HRPIValueConstants;

public class EmpNumberReUseUpgradeTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(EmpNumberReUseUpgradeTask.class);
    public final HRBaseServiceHelper employeeServiceHelper = new HRBaseServiceHelper("hrpi_employee");
    public final HRBaseServiceHelper empentrelServiceHelper = new HRBaseServiceHelper("hrpi_empentrel");
    protected final HRBaseServiceHelper personServiceHelper = new HRBaseServiceHelper("hrpi_person");
    protected final HRBaseServiceHelper eramanFileServiceHelper = new HRBaseServiceHelper("hspm_ermanfile");
    String OPERATIONRESULT_FAIL = "0";
    String OPERATIONRESULT_SUCCESS = "1";
    String OPERATIONRESULT_IN_PROGRESS = "2";
    private static final String NUMBER_MATCH_PATTERN = ".*-R\\d+$";
    private static final String UNDERLINE_R = "-R";
    private static final String UPDATE_ALL = "1";
    private Map<String, String> oldNumVsNewNumMap = Maps.newLinkedHashMapWithExpectedSize((int)16);
    private HRBaseServiceHelper callInfResultServiceHelper = new HRBaseServiceHelper("hrpi_callinfresult");
    private Map<String, List<String>> entityVsNumberFieldListMap = Maps.newHashMapWithExpectedSize((int)4);

    public EmpNumberReUseUpgradeTask() {
        this.entityVsNumberFieldListMap.put("hrpi_employee", Collections.singletonList("empnumber"));
        this.entityVsNumberFieldListMap.put("hrpi_empentrel", Arrays.asList("empnumber", "oldempnumber"));
        this.entityVsNumberFieldListMap.put("hrpi_person", Collections.singletonList("number"));
        this.entityVsNumberFieldListMap.put("hspm_ermanfile", Collections.singletonList("number"));
    }

    public void execute(RequestContext requestContext, Map<String, Object> paramMap) throws KDException {
        this.executeUpgrade(paramMap);
        this.disableTask();
    }

    private void executeUpgrade(Map<String, Object> paramMap) {
        DynamicObject[] interfaceDynArr;
        Map<Object, Object> infParamMap = Maps.newHashMapWithExpectedSize((int)16);
        Long curId = ORM.create().genLongIds("hrpi_callinfresult", 1)[0];
        try (TXHandle required = TX.required();){
            List<Long> inEmployeeIdList = this.getNeedUpdateEmployeeBoId(paramMap);
            if (CollectionUtils.isEmpty(inEmployeeIdList)) {
                LOG.info("EmpNumberReUseUpgradeTask:there are no employeeBoId need to update;");
                return;
            }
            DynamicObject[] employeeDynArr = HRPIEmployeeRepository.listEmployeeIdsCurVersion(inEmployeeIdList, "id, mid, person, laborrelstatus");
            ArrayList employeeIdList = Lists.newArrayListWithExpectedSize((int)employeeDynArr.length);
            ArrayList employeeIdListForBusinessNum = Lists.newArrayListWithExpectedSize((int)employeeDynArr.length);
            ArrayList personIdList = Lists.newArrayListWithExpectedSize((int)employeeDynArr.length);
            this.findEmployeeIdAndPersonIdList(employeeDynArr, employeeIdList, employeeIdListForBusinessNum, personIdList);
            LOG.info("EmpNumberReUseUpgradeTask.employeeIdList:{}", (Object)employeeIdList);
            if (CollectionUtils.isEmpty((Collection)employeeIdList)) {
                return;
            }
            try {
                DynamicObject[] manFileDynArr;
                DynamicObject[] personDynArr;
                DynamicObject[] empEntrelDynArr;
                DynamicObject[] allEmployeeDynArr;
                ArrayList employeeDynList = Lists.newArrayListWithExpectedSize((int)16);
                ArrayList empentrelDynList = Lists.newArrayListWithExpectedSize((int)16);
                ArrayList personDynList = Lists.newArrayListWithExpectedSize((int)16);
                ArrayList ermanFileDynList = Lists.newArrayListWithExpectedSize((int)16);
                for (DynamicObject employeeDyn : allEmployeeDynArr = HRPIEmployeeRepository.queryEmployeeByIds(employeeIdList, "id, empnumber")) {
                    String entityName = employeeDyn.getDataEntityType().getName();
                    this.findAndReplaceEmpNumber(employeeDyn, this.entityVsNumberFieldListMap.get(entityName), employeeDynList, true);
                }
                for (DynamicObject empEntrelDyn : empEntrelDynArr = HRPIEmpEntrelRepository.getInstance().listDynByEmployeeId(employeeIdList)) {
                    String entityName = empEntrelDyn.getDataEntityType().getName();
                    this.findAndReplaceEmpNumber(empEntrelDyn, this.entityVsNumberFieldListMap.get(entityName), empentrelDynList, false);
                }
                for (DynamicObject personDyn : personDynArr = HRPIPersonRepository.listPersons(personIdList, "id, number")) {
                    String entityName = personDyn.getDataEntityType().getName();
                    this.findAndReplaceEmpNumber(personDyn, this.entityVsNumberFieldListMap.get(entityName), personDynList, false);
                }
                for (DynamicObject manFileDyn : manFileDynArr = HRPIManFileRepository.getFileByEmpId(employeeIdList, "id, number")) {
                    String entityName = manFileDyn.getDataEntityType().getName();
                    this.findAndReplaceEmpNumber(manFileDyn, this.entityVsNumberFieldListMap.get(entityName), ermanFileDynList, false);
                }
                this.employeeServiceHelper.save(employeeDynList.toArray(new DynamicObject[0]));
                this.empentrelServiceHelper.save(empentrelDynList.toArray(new DynamicObject[0]));
                this.personServiceHelper.save(personDynList.toArray(new DynamicObject[0]));
                this.eramanFileServiceHelper.save(ermanFileDynList.toArray(new DynamicObject[0]));
                try {
                    LOG.info("EmpNumberReUseUpgradeTask.employeeIdListForBusinessNum:{}", (Object)employeeIdListForBusinessNum);
                    DynamicObject[] employeeDynArrForInterface = HRPIEmployeeRepository.listEmployeeIds(new HashSet<Long>(employeeIdListForBusinessNum));
                    DepempUpgradeService depempUpgradeService = new DepempUpgradeService();
                    depempUpgradeService.doUpdateNumber(employeeDynArrForInterface, "updateAll", true);
                }
                catch (Exception ex) {
                    LOG.error("depempUpgradeService error!");
                    throw ex;
                }
                LOG.info("EmpNumberReUseUpgradeTask.personIdList:{}", (Object)personIdList);
                this.sendChangeInfoSyncToSysUser(personIdList);
                interfaceDynArr = HRPINumberReuseInfRepository.getInstance().listAllInfInfo();
                infParamMap = this.assembleInfParamMap();
                this.assembleCallInfResultDynAndSave(curId, interfaceDynArr, infParamMap);
            }
            catch (Exception ex) {
                required.markRollback();
                LOG.error((Throwable)ex);
                throw ex;
            }
        }
        DynamicObject curResultDyn = HRPICallInfResultRepository.getInstance().loadById(curId);
        HashMap idVsFlagMap = Maps.newHashMapWithExpectedSize((int)interfaceDynArr.length);
        Boolean successFlag = Boolean.TRUE;
        for (DynamicObject interfaceDyn : interfaceDynArr) {
            long infId = interfaceDyn.getLong("id");
            String cloudId = interfaceDyn.getString("cloudid");
            String appId = interfaceDyn.getString("appid");
            String serviceName = interfaceDyn.getString("servicename");
            String methodName = interfaceDyn.getString("methodname");
            Boolean curFlag = Boolean.FALSE;
            try {
                Map<String, Object> resultList = this.invokeService(infParamMap, cloudId, appId, serviceName, methodName);
                curFlag = (Boolean)resultList.get("success");
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                LOG.error("EmpNumberReUseUpgradeTask.callinf.error.cloudId:{}, appId:{}, serviceName:{}", new Object[]{cloudId, appId, serviceName});
                successFlag = successFlag & curFlag;
            }
            idVsFlagMap.put(infId, curFlag);
        }
        curResultDyn.set("operationresult", (Object)(successFlag != false ? this.OPERATIONRESULT_SUCCESS : this.OPERATIONRESULT_FAIL));
        this.callInfResultServiceHelper.save(new DynamicObject[]{curResultDyn});
        LOG.error("EmpNumberReUseUpgradeTask.callinf.finally:{}", (Object)idVsFlagMap);
    }

    private void disableTask() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableSchedule("3RA9EIV65GHK");
    }

    private Map<String, Object> invokeService(Map<String, Object> infParamMap, String cloudId, String appId, String serviceName, String methodName) {
        return (Map)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{infParamMap});
    }

    private void assembleCallInfResultDynAndSave(Long curId, DynamicObject[] interfaceDynArr, Map<String, Object> infParamMap) {
        DynamicObject callInfResultDyn = this.callInfResultServiceHelper.generateEmptyDynamicObject();
        Date curDate = new Date();
        callInfResultDyn.set("id", (Object)curId);
        callInfResultDyn.set("createtime", (Object)curDate);
        callInfResultDyn.set("creator", (Object)RequestContext.get().getCurrUserId());
        callInfResultDyn.set("latestoperatetime", (Object)curDate);
        callInfResultDyn.set("operationresult", (Object)this.OPERATIONRESULT_IN_PROGRESS);
        callInfResultDyn.set("retrycount", (Object)"0");
        this.setInfList(callInfResultDyn, interfaceDynArr);
        callInfResultDyn.set("infparam", (Object)SerializationUtils.toJsonString(infParamMap));
        this.callInfResultServiceHelper.save(new DynamicObject[]{callInfResultDyn});
    }

    private void setInfList(DynamicObject callInfResultDyn, DynamicObject[] interfaceDynArr) {
        DynamicObjectCollection infListCol = callInfResultDyn.getDynamicObjectCollection("inflist");
        DynamicObjectType entryType = infListCol.getDynamicObjectType();
        for (DynamicObject interfaceDyn : interfaceDynArr) {
            DynamicObject row = new DynamicObject(entryType);
            row.set("fbasedataid", (Object)interfaceDyn);
            infListCol.add((Object)row);
        }
    }

    private Map<String, Object> assembleInfParamMap() {
        HashMap paramMap = Maps.newHashMapWithExpectedSize((int)1);
        ArrayList msgList = Lists.newArrayListWithExpectedSize((int)this.oldNumVsNewNumMap.size());
        Set<Map.Entry<String, String>> entries = this.oldNumVsNewNumMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String oriNumber = entry.getKey();
            String newNumber = entry.getValue();
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("oriNumber", oriNumber);
            map.put("newNumber", newNumber);
            msgList.add(map);
        }
        paramMap.put("data", msgList);
        return paramMap;
    }

    private List<Long> getNeedUpdateEmployeeBoId(Map<String, Object> map) {
        List<Object> inEmployeeIdList = Lists.newArrayListWithExpectedSize((int)16);
        if (Objects.nonNull(map.get("empNumber"))) {
            String empNumberInParam = String.valueOf(map.get("empNumber"));
            if (HRStringUtils.equals((String)empNumberInParam, (String)"ALL")) {
                DynamicObject[] allCurEmployees = HRPIEmployeeRepository.listAllCurEmployees();
                inEmployeeIdList = Arrays.stream(allCurEmployees).map(employee -> employee.getLong("id")).collect(Collectors.toList());
            } else {
                List<String> inEmpNumberList = Arrays.stream(empNumberInParam.split(",")).filter(number -> HRStringUtils.isNotEmpty((String)number)).collect(Collectors.toList());
                Predicate<DynamicObject> flag = dyn -> dyn.getString("empnumber").lastIndexOf(UNDERLINE_R) == -1 || inEmpNumberList.contains(dyn.getString("empnumber").substring(0, dyn.getString("empnumber").lastIndexOf(UNDERLINE_R)));
                DynamicObject[] employeesByLikeNumbers = HRPIEmployeeRepository.listEmployeesByLikeNumbers("id", inEmpNumberList);
                inEmployeeIdList = Arrays.stream(employeesByLikeNumbers).filter(dyn -> HRStringUtils.isNotEmpty((String)dyn.getString("empnumber"))).filter(flag).map(employee -> employee.getLong("id")).collect(Collectors.toList());
            }
        }
        return inEmployeeIdList;
    }

    private void findEmployeeIdAndPersonIdList(DynamicObject[] employeeDynArr, List<Long> allEmployeeIdList, List<Long> employeeIdListForBusinessNum, List<Long> allPersonIdList) {
        Map<Long, List<DynamicObject>> midVsDynListMap = Arrays.stream(employeeDynArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("mid")));
        this.getReUseIdList(midVsDynListMap, allEmployeeIdList, employeeIdListForBusinessNum, allPersonIdList);
        this.getReplaceIdList(midVsDynListMap, allEmployeeIdList, employeeIdListForBusinessNum, allPersonIdList);
    }

    private List<Long> getReplaceIdList(Map<Long, List<DynamicObject>> midVsDynListMap, List<Long> employeeIdList, List<Long> employeeIdListForBusinessNum, List<Long> personIdList) {
        List singleEntryList = midVsDynListMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() == 1).filter(entry -> HRPIValueConstants.LABRELSTATUSPRD_END.longValue() == ((DynamicObject)((List)entry.getValue()).get(0)).getLong("laborrelstatus.labrelstatusprd.id")).collect(Collectors.toList());
        ArrayList numberReplaceEmployeeIdList = Lists.newArrayListWithExpectedSize((int)16);
        for (Map.Entry mIdVsEmployeeDynListEntry : singleEntryList) {
            DynamicObject employeeDyn = (DynamicObject)((List)mIdVsEmployeeDynListEntry.getValue()).get(0);
            if (!this.matchSuffixR(employeeDyn.getString("empnumber"))) continue;
            employeeIdList.add(employeeDyn.getLong("id"));
            personIdList.add(employeeDyn.getLong("person.id"));
            employeeIdListForBusinessNum.add(employeeDyn.getLong("id"));
        }
        return numberReplaceEmployeeIdList;
    }

    private void getReUseIdList(Map<Long, List<DynamicObject>> midVsDynListMap, List<Long> employeeIdList, List<Long> employeeIdListForBusinessNum, List<Long> personIdList) {
        List reUseEntryList = midVsDynListMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).collect(Collectors.toList());
        for (Map.Entry mIdVsEmployeeDynListEntry : reUseEntryList) {
            List employeeDynList = (List)mIdVsEmployeeDynListEntry.getValue();
            List matchList = employeeDynList.stream().filter(dyn -> this.matchSuffixR(dyn.getString("empnumber"))).collect(Collectors.toList());
            if (matchList.size() == 0) continue;
            for (DynamicObject employeeDyn : employeeDynList) {
                employeeIdList.add(employeeDyn.getLong("id"));
                String empNumber = employeeDyn.getString("empnumber");
                if (!this.matchSuffixR(empNumber) || HRPIValueConstants.LABRELSTATUSPRD_END.longValue() != employeeDyn.getLong("laborrelstatus.labrelstatusprd.id")) continue;
                personIdList.add(employeeDyn.getLong("person.id"));
                employeeIdListForBusinessNum.add(employeeDyn.getLong("id"));
            }
        }
    }

    private void findAndReplaceEmpNumber(DynamicObject dyn, List<String> fieldList, List<DynamicObject> toSaveDynList, boolean isPutMapFlag) {
        boolean needToSave = false;
        for (String field : fieldList) {
            String number = dyn.getString(field);
            if (!this.matchSuffixR(number)) continue;
            needToSave = true;
            String newNumber = this.removeR(number);
            dyn.set(field, (Object)newNumber);
            if (!isPutMapFlag) continue;
            this.oldNumVsNewNumMap.put(number, newNumber);
        }
        if (needToSave) {
            toSaveDynList.add(dyn);
        }
    }

    private boolean matchSuffixR(String empNumber) {
        return Pattern.matches(NUMBER_MATCH_PATTERN, empNumber);
    }

    private String removeR(String number) {
        return number.substring(0, number.lastIndexOf(UNDERLINE_R));
    }

    public void sendChangeInfoSyncToSysUser(List<Long> personId) {
        LOG.info("sendChangeInfoSyncToSysUserStart");
        QFilter qFilter = new QFilter("id", "in", personId);
        DynamicObject[] baseInfo = this.getBaseInfoList("hrpi_person", new QFilter[]{qFilter}, "id, number,name");
        if (baseInfo != null && baseInfo.length > 0) {
            ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>(10);
            for (DynamicObject dy : baseInfo) {
                HashMap<String, Object> temp = new HashMap<String, Object>(16);
                temp.put("number", dy.getString("number"));
                temp.put("name", dy.getString("name"));
                temp.put("personid", dy.getLong("id"));
                temp.put("synctype", "disableupdate");
                userList.add(temp);
            }
            Map<String, Object> result = HRPIOperationServiceImpl.getInstance().syncPersonToSysUer(userList);
            LOG.info(MessageFormat.format("entityName,syncPersonToSysUer:[{0}]", result));
        }
    }

    private DynamicObject[] getBaseInfoList(String entityName, QFilter[] qFilters, String fields) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityName);
        return serviceHelper.queryOriginalArray(fields, qFilters);
    }
}

