/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIManFileRepository;
import kd.hrmp.hrpi.business.domian.service.IHRPIOperationService;
import kd.hrmp.hrpi.business.domian.service.impl.HRPIOperationServiceImpl;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;

public class LaborRecordUpgradeService
extends AbstractTask {
    private int BATCH_COUNT = 1000;
    private static final Log LOGGER = LogFactory.getLog(LaborRecordUpgradeService.class);
    private IHRPIOperationService hrpiOperationService = HRPIOperationServiceImpl.getInstance();
    HRBaseServiceHelper labServiceHelper = new HRBaseServiceHelper("hrpi_laborrelrecord");

    public void doUpgrade(Map<String, Object> paramMap) {
        block5: {
            try {
                Object upgradeAllParam = paramMap.get("upgradeAll");
                Boolean upgradeAll = upgradeAllParam != null ? Boolean.valueOf((String)upgradeAllParam) : Boolean.TRUE;
                String employeeIds = (String)paramMap.get("employeeIds");
                if (!upgradeAll.booleanValue() && HRStringUtils.isEmpty((String)employeeIds)) {
                    LOGGER.info("LaborRecordUpgradeService not set employeeIds");
                    return;
                }
                long id = 0L;
                if (upgradeAll.booleanValue()) {
                    DynamicObject[] dyArray;
                    while ((dyArray = HRPIEmployeeRepository.batchQueryEmployee(id, 1000)) != null && dyArray.length > 0) {
                        id = dyArray[dyArray.length - 1].getLong("id");
                        if (!this.doUpdate(dyArray).booleanValue() || dyArray.length >= 1000) continue;
                        break block5;
                    }
                    break block5;
                }
                String[] employees = employeeIds.split(",");
                List<Long> empIds = Arrays.asList(employees).stream().map(id1 -> Long.parseLong(id1)).collect(Collectors.toList());
                DynamicObject[] dyArray = HRPIEmployeeRepository.listEmployeeIds(empIds);
                this.doUpdate(dyArray);
            }
            catch (Exception ex) {
                LOGGER.error("handle_labor_ex", (Throwable)ex);
            }
        }
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("LaborRecordUpgradeServiceStart");
        this.doUpgrade(map);
        LOGGER.info("LaborRecordUpgradeServiceEnd");
    }

    private Boolean doUpdate(DynamicObject[] dyArray) {
        List<DynamicObject> empLists = Arrays.asList(dyArray);
        List<Long> queryIds = empLists.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        if (queryIds == null || queryIds.size() == 0) {
            return Boolean.FALSE;
        }
        DynamicObject[] laborRecordByEmpId = HRPIEmployeeRepository.getLaborRecordByEmpId(queryIds);
        List laborEmpIds = Arrays.stream(laborRecordByEmpId).map(dy -> dy.getLong("employee.id")).distinct().collect(Collectors.toList());
        queryIds.removeAll(laborEmpIds);
        if (queryIds == null || queryIds.size() == 0) {
            LOGGER.info("LaborRecordUpgradeService already exists");
            return Boolean.FALSE;
        }
        DynamicObject[] getFileByEmpIdForStatusDys = HRPIManFileRepository.getFileByEmpIdForStatus(queryIds);
        if (getFileByEmpIdForStatusDys == null || getFileByEmpIdForStatusDys.length == 0) {
            LOGGER.info("LaborRecordUpgradeService no file");
            return Boolean.FALSE;
        }
        Set<Long> personSet = Arrays.stream(getFileByEmpIdForStatusDys).map(file -> file.getLong("person.id")).collect(Collectors.toSet());
        DynamicObject[] onBoardEmployee = HRPIEmployeeRepository.getOnBoardEmployee(personSet);
        Set<Long> onBoardPersonIdSet = Arrays.stream(onBoardEmployee).map(emp -> emp.getLong("person.id")).collect(Collectors.toSet());
        List leavePersonMainFile = Arrays.stream(getFileByEmpIdForStatusDys).filter(file -> !onBoardPersonIdSet.contains(file.getLong("person.id"))).collect(Collectors.toList());
        List sortedLeaveFiles = leavePersonMainFile.stream().sorted(Comparator.comparing(dy -> dy.getDate("startdate"), Comparator.naturalOrder())).collect(Collectors.toList());
        HashMap leaveFileMap = new HashMap();
        sortedLeaveFiles.stream().forEach(file -> leaveFileMap.put(file.getLong("person.id"), file));
        Collection<DynamicObject> realLeaveFiles = leaveFileMap.values();
        List sortedFiles = Arrays.asList(getFileByEmpIdForStatusDys).stream().sorted(Comparator.comparing(dy -> dy.getDate("startdate"), Comparator.naturalOrder())).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> groupByEmpFiles = sortedFiles.stream().collect(Collectors.groupingBy(file -> file.getLong("employee.id")));
        Map<Long, List<DynamicObject>> distinctFileGroup = this.getDistinctFile(groupByEmpFiles);
        ArrayList<Long> newInsertIds = new ArrayList<Long>();
        this.setLaborDyValue(distinctFileGroup, onBoardPersonIdSet, newInsertIds);
        this.editLaborRecordByLeave(realLeaveFiles);
        return Boolean.TRUE;
    }

    private void setLaborDyValue(Map<Long, List<DynamicObject>> distinctFileGroup, Set<Long> onBoardPersonIdSet, ArrayList<Long> newInsertIds) {
        distinctFileGroup.entrySet().forEach(entry -> {
            List sortedFiles = (List)entry.getValue();
            List<DynamicObject> sortedContracts = this.getSortedContracts(sortedFiles);
            HashMap<Long, Long> lawEntityMap = new HashMap<Long, Long>();
            sortedContracts.forEach(contract -> {
                DynamicObject lawEntity = contract.getDynamicObject("actualsigncompany.lawentity");
                if (lawEntity != null) {
                    lawEntityMap.put(contract.getLong("id"), lawEntity.getLong("id"));
                } else {
                    lawEntityMap.put(contract.getLong("id"), null);
                }
            });
            ArrayList<DynamicObject> dynamics = new ArrayList<DynamicObject>();
            dynamics.addAll(sortedFiles);
            dynamics.addAll(sortedContracts);
            List sortedDynamics = dynamics.stream().sorted(Comparator.comparing(dy -> dy.getDate("startdate"), Comparator.naturalOrder())).collect(Collectors.toList());
            int fileIndex = 0;
            int contractIndex = 0;
            Long pkValue = 0L;
            DynamicObject emptyDy = this.labServiceHelper.generateEmptyDynamicObject();
            for (int i = 0; i < sortedDynamics.size(); ++i) {
                DynamicObject dy2 = (DynamicObject)sortedDynamics.get(i);
                String entity = dy2.getDataEntityType().getName();
                if (HRStringUtils.equals((String)entity, (String)"hspm_ermanfile")) {
                    if (emptyDy != null && fileIndex != 0) {
                        DynamicObject updateDy = this.updateHisLaborDy(emptyDy, (DynamicObject)sortedFiles.get(fileIndex));
                        this.doSaveLabor(updateDy, null);
                    }
                    DynamicObject newLaborDy = this.createNewLaborDy(dy2);
                    pkValue = this.saveLaborByFile(newLaborDy, newInsertIds, fileIndex, sortedFiles);
                    emptyDy = this.labServiceHelper.loadSingle((Object)pkValue);
                    ++fileIndex;
                    continue;
                }
                this.updateLaborByContract(contractIndex, lawEntityMap, sortedContracts);
                ++contractIndex;
            }
        });
    }

    private void updateLaborByContract(int contractIndex, HashMap<Long, Long> lawEntityMap, List<DynamicObject> sortedContracts) {
        DynamicObject contract = sortedContracts.get(contractIndex);
        ArrayList<Map<String, Object>> paramList = new ArrayList<Map<String, Object>>();
        Long lawEntityId = lawEntityMap.get(contract.getLong("id"));
        HashMap<String, Object> recordParamMap = new HashMap<String, Object>();
        recordParamMap.put("personid", contract.get("person.id"));
        recordParamMap.put("orgid", contract.get("ermanorg.id"));
        recordParamMap.put("lawentityid", lawEntityId);
        recordParamMap.put("startdate", contract.getDate("startdate"));
        paramList.add(recordParamMap);
        Map<String, Object> resultMap = null;
        try {
            resultMap = this.hrpiOperationService.doUpdateLaborRelRecord(paramList, false);
            LOGGER.info("resultMap=={}", resultMap);
        }
        catch (ParseException esc) {
            LOGGER.error((Throwable)esc);
        }
    }

    private List<DynamicObject> getSortedContracts(List<DynamicObject> sortedFiles) {
        ArrayList contractList = new ArrayList();
        sortedFiles.stream().forEach(file -> contractList.add(file.get("org.id") + "-" + file.get("person.id")));
        List<Long> orgList = sortedFiles.stream().map(file -> file.getLong("org.id")).collect(Collectors.toList());
        List<Long> personList = sortedFiles.stream().map(file -> file.getLong("person.id")).collect(Collectors.toList());
        DynamicObject[] contracts = this.queryContractInfo(orgList, personList, "protocoltype");
        List realContracts = Arrays.stream(contracts).filter(contract -> contractList.contains(contract.get("ermanorg.id") + "-" + contract.get("person.id"))).collect(Collectors.toList());
        List<DynamicObject> sortedContracts = realContracts.stream().sorted(Comparator.comparing(dy -> dy.getDate("startdate"), Comparator.naturalOrder())).collect(Collectors.toList());
        return sortedContracts;
    }

    public DynamicObject[] queryContractInfo(List<Long> orgList, List<Long> personList, String filterField) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hlcm_contract");
        String dynamicPropString = DynamicTransformUtil.getDynamicPropString(helper.getEntityName());
        QFilter orgFilter = new QFilter("ermanorg", "in", orgList);
        QFilter personFilter = new QFilter("person.id", "in", personList);
        if (HRStringUtils.isNotEmpty((String)filterField)) {
            QFilter pFilter = new QFilter(filterField, "in", (Object)new String[]{"1", "2"});
            orgFilter.and(pFilter);
        }
        return helper.query(dynamicPropString, new QFilter[]{QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf(), orgFilter, personFilter});
    }

    private Long saveLaborByFile(DynamicObject newLaborDy, ArrayList<Long> newInsertIds, int fileIndex, List<DynamicObject> files) {
        DynamicObject file = files.get(fileIndex);
        String number = CodeRuleServiceHelper.getNumber((String)"hrpi_laborrelrecord", (DynamicObject)newLaborDy, (String)file.getString("org.id"));
        String newNumber = number.replaceAll("^(0+)", "");
        newLaborDy.set("number", (Object)newNumber);
        this.doSaveLabor(newLaborDy, newInsertIds);
        return newLaborDy.getLong("id");
    }

    private DynamicObject updateHisLaborDy(DynamicObject recentlyEffectiveDy, DynamicObject thisFile) {
        DynamicObject updateDy = this.labServiceHelper.generateEmptyDynamicObject();
        recentlyEffectiveDy = this.labServiceHelper.loadSingle(recentlyEffectiveDy.getPkValue());
        HRDynamicObjectUtils.copy((DynamicObject)recentlyEffectiveDy, (DynamicObject)updateDy);
        updateDy.set("enddate", (Object)HRDateTimeUtils.addDay((Date)thisFile.getDate("startdate"), (long)-1L));
        updateDy.set("sysenddate", (Object)thisFile.getDate("startdate"));
        updateDy.set("bsed", (Object)thisFile.getDate("startdate"));
        updateDy.set("businessstatus", (Object)"2");
        return updateDy;
    }

    private void doSaveLabor(DynamicObject newLaborDy, ArrayList<Long> newInsertIds) {
        DynamicObjectCollection sortedDysCollection = new DynamicObjectCollection();
        sortedDysCollection.add((Object)newLaborDy);
        HashMap<String, DynamicObjectCollection> attachMap = new HashMap<String, DynamicObjectCollection>();
        attachMap.put("hrpi_laborrelrecord", sortedDysCollection);
        Map<String, Object> objectMap = this.hrpiOperationService.doSaveOrUpdate(attachMap, false);
        Long newInsertId = (Long)((List)((HashMap)((List)objectMap.get("data")).get(0)).get("ids")).get(1);
        if (newInsertIds != null) {
            newInsertIds.add(newInsertId);
        }
    }

    private DynamicObject createNewLaborDy(DynamicObject file) {
        DynamicObject newDy = this.labServiceHelper.generateEmptyDynamicObject();
        newDy.set("startdate", (Object)file.getDate("startdate"));
        newDy.set("enddate", (Object)HRDateTimeUtils.getSysMaxDate());
        newDy.set("sysenddate", (Object)HRDateTimeUtils.getSysMaxDate());
        newDy.set("bsed", (Object)file.getDate("startdate"));
        newDy.set("businessstatus", (Object)"1");
        newDy.set("person", file.get("person"));
        newDy.set("employee", file.get("employee"));
        newDy.set("org", file.get("org"));
        newDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        newDy.set("createtime", (Object)new Date());
        newDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newDy.set("modifytime", (Object)new Date());
        newDy.set("initstatus", (Object)"2");
        return newDy;
    }

    private void editLaborRecordByLeave(Collection<DynamicObject> leavePersonMainFile) {
        leavePersonMainFile.forEach(file -> {
            ArrayList<Map<String, Object>> paramList1 = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> recordParamMap = new HashMap<String, Object>();
            recordParamMap.put("personid", file.get("person.id"));
            recordParamMap.put("orgid", file.get("org.id"));
            recordParamMap.put("startdate", HRDateTimeUtils.addDay((Date)file.getDate("enddate"), (long)1L));
            paramList1.add(recordParamMap);
            LOGGER.info("paramListFile=={}", paramList1);
            Map<String, Object> resultMap = null;
            try {
                resultMap = this.hrpiOperationService.doUpdateLaborRelRecord(paramList1, true);
                LOGGER.info("FileResultMap=={}", resultMap);
            }
            catch (ParseException esc) {
                LOGGER.error((Throwable)esc);
            }
        });
    }

    private Map<Long, List<DynamicObject>> getDistinctFile(Map<Long, List<DynamicObject>> fileGroup) {
        HashMap<Long, List<DynamicObject>> newFileGroup = new HashMap<Long, List<DynamicObject>>();
        fileGroup.entrySet().stream().forEach(entry -> {
            ArrayList newFiles = new ArrayList();
            Long employeeId = (Long)entry.getKey();
            List files = (List)entry.getValue();
            newFiles.add(files.get(0));
            int size = files.size();
            for (int i = 0; i < size; ++i) {
                if (i == size - 1) continue;
                DynamicObject firstDy = (DynamicObject)files.get(i);
                DynamicObject secondDy = (DynamicObject)files.get(i + 1);
                if (firstDy.getLong("org.id") == secondDy.getLong("org.id")) continue;
                newFiles.add(secondDy);
            }
            newFileGroup.put(employeeId, newFiles);
        });
        return newFileGroup;
    }
}

