/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class ReviseRecordUpgradeTask
extends AbstractTask {
    private static String PAGE_REVISE_RECORD = "hrpi_reviserecord";
    private static String PAGE_REVISE_LOG = "hrpi_reviselog";
    private HRBaseServiceHelper reviseRecordHelper = new HRBaseServiceHelper(PAGE_REVISE_RECORD);
    private HRBaseServiceHelper reviseLogHelper = new HRBaseServiceHelper(PAGE_REVISE_LOG);
    private static final Log LOGGER = LogFactory.getLog(ReviseRecordUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        LOGGER.info("\u6570\u636e\u5347\u7ea7\u4efb\u52a1 \u5f00\u59cb\u6267\u884c:");
        this.executeUpgrade();
        this.disableTask();
        LOGGER.info("\u6570\u636e\u5347\u7ea7\u4efb\u52a1: \u6267\u884c\u5b8c\uff0c\u5171\u8017\u65f6 {} \u6beb\u79d2", (Object)(System.currentTimeMillis() - startTime));
    }

    private void executeUpgrade() {
        try (TXHandle required = TX.required();){
            try {
                QFilter reviseNumberFilter = new QFilter("revisenumber", "=", (Object)"");
                DynamicObject[] reviseRecordDynArr = this.reviseRecordHelper.loadDynamicObjectArray(new QFilter[]{reviseNumberFilter});
                Map<Long, DynamicObject> idVsRecordDynMap = Arrays.stream(reviseRecordDynArr).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn));
                List emptyValueReviseRecordIdList = Arrays.stream(reviseRecordDynArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
                QFilter reviseRecordIdFilter = new QFilter("reviserecord", "in", emptyValueReviseRecordIdList);
                DynamicObject[] reviseLogDynArr = this.reviseLogHelper.query("id, reviserecord, revisedate, revisenumber", new QFilter[]{reviseRecordIdFilter});
                Map<Long, List<DynamicObject>> reviseRecordIdVsDynListMap = Arrays.stream(reviseLogDynArr).collect(Collectors.groupingBy(dyn -> dyn.getLong("reviserecord.id")));
                Set<Map.Entry<Long, List<DynamicObject>>> entries = reviseRecordIdVsDynListMap.entrySet();
                for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
                    Long reviseRecordId = entry.getKey();
                    List<DynamicObject> reviseRecordDynList = entry.getValue();
                    DynamicObject reviseRecordDyn = idVsRecordDynMap.get(reviseRecordId);
                    reviseRecordDyn.set("revisenumber", (Object)reviseRecordDynList.get(0).getString("revisenumber"));
                    reviseRecordDyn.set("recorddate", (Object)reviseRecordDyn.getDate("createtime"));
                    reviseRecordDyn.set("issend", (Object)false);
                }
                this.reviseRecordHelper.save(reviseRecordDynArr);
            }
            catch (Exception ex) {
                required.markRollback();
                LOGGER.error("upgrade error", (Throwable)ex);
            }
        }
    }

    private void disableTask() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("40KEQ5W1JS0U");
        scheduleManager.disableSchedule("40KF1TQMR3V3");
    }
}

