/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIBosUserRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmpposRepository;
import kd.hrmp.hrpi.business.domian.service.IHRPIOperationService;
import kd.hrmp.hrpi.business.domian.service.impl.HRPIOperationServiceImpl;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;
import kd.hrmp.hrpi.common.HRPIValueConstants;

public class SyncPersonToUserForPositionTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(SyncPersonToUserForPositionTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.handleExecute(map, "1");
    }

    private void disableTask() {
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableSchedule("457Q3AAI723C");
    }

    public void handleExecute(Map<String, Object> map, String type) {
        long startTime = System.currentTimeMillis();
        LOGGER.warn("handleCustomParamStart->\u3010{}\u3011", map);
        this.handleCustomParam(map, type);
        LOGGER.warn("handleCustomParamEnd->{}->\u3010{}\u3011", (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime), map);
        this.disableTask();
    }

    private void handleErrorData(String type, IHRPIOperationService service) {
        long startTime = System.currentTimeMillis();
        LOGGER.info("handleErrorCustomParamStart");
        int batCount = 5000;
        long id = 0L;
        int total = 0;
        try {
            DynamicObject[] dyArray;
            while ((dyArray = HRPIBosUserRepository.getSyncLog(id, batCount)) != null && dyArray.length > 0) {
                this.handleErrorLogData(service, dyArray, type);
                if (dyArray.length >= batCount && total <= 100) {
                    id = dyArray[dyArray.length - 1].getLong("id");
                    ++total;
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle_log_ex", (Throwable)ex);
        }
        LOGGER.warn("handleErrorCustomParamFinish->{}", (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime));
    }

    private void handleCustomParam(Map<String, Object> map, String type) {
        IHRPIOperationService service = HRPIOperationServiceImpl.getInstance();
        String batchCountStr = (String)map.get("batchcount");
        String refreshAll = (String)map.getOrDefault("refreshall", "1");
        this.customBatch(service, batchCountStr);
        if (HRStringUtils.isEmpty((String)refreshAll)) {
            this.handleErrorData(type, service);
        }
    }

    private void customBatch(IHRPIOperationService service, String batchCountStr) {
        long startTime = System.currentTimeMillis();
        Map<Object, DynamicObject> onBrdStatus = this.getOnBrdStatus();
        int batchCount = 3000;
        try {
            if (HRStringUtils.isNotEmpty((String)batchCountStr) && (batchCount = Integer.parseInt(batchCountStr)) > 3000) {
                batchCount = 3000;
            }
        }
        catch (Exception exc) {
            LOGGER.error("transformRangeException", (Throwable)exc);
            return;
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        filters.add(QFilterUtil.getCurrentQf());
        int count = ORM.create().count("SyncPersonToUserTask", "hrpi_person", filters.toArray(new QFilter[0]));
        int maxCount = count / batchCount;
        int foCount = 0;
        List<Long> tempPersonIds = null;
        long id = 0L;
        try {
            while ((tempPersonIds = this.queryHandlePerson(id, batchCount, onBrdStatus)) != null && tempPersonIds.size() > 0) {
                this.batchHandleCustomData(tempPersonIds, service);
                if (tempPersonIds.size() >= batchCount && ++foCount <= maxCount) {
                    id = tempPersonIds.get(tempPersonIds.size() - 1);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.error("customBatch_ex", (Throwable)ex);
        }
        LOGGER.warn("handleCustomParamFinish->{}", (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTime));
    }

    public Map<Object, DynamicObject> getOnBrdStatus() {
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter = new QFilter("labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING);
        QFilter[] filters = new QFilter[]{qFilter, enableFilter};
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"id", (QFilter[])filters);
        if (!CollectionUtils.isEmpty((Map)entityCfMap)) {
            return entityCfMap;
        }
        return new HashMap<Object, DynamicObject>(16);
    }

    private List<Long> queryHandlePerson(long id, int batchCount, Map<Object, DynamicObject> onBrdStatus) {
        DynamicObject[] allPosEmpPosDynArr;
        boolean synParamEnable = this.getPosSynPlatParam();
        if (!synParamEnable) {
            return Lists.newArrayListWithExpectedSize((int)0);
        }
        ArrayList successPersonList = Lists.newArrayListWithExpectedSize((int)16);
        QFilter aPositionFilter = new QFilter("apositiontype", "=", (Object)"1");
        for (DynamicObject empPosDyn : allPosEmpPosDynArr = HRPIEmpposRepository.batchQueryAllEmpPos(aPositionFilter, id, batchCount)) {
            DynamicObject personDyn = empPosDyn.getDynamicObject("person");
            if (!Objects.nonNull(personDyn)) continue;
            successPersonList.add(personDyn.getLong("id"));
        }
        return successPersonList;
    }

    private boolean getPosSynPlatParam() {
        HRBaseServiceHelper odcConfigParamHelper = new HRBaseServiceHelper("haos_odcconfigparam");
        QFilter synPlatFormFilter = new QFilter("number", "=", (Object)"isPositionSyncPlatform");
        DynamicObject odcConfigParamDyn = odcConfigParamHelper.loadDynamicObject(new QFilter[]{synPlatFormFilter});
        if (Objects.isNull(odcConfigParamDyn)) {
            return false;
        }
        String paramValue = odcConfigParamDyn.getString("value");
        return HRStringUtils.equals((String)"1", (String)paramValue);
    }

    private void handleErrorLogData(IHRPIOperationService service, DynamicObject[] syncLogArr, String type) {
        ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>(10);
        if ("1".equals(type)) {
            this.handleRepeatAndSingleData(service, syncLogArr, userList);
        }
        this.pageExecuteUserInfoData(service, userList, "1");
    }

    private void handleRepeatAndSingleData(IHRPIOperationService service, DynamicObject[] syncLogArr, List<Map<String, Object>> userList) {
        String number;
        ArrayList<Map<String, Object>> repUserList = new ArrayList<Map<String, Object>>(10);
        HashSet<String> numberRep = new HashSet<String>(16);
        HashSet<String> numberDup = new HashSet<String>(16);
        for (DynamicObject dy : syncLogArr) {
            number = dy.getString("number");
            if (numberRep.contains(number)) {
                numberDup.add(number);
            }
            if (!HRStringUtils.isNotEmpty((String)number)) continue;
            numberRep.add(number);
        }
        for (DynamicObject dy : syncLogArr) {
            number = dy.getString("number");
            String param = dy.getString("param");
            Map userMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
            userMap.put("id", dy.getLong("id"));
            if (numberDup.contains(number)) {
                userMap.put("createtime", dy.get("createtime"));
                repUserList.add(userMap);
                continue;
            }
            userList.add(userMap);
        }
        if (repUserList.size() == 0) {
            return;
        }
        DynamicObjectCollection updateDys = new DynamicObjectCollection();
        List<Map<String, Object>> successIds = this.sortErrorLogHandleData(service, repUserList, updateDys);
        if (successIds.size() > 0) {
            this.updateErrorLog(successIds, repUserList, updateDys, "1");
            return;
        }
        if (updateDys.size() > 0) {
            HRPIBosUserRepository.saveSyncLog(updateDys);
        }
    }

    private List<Map<String, Object>> sortErrorLogHandleData(IHRPIOperationService service, List<Map<String, Object>> repUserList, DynamicObjectCollection updateDys) {
        ArrayList<Map<String, Object>> successIds = new ArrayList<Map<String, Object>>(10);
        List<String> numbers = repUserList.stream().map(tempMap -> (String)tempMap.get("number")).collect(Collectors.toList());
        List<String> names = repUserList.stream().map(tempMap -> (String)tempMap.get("name")).collect(Collectors.toList());
        DynamicObject[] syncLogArr = HRPIBosUserRepository.getSyncLogByFilter(names, numbers);
        HashMap<String, DynamicObject> quitMap = new HashMap<String, DynamicObject>(16);
        ArrayList<Map<String, Object>> quitList = new ArrayList<Map<String, Object>>(10);
        for (DynamicObject dy2 : syncLogArr) {
            String syncType;
            String name = dy2.getString("name");
            String number = dy2.getString("number");
            String param = dy2.getString("param");
            StringBuilder key = new StringBuilder();
            key.append(name);
            key.append(number);
            long personId = 0L;
            Map userMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
            if (userMap.containsKey("personid") && userMap.get("personid") instanceof Long) {
                personId = (Long)userMap.get("personid");
                key.append(personId);
            }
            if (!"quit".equals(syncType = dy2.getString("synctype")) || !"0".equals(dy2.getString("status"))) continue;
            this.handleSingle(quitList, name, number, syncType, "0", personId);
            quitMap.put(key.toString(), dy2);
        }
        HashMap<String, DynamicObject> updateMap = new HashMap<String, DynamicObject>(16);
        List sortCollection = Arrays.stream(syncLogArr).sorted(Comparator.comparing(dy -> dy.getDate("createtime"))).collect(Collectors.toList());
        Set quitSet = quitMap.keySet();
        HashSet<String> maxSet = new HashSet<String>(16);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(10);
        for (int idx = sortCollection.size() - 1; idx >= 0; --idx) {
            DynamicObject dy3 = (DynamicObject)sortCollection.get(idx);
            String number = dy3.getString("number");
            String name = dy3.getString("name");
            StringBuilder key = new StringBuilder();
            key.append(number);
            key.append(name);
            String param = dy3.getString("param");
            Map userMap = (Map)SerializationUtils.fromJsonString((String)param, Map.class);
            long personId = 0L;
            if (userMap.containsKey("personid") && userMap.get("personid") instanceof Long) {
                personId = (Long)userMap.get("personid");
                key.append(personId);
            }
            String syncType = dy3.getString("synctype");
            if (quitSet.contains(key.toString()) || maxSet.contains(key.toString())) {
                dy3.set("status", (Object)"1");
                dy3.set("modifytime", (Object)new Date());
                updateDys.add((Object)dy3);
                continue;
            }
            DynamicObject tmpDy = (DynamicObject)updateMap.get(key.toString());
            if (tmpDy != null) {
                if ("1".equals(tmpDy.getString("status"))) {
                    dy3.set("status", (Object)"1");
                    dy3.set("modifytime", (Object)new Date());
                    updateDys.add((Object)dy3);
                    this.handleSingle(list, name, number, syncType, "0", personId);
                } else {
                    this.handleSingle(list, name, number, tmpDy.getString("synctype"), "0", personId);
                }
                maxSet.add(key.toString());
                continue;
            }
            updateMap.put(key.toString(), dy3);
            if (!"0".equals(dy3.getString("status"))) continue;
            dy3.set("status", (Object)"1");
            dy3.set("modifytime", (Object)new Date());
            updateDys.add((Object)dy3);
        }
        if (list.size() > 0) {
            Map<String, Object> retMap = service.diffTypeSyncPersonToSysUer(list, "2");
            if (((Boolean)retMap.get("success")).booleanValue()) {
                successIds.addAll(list);
            }
            LOGGER.info("handleSameNumber:\u3010{}\u3011", retMap);
        }
        if (quitList.size() > 0) {
            Map<String, Object> quitRetMap = service.diffTypeSyncPersonToSysUer(quitList, "2");
            if (((Boolean)quitRetMap.get("success")).booleanValue()) {
                successIds.addAll(list);
            }
            LOGGER.info("handleSameQuitNumber:\u3010{}\u3011", quitRetMap);
        }
        return successIds;
    }

    private void batchHandleCustomData(List<Long> tempPersonIds, IHRPIOperationService service) {
        ArrayList<Map<String, Object>> userList = new ArrayList<Map<String, Object>>(10);
        for (Long personId : tempPersonIds) {
            this.handleSingle(userList, null, null, "update", "0", personId);
        }
        if (userList.size() <= 0) {
            LOGGER.info("batchHandleCustomDataEmpty");
            return;
        }
        this.pageExecuteUserInfoData(service, userList, "0");
    }

    private void pageExecuteUserInfoData(IHRPIOperationService service, List<Map<String, Object>> userList, String addCont) {
        LOGGER.info("batchHandleCustomData:{}", (Object)addCont);
        ArrayList<Map<String, Object>> successIds = new ArrayList<Map<String, Object>>(userList.size());
        Map<String, Object> retMap = service.diffTypeSyncPersonToSysUer(userList, "0".equals(addCont) ? "1" : "2");
        if ("1".equals(addCont)) {
            if (!((Boolean)retMap.get("success")).booleanValue()) {
                Map errorData = (Map)retMap.get("data");
                if (errorData != null && errorData.size() > 0) {
                    Set errorNumber = errorData.keySet();
                    List collect = userList.stream().filter(tmp -> errorNumber.contains(tmp.get("number"))).collect(Collectors.toList());
                    successIds.addAll(collect);
                }
            } else {
                successIds.addAll(userList);
            }
        }
        this.updateErrorLog(successIds, userList, null, addCont);
    }

    private void updateErrorLog(List<Map<String, Object>> successIdList, List<Map<String, Object>> userList, DynamicObjectCollection updateDys, String addCont) {
        List<Long> allPkIds = userList.stream().map(dy -> (Long)dy.get("id")).collect(Collectors.toList());
        Set successIds = successIdList.stream().map(dy -> (Long)dy.get("id")).collect(Collectors.toSet());
        DynamicObject[] syncLogByIds = HRPIBosUserRepository.getSyncLogByIds(allPkIds);
        if (syncLogByIds != null && syncLogByIds.length > 0) {
            DynamicObjectCollection dys = new DynamicObjectCollection();
            for (DynamicObject dy2 : syncLogByIds) {
                int tryTime = dy2.getInt("trytime");
                long accountId = RequestContext.get().getCurrUserId();
                long admin = 1L;
                if (accountId != 0L) {
                    admin = accountId;
                }
                dy2.set("modifier", (Object)admin);
                dy2.set("modifytime", (Object)new Date());
                dy2.set("trytime", (Object)(++tryTime));
                if (successIds.contains(dy2.getLong("id"))) {
                    dy2.set("status", (Object)"1");
                } else {
                    dy2.set("status", (Object)"0");
                }
                dys.add((Object)dy2);
            }
            if (updateDys != null) {
                dys.addAll((Collection)updateDys);
            }
            HRPIBosUserRepository.saveSyncLog(dys);
        }
        LOGGER.info("updateErrorLogFinish->{}", (Object)addCont);
    }

    private void handleSingle(List<Map<String, Object>> userList, String name, String number, String syncType, String type, long personId) {
        HashMap<String, Object> temp = new HashMap<String, Object>(16);
        if ("1".equals(type)) {
            temp.put("name", name);
            temp.put("number", number);
        } else if ("0".equals(type)) {
            temp.put("name", name);
            temp.put("number", number);
            temp.put("personid", personId);
        }
        temp.put("synctype", syncType);
        userList.add(temp);
    }
}

