/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.extplugin.PluginCall;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmpposRepository;
import kd.hrmp.hrpi.business.extpoint.ProxyUtils;
import kd.hrmp.hrpi.common.entity.EmpposUpdEntity;
import kd.sdk.hr.hrmp.hrpi.extpoint.ICustomUpdEmpposVid;

public class UpdHROrgPositonTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(UpdHROrgPositonTask.class);
    private static final String selProp = "boid,id,bsed,bsled";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isDeal = ProxyUtils.setPosVidTask((PluginCall<ICustomUpdEmpposVid, Boolean>)((PluginCall)ICustomUpdEmpposVid::updVidByTask));
        if (!isDeal) {
            this.defaultSetVid();
        }
    }

    private void defaultSetVid() {
        LOGGER.info("===UpdHROrgPositonTask start");
        int batchCount = 1000;
        long id = 0L;
        try {
            DynamicObject[] dyArray;
            while ((dyArray = HRPIEmpposRepository.batchQueryEmppos(id, batchCount)) != null && dyArray.length > 0) {
                Map<String, List<DynamicObject>> empposMap = Arrays.stream(dyArray).collect(Collectors.groupingBy(dy -> dy.getString("businessstatus")));
                ArrayList<DynamicObject> effEmpposList = new ArrayList<DynamicObject>(dyArray.length);
                ArrayList<DynamicObject> invEmpposList = new ArrayList<DynamicObject>(dyArray.length);
                EmpposUpdEntity empposUpdEntity = new EmpposUpdEntity();
                empposMap.forEach((businessstatus, empposList) -> {
                    if ("1".equals(businessstatus)) {
                        for (DynamicObject empposorgrel : empposList) {
                            this.checkAndSetField(empposorgrel, "adminorg.id", "adminorgvid_id", true, new ArrayList<Long>());
                            this.getPosTypeAndSetPosVal(empposorgrel, true, empposUpdEntity);
                            effEmpposList.add(empposorgrel);
                        }
                    } else {
                        for (DynamicObject empposorgrel : empposList) {
                            this.checkAndSetField(empposorgrel, "adminorg.id", "adminorgvid_id", false, empposUpdEntity.getAdminOrgIds());
                            this.getPosTypeAndSetPosVal(empposorgrel, false, empposUpdEntity);
                            invEmpposList.add(empposorgrel);
                        }
                    }
                });
                QFilter orgDataFilter = new QFilter("datastatus", "in", Arrays.asList("1", "2"));
                ArrayList<QFilter> orgFilterList = new ArrayList<QFilter>(4);
                orgFilterList.add(orgDataFilter);
                Map<Long, List<DynamicObject>> adminOrgBoidMap = HRPIEmpposRepository.getVidByBoId("haos_adminorghr", selProp, empposUpdEntity.getAdminOrgIds(), orgFilterList);
                QFilter posDataFilter = new QFilter("datastatus", "in", Arrays.asList("0", "1", "2"));
                ArrayList<QFilter> posDataFilterList = new ArrayList<QFilter>(4);
                posDataFilterList.add(posDataFilter);
                Map<Long, List<DynamicObject>> posBoidMap = HRPIEmpposRepository.getVidByBoId("hbpm_positionhr", selProp, empposUpdEntity.getPositionIds(), posDataFilterList);
                Map<Long, List<DynamicObject>> stdPosBoidMap = HRPIEmpposRepository.getVidByBoId("hbpm_stposition", selProp, empposUpdEntity.getStdPositionIds(), posDataFilterList);
                Map<Long, List<DynamicObject>> jobBoidMap = HRPIEmpposRepository.getVidByBoId("hbjm_jobhr", selProp, empposUpdEntity.getJobIds(), posDataFilterList);
                for (DynamicObject dy2 : invEmpposList) {
                    List<DynamicObject> queryOrgAdminList;
                    Date endDate = dy2.getDate("enddate");
                    long adminId = dy2.getLong("adminorg.id");
                    long adminVId = dy2.getLong("adminorgvid_id");
                    if (adminId != 0L && adminVId == 0L && endDate != null && !CollectionUtils.isEmpty(adminOrgBoidMap) && !CollectionUtils.isEmpty(queryOrgAdminList = adminOrgBoidMap.get(adminId))) {
                        this.setVid(dy2, endDate, queryOrgAdminList, "adminorgvid_id");
                    }
                    this.setPosStdJobVid(posBoidMap, stdPosBoidMap, jobBoidMap, dy2, endDate);
                }
                if (!CollectionUtils.isEmpty(invEmpposList)) {
                    HRPIEmpposRepository.saveEmppos(invEmpposList);
                }
                if (!CollectionUtils.isEmpty(effEmpposList)) {
                    HRPIEmpposRepository.saveEmppos(effEmpposList);
                }
                if (dyArray.length < batchCount) break;
                id = dyArray[dyArray.length - 1].getLong("id");
            }
            ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            scheduleManager.disableJob("3PAYTFB1KXIF");
            scheduleManager.disableSchedule("3PECW48Y=YRN");
            LOGGER.info("===UpdHROrgPositonTask finish");
        }
        catch (Exception exp) {
            LOGGER.error("===UpdHROrgPositonTask error", (Throwable)exp);
            throw exp;
        }
    }

    private void setPosStdJobVid(Map<Long, List<DynamicObject>> posBoidMap, Map<Long, List<DynamicObject>> stdPosBoidMap, Map<Long, List<DynamicObject>> jobBoidMap, DynamicObject dy, Date endDate) {
        String positionType;
        switch (positionType = dy.getString("apositiontype")) {
            case "1": {
                List<DynamicObject> queryList;
                long posId = dy.getLong("position.id");
                long posVId = dy.getLong("positionvid_id");
                if (posId == 0L || posVId != 0L || endDate == null || CollectionUtils.isEmpty(posBoidMap) || CollectionUtils.isEmpty(queryList = posBoidMap.get(posId))) break;
                this.setVid(dy, endDate, queryList, "positionvid_id");
                break;
            }
            case "0": {
                List<DynamicObject> queryList;
                long stdposId = dy.getLong("stdposition.id");
                long stdposVId = dy.getLong("stdpositionvid_id");
                if (stdposId == 0L || stdposVId != 0L || endDate == null || CollectionUtils.isEmpty(stdPosBoidMap) || CollectionUtils.isEmpty(queryList = stdPosBoidMap.get(stdposId))) break;
                this.setVid(dy, endDate, queryList, "stdpositionvid_id");
                break;
            }
            case "2": {
                List<DynamicObject> queryList;
                long jobId = dy.getLong("job.id");
                long jobVId = dy.getLong("jobvid_id");
                if (jobId == 0L || jobVId != 0L || endDate == null || CollectionUtils.isEmpty(jobBoidMap) || CollectionUtils.isEmpty(queryList = jobBoidMap.get(jobId))) break;
                this.setVid(dy, endDate, queryList, "jobvid_id");
                break;
            }
            default: {
                LOGGER.warn("EmpposorgrelServiceHelper#setEmpposorgrelHisInfo positionType error {}", (Object)positionType);
            }
        }
    }

    private void setVid(DynamicObject dy, Date endDate, List<DynamicObject> queryList, String vidKey) {
        queryList.stream().filter(queryOrgAdmin -> queryOrgAdmin.getDate("bsed") != null && queryOrgAdmin.getDate("bsled") != null).filter(queryOrgAdmin -> endDate.compareTo(queryOrgAdmin.getDate("bsed")) >= 0).filter(queryOrgAdmin -> queryOrgAdmin.getDate("bsled").compareTo(endDate) >= 0).findFirst().ifPresent(targetDy -> dy.set(vidKey, (Object)targetDy.getLong("id")));
    }

    private void getPosTypeAndSetPosVal(DynamicObject empposorgrel, boolean isEff, EmpposUpdEntity empposUpdEntity) {
        String positionType;
        switch (positionType = empposorgrel.getString("apositiontype")) {
            case "1": {
                this.checkAndSetField(empposorgrel, "position.id", "positionvid_id", isEff, empposUpdEntity.getPositionIds());
                break;
            }
            case "0": {
                this.checkAndSetField(empposorgrel, "stdposition.id", "stdpositionvid_id", isEff, empposUpdEntity.getStdPositionIds());
                empposorgrel.set("positionvid_id", (Object)empposorgrel.getLong("position.id"));
                break;
            }
            case "2": {
                this.checkAndSetField(empposorgrel, "job.id", "jobvid_id", isEff, empposUpdEntity.getJobIds());
                empposorgrel.set("positionvid_id", (Object)empposorgrel.getLong("position.id"));
                break;
            }
            default: {
                LOGGER.warn("EmpposorgrelServiceHelper#setEmpposorgrelHisInfo positionType error {}", (Object)positionType);
            }
        }
    }

    private void checkAndSetField(DynamicObject empposorgrel, String key, String vidKey, boolean isEff, List<Long> valIds) {
        long id = empposorgrel.getLong(key);
        long vid = empposorgrel.getLong(vidKey);
        if (id != 0L && vid == 0L && isEff) {
            empposorgrel.set(vidKey, empposorgrel.get(key));
        }
        if (id != 0L && vid == 0L && !isEff) {
            valIds.add(id);
        }
    }
}

