/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrpi.business.domian.service.impl.generic.coderule.DefaultPersonGenericCodeRule;
import org.apache.commons.lang.time.StopWatch;

public class UpdateCodeRuleTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(UpdateCodeRuleTask.class);
    private static final int BATCH_COUNT = 1000;
    private static final HRBaseServiceHelper EMPENTREL_HELPER = new HRBaseServiceHelper("hrpi_empentrel");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("UpdateCodeRuleTask#execute_start");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.empentrelCodeRuleUpdate();
            stopWatch.split();
            LOGGER.info("UpdateCodeRuleTask#execute_empentrelStart time is: {} ms.", (Object)stopWatch.getSplitTime());
        }
        finally {
            stopWatch.stop();
            LOGGER.info("UpdateCodeRuleTask#execute_end time is: {} ms.", (Object)stopWatch.getTime());
        }
    }

    private void empentrelCodeRuleUpdate() {
        long id = 0L;
        try {
            Object[] dyArray;
            while ((dyArray = UpdateCodeRuleTask.queryEmpentrel(id)) != null && dyArray.length > 0) {
                DynamicObjectCollection dyColl = new DynamicObjectCollection();
                dyColl.addAll((Collection)Lists.newArrayList((Object[])dyArray));
                DefaultPersonGenericCodeRule.getInstance().getNumbersAndUpdate("hrpi_empentrel", dyColl, "number");
                LOGGER.info(String.format("entityName[%s] getNumbersAndUpdate. ", "hrpi_empentrel"));
                if (dyArray.length >= 1000) {
                    id = dyArray[dyArray.length - 1].getLong("id");
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            LOGGER.error("handle_empentrel_ex", (Throwable)ex);
        }
    }

    private static DynamicObject[] queryEmpentrel(long id) {
        QFilter qFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter statusFilter = new QFilter("businessstatus", "=", (Object)"1");
        QFilter codeRuleFixedFilter = new QFilter("number", "=", (Object)"FIXED_NUMBER");
        QFilter[] qFilters = new QFilter[]{new QFilter("id", ">", (Object)id), qFilter, statusFilter, codeRuleFixedFilter};
        return EMPENTREL_HELPER.query("id,boid,number,empnumber,iscurrentversion,businessstatus", qFilters, "id", 1000);
    }
}

