/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.business.domian.service.IHRPIOperationService;
import kd.hrmp.hrpi.business.domian.service.impl.HRPIOperationServiceImpl;
import kd.hrmp.hrpi.business.task.LaborRecordUpgradeService;

public class UpdateEmptyLawLabRecordTask
extends AbstractTask {
    private int BATCH_COUNT = 1000;
    private static final Log LOGGER = LogFactory.getLog(UpdateEmptyLawLabRecordTask.class);
    private IHRPIOperationService SERVICE_HELPER = HRPIOperationServiceImpl.getInstance();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("UpdateEmptyLawLabRecordTaskStart");
        this.updateEmptyLawLabRecord(map);
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        scheduleManager.disableJob("3E2P=YFI=AUT");
        scheduleManager.disableSchedule("3E2PDCY5139H");
        LOGGER.info("UpdateEmptyLawLabRecordTaskEnd");
    }

    public void updateEmptyLawLabRecord(Map<String, Object> paramMap) {
        block5: {
            LOGGER.info("updateEmptyLawLabRecordMap-->{}", paramMap);
            Object updateAll = paramMap.get("updateAll");
            Boolean upgradeAll = updateAll != null ? Boolean.valueOf((String)updateAll) : Boolean.TRUE;
            String employeeIds = (String)paramMap.get("employeeIds");
            if (!upgradeAll.booleanValue() && HRStringUtils.isEmpty((String)employeeIds)) {
                LOGGER.info("LaborRecordUpgradeService not set employeeIds");
                return;
            }
            try {
                if (upgradeAll.booleanValue()) {
                    DynamicObject[] dyArray;
                    long id = 0L;
                    while ((dyArray = HRPIEmployeeRepository.batchQueryEmployee(id, this.BATCH_COUNT)) != null && dyArray.length > 0) {
                        id = dyArray[dyArray.length - 1].getLong("id");
                        if (!this.doUpdateEmptyLabRecord(dyArray).booleanValue() || dyArray.length >= this.BATCH_COUNT) continue;
                        break block5;
                    }
                    break block5;
                }
                String[] employees = employeeIds.split(",");
                List<Long> empIds = Arrays.stream(employees).map(Long::parseLong).collect(Collectors.toList());
                DynamicObject[] dyArray = HRPIEmployeeRepository.listEmployeeIds(empIds);
                this.doUpdateEmptyLabRecord(dyArray);
            }
            catch (Exception ex) {
                LOGGER.error("update_labor_ex", (Throwable)ex);
            }
        }
    }

    private Boolean doUpdateEmptyLabRecord(DynamicObject[] dyArray) {
        List<DynamicObject> empLists = Arrays.asList(dyArray);
        List<Long> queryIds = empLists.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        if (queryIds.size() == 0) {
            return Boolean.FALSE;
        }
        Object[] labRecordLawDys = HRPIEmployeeRepository.getLabRecordLawByEmpId(queryIds);
        if (HRArrayUtils.isEmpty((Object[])labRecordLawDys)) {
            LOGGER.info("not find empty lawentity");
            return Boolean.FALSE;
        }
        HashMap<String, Long> personOrgLawMap = new HashMap<String, Long>(16);
        HashMap<String, Date> personOrgDateMap = new HashMap<String, Date>(16);
        this.collectContractInfo((DynamicObject[])labRecordLawDys, personOrgLawMap, personOrgDateMap);
        List<Map<String, Object>> jobList = this.makeUpdateData((DynamicObject[])labRecordLawDys, personOrgLawMap, personOrgDateMap);
        if (!CollectionUtils.isEmpty(jobList)) {
            this.SERVICE_HELPER.updateLaborRelRecord(jobList);
        }
        return Boolean.TRUE;
    }

    private List<Map<String, Object>> makeUpdateData(DynamicObject[] labRecordLawDys, Map<String, Long> personOrgLawMap, Map<String, Date> personOrgDateMap) {
        ArrayList<Map<String, Object>> jobList = new ArrayList<Map<String, Object>>(labRecordLawDys.length);
        for (DynamicObject empLawDy : labRecordLawDys) {
            HashMap<String, Comparable<Long>> tmpMap = new HashMap<String, Comparable<Long>>(16);
            long personId = empLawDy.getLong("person.id");
            long orgId = empLawDy.getLong("org.id");
            String key = personId + "-" + orgId;
            tmpMap.put("personid", Long.valueOf(personId));
            tmpMap.put("orgid", Long.valueOf(orgId));
            tmpMap.put("lawentityid", personOrgLawMap.get(key));
            tmpMap.put("startdate", personOrgDateMap.get(key));
            jobList.add(tmpMap);
        }
        return jobList;
    }

    private void collectContractInfo(DynamicObject[] labRecordLawDys, Map<String, Long> personOrgLawMap, Map<String, Date> personOrgDateMap) {
        List<Long> personIds = Arrays.stream(labRecordLawDys).map(dy -> dy.getLong("person.id")).collect(Collectors.toList());
        List<Long> orgIds = Arrays.stream(labRecordLawDys).map(dy -> dy.getLong("org.id")).collect(Collectors.toList());
        DynamicObject[] contractInfoDys = new LaborRecordUpgradeService().queryContractInfo(orgIds, personIds, "protocoltype");
        List sortedContracts = Arrays.stream(contractInfoDys).sorted(Comparator.comparing(dy -> dy.getDate("startdate"), Comparator.reverseOrder())).collect(Collectors.toList());
        for (DynamicObject contractInfo : sortedContracts) {
            long orgId = contractInfo.getLong("ermanorg.id");
            long contractPersonId = contractInfo.getLong("person.id");
            String key = contractPersonId + "-" + orgId;
            Date startDate = contractInfo.getDate("startdate");
            DynamicObject lawEntity = contractInfo.getDynamicObject("actualsigncompany.lawentity");
            Set<String> keySet = personOrgLawMap.keySet();
            if (keySet.contains(key)) continue;
            if (lawEntity != null) {
                personOrgLawMap.put(key, lawEntity.getLong("id"));
            } else {
                personOrgLawMap.put(key, null);
            }
            personOrgDateMap.put(key, startDate);
        }
    }
}

