/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.tools;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.impl.ORMImpl;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import kd.hrmp.hrpi.business.infrastructure.utils.QFilterUtil;

public class CustomRuleUtil {
    private static final Log LOGGER = LogFactory.getLog(CustomRuleUtil.class);
    public static ThreadLocal<Map<String, List<DynamicObject>>> threadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processOfLatestRecord(String entityNumber, DynamicObjectCollection dyColl) throws KDBizException {
        try {
            HashMap map2 = new HashMap();
            map2.put(entityNumber, new ArrayList());
            threadLocal.set(map2);
            Set personIds = dyColl.stream().filter(dy -> dy.get("boid") == null || (Long)dy.get("boid") == 0L).map(CustomRuleUtil::getPersonId).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(personIds)) {
                LOGGER.info("this batch has no data to insert");
                return;
            }
            DynamicObject[] latestDys = new HRBaseServiceHelper(entityNumber).loadDynamicObjectArray(new QFilter[]{new QFilter("person", "in", personIds), QFilterUtil.getInitStatusFinish(), QFilterUtil.isLatestRecord(), QFilterUtil.getStatusFilters(), QFilterUtil.getDataStatusFilter(), QFilterUtil.getCurrentQf()});
            if (latestDys == null || latestDys.length == 0) {
                dyColl.stream().filter(dy -> dy.get("boid") == null || (Long)dy.get("boid") == 0L).forEach(dy -> dy.set("islatestrecord", (Object)Character.valueOf('1')));
                LOGGER.info("this batch , all the data need to be inserted has no latest data in database");
                return;
            }
            List repeatPersonIds = Arrays.stream(latestDys).collect(Collectors.groupingBy(CustomRuleUtil::getPersonId)).entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(repeatPersonIds)) {
                throw new KDBizException("the personIds in this batch found two match error data in database , one person match one more latest_record employee : " + JSONObject.toJSONString(repeatPersonIds));
            }
            Map<Long, DynamicObject> personIdWithObj = Arrays.stream(latestDys).collect(Collectors.toMap(CustomRuleUtil::getPersonId, dy -> dy));
            List needToBeUpdated = dyColl.stream().filter(dy -> dy.get("boid") != null && (Long)dy.get("boid") != 0L).filter(dy -> personIdWithObj.containsKey(CustomRuleUtil.getPersonId(dy))).map(CustomRuleUtil::getPersonId).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
            dyColl.stream().filter(dy -> dy.get("boid") == null || (Long)dy.get("boid") == 0L).forEach(dy -> {
                DynamicObject databaseObj = (DynamicObject)personIdWithObj.get(CustomRuleUtil.getPersonId(dy));
                if (databaseObj == null) {
                    dy.set("islatestrecord", (Object)Character.valueOf('1'));
                } else {
                    CustomRuleUtil.compareAndSet(dy, databaseObj, dyColl, needToBeUpdated);
                }
            });
            dyColl.addAll((Collection)threadLocal.get().get(entityNumber));
        }
        finally {
            Map<String, List<DynamicObject>> empMap = threadLocal.get();
            Optional.ofNullable(empMap).ifPresent(map -> {
                List cfr_ignored_0 = (List)map.remove(entityNumber);
            });
        }
    }

    public static long getPersonId(DynamicObject dy) {
        if (dy.containsProperty("person_id") && 0L != dy.getLong("person_id")) {
            return dy.getLong("person_id");
        }
        Object o = dy.get("person");
        if (o instanceof DynamicObject) {
            return (Long)((DynamicObject)o).getPkValue();
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        throw new KDBizException("this dy cannot find the id of person");
    }

    private static void compareAndSet(DynamicObject storageDy, DynamicObject databaseDy, DynamicObjectCollection dyColl, List<Long> needToBeUpdated) {
        Date storageStartDate;
        Date databaseStartDate = databaseDy.getDate("startdate");
        boolean storageBeforeDatabase = databaseStartDate.compareTo(storageStartDate = storageDy.getDate("startdate")) == 0 ? Objects.nonNull(storageDy.getDate("bred")) : storageStartDate.before(databaseStartDate);
        CustomRuleUtil.doCompareAndSet(storageDy, dyColl, needToBeUpdated, databaseDy, storageBeforeDatabase);
    }

    private static void doCompareAndSet(DynamicObject storageDy, DynamicObjectCollection dyColl, List<Long> needToBeUpdated, DynamicObject databaseDy, boolean storageBeforeDatabase) {
        if (needToBeUpdated.contains(CustomRuleUtil.getPersonId(storageDy))) {
            DynamicObject object = dyColl.stream().filter(dy -> dy.get("boid") != null && (Long)dy.get("boid") != 0L && CustomRuleUtil.getPersonId(dy) == CustomRuleUtil.getPersonId(storageDy)).findFirst().get();
            if (DateUtil.isSameDay(object.getDate("startdate"), databaseDy.getDate("startdate"))) {
                object.set("islatestrecord", (Object)Character.valueOf(CustomRuleUtil.booleanToChar(storageBeforeDatabase)));
            } else {
                needToBeUpdated.remove(CustomRuleUtil.getPersonId(storageDy));
                CustomRuleUtil.compareAndSet(storageDy, object, dyColl, needToBeUpdated);
            }
        } else {
            storageDy.set("islatestrecord", (Object)Character.valueOf(CustomRuleUtil.booleanToChar(!storageBeforeDatabase)));
            if (!storageBeforeDatabase) {
                CustomRuleUtil.createDataFromDatabase(databaseDy);
            }
        }
    }

    private static void createDataFromDatabase(DynamicObject databaseDy) {
        DynamicObject instance = (DynamicObject)databaseDy.getDataEntityType().createInstance();
        HRDynamicObjectUtils.copy((DynamicObject)databaseDy, (DynamicObject)instance);
        String entityName = databaseDy.getDynamicObjectType().getName();
        instance.set("id", (Object)new ORMImpl().genLongId(entityName));
        instance.set("islatestrecord", (Object)Character.valueOf('0'));
        threadLocal.get().get(entityName).add(instance);
    }

    private static char booleanToChar(boolean b) {
        return b ? (char)'1' : '0';
    }

    public static int convertSwitch2Int(Object switchValue) {
        if (Objects.isNull(switchValue)) {
            return 0;
        }
        if (switchValue instanceof Boolean) {
            return Boolean.TRUE == switchValue ? 1 : 0;
        }
        if (switchValue instanceof String) {
            return HRStringUtils.equals((String)"1", (String)switchValue.toString()) || HRStringUtils.equalsIgnoreCase((String)"true", (String)switchValue.toString()) ? 1 : 0;
        }
        if (switchValue instanceof Integer) {
            return (Integer)switchValue;
        }
        return 0;
    }
}

