/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.business.tools;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Button;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrpi.business.infrastructure.utils.DynamicTransformUtil;

public class TestToolsPlugin
extends HRDataBaseEdit {
    private static final Log LOG = LogFactory.getLog(TestToolsPlugin.class);
    private static final String SEARCHMSGBTN = "searchmsg";
    private static final String MSGNUMBER = "msgnumber";
    private static final String MSGENTRY = "msgentry";
    private static final String SERVICEBTN = "servicebtn";
    private static final String CLOUDID = "cloudid";
    private static final String APPID = "appid";
    private static final String SERVICENAME = "servicename";
    private static final String METHODNAME = "methodname";
    private static final String ENTRYENTITY = "entryentity";
    private static final String PARAMTYPE = "paramtype";
    private static final String PARAMARRTYPE = "paramarrtype";
    private static final String PARAMKEY = "paramkey";
    private static final String PARAMDATA = "paramdata";
    private static String PARAMRESULT = "issuccess";
    private static String PARAMS = "params";
    private static String SERVICERESPONSE = "serviceresponse";
    private static String APPID_HJM = "hjm";
    private static String CACHE_KEY_PRE = "TestToolsPlugin-CACHE-";
    private static int MAX_PARAM_SIZE = 10;
    private static int INIT_HASH_SIZE = 8;
    private static int MAX_LIST_SIZE = 500;
    private static final String LISTENTRYENTITY = "listentryentity";
    private static final String LISTCLOUDID = "listcloudid";
    private static final String LISTAPPID = "listappid";
    private static final String LISTSERVICENAME = "listservicename";
    private static final String LISTMETHODNAME = "listmethodname";
    private static final String LISTPARAMS = "listparams";
    private static final String SERVICEDATE = "servicedate";
    private static final String SEARCHSERVICEBTN = "searchservicebtn";
    private static final String COPYSERVICEBTN = "copyservicebtn";
    private static List<String> MSG_SHOW_COLs = Arrays.asList("number", "msgtitle", "msgtag", "sendtime", "params");

    public void registerListener(EventObject evn) {
        super.registerListener(evn);
        Button servicebtn = (Button)this.getView().getControl(SERVICEBTN);
        servicebtn.addClickListener((ClickListener)this);
        Button searchservicebtn = (Button)this.getView().getControl(SEARCHSERVICEBTN);
        searchservicebtn.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        DynamicObject data = this.getModel().getDataEntity();
        if (HRStringUtils.equals((String)SEARCHMSGBTN, (String)source.getKey())) {
            this.getModel().deleteEntryData(MSGENTRY);
            String msgNumber = data.getString(MSGNUMBER);
            if (HRStringUtils.isEmpty((String)msgNumber)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6d88\u606f\u7f16\u7801\u8fdb\u884c\u67e5\u8be2", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
                return;
            }
            HRBaseServiceHelper service = new HRBaseServiceHelper("hrcs_msgcenter");
            DynamicObject msg = service.loadDynamicObject(new QFilter("number", "=", (Object)msgNumber));
            if (ObjectUtils.isEmpty((Object)msg)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setMsgInfo(msg);
        } else if (HRStringUtils.equals((String)SEARCHSERVICEBTN, (String)source.getKey())) {
            // empty if block
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        DynamicObject data = this.getModel().getDataEntity();
        if (HRStringUtils.equals((String)SERVICEBTN, (String)afterDoOperationEventArgs.getOperateKey())) {
            if (this.valideServiceParams()) {
                String cloudId = data.getString(CLOUDID);
                String appId = data.getString(APPID);
                String cacheStringData = data.getString(SERVICENAME);
                String methodName = data.getString(METHODNAME);
                try {
                    JSONObject jon = new JSONObject();
                    jon.put("date", (Object)new Date());
                    Map<String, Object> info = this.getParams();
                    if (((Boolean)info.get(PARAMRESULT)).booleanValue()) {
                        Object returnInfo = this.invokeMethod(cloudId, appId, cacheStringData, methodName, (List)info.get(PARAMS));
                        ValueFilter valueFilter = new ValueFilter(){

                            public Object process(Object o, String s, Object o1) {
                                return TestToolsPlugin.this.dealDynaObjectData(o1);
                            }
                        };
                        String pretty = JSON.toJSONString((Object)returnInfo, (SerializeFilter)valueFilter, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
                        CodeEdit edit = (CodeEdit)this.getView().getControl(SERVICERESPONSE);
                        edit.setText(pretty);
                        this.saveToCache();
                    }
                }
                catch (Exception var12) {
                    if (!(var12.getCause() instanceof ClassNotFoundException || var12.getMessage() != null && var12.getMessage().indexOf(ResManager.loadKDString((String)"\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0])) > -1)) {
                        this.getView().showErrorNotification(var12.getMessage());
                        throw var12;
                    }
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u670d\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u5e94\u7528\u6807\u8bc6\u3001\u670d\u52a1\u914d\u7f6e\u4ee5\u53ca\u53c2\u6570", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (HRStringUtils.equals((String)COPYSERVICEBTN, (String)afterDoOperationEventArgs.getOperateKey())) {
            List personalData;
            EntryGrid entryGrid = (EntryGrid)this.getControl(LISTENTRYENTITY);
            int[] selectIndex = entryGrid.getSelectRows();
            if (selectIndex == null || selectIndex.length == 0) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (selectIndex.length > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
                return;
            }
            String cacheStringData = (String)HRAppCache.get((String)APPID_HJM).get(this.getCacheKey(), String.class);
            if (HRStringUtils.isNotEmpty((String)cacheStringData) && !ObjectUtils.isEmpty((Object)(personalData = (List)SerializationUtils.deSerializeFromBase64((String)cacheStringData))) && personalData.size() > selectIndex[0]) {
                Map info = (Map)personalData.get(selectIndex[0]);
                this.getModel().setValue(CLOUDID, info.get(CLOUDID));
                this.getModel().setValue(APPID, info.get(APPID));
                this.getModel().setValue(SERVICENAME, info.get(SERVICENAME));
                this.getModel().setValue(METHODNAME, info.get(METHODNAME));
                this.getModel().deleteEntryData(ENTRYENTITY);
                DynamicObjectCollection entries = (DynamicObjectCollection)info.get(ENTRYENTITY);
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, entries.size());
                for (int i = 0; i < entries.size(); ++i) {
                    DynamicObject entryInfo = (DynamicObject)entries.get(i);
                    this.getModel().setValue(PARAMTYPE, (Object)entryInfo.getString(PARAMTYPE), i);
                    this.getModel().setValue(PARAMARRTYPE, (Object)entryInfo.getString(PARAMARRTYPE), i);
                    this.getModel().setValue(PARAMKEY, (Object)entryInfo.getString(PARAMKEY), i);
                    this.getModel().setValue(PARAMDATA, (Object)entryInfo.getString("paramdata_tag"), i);
                    this.getModel().setValue("paramdata_tag", (Object)entryInfo.getString("paramdata_tag"), i);
                }
            }
            this.getView().updateView();
        }
    }

    private void setMsgInfo(DynamicObject msg) {
        IDataEntityType dataEntityType = msg.getDataEntityType();
        DataEntityPropertyCollection props = dataEntityType.getProperties();
        this.getModel().batchCreateNewEntryRow(MSGENTRY, MSG_SHOW_COLs.size());
        for (int i = 0; i < MSG_SHOW_COLs.size(); ++i) {
            String col = MSG_SHOW_COLs.get(i);
            IDataEntityProperty prop = (IDataEntityProperty)props.get((Object)col);
            if (ObjectUtils.isEmpty((Object)prop)) continue;
            this.getModel().setValue("msgcolname", (Object)prop.getDisplayName(), i);
            this.getModel().setValue("msgcolcode", (Object)col, i);
            if (HRStringUtils.equals((String)"params", (String)col)) {
                String info = msg.getString(col);
                if (!HRStringUtils.isNotEmpty((String)info)) continue;
                Object content = SerializationUtils.deSerializeFromBase64((String)info);
                this.getModel().setValue("msgcoldata", content, i);
                continue;
            }
            this.getModel().setValue("msgcoldata", msg.get(col), i);
        }
    }

    private boolean valideServiceParams() {
        DynamicObject data = this.getModel().getDataEntity();
        String cloudid = data.getString(CLOUDID);
        String appId = data.getString(APPID);
        String serviceName = data.getString(SERVICENAME);
        String methodName = data.getString(METHODNAME);
        if (HRStringUtils.isEmpty((String)cloudid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e91\u5e94\u7528\u6807\u8bc6", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isEmpty((String)appId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5e94\u7528\u6807\u8bc6", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isEmpty((String)serviceName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u670d\u52a1\u540d\u79f0", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (HRStringUtils.isEmpty((String)methodName)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u670d\u52a1\u65b9\u6cd5", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private Map<String, Object> getParams() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder errorInfo = new StringBuilder();
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObjectCollection params = data.getDynamicObjectCollection(ENTRYENTITY);
        if (ObjectUtils.isEmpty((Object)params)) {
            result.put(PARAMRESULT, Boolean.FALSE);
            return result;
        }
        ArrayList<Object> resultData = new ArrayList<Object>();
        for (int i = 0; i < params.size(); ++i) {
            DynamicObject param = (DynamicObject)params.get(i);
            String paramtype = param.getString(PARAMTYPE);
            String paramarrtype = param.getString(PARAMARRTYPE);
            String paramkey = param.getString(PARAMKEY);
            String paramdata = param.getString("paramdata_tag");
            boolean success = true;
            if (HRStringUtils.isEmpty((String)paramtype) && HRStringUtils.isEmpty((String)paramkey) && HRStringUtils.isEmpty((String)paramdata)) continue;
            if (HRStringUtils.isEmpty((String)paramtype)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u9009\u62e9\u53c2\u6570\u7c7b\u578b\n", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (HRStringUtils.isEmpty((String)paramarrtype)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u9009\u62e9\u53c2\u6570\u96c6\u5408\u7c7b\u578b\n", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype) && HRStringUtils.isEmpty((String)paramkey)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u9009\u62e9\u5b9e\u4f53\u7f16\u7801\n", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (HRStringUtils.isEmpty((String)paramdata)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u8bf7\u586b\u5199\u53c2\u6570\u503c\n", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]), i + 1));
                success = false;
            }
            if (!success) continue;
            try {
                if (HRStringUtils.equals((String)"single", (String)paramarrtype)) {
                    this.dealSingleTypeData(paramtype, paramkey, paramdata, resultData);
                    continue;
                }
                if (HRStringUtils.equals((String)"array", (String)paramarrtype)) {
                    this.dealArrayTypeData(paramtype, paramkey, paramdata, resultData);
                    continue;
                }
                if (!HRStringUtils.equals((String)"list", (String)paramarrtype)) continue;
                this.dealListTypeData(paramtype, paramkey, paramdata, resultData);
                continue;
            }
            catch (Exception exception) {
                LOG.error("TestToolsPlugin.getParams:", (Throwable)exception);
                errorInfo.append(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u53c2\u6570\u503c\u89e3\u6790\u9519\u8bef\n", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]), i + 1));
                result.put(PARAMRESULT, Boolean.FALSE);
            }
        }
        if (HRStringUtils.isNotEmpty((String)errorInfo.toString())) {
            this.getView().showErrorNotification(errorInfo.toString());
            result.put(PARAMRESULT, Boolean.FALSE);
        } else {
            result.put(PARAMS, resultData);
            result.put(PARAMRESULT, Boolean.TRUE);
        }
        return result;
    }

    private void dealSingleTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        if (HRStringUtils.equals((String)"int", (String)paramtype)) {
            resultData.add(Integer.parseInt(paramdata));
        } else if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            resultData.add(Long.parseLong(paramdata));
        } else if (HRStringUtils.equals((String)"boolean", (String)paramtype)) {
            resultData.add(Boolean.parseBoolean(paramdata));
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            resultData.add(paramdata);
        } else if (HRStringUtils.equals((String)"date", (String)paramtype)) {
            resultData.add(HRDateTimeUtils.parseDate((String)String.valueOf(paramdata)));
        } else if (HRStringUtils.equals((String)"map", (String)paramtype)) {
            Map map = (Map)JSON.parseObject((String)paramdata, Map.class);
            map.forEach((key, value) -> {
                if (value instanceof String && ((String)value).endsWith("DATE")) {
                    try {
                        String dateStr = ((String)value).substring(0, value.toString().indexOf("DATE"));
                        Date date = HRDateTimeUtils.parseDate((String)dateStr);
                        map.put(key, date);
                    }
                    catch (ParseException e) {
                        LOG.error("transfer String to date error");
                    }
                }
            });
            resultData.add(map);
        } else if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype)) {
            Object[] datas = this.getDataFromDb(paramkey, paramdata);
            if (!ObjectUtils.isEmpty((Object[])datas)) {
                resultData.add(datas[0]);
            }
        } else if (HRStringUtils.equals((String)"json", (String)paramtype)) {
            resultData.add(JSONObject.parseObject((String)paramdata));
        }
    }

    private void dealArrayTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        if (HRStringUtils.equals((String)"int", (String)paramtype)) {
            resultData.add(this.parseIntegerList(paramdata).toArray());
        } else if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            resultData.add(this.parseLongList(paramdata).toArray());
        } else if (HRStringUtils.equals((String)"boolean", (String)paramtype)) {
            resultData.add(this.parseBooleanList(paramdata).toArray());
        } else if (HRStringUtils.equals((String)"date", (String)paramtype)) {
            resultData.add(this.parseDateList(paramdata).toArray());
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            resultData.add(this.parseStringList(paramdata).toArray());
        } else if (HRStringUtils.equals((String)"map", (String)paramtype)) {
            resultData.add(this.parseMapList(paramdata).toArray());
        } else if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype)) {
            DynamicObject[] datas = this.getDataFromDb(paramkey, paramdata);
            resultData.add(datas);
        }
    }

    private void dealListTypeData(String paramtype, String paramkey, String paramdata, List<Object> resultData) throws ParseException {
        if (HRStringUtils.equals((String)"int", (String)paramtype)) {
            resultData.add(this.parseIntegerList(paramdata));
        } else if (HRStringUtils.equals((String)"long", (String)paramtype)) {
            resultData.add(this.parseLongList(paramdata));
        } else if (HRStringUtils.equals((String)"boolean", (String)paramtype)) {
            resultData.add(this.parseBooleanList(paramdata));
        } else if (HRStringUtils.equals((String)"string", (String)paramtype)) {
            resultData.add(this.parseStringList(paramdata));
        } else if (HRStringUtils.equals((String)"date", (String)paramtype)) {
            resultData.add(this.parseDateList(paramdata));
        } else if (HRStringUtils.equals((String)"map", (String)paramtype)) {
            resultData.add(this.parseMapList(paramdata));
        } else if (HRStringUtils.equals((String)"dynamicObject", (String)paramtype)) {
            DynamicObject[] datas = this.getDataFromDb(paramkey, paramdata);
            resultData.add(Arrays.stream(datas).collect(Collectors.toList()));
        } else if (HRStringUtils.equals((String)"json", (String)paramtype)) {
            resultData.add(this.parseJsonArray(paramdata));
        }
    }

    private List<Integer> parseIntegerList(String paramdata) {
        String[] datas;
        ArrayList<Integer> result = new ArrayList<Integer>(INIT_HASH_SIZE);
        String[] var4 = datas = paramdata.split(",");
        int var5 = datas.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String data = var4[var6];
            result.add(Integer.parseInt(data));
        }
        return result;
    }

    private List<Long> parseLongList(String paramdata) {
        String[] datas;
        ArrayList<Long> result = new ArrayList<Long>(INIT_HASH_SIZE);
        String[] var4 = datas = paramdata.split(",");
        int var5 = datas.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String data = var4[var6];
            result.add(Long.parseLong(data));
        }
        return result;
    }

    private List<Boolean> parseBooleanList(String paramdata) {
        String[] datas;
        ArrayList<Boolean> result = new ArrayList<Boolean>(INIT_HASH_SIZE);
        String[] var4 = datas = paramdata.split(",");
        int var5 = datas.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String data = var4[var6];
            result.add(Boolean.parseBoolean(data));
        }
        return result;
    }

    private List<Date> parseDateList(String paramdata) throws ParseException {
        String[] datas;
        ArrayList<Date> result = new ArrayList<Date>(INIT_HASH_SIZE);
        String[] var4 = datas = paramdata.split(",");
        int var5 = datas.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String var10000 = var4[var6];
            result.add(HRDateTimeUtils.parseDate((String)String.valueOf(paramdata)));
        }
        return result;
    }

    private JSONArray parseJsonArray(String paramdata) {
        JSONArray jsonArray = JSONArray.parseArray((String)paramdata);
        this.dealDateForJsonArr(jsonArray);
        return jsonArray;
    }

    private void dealDateForJsonObject(JSONObject jsonObject) {
        for (Map.Entry obj : jsonObject.entrySet()) {
            String key = (String)obj.getKey();
            Object item = obj.getValue();
            if (item instanceof JSONObject) {
                this.dealDateForJsonObject((JSONObject)item);
                continue;
            }
            if (item instanceof JSONArray) {
                this.dealDateForJsonArr((JSONArray)item);
                continue;
            }
            if (!(item instanceof String) || !this.isDateType((String)item).booleanValue()) continue;
            try {
                jsonObject.put(key, (Object)HRDateTimeUtils.parseDate((String)((String)item)));
            }
            catch (ParseException e) {
                LOG.error("kd.hrmp.hrpi.business.test.TestToolsPlugin.dealDateForJsonObject:", (Throwable)e);
            }
        }
    }

    private void dealDateForJsonArr(JSONArray jsonArray) {
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object obj = jsonArray.get(i);
            if (obj instanceof JSONObject) {
                this.dealDateForJsonObject((JSONObject)obj);
                continue;
            }
            if (!(obj instanceof String) || !this.isDateType((String)obj).booleanValue()) continue;
            try {
                jsonArray.set(i, (Object)HRDateTimeUtils.parseDate((String)((String)obj)));
                continue;
            }
            catch (ParseException e) {
                LOG.error("kd.hrmp.hrpi.business.test.TestToolsPlugin.dealDateForJsonArr:", (Throwable)e);
            }
        }
    }

    private Boolean isDateType(String date) {
        String reg = "^((\\d{2}(([02468][048])|([13579][26]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][1235679])|([13579][01345789]))[\\-\\/\\s]?((((0?[13578])|(1[02]))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\-\\/\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\-\\/\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))";
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(date);
        return matcher.matches();
    }

    private List<String> parseStringList(String paramdata) {
        String[] datas;
        ArrayList<String> result = new ArrayList<String>(INIT_HASH_SIZE);
        String[] var4 = datas = paramdata.split(",");
        int var5 = datas.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String data = var4[var6];
            result.add(data);
        }
        return result;
    }

    private List<Map> parseMapList(String paramdata) throws ParseException {
        String[] datas;
        ArrayList<Map> result = new ArrayList<Map>(INIT_HASH_SIZE);
        String[] var4 = datas = paramdata.split("},");
        int var5 = datas.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            String data = var4[var6];
            if (!(data = data.trim()).endsWith("}")) {
                data = data + "}";
            }
            Map mapdata = (Map)JSON.parseObject((String)data, Map.class);
            for (Map.Entry entry : mapdata.entrySet()) {
                if (!String.valueOf(entry.getValue()).endsWith("DATE")) continue;
                String dealData = String.valueOf(entry.getValue());
                dealData = dealData.substring(0, dealData.length() - 4);
                mapdata.put(entry.getKey(), HRDateTimeUtils.parseDate((String)dealData));
            }
            result.add(mapdata);
        }
        return result;
    }

    private DynamicObject[] getDataFromDb(String paramkey, String paramdata) {
        try {
            List<Long> searchIds = this.parseLongList(paramdata);
            HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(paramkey);
            DynamicObject[] datas = baseServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", searchIds)});
            return datas;
        }
        catch (Exception var6) {
            throw new KDBizException(var6.getMessage());
        }
    }

    private Object invokeMethod(String cloudId, String appId, String serviceName, String methodName, List<Object> params) {
        if (params != null && params.size() > MAX_PARAM_SIZE) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u6761\u76ee\u4e0d\u80fd\u5927\u4e8e%s", (String)"TestToolsPlugin_0", (String)"hrmp-hbpm-formplugin", (Object[])new Object[0]), MAX_PARAM_SIZE));
            return null;
        }
        Object result = null;
        if (params == null) {
            params = new ArrayList<Object>();
        }
        int size = params.size();
        switch (size) {
            case 0: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])null);
            }
            case 1: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0)});
            }
            case 2: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1)});
            }
            case 3: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2)});
            }
            case 4: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3)});
            }
            case 5: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4)});
            }
            case 6: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5)});
            }
            case 7: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5), params.get(6)});
            }
            case 8: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5), params.get(6), params.get(7)});
            }
            case 9: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5), params.get(6), params.get(7), params.get(8)});
            }
            case 10: {
                return HRMServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{params.get(0), params.get(1), params.get(2), params.get(3), params.get(4), params.get(5), params.get(6), params.get(7), params.get(8), params.get(9)});
            }
        }
        return result;
    }

    void saveToCache() {
        DynamicObject data = this.getModel().getDataEntity();
        String cloudid = data.getString(CLOUDID);
        String appId = data.getString(APPID);
        String serviceName = data.getString(SERVICENAME);
        String methodName = data.getString(METHODNAME);
        DynamicObjectCollection params = data.getDynamicObjectCollection(ENTRYENTITY);
        HashMap<String, Object> datas = new HashMap<String, Object>(INIT_HASH_SIZE);
        datas.put(CLOUDID, cloudid);
        datas.put(APPID, appId);
        datas.put(SERVICENAME, serviceName);
        datas.put(METHODNAME, methodName);
        datas.put(ENTRYENTITY, params);
        datas.put(SERVICEDATE, new Date());
        String cacheStringData = (String)HRAppCache.get((String)APPID_HJM).get(this.getCacheKey(), String.class);
        ArrayList<HashMap<String, Object>> personalData = null;
        if (HRStringUtils.isNotEmpty((String)cacheStringData)) {
            personalData = (ArrayList<HashMap<String, Object>>)SerializationUtils.deSerializeFromBase64((String)cacheStringData);
        }
        if (personalData == null) {
            personalData = new ArrayList<HashMap<String, Object>>();
        }
        personalData.add(datas);
        if (personalData.size() >= MAX_LIST_SIZE) {
            personalData.remove(0);
        }
        HRAppCache.get((String)APPID_HJM).remove(this.getCacheKey());
        HRAppCache.get((String)APPID_HJM).put(this.getCacheKey(), (Object)SerializationUtils.serializeToBase64(personalData));
    }

    private String getCacheKey() {
        return CACHE_KEY_PRE + RequestContext.get().getCurrUserId();
    }

    private Object dealDynaObjectData(Object datas) {
        if (datas == null) {
            return null;
        }
        if (datas instanceof DynamicObjectCollection) {
            DynamicObjectCollection coll = (DynamicObjectCollection)datas;
            ArrayList<List<Map<String, Object>>> returnInfo = new ArrayList<List<Map<String, Object>>>(coll.size());
            Iterator var14 = coll.iterator();
            returnInfo.add(DynamicTransformUtil.dynamicListToDyMap((List<DynamicObject>)coll));
            return returnInfo;
        }
        if (datas instanceof List) {
            List coll = (List)datas;
            ArrayList<Object> returnInfo = new ArrayList<Object>(coll.size());
            for (Object oo : coll) {
                returnInfo.add(this.dealDynaObjectData(oo));
            }
            return returnInfo;
        }
        if (datas.getClass().isArray()) {
            Object[] arrs = (Object[])datas;
            ArrayList<Object> returnInfo = new ArrayList<Object>(arrs.length);
            Object[] var13 = arrs;
            int var15 = arrs.length;
            for (int var6 = 0; var6 < var15; ++var6) {
                Object tmp = var13[var6];
                returnInfo.add(this.dealDynaObjectData(tmp));
            }
            return returnInfo;
        }
        if (datas instanceof DynamicObject) {
            Map<String, Object> map = DynamicTransformUtil.dynamicObjectToMap((DynamicObject)datas);
            return map;
        }
        if (!(datas instanceof Map)) {
            return datas;
        }
        Map mapdata = (Map)datas;
        for (Map.Entry entry : mapdata.entrySet()) {
            Object oo = this.dealDynaObjectData(entry.getValue());
            mapdata.put(entry.getKey(), oo);
        }
        return mapdata;
    }
}

