/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.service.impl.BlackListServiceImpl;
import kd.hrmp.hrpi.mservice.api.IHRPIBlackListService;

public class HRPIBlackListService
implements IHRPIBlackListService {
    private static final Log LOGGER = LogFactory.getLog(HRPIBlackListService.class);

    public Map<String, Object> queryBlackListByFieldId(Map<String, Object> paramMap) {
        HashMap<String, Object> result = new HashMap(4);
        BlackListServiceImpl blackListService = new BlackListServiceImpl();
        if (HRObjectUtils.isEmpty((Object)paramMap.get("id")) || HRObjectUtils.isEmpty((Object)paramMap.get("idtype"))) {
            return this.assembleResult(Boolean.FALSE, "203", "fail for lose must param or arguement type mismatch", result);
        }
        Long id = Long.valueOf(String.valueOf(paramMap.get("id")));
        String idType = String.valueOf(paramMap.get("idtype"));
        try {
            List mapList = blackListService.queryBlackListByPid(id, idType);
            result = CollectionUtils.isEmpty((Collection)mapList) ? this.assembleResult(Boolean.TRUE, "201", "success but get no data", mapList) : this.assembleResult(Boolean.TRUE, "200", "success to get data", mapList);
            return result;
        }
        catch (Exception ex) {
            LOGGER.error("HRPIBlackListService.queryBlackListByFieldId.error", (Throwable)ex);
            return this.assembleResult(Boolean.FALSE, "204", "fail for exception", result);
        }
    }

    public Map<String, Object> getBlackListByContactNum(Map<String, String> paramMap) {
        HashMap<String, Object> result = new HashMap(4);
        String name = paramMap.get("name");
        BlackListServiceImpl blackListService = new BlackListServiceImpl();
        String contactType = paramMap.get("contacttype");
        String contactNumber = paramMap.get("contactnumber");
        if (HRStringUtils.isEmpty((String)contactType) || HRStringUtils.isEmpty((String)contactNumber)) {
            return this.assembleResult(Boolean.FALSE, "203", "fail for lose must param or arguement type mismatch", result);
        }
        try {
            List mapList = blackListService.queryBlackListByContactNum(name, contactType, contactNumber);
            result = CollectionUtils.isEmpty((Collection)mapList) ? this.assembleResult(Boolean.TRUE, "201", "success but get no data", mapList) : this.assembleResult(Boolean.TRUE, "200", "success to get data", mapList);
            return result;
        }
        catch (Exception ex) {
            LOGGER.error("HRPIBlackListService.getBlackListByContactNum.error", (Throwable)ex);
            return this.assembleResult(Boolean.FALSE, "204", "fail for exception", result);
        }
    }

    public Map<String, Object> getBlackListByCardInfo(Map<String, Object> paramMap) {
        BlackListServiceImpl blackListService = new BlackListServiceImpl();
        HashMap<String, Object> result = new HashMap(4);
        Boolean checkResult = this.checkMustInput(paramMap);
        if (!checkResult.booleanValue()) {
            return this.assembleResult(Boolean.FALSE, "203", "fail for lose must param or arguement type mismatch", result);
        }
        String name = HRObjectUtils.isEmpty((Object)paramMap.get("name")) ? "" : String.valueOf(paramMap.get("name"));
        String cardNum = String.valueOf(paramMap.get("cardnumber"));
        Long cardId = Long.valueOf(String.valueOf(paramMap.get("cardid")));
        try {
            List mapList = blackListService.queryBlackListByCardInfo(name, cardId, cardNum);
            result = CollectionUtils.isEmpty((Collection)mapList) ? this.assembleResult(Boolean.TRUE, "201", "success but get no data", mapList) : this.assembleResult(Boolean.TRUE, "200", "success to get data", mapList);
            return result;
        }
        catch (Exception ex) {
            LOGGER.error("HRPIBlackListService.getBlackListByCardInfo.error", (Throwable)ex);
            return this.assembleResult(Boolean.FALSE, "204", "fail for exception", result);
        }
    }

    private Boolean checkMustInput(Map<String, Object> paramMap) {
        if (HRObjectUtils.isEmpty((Object)paramMap.get("cardnumber")) || HRObjectUtils.isEmpty((Object)paramMap.get("cardid")) || !(paramMap.get("cardid") instanceof Long)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Map<String, Object> newBlackListBatch(List<Map<String, Object>> paramList) {
        BlackListServiceImpl blackListService = new BlackListServiceImpl();
        return blackListService.newBlackListForSysPerson(paramList);
    }

    public Map<String, Object> newBlackListBatchOutside(List<Map<String, Object>> paramList) {
        BlackListServiceImpl blackListService = new BlackListServiceImpl();
        return blackListService.newBlackList(paramList);
    }

    public Map<String, Object> editBlackListBatch(List<Map<String, Object>> paramList) {
        BlackListServiceImpl blackListService = new BlackListServiceImpl();
        return blackListService.editBlackList(paramList);
    }

    public Map<String, Object> deleteBlackList(Map<String, Object> paramMap) {
        BlackListServiceImpl blackListService = new BlackListServiceImpl();
        return blackListService.deleteBlackList(paramMap);
    }

    public Map<String, Object> getBlacklistInfo(Map<String, Object> paramMap) {
        BlackListServiceImpl blackListService = new BlackListServiceImpl();
        return blackListService.getBlacklistInfo(paramMap);
    }

    private Map<String, Object> assembleResult(Boolean success, String code, String msg, Object data) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", success);
        resultMap.put("code", code);
        resultMap.put("message", msg);
        resultMap.put("data", data);
        return resultMap;
    }
}

