/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrpi.business.application.charge.IChargeApplication;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;
import kd.hrmp.hrpi.common.model.charge.QueryTagParam;
import kd.hrmp.hrpi.mservice.api.IHRPIChargeService;

public class HRPIChargeService
implements IHRPIChargeService,
HRPIChargePersonConstants {
    private static final Log logger = LogFactory.getLog(HRPIChargeService.class);
    private final IChargeApplication chargeApplication = new ChargeApplicationImpl();

    public Map<String, Object> setChargePerson(List<Map<String, Object>> chargePersonParam) {
        logger.info("setChargePerson chargePersonParam:" + JSON.toJSONString(chargePersonParam));
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            Map map = this.chargeApplication.setChargePerson(chargePersonParam);
            return map;
        }
        catch (Exception e) {
            logger.error("set charge person error:", (Throwable)e);
            txHandle.markRollback();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)16);
        result.put("code", 201);
        result.put("ErrMsg", "set charge person error!");
        result.put("data", null);
        return result;
    }

    public void setChargePersonByPosition(List<Map<String, Object>> positionParam) {
        logger.info("setChargePersonByPosition positionParam:" + JSON.toJSONString(positionParam));
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                this.chargeApplication.setChargePersonByPosition(positionParam);
            }
            catch (Exception e) {
                txHandle.markRollback();
            }
        }
    }

    public Map<Long, List<Map<String, Object>>> queryChargePersonByOrgId(List<Long> orgIds, Date queryDate) {
        logger.info("queryChargePersonByOrgId queryDate:{} orgIds:{}", (Object)queryDate, (Object)JSON.toJSONString(orgIds));
        return this.chargeApplication.queryChargePersonByOrgId(orgIds, queryDate);
    }

    public Map<Long, List<Map<String, Object>>> queryChargeByPersonId(List<Long> personIds, Date queryDate) {
        logger.info("queryChargeByPersonId queryDate:{} personIds:{}", (Object)queryDate, (Object)JSON.toJSONString(personIds));
        return this.chargeApplication.queryChargeByPersonId(personIds, queryDate);
    }

    public Map<Long, List<Map<String, Object>>> queryPastChargeByOrgId(List<Long> orgIds, Date queryDate) {
        logger.info("queryPastChargeByOrgId queryDate:{} orgIds:{}", (Object)queryDate, (Object)JSON.toJSONString(orgIds));
        return this.chargeApplication.queryPastChargeByOrgId(orgIds, queryDate);
    }

    public Map<Long, List<Map<String, Object>>> queryChargeWithParentByOrgId(List<Long> orgIds, Date queryDate) {
        logger.info("queryChargeWithParentByOrgId queryDate:{} orgIds:{}", (Object)queryDate, (Object)JSON.toJSONString(orgIds));
        return this.chargeApplication.queryChargeWithParentByOrgId(orgIds, queryDate);
    }

    public Map<Long, List<Map<String, Object>>> queryChargeWithParentByOrgId(List<Long> orgIds, Date queryDate, Long structProject) {
        logger.info("queryChargeWithParentByOrgId queryDate:{}, structProjectId:{}, orgIds:{}", new Object[]{queryDate, structProject, JSON.toJSONString(orgIds)});
        if (CollectionUtils.isEmpty(orgIds)) {
            throw new KDBizException("orgIds can not be empty!");
        }
        if (structProject == null || structProject == 0L) {
            structProject = 1010L;
        }
        return this.chargeApplication.queryChargeWithParentByOrgId(orgIds, queryDate, structProject);
    }

    public List<Map<String, Object>> queryChargeTag(List<Map<String, Object>> inParam) {
        logger.info("queryChargeTag, inParam: {}", inParam);
        if (CollectionUtils.isEmpty(inParam)) {
            return Collections.emptyList();
        }
        if (inParam.size() > 1000) {
            throw new KDBizException("inParam's size can not be more than 1000!");
        }
        try {
            Date nowDay = HRDateTimeUtils.getNowDate();
            List queryTagParamList = inParam.stream().filter(param -> param.get("personId") != null).filter(param -> param.get("depId") != null).map(param -> {
                QueryTagParam queryTagParam = new QueryTagParam();
                queryTagParam.setPersonId(Long.parseLong(param.get("personId").toString()));
                queryTagParam.setDepId(Long.parseLong(param.get("depId").toString()));
                Object date = param.get("date");
                if (date == null) {
                    queryTagParam.setDate(nowDay);
                } else if (date instanceof Date) {
                    queryTagParam.setDate((Date)date);
                } else {
                    try {
                        queryTagParam.setDate(HRDateTimeUtils.parseDate((String)date.toString()));
                    }
                    catch (ParseException e) {
                        logger.error("queryChargeTag, parse date error", (Throwable)e);
                        throw new KDBizException(e.getMessage());
                    }
                }
                return queryTagParam;
            }).collect(Collectors.toList());
            DynamicObject[] chargePersons = this.chargeApplication.queryChargeTag(queryTagParamList);
            List<Map<String, Object>> result = Arrays.stream(chargePersons).map(chargePerson -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("personId", chargePerson.getLong("chargeperson.person.id"));
                map.put("depId", chargePerson.getLong("adminorg.id"));
                map.put("depEmpId", chargePerson.getLong("chargeperson.id"));
                map.put("ismain", chargePerson.getString("ismain"));
                map.put("effdt", chargePerson.getDate("effdt"));
                map.put("leffdt", chargePerson.getDate("leffdt"));
                return map;
            }).collect(Collectors.toList());
            logger.info("queryChargeTag success with outParam:{}", result);
            return result;
        }
        catch (Exception e) {
            logger.error("queryChargeTag error", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public Map<String, List<Map<String, Object>>> queryChargePersonByOrgIdAndDate(List<Map<String, Object>> queryParam) {
        logger.info("queryChargePersonByOrgIdAndDate, param: {}", queryParam);
        if (CollectionUtils.isEmpty(queryParam)) {
            return new HashMap<String, List<Map<String, Object>>>(4);
        }
        HashMap<String, List<Map<String, Object>>> retMap = new HashMap(queryParam.size());
        if (queryParam.size() > 5000) {
            throw new KDBizException("param's size can not be more than 5000!");
        }
        try {
            retMap = this.chargeApplication.queryChargePersonByOrgIdAndDate(queryParam);
        }
        catch (Exception e) {
            logger.error("queryChargePersonByOrgIdAndDate error", (Throwable)e);
            return new HashMap<String, List<Map<String, Object>>>(4);
        }
        return retMap;
    }
}

