/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice;

import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.hr.hbp.common.util.HRDBUtil;

public class HRPIERFileTypeUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(HRPIERFileTypeUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        logger.info("Start HRPIERFileTypeUpgradeService");
        UpgradeResult result = new UpgradeResult();
        DBRoute dbRouteHR = new DBRoute("hr");
        String sql = "select fid, flaborreltypeid from t_hrpi_erfiletype;";
        DataSet dataSet = HRDBUtil.queryDataSet((String)"HRPIERFileTypeUpgradeService", (DBRoute)dbRouteHR, (String)sql, null);
        if (dataSet.isEmpty()) {
            return result;
        }
        String sqlERFilelabtype = "select fpkid, fid, fbasedataid from t_hrpi_erfilelabtype;";
        DataSet fileLabTypeDataSet = HRDBUtil.queryDataSet((String)"HRPIERFileTypeUpgradeService", (DBRoute)dbRouteHR, (String)sqlERFilelabtype, null);
        HashSet fileLabTypeIds = new HashSet(100);
        fileLabTypeDataSet.forEach(dataRow -> fileLabTypeIds.add(dataRow.get("fid").toString() + dataRow.get("fbasedataid").toString()));
        try (TXHandle txHandle = TX.required();){
            try {
                dataSet.forEach(dataRow -> {
                    String flaborreltypeidStr = dataRow.get("flaborreltypeid").toString();
                    long flaborreltypeid = Long.parseLong(flaborreltypeidStr);
                    if (0L == flaborreltypeid) {
                        return;
                    }
                    String fidStr = dataRow.get("fid").toString();
                    if (fileLabTypeIds.contains(fidStr + flaborreltypeidStr)) {
                        return;
                    }
                    long fid = Long.parseLong(fidStr);
                    long fpkid = DB.genLongId((String)"t_hrpi_erfilelabtype");
                    String insertSql = "INSERT INTO T_HRPI_ERFILELABTYPE (FPKID, FID, FBASEDATAID) VALUES (?, ?, ?);";
                    DB.execute((DBRoute)dbRouteHR, (String)insertSql, (Object[])new Object[]{fpkid, fid, flaborreltypeid});
                });
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                txHandle.markRollback();
                result.setSuccess(false);
                UpgradeResult upgradeResult = result;
                if (txHandle != null) {
                    if (var13_13 != null) {
                        try {
                            txHandle.close();
                        }
                        catch (Throwable throwable) {
                            var13_13.addSuppressed(throwable);
                        }
                    } else {
                        txHandle.close();
                    }
                }
                return upgradeResult;
            }
        }
        result.setSuccess(true);
        return result;
    }
}

