/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.controller;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hrmp.hrpi.business.domian.service.impl.generic.PersonGenericServiceImpl;
import kd.hrmp.hrpi.mservice.webapi.controller.AbsPersonSaveBaseController;
import kd.hrmp.hrpi.mservice.webapi.model.response.SaveBaseModel;

public abstract class AbsPersonExtraSaveBaseController
extends AbsPersonSaveBaseController
implements Serializable {
    private static final Log LOG = LogFactory.getLog(AbsPersonExtraSaveBaseController.class);
    private static final String HIS_DYNS = "hisDyns";
    private static final String ID = "id";
    private static final String CALLER_OPENAPI = "openAPI";
    private static final String HRPI_EVENT = "hrpi_event";
    private static final long serialVersionUID = 8651022531181083570L;
    public static Date MAXDATE;
    public static List<EnabledLang> enabledLangList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CustomApiResult<List<SaveBaseModel>> execute(List reqList) {
        try {
            LOG.info("start to execute the request ...");
            if (this.checkAndTransFailed(reqList)) {
                CustomApiResult customApiResult = this.result;
                return customApiResult;
            }
            LOG.info("start change the request list to map , for the entity={}", (Object)this.getEntityName());
            Map<String, DynamicObjectCollection> dyWithCollection = this.changeToDyCollection(this.requestParams);
            Map<String, Object> paramMap = this.buildSaveBatchByCollection(dyWithCollection);
            LOG.info("start invoke the service of save batch ... ");
            Map resultMap = PersonGenericServiceImpl.getInstance().saveBatch(paramMap);
            if (!((Boolean)resultMap.get("success")).booleanValue()) {
                this.callBackErrorMsg(JSONObject.toJSONString((Object)resultMap));
                CustomApiResult<List<SaveBaseModel>> customApiResult = this.executeResWithFailed();
                return customApiResult;
            }
            this.syncSysUser();
            CustomApiResult<List<SaveBaseModel>> customApiResult = this.executeResWithSuccess();
            return customApiResult;
        }
        catch (Exception exception) {
            LOG.error("occur error when invoke save batch , please read the log and do analysis . ", (Throwable)exception);
            this.callBackErrorMsg(exception.getMessage());
            CustomApiResult<List<SaveBaseModel>> customApiResult = this.executeResWithException();
            return customApiResult;
        }
        finally {
            this.cleanCache();
        }
    }

    protected Map<String, DynamicObjectCollection> changeToDyCollection(List<Map<String, Object>> requestParams) {
        if (CollectionUtils.isEmpty(requestParams)) {
            LOG.error(this.getEntityName() + ": the requestParams of method(changeToDyCollection) is empty , plz check the transfer process .");
        }
        String entityName = this.getEntityName();
        HashMap<String, DynamicObjectCollection> hisDys = new HashMap<String, DynamicObjectCollection>();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        DynamicObjectCollection dys = new DynamicObjectCollection((DynamicObjectType)entityType, null);
        Set<String> fields = entityType.getFields().keySet();
        for (Map<String, Object> propMap : requestParams) {
            DynamicObject obj = (DynamicObject)entityType.createInstance();
            this.fillDyObj(fields, obj, propMap);
            obj.set("initstatus", (Object)"2");
            dys.add((Object)obj);
        }
        hisDys.put(HIS_DYNS, dys);
        return hisDys;
    }

    private void fillDyObj(Set<String> fields, DynamicObject obj, Map<String, Object> propMap) {
        obj.set(ID, propMap.get(ID));
        fields.forEach(field -> {
            Object propValue = propMap.get(field);
            if (null != propValue) {
                if (propValue instanceof Map) {
                    LocaleString localeString = new LocaleString();
                    Map langMap = (Map)propValue;
                    enabledLangList.forEach(lang -> {
                        String number = lang.getNumber();
                        String numberV = (String)langMap.get(number);
                        if (null != numberV) {
                            localeString.setItem(number, (Object)numberV);
                        }
                    });
                    obj.set(field, (Object)localeString);
                } else {
                    obj.set(field, propValue);
                }
            }
        });
    }

    protected Map<String, Object> buildSaveBatchByCollection(Map dyWithCollection) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        ArrayList<Map> data = new ArrayList<Map>(1);
        data.add(dyWithCollection);
        paramMap.put("data", data);
        paramMap.put("caller", CALLER_OPENAPI);
        paramMap.put("mustAllSuccess", Boolean.TRUE);
        Long eventId = ORM.create().genLongId(HRPI_EVENT);
        paramMap.put("eventId", eventId);
        return paramMap;
    }

    protected abstract String getEntityName();

    @Override
    protected Map invokeService() {
        return null;
    }

    static {
        try {
            MAXDATE = HRDateTimeUtils.parseDate((String)"2999-12-31");
            IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
            enabledLangList = service.getEnabledLang();
        }
        catch (ParseException e) {
            LOG.error(" date parse error ", (Throwable)e);
        }
    }
}

