/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.controller;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.util.ReflectionUtils;
import kd.hrmp.hrpi.business.domian.service.openapi.ISyncSysUserService;
import kd.hrmp.hrpi.mservice.webapi.model.annotation.DataBaseNumber;
import kd.hrmp.hrpi.mservice.webapi.model.annotation.NeedSyncSysUser;
import kd.hrmp.hrpi.mservice.webapi.model.request.BaseModel;
import kd.hrmp.hrpi.mservice.webapi.model.request.modelpart.ModelPart;
import kd.hrmp.hrpi.mservice.webapi.model.response.SaveBaseModel;
import kd.hrmp.hrpi.mservice.webapi.model.util.JsonUtils;
import kd.hrmp.hrpi.mservice.webapi.response.ErrorCode;
import kd.hrmp.hrpi.mservice.webapi.transfer.BaseDataFactory;
import kd.hrmp.hrpi.mservice.webapi.transfer.entity.DataDiv;
import kd.hrmp.hrpi.mservice.webapi.transfer.entity.ValidateContext;

public abstract class AbsPersonSaveBaseController<T extends BaseModel>
implements Serializable {
    protected static final Log LOG = LogFactory.getLog(AbsPersonSaveBaseController.class);
    protected static final ThreadLocal<Map<String, Object>> CACHE_MAP = ThreadLocal.withInitial(HashMap::new);
    private static final String TOTAL_INPUT_COUNT = "allCount";
    private static final String TRANSFER_ERROR_COUNT = "transferErrorCount";
    private static final String TRANSFER_ERROR_MSG_DETAIL = "transferErrorMsgDetail";
    private static final String CALLBACK_ERROR_MSG_DETAIL = "callbackErrorMsgDetail";
    private static final String TOTAL_FAILED_COUNT = "totalFailedCount";
    private static final String TOTAL_SUCCESS_COUNT = "totalSuccessCount";
    private static final String NUMBER = "Number";
    private static final long serialVersionUID = 326431217368411553L;
    private static final int MAP_SIZE_BASE_DATA = 64;
    private static final String STRING_NUMBER = "number";
    protected CustomApiResult<List<SaveBaseModel>> result;
    protected List<Map<String, Object>> requestParams;
    protected List<Long> personIds;
    protected List<Object> numbers;
    protected boolean ifSyncSysUser = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CustomApiResult<List<SaveBaseModel>> execute(List<T> reqList) {
        try {
            LOG.info("start to execute the request ...");
            if (this.checkAndTransFailed(reqList)) {
                CustomApiResult<List<SaveBaseModel>> customApiResult = this.result;
                return customApiResult;
            }
            this.numbers = this.getEmpOrgsNumbers();
            Map resultMap = this.invokeService();
            if (!((Boolean)resultMap.get("success")).booleanValue()) {
                this.callBackErrorMsg(SerializationUtils.toJsonString((Object)resultMap));
                CustomApiResult<List<SaveBaseModel>> customApiResult = this.executeResWithFailed();
                return customApiResult;
            }
            this.syncSysUser();
            CustomApiResult<List<SaveBaseModel>> customApiResult = this.executeResWithSuccess();
            return customApiResult;
        }
        catch (Exception exception) {
            LOG.error("%s : occur error when invoke service : %s", (Object)this.getClass().getName(), (Object)exception);
            this.callBackErrorMsg(exception.getMessage());
            CustomApiResult<List<SaveBaseModel>> customApiResult = this.executeResWithException();
            return customApiResult;
        }
        finally {
            this.cleanCache();
        }
    }

    private List<Object> getEmpOrgsNumbers() {
        String key;
        Optional<NeedSyncSysUser> annotation = Optional.ofNullable(this.getClass().getDeclaredAnnotation(NeedSyncSysUser.class));
        if (annotation.isPresent() && STRING_NUMBER.equals(key = annotation.get().key())) {
            return this.requestParams.stream().map(map -> map.get(key)).collect(Collectors.toList());
        }
        return Collections.EMPTY_LIST;
    }

    protected void syncSysUser() {
        if (this.ifSyncSysUser && this.fillPersonIds()) {
            ISyncSysUserService.getInstance().syncSysUser(this.personIds);
        }
    }

    protected boolean fillPersonIds() {
        Class<?> clazz = this.getClass();
        NeedSyncSysUser annotation = clazz.getDeclaredAnnotation(NeedSyncSysUser.class);
        if (null != annotation) {
            String key = annotation.key();
            String tableEntity = annotation.tableEntity();
            this.doFillPersonIds(key, tableEntity);
            return true;
        }
        return false;
    }

    private void doFillPersonIds(String key, String tableEntity) {
        switch (key) {
            case "number": {
                this.personIds = ISyncSysUserService.getInstance().getPersonIdsByOts(this.numbers, key, tableEntity);
                break;
            }
            case "person": {
                this.personIds = this.requestParams.stream().map(map -> (Long)map.get("person")).distinct().collect(Collectors.toList());
                break;
            }
            default: {
                throw new KDBizException(MessageFormat.format("error of the @NeedSyncSysUser ... key : {0} ; value : {1}", key, tableEntity));
            }
        }
    }

    protected boolean checkAndTransFailed(List<T> list) {
        LOG.info("start check and transfer request params , list type:%s , list size:%s", (Object)this.paramModelType().getName(), (Object)list.size());
        this.fillAllCount(list);
        List<DataDiv<DataDiv>> dataDivs = this.generateDivs(list);
        this.specialValidate(dataDivs);
        if (this.needChangeNumberToId(this.paramModelType())) {
            LOG.info("start transfer number to id for the base_data ...");
            this.change(dataDivs);
            LOG.info("transfer number to id for the base_data over .");
        }
        this.specialTransAfterBaseDataFill(dataDivs);
        ArrayList successList = new ArrayList();
        ArrayList<DataDiv> errorList = new ArrayList<DataDiv>();
        dataDivs.forEach(data -> {
            if (data.getContext().isSuccess()) {
                successList.add(data);
            } else {
                errorList.add((DataDiv)data);
            }
        });
        this.fillErrorMsg(errorList);
        if (successList.size() == 0) {
            CustomApiResult fail = CustomApiResult.fail((String)ErrorCode.INVOKE_RETURN_FAILED.getCode(), (String)this.packErrorMsg());
            fail.setData(this.packTransferErrorMsgDetail());
            this.result = fail;
            return true;
        }
        this.requestParams = new ArrayList<Map<String, Object>>(successList.size());
        try {
            LOG.info("start build request params , total size : %s ; transferError size : %s ; transferSuccess size : %s", new Object[]{list.size(), errorList.size(), successList.size()});
            successList.forEach(baseDiv -> this.requestParams.add(JsonUtils.parseJSON2Map(JSONObject.toJSON(baseDiv.getT()))));
        }
        catch (Exception exception) {
            LOG.error("occur error when build request params , error msg : %s", (Throwable)exception);
            this.result = CustomApiResult.fail((String)ErrorCode.TRANSFORMATION_OCCUR_ERROR.getCode(), (String)exception.getMessage());
            return true;
        }
        return false;
    }

    protected void specialTransAfterBaseDataFill(List<DataDiv<T>> dataDivs) {
    }

    protected void specialValidate(List<DataDiv<T>> dataDivs) {
    }

    private void fillAllCount(List<T> list) {
        HashMap<String, Integer> completeMsg = new HashMap<String, Integer>();
        completeMsg.put(TOTAL_INPUT_COUNT, list.size());
        CACHE_MAP.get().put(String.valueOf(this.getClass()), completeMsg);
    }

    private void fillErrorMsg(List<DataDiv> errorList) {
        Object cacheItem = CACHE_MAP.get().get(String.valueOf(this.getClass()));
        if (null != cacheItem) {
            ((Map)cacheItem).put(TRANSFER_ERROR_COUNT, errorList.size());
            List baseModels = errorList.stream().map(temp -> {
                temp.getContext().getSaveBaseModel().setPrimarySign(temp.getT().getPrimaryKey() + " " + temp.getT().getPrimaryValue());
                return temp.getContext().getSaveBaseModel();
            }).collect(Collectors.toList());
            ((Map)cacheItem).put(TRANSFER_ERROR_MSG_DETAIL, baseModels);
        }
    }

    protected void callBackErrorMsg(String errorMsg) {
        Map cacheItem = (Map)CACHE_MAP.get().get(String.valueOf(this.getClass()));
        cacheItem.put(TOTAL_FAILED_COUNT, cacheItem.get(TOTAL_INPUT_COUNT));
        cacheItem.put(CALLBACK_ERROR_MSG_DETAIL, errorMsg);
    }

    protected CustomApiResult<List<SaveBaseModel>> executeResWithSuccess() {
        CustomApiResult success = CustomApiResult.success(null);
        this.successNumberFixed();
        success.setData(this.packTransferErrorMsgDetail());
        success.setMessage(this.packErrorMsg());
        return success;
    }

    private void successNumberFixed() {
        Map cacheItem = (Map)CACHE_MAP.get().get(String.valueOf(this.getClass()));
        int all = (Integer)cacheItem.get(TOTAL_INPUT_COUNT);
        int transFailed = (Integer)cacheItem.get(TRANSFER_ERROR_COUNT);
        cacheItem.put(TOTAL_SUCCESS_COUNT, all - transFailed);
    }

    protected CustomApiResult<List<SaveBaseModel>> executeResWithFailed() {
        CustomApiResult fail = CustomApiResult.fail((String)ErrorCode.INVOKE_RETURN_FAILED.getCode(), (String)this.packErrorMsg());
        fail.setData(this.packTransferErrorMsgDetail());
        return fail;
    }

    protected CustomApiResult<List<SaveBaseModel>> executeResWithException() {
        CustomApiResult exception = CustomApiResult.fail((String)ErrorCode.INVOKE_RETURN_FAILED.getCode(), (String)this.packErrorMsg());
        exception.setData(this.packTransferErrorMsgDetail());
        return exception;
    }

    protected String packErrorMsg() {
        Map cacheItem = (Map)CACHE_MAP.get().get(String.valueOf(this.getClass()));
        HashMap infoMsg = new HashMap();
        Arrays.asList(TOTAL_INPUT_COUNT, TRANSFER_ERROR_COUNT, TOTAL_FAILED_COUNT, TOTAL_SUCCESS_COUNT, CALLBACK_ERROR_MSG_DETAIL).forEach(key -> infoMsg.put(key, cacheItem.get(key)));
        return JSONObject.toJSONString(infoMsg);
    }

    private List<SaveBaseModel> packTransferErrorMsgDetail() {
        Map cacheItem = (Map)CACHE_MAP.get().get(String.valueOf(this.getClass()));
        Object o = cacheItem.get(TRANSFER_ERROR_MSG_DETAIL);
        return (List)o;
    }

    protected void cleanCache() {
        CACHE_MAP.get().remove(String.valueOf(this.getClass()));
        LOG.info("remove all the information of %s", (Object)String.valueOf(this.getClass()));
    }

    private void change(List<DataDiv<T>> list) {
        try {
            Class paramModelType = this.paramModelType();
            HashMap filedNameWithEntityNameMap = Maps.newHashMapWithExpectedSize((int)64);
            this.getAllFiledSignedDataBaseNumber(paramModelType, filedNameWithEntityNameMap, "");
            HashMap entityNameWithNumbers = Maps.newHashMapWithExpectedSize((int)64);
            for (Map.Entry entry : filedNameWithEntityNameMap.entrySet()) {
                HashSet numbers = Sets.newHashSetWithExpectedSize((int)filedNameWithEntityNameMap.size());
                list.forEach(obj -> {
                    try {
                        this.fillNumbers(obj.getT(), (String)entry.getKey(), numbers);
                    }
                    catch (IllegalAccessException | NoSuchFieldException | KDBizException e) {
                        LOG.error("occur error when getting the value of field need transfer number to id . ", e);
                    }
                });
                Optional optionalSet = Optional.ofNullable(entityNameWithNumbers.get(entry.getValue()));
                optionalSet.ifPresent(numbers::addAll);
                entityNameWithNumbers.put(entry.getValue(), numbers);
            }
            String randomKey = ID.genStringId();
            entityNameWithNumbers.keySet().forEach(key -> BaseDataFactory.get(randomKey, key).fillDataEnterParams((Set)entityNameWithNumbers.get(key)).queryData());
            list.forEach(div -> {
                try {
                    for (Map.Entry entry : filedNameWithEntityNameMap.entrySet()) {
                        Map<String, Object> dataMap = BaseDataFactory.get(randomKey, (String)entry.getValue()).getCache();
                        this.fillTheNewField(div.getT(), (String)entry.getKey(), (Map)dataMap.get(entry.getValue()), div.getContext());
                    }
                }
                catch (IllegalAccessException | NoSuchFieldException e) {
                    LOG.error("occur error when transfer number to id . ", (Throwable)e);
                }
            });
            entityNameWithNumbers.keySet().forEach(key -> BaseDataFactory.get(randomKey, key).cacheClear());
            BaseDataFactory.cacheClear(randomKey);
        }
        catch (Exception exception) {
            LOG.error("occur error when transfer number to id for the base_data , error msg: %s", (Throwable)exception);
            this.result = CustomApiResult.fail((String)"400", (String)"change data error , details in error log");
        }
    }

    private List<DataDiv<T>> generateDivs(List<T> list) {
        ArrayList divs = new ArrayList(list.size());
        list.forEach(t -> divs.add(new DataDiv<BaseModel>((BaseModel)t, new ValidateContext(true))));
        return divs;
    }

    private void fillNumbers(Object obj, String key, Set<String> numbers) throws NoSuchFieldException, IllegalAccessException, KDBizException {
        if (obj instanceof List) {
            List list = (List)obj;
            for (Object o : list) {
                this.fillNumbers(o, key, numbers);
            }
        } else {
            this.doFillNumbers(obj, key, numbers);
        }
    }

    private void doFillNumbers(Object obj, String key, Set<String> numbers) throws NoSuchFieldException, IllegalAccessException, KDBizException {
        if (key.contains(".")) {
            String[] tempKeys = key.split("\\.");
            String tempKey = tempKeys[0];
            Field field = obj.getClass().getDeclaredField(tempKey);
            ReflectionUtils.makeAccessible((Field)field);
            key = key.substring(tempKey.length() + 1);
            this.fillNumbers(field.get(obj), key, numbers);
        } else {
            Field field = obj.getClass().getDeclaredField(key);
            ReflectionUtils.makeAccessible((Field)field);
            Object objValue = field.get(obj);
            if (null != objValue && !(objValue instanceof String)) {
                LOG.error(String.format("there are some code wrong , the number must be String type , please check the field : %s", field.getName()));
                throw new KDBizException(String.format("there are some code wrong , the number must be String type , please check the field : %s", field.getName()));
            }
            if (StringUtils.isNotEmpty((CharSequence)((String)objValue))) {
                numbers.add((String)objValue);
            }
        }
    }

    private void fillTheNewField(Object model, String key, Map<String, Object> dataMap, ValidateContext context) throws NoSuchFieldException, IllegalAccessException {
        if (List.class.isAssignableFrom(model.getClass())) {
            List list = (List)model;
            for (Object o : list) {
                this.fillTheNewField(o, key, dataMap, context);
            }
        } else if (key.contains(".")) {
            String[] tempKeys = key.split("\\.");
            String tempKey = tempKeys[0];
            Field field = model.getClass().getDeclaredField(tempKey);
            ReflectionUtils.makeAccessible((Field)field);
            this.fillTheNewField(field.get(model), key.substring(tempKey.length() + 1), dataMap, context);
        } else {
            Field oldField = model.getClass().getDeclaredField(key);
            ReflectionUtils.makeAccessible((Field)oldField);
            Object valueNumber = oldField.get(model);
            Field newField = model.getClass().getDeclaredField(this.deleteNumberSuffix(key));
            Object baseDataFid = dataMap.get(valueNumber);
            if (StringUtils.isNotEmpty((CharSequence)((String)valueNumber)) && null == baseDataFid) {
                LOG.warn("Transfer failed , the number input is illegal , please check the %s :%s", (Object)key, valueNumber);
                context.setSuccess(false);
                context.getSaveBaseModel().getTransferErrorMsg().add(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u8f6c\u6362\u5931\u8d25\uff1a\u5b57\u6bb5\u201c{0}\u201d\u503c\u201c{1}\u201d\uff1b ", (String)"AbsPersonSaveBaseController_0", (String)"hrmp-hrpi-mservice", (Object[])new Object[]{key, valueNumber}));
            } else {
                ReflectionUtils.makeAccessible((Field)newField);
                newField.set(model, baseDataFid);
            }
        }
    }

    private String deleteNumberSuffix(String key) {
        if (!key.contains(NUMBER)) {
            throw new KDBizException("the key do not contains number , there are some definition error , please check the field such signed by @DataBaseNumber , if there is no 'Number' suffix , fix it up .");
        }
        return key.substring(0, key.indexOf(78));
    }

    private void getAllFiledSignedDataBaseNumber(Class paramModelType, Map<String, String> filedNameWithEntityNameMap, String prefixOfKey) {
        Field[] allFields = paramModelType.getDeclaredFields();
        Arrays.stream(allFields).forEach(field -> {
            if (ModelPart.class.isAssignableFrom(field.getType())) {
                this.getAllFiledSignedDataBaseNumber(field.getType(), filedNameWithEntityNameMap, prefixOfKey + field.getName() + ".");
            }
            if (List.class.isAssignableFrom(field.getType()) && ModelPart.class.isAssignableFrom(this.getClassOfListObj((Field)field))) {
                this.getAllFiledSignedDataBaseNumber(this.getClassOfListObj((Field)field), filedNameWithEntityNameMap, prefixOfKey + field.getName() + ".");
            }
            if (null != field.getAnnotation(DataBaseNumber.class)) {
                String key = prefixOfKey + field.getName();
                String value = field.getAnnotation(DataBaseNumber.class).value();
                filedNameWithEntityNameMap.put(key, value);
            }
        });
    }

    private Class getClassOfListObj(Field field) {
        Type genericType = field.getGenericType();
        if (genericType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            return (Class)pt.getActualTypeArguments()[0];
        }
        LOG.error("check the T.class , it may be wrote wrong value .");
        return Object.class;
    }

    private boolean needChangeNumberToId(Class paramModelType) {
        if (null == paramModelType) {
            throw new KDBizException("it's necessary to override the method 'paramModelType' , and give right return value . ");
        }
        Field[] allFields = paramModelType.getDeclaredFields();
        return Arrays.stream(allFields).anyMatch(field -> {
            if (ModelPart.class.isAssignableFrom(field.getType())) {
                return this.needChangeNumberToId(field.getType());
            }
            if (List.class.isAssignableFrom(field.getType())) {
                Class clazz = this.getClassOfListObj((Field)field);
                return this.needChangeNumberToId(clazz);
            }
            return null != field.getAnnotation(DataBaseNumber.class);
        });
    }

    protected abstract Class paramModelType();

    protected abstract Map invokeService();
}

