/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.controller;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.util.CollectionUtils;
import kd.hrmp.hrpi.business.application.IApplyApplication;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.mservice.webapi.controller.AbsPersonSaveBaseController;
import kd.hrmp.hrpi.mservice.webapi.model.annotation.NeedSyncSysUser;
import kd.hrmp.hrpi.mservice.webapi.model.request.PersonModel;
import kd.hrmp.hrpi.mservice.webapi.model.request.modelpart.EmployeeBaseInfo;
import kd.hrmp.hrpi.mservice.webapi.model.request.modelpart.Empposorgrels;
import kd.hrmp.hrpi.mservice.webapi.model.response.SaveBaseModel;
import kd.hrmp.hrpi.mservice.webapi.model.util.CommonBusinessUtils;
import kd.hrmp.hrpi.mservice.webapi.transfer.entity.DataDiv;
import kd.hrmp.hrpi.mservice.webapi.transfer.entity.ValidateContext;

@NeedSyncSysUser
@ApiController(value="hrpi", desc="\u521b\u5efa\u56db\u5c42\u4eba\u53ca\u57fa\u7840\u8868\u4fe1\u606f")
@ApiMapping(value="/openapi/save")
public class AddEmployeeController
extends AbsPersonSaveBaseController
implements Serializable {
    private static final long serialVersionUID = 8021045210145128325L;

    @ApiPostMapping(value="addemployee", desc="\u6279\u91cf\u521b\u5efa\u4eba\u5458\u4fe1\u606f")
    @ApiErrorCodes(value={@ApiErrorCode(code="810", desc="transfer data occur exception , more information details on error message ."), @ApiErrorCode(code="820", desc="invoke service occur exception ,more information details on error message .")})
    public CustomApiResult<List<@ApiResponseBody SaveBaseModel>> addEmployee(@Valid @NotNull @ApiParam(value="\u65b0\u589e\u5458\u5de5\u4fe1\u606f", required=true) @Size(max=500) @Valid @NotNull @ApiParam(value="\u65b0\u589e\u5458\u5de5\u4fe1\u606f", required=true) @Size(max=500) List<PersonModel> personModels) {
        return this.execute(personModels);
    }

    @Override
    protected Class paramModelType() {
        return PersonModel.class;
    }

    @Override
    protected Map invokeService() {
        return IApplyApplication.getInstance().addEmployee(this.requestParams);
    }

    protected void specialValidate(List list) {
        list.forEach(div -> {
            if (div instanceof DataDiv) {
                PersonModel model = (PersonModel)((DataDiv)div).getT();
                ValidateContext context = ((DataDiv)div).getContext();
                List<String> transferErrorMsg = context.getSaveBaseModel().getTransferErrorMsg();
                if (!CommonServiceUtil.validatePhone((String)model.getPhone())) {
                    transferErrorMsg.add(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801{0}\u683c\u5f0f\u4e0d\u6b63\u786e\uff1b", (String)"AbsPersonSaveBaseController_2", (String)"hrmp-hrpi-mservice", (Object[])new Object[]{model.getPhone()}));
                }
                Empposorgrels empposorgrels = Optional.of(model).map(PersonModel::getBaseinfo).map(EmployeeBaseInfo::getEmpposorgrels).get().stream().findFirst().orElse(null);
                String positionNumber = Optional.ofNullable(empposorgrels).map(Empposorgrels::getPositionNumber).orElse(null);
                String stdPositionNumber = Optional.ofNullable(empposorgrels).map(Empposorgrels::getStdpositionNumber).orElse(null);
                String jobNumber = Optional.ofNullable(empposorgrels).map(Empposorgrels::getJobNumber).orElse(null);
                if (CommonServiceUtil.isOverOneInput((String[])new String[]{positionNumber, stdPositionNumber, jobNumber})) {
                    transferErrorMsg.add(ResManager.loadKDString((String)"\u5165\u53c2\u4efb\u804c\u7ecf\u5386\u5458\u5de5\u7684\u5c97\u4f4dNumber/\u6807\u51c6\u5c97\u4f4dNumber/\u804c\u4f4dNumber\u6709\u4e14\u5fc5\u987b\u586b\u4e00\u4e2a ; ", (String)"AbsPersonSaveBaseController_3", (String)"hrmp-hrpi-mservice", (Object[])new Object[0]));
                }
                if (!CollectionUtils.isEmpty(transferErrorMsg)) {
                    context.setSuccess(false);
                }
            }
        });
    }

    protected void specialTransAfterBaseDataFill(List list) {
        CommonBusinessUtils.transBloodType(list);
    }
}

