/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrpi.business.domian.service.impl.QueryByOrgServiceImpl;
import kd.hrmp.hrpi.mservice.webapi.controller.AbsQueryBaseController;

@ApiController(value="hrpi", desc="\u67e5\u8be2\u6307\u5b9a\u90e8\u95e8\u4e0b\u6240\u6709\u751f\u6548\u7684\u4eba\u5458\u4fe1\u606f")
@ApiMapping(value="/openapi/query")
public class QueryAllPersonOfOrgController
extends AbsQueryBaseController
implements Serializable {
    private static final Log LOG = LogFactory.getLog(QueryAllPersonOfOrgController.class);
    private static final long serialVersionUID = -1501147786169122549L;

    @ApiPostMapping(value="getallusersoforg", desc="\u83b7\u53d6\u6307\u5b9a\u90e8\u95e8\u4e0b\u6240\u6709\u751f\u6548\u7684\u4eba\u5458\u4fe1\u606f")
    public CustomApiResult<@ApiResponseBody(example="Map\u7684key\u4e3a\u90e8\u95e8\u7f16\u7801 , Value\u4e3a\u8be5\u90e8\u95e8\u4e0b\u751f\u6548\u7684\u81ea\u7136\u4ebaID\u96c6\u5408") Map<String, Set<Long>>> getAllUsersOfOrg(@Valid @NotNull @ApiParam(value="\u4efb\u804c\u7c7b\u578b", required=true, example="1:\u6240\u6709\u7c7b\u578b;\u6216\u6307\u5b9a\u7c7b\u578b") @Valid @NotNull @ApiParam(value="\u4efb\u804c\u7c7b\u578b", required=true, example="1:\u6240\u6709\u7c7b\u578b;\u6216\u6307\u5b9a\u7c7b\u578b") String posType, @Valid @NotNull @ApiParam(value="\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408", required=true) @Size(max=2000) @Valid @NotNull @ApiParam(value="\u884c\u653f\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408", required=true) @Size(max=2000) List<String> orgNumbers, @Valid @NotNull @ApiParam(value="\u662f\u5426\u5305\u542b\u4e0b\u7ea7\u7ec4\u7ec7", required=true, example="\u6b64\u53c2\u6570\u5f00\u542f\u4f1a\u589e\u52a0\u8017\u65f6,\u9700\u8010\u5fc3\u7b49\u5f85") @Valid @NotNull @ApiParam(value="\u662f\u5426\u5305\u542b\u4e0b\u7ea7\u7ec4\u7ec7", required=true, example="\u6b64\u53c2\u6570\u5f00\u542f\u4f1a\u589e\u52a0\u8017\u65f6,\u9700\u8010\u5fc3\u7b49\u5f85") Boolean includeSubOrg) {
        Map allUsersOfOrg;
        if (this.listIsIllegal(orgNumbers, String.class, "orgNumbers")) {
            return this.result;
        }
        Map<Long, String> idWithNumber = this.fillIdWithNumber(orgNumbers);
        try {
            allUsersOfOrg = QueryByOrgServiceImpl.getInstance().getAllUsersOfOrg(posType, new ArrayList<Long>(idWithNumber.keySet()), includeSubOrg.booleanValue());
            if (includeSubOrg.booleanValue()) {
                this.reFillIdWithNumber(idWithNumber, allUsersOfOrg);
            }
            if (ObjectUtils.isEmpty((Object)allUsersOfOrg)) {
                LOG.info("method getAllUsersOfOrg return empty collection ");
                return CustomApiResult.success((Object)Collections.EMPTY_MAP);
            }
        }
        catch (Exception exception) {
            LOG.error("occur error when invoke service :", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
        return CustomApiResult.success(allUsersOfOrg.keySet().stream().collect(Collectors.toMap(idWithNumber::get, allUsersOfOrg::get)));
    }

    private void reFillIdWithNumber(Map<Long, String> idWithNumber, Map<Long, Set<Long>> allUsersOfOrg) {
        Set<Long> orgIds = allUsersOfOrg.keySet();
        DynamicObject[] objects = new HRBaseServiceHelper("haos_adminorghr").queryOriginalArray("id,number", new QFilter[]{new QFilter("id", "in", orgIds)});
        idWithNumber.putAll(Arrays.stream(objects).collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("number"))));
    }

    private Map<Long, String> fillIdWithNumber(List<String> orgNumbers) {
        Map orgInfos = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"getAdminOrgInfoByNumber", (Object[])new Object[]{orgNumbers, new Date()});
        return Objects.requireNonNull(orgInfos).keySet().stream().collect(Collectors.toMap(key -> (Long)((Map)orgInfos.get(key)).get("boid"), key -> key));
    }
}

