/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hrmp.hrpi.business.domian.service.impl.QueryByOrgServiceImpl;
import kd.hrmp.hrpi.mservice.webapi.controller.AbsQueryBaseController;

@ApiController(value="hrpi", desc="\u67e5\u8be2\u4efb\u804c\u5728\u67d0\u4e2a\u5c97\u4f4d\u4e0b\u7684\u4eba\u5458\u6e05\u5355")
@ApiMapping(value="/openapi/query")
public class QueryAllPersonOfPositionController
extends AbsQueryBaseController
implements Serializable {
    private static final long serialVersionUID = 2795467519619203999L;
    private static final Log LOG = LogFactory.getLog(QueryAllPersonOfPositionController.class);

    @ApiPostMapping(value="getallusersofposition", desc="\u67e5\u8be2\u4efb\u804c\u5728\u67d0\u4e2a\u5c97\u4f4d\u4e0b\u7684\u4eba\u5458ID")
    public CustomApiResult<@ApiResponseBody(example="Map\u7684Key\u4e3a\u5c97\u4f4d\u7f16\u7801 , Value\u4e3a\u8be5\u5c97\u4f4d\u4e0b\u7684\u81ea\u7136\u4ebaID\u96c6\u5408") Map<String, Set<Long>>> getAllUsersOfPosition(@Valid @NotNull @ApiParam(value="\u4efb\u804c\u7c7b\u578b", required=true, example="1:\u6240\u6709\u7c7b\u578b;\u6216\u6307\u5b9a\u7c7b\u578b") @Valid @NotNull @ApiParam(value="\u4efb\u804c\u7c7b\u578b", required=true, example="1:\u6240\u6709\u7c7b\u578b;\u6216\u6307\u5b9a\u7c7b\u578b") String posType, @Valid @NotNull @ApiParam(value="\u5c97\u4f4dNumbers", required=true) @Size(max=2000) @Valid @NotNull @ApiParam(value="\u5c97\u4f4dNumbers", required=true) @Size(max=2000) List<String> positionNumbers) {
        Map allUsersOfPosition;
        if (this.listIsIllegal(positionNumbers, String.class, "positionNumbers")) {
            return this.result;
        }
        Map<Long, String> idWithNumber = this.fillIdWithNumber(positionNumbers);
        try {
            allUsersOfPosition = QueryByOrgServiceImpl.getInstance().getAllUsersOfPosition(posType, new ArrayList<Long>(idWithNumber.keySet()));
            if (ObjectUtils.isEmpty((Object)allUsersOfPosition)) {
                LOG.info("method getAllUsersOfPosition return empty collection ");
                return CustomApiResult.success((Object)Collections.EMPTY_MAP);
            }
        }
        catch (Exception exception) {
            LOG.error("occur error when invoke service :", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
        return CustomApiResult.success(this.transResult(allUsersOfPosition, idWithNumber));
    }

    private Map<String, Set<Long>> transResult(Map<Long, Set<Long>> allUsersOfPosition, Map<Long, String> idWithNumber) {
        return allUsersOfPosition.keySet().stream().collect(Collectors.toMap(idWithNumber::get, allUsersOfPosition::get));
    }

    private Map<Long, String> fillIdWithNumber(List<String> positionNumbers) {
        Map positionInfos = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"hbpm", (String)"IPositionService", (String)"queryPositionHisByNumber", (Object[])new Object[]{positionNumbers, new Date()});
        if (200 != (Integer)positionInfos.get("code")) {
            throw new KDBizException((String)positionInfos.get("ErrMsg"));
        }
        List data = (List)positionInfos.get("data");
        return data.stream().collect(Collectors.toMap(map -> (Long)map.get("boid"), map -> (String)map.get("number")));
    }
}

