/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.controller;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.hrmp.hrpi.business.domian.service.impl.PersonRoleServiceImpl;
import kd.hrmp.hrpi.mservice.webapi.controller.AbsQueryBaseController;
import kd.hrmp.hrpi.mservice.webapi.model.response.DirectSuperiorModel;
import kd.hrmp.hrpi.mservice.webapi.model.util.ModelUtils;

@ApiController(value="hrpi", desc="\u67e5\u8be2\u5458\u5de5\u7684\u76f4\u63a5\u4e0a\u7ea7")
@ApiMapping(value="/openapi/query")
public class QueryDirectSuperiorController
extends AbsQueryBaseController
implements Serializable {
    private static final long serialVersionUID = 217397449791313484L;
    private static final Log LOG = LogFactory.getLog(QueryDirectSuperiorController.class);

    @ApiPostMapping(value="getdirectsuperior", desc="\u67e5\u8be2\u5458\u5de5\u7684\u76f4\u63a5\u4e0a\u7ea7")
    public CustomApiResult<@ApiResponseBody(example="Map\u7684key\u4e3a\u81ea\u7136\u4ebaID , Value\u4e3a\u8be5\u81ea\u7136\u4eba\u5bf9\u5e94\u7684N\u4e2a\u76f4\u63a5\u4e0a\u7ea7\u4fe1\u606f") Map<Long, List<DirectSuperiorModel>>> getDirectSuperior(@Valid @NotNull @ApiParam(value="\u81ea\u7136\u4ebaID", required=true) @Size(max=2000) @Valid @NotNull @ApiParam(value="\u81ea\u7136\u4ebaID", required=true) @Size(max=2000) List<Long> personIds) {
        Map directSuperiors;
        if (this.listIsIllegal(personIds, Long.class, "personIds")) {
            return this.result;
        }
        try {
            directSuperiors = PersonRoleServiceImpl.getInstance().getDirectSuperior(personIds);
            if (ObjectUtils.isEmpty((Object)directSuperiors)) {
                LOG.info("method getDirectSuperior return empty collection ");
                return CustomApiResult.success((Object)Collections.EMPTY_MAP);
            }
        }
        catch (Exception exception) {
            LOG.error("occur error when invoke service :", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
        return CustomApiResult.success(this.packageResponseMap(directSuperiors));
    }

    private Map<Long, List<DirectSuperiorModel>> packageResponseMap(Map<Long, List<Map<String, Object>>> directSuperiors) {
        HashMap resModels = Maps.newHashMapWithExpectedSize((int)directSuperiors.size());
        directSuperiors.keySet().forEach(tempKey -> resModels.put(tempKey, ModelUtils.transfer2Objects((List)directSuperiors.get(tempKey), DirectSuperiorModel.class)));
        return resModels;
    }
}

