/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hrmp.hrpi.business.domian.service.impl.PersonRoleServiceImpl;
import kd.hrmp.hrpi.mservice.webapi.controller.AbsQueryBaseController;
import kd.hrmp.hrpi.mservice.webapi.model.response.MainChargeInfoModel;
import kd.hrmp.hrpi.mservice.webapi.model.util.ModelUtils;

@ApiController(value="hrpi", desc="\u83b7\u53d6\u751f\u6548\u4e2d\u7684\u4e3b\u8d1f\u8d23\u4eba\u4fe1\u606f")
@ApiMapping(value="/openapi/query")
public class QueryMainChargeByOrgController
extends AbsQueryBaseController
implements Serializable {
    private static final long serialVersionUID = 7117000687802898350L;
    private static final Log LOG = LogFactory.getLog(QueryMainChargeByOrgController.class);

    @ApiPostMapping(value="getmainchargebyorg", desc="\u67e5\u8be2\u751f\u6548\u4e2d\u7684\u4e3b\u8d1f\u8d23\u4eba\u4fe1\u606f")
    public CustomApiResult<@ApiResponseBody(example="Map\u7684Key\u4e3a\u7ec4\u7ec7\u7f16\u7801 , Value\u4e3a\u8be5\u7ec4\u7ec7\u7684\u751f\u6548\u7684\u4e3b\u8d1f\u8d23\u4eba\u4fe1\u606f") Map<String, List<MainChargeInfoModel>>> getMainChargeByOrg(@Valid @NotNull @ApiParam(value="\u7ec4\u7ec7Numbers", required=true) @Size(max=2000) @Valid @NotNull @ApiParam(value="\u7ec4\u7ec7Numbers", required=true) @Size(max=2000) List<String> orgNumbers) {
        List mainChargeInfos;
        if (this.listIsIllegal(orgNumbers, String.class, "orgNumbers")) {
            return this.result;
        }
        Map<Long, String> idWithNumber = this.fillIdWithNumber(orgNumbers);
        try {
            mainChargeInfos = PersonRoleServiceImpl.getInstance().getMainChargeByOrg(new ArrayList<Long>(idWithNumber.keySet()));
            if (ObjectUtils.isEmpty((Object)mainChargeInfos)) {
                LOG.info("method mainChargeInfos return empty collection ");
                return CustomApiResult.success((Object)Collections.EMPTY_MAP);
            }
        }
        catch (Exception exception) {
            LOG.error("occur error when invoke service :", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
        return CustomApiResult.success(this.packResponseMap(mainChargeInfos, idWithNumber));
    }

    private Map<Long, String> fillIdWithNumber(List<String> orgNumbers) {
        Map orgInfos = (Map)DispatchServiceHelper.invokeBizService((String)"hrmp", (String)"haos", (String)"IHAOSBatchAdminOrgInfoQueryService", (String)"getAdminOrgInfoByNumber", (Object[])new Object[]{orgNumbers, new Date()});
        return Objects.requireNonNull(orgInfos).keySet().stream().collect(Collectors.toMap(key -> (Long)((Map)orgInfos.get(key)).get("boid"), key -> key));
    }

    private Map<String, List<MainChargeInfoModel>> packResponseMap(List<Map<String, Object>> mainChargeInfos, Map<Long, String> idWithNumber) {
        mainChargeInfos.forEach(tempInfo -> tempInfo.put("adminorg", idWithNumber.get(tempInfo.get("adminorg"))));
        List<MainChargeInfoModel> models = ModelUtils.transfer2Objects(mainChargeInfos, MainChargeInfoModel.class);
        return Objects.requireNonNull(models).stream().collect(Collectors.groupingBy(MainChargeInfoModel::getAdminorg));
    }
}

