/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.controller;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.hrmp.hrpi.business.domian.service.impl.PersonServiceImpl;
import kd.hrmp.hrpi.mservice.webapi.controller.AbsQueryBaseController;
import kd.hrmp.hrpi.mservice.webapi.model.response.PersonBaseInfoModel;
import kd.hrmp.hrpi.mservice.webapi.model.util.ModelUtils;

@ApiController(value="hrpi", desc="\u83b7\u53d6\u4e2a\u4eba\u57fa\u672c\u4fe1\u606f")
@ApiMapping(value="/openapi/query")
public class QueryPersonBaseInfoController
extends AbsQueryBaseController
implements Serializable {
    private static final long serialVersionUID = 3942900610529628342L;
    private static final Log LOG = LogFactory.getLog(QueryPersonBaseInfoController.class);

    @ApiPostMapping(value="querypersoninfos", desc="\u6279\u91cf\u67e5\u8be2\u4e2a\u4eba\u57fa\u672c\u4fe1\u606f")
    public CustomApiResult<@ApiResponseBody List<PersonBaseInfoModel>> listPersonInfos(@Valid @NotNull @ApiParam(value="\u81ea\u7136\u4ebaID\u96c6\u5408", required=true) @Size(max=2000) @Valid @NotNull @ApiParam(value="\u81ea\u7136\u4ebaID\u96c6\u5408", required=true) @Size(max=2000) List<Long> personIds) {
        if (this.listIsIllegal(personIds, Long.class, "personIds")) {
            return this.result;
        }
        try {
            List personInfos = PersonServiceImpl.getInstance().listPersonInfos(personIds);
            if (ObjectUtils.isEmpty((Object)personInfos) || personInfos.stream().allMatch(temp -> null == temp || temp.size() == 0)) {
                LOG.info("method listPersonInfos return empty collection ");
                return CustomApiResult.success(Collections.emptyList());
            }
            List<PersonBaseInfoModel> resModelList = ModelUtils.transfer2Objects(personInfos, PersonBaseInfoModel.class);
            return CustomApiResult.success(resModelList);
        }
        catch (Exception exception) {
            LOG.error("occur error when invoke service :", (Throwable)exception);
            throw new KDBizException(exception.getMessage());
        }
    }
}

