/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.controller;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiErrorCodes;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.hrmp.hrpi.business.application.IApplyApplication;
import kd.hrmp.hrpi.business.init.common.CommonServiceUtil;
import kd.hrmp.hrpi.mservice.webapi.controller.AbsPersonSaveBaseController;
import kd.hrmp.hrpi.mservice.webapi.model.annotation.NeedSyncSysUser;
import kd.hrmp.hrpi.mservice.webapi.model.request.EmpOrgRelInfoModel;
import kd.hrmp.hrpi.mservice.webapi.model.response.SaveBaseModel;
import kd.hrmp.hrpi.mservice.webapi.transfer.entity.DataDiv;
import kd.hrmp.hrpi.mservice.webapi.transfer.entity.ValidateContext;

@NeedSyncSysUser(key="number")
@ApiController(value="hrpi", desc="\u6279\u91cf\u7ef4\u62a4\u5458\u5de5\u7684\u4efb\u804c\u7ecf\u5386")
@ApiMapping(value="/openapi/save")
public class SaveEmpOrgrelsController
extends AbsPersonSaveBaseController
implements Serializable {
    private static final long serialVersionUID = -927434522651090497L;
    private static final Log LOGGER = LogFactory.getLog(SaveEmpOrgrelsController.class);

    @ApiPostMapping(value="emporgrels", desc="\u6279\u91cf\u7ef4\u62a4\u4efb\u804c\u7ecf\u5386")
    @ApiErrorCodes(value={@ApiErrorCode(code="810", desc="transfer data occur exception , more information details on error message ."), @ApiErrorCode(code="820", desc="invoke service occur exception ,more information details on error message .")})
    public CustomApiResult<List<@ApiResponseBody SaveBaseModel>> saveEmpOrgrels(@Valid @NotNull @ApiParam(value="\u7ef4\u62a4\u4efb\u804c\u7ecf\u5386", required=true) @Size(max=500) @Valid @NotNull @ApiParam(value="\u7ef4\u62a4\u4efb\u804c\u7ecf\u5386", required=true) @Size(max=500) List<EmpOrgRelInfoModel> employeeRelsInfoModels) {
        return this.execute(employeeRelsInfoModels);
    }

    @Override
    protected Class paramModelType() {
        return EmpOrgRelInfoModel.class;
    }

    @Override
    protected Map invokeService() {
        return IApplyApplication.getInstance().saveEmpOrgrels(this.requestParams);
    }

    protected void specialValidate(List list) {
        list.forEach(div -> {
            if (div instanceof DataDiv) {
                EmpOrgRelInfoModel empOrgRelInfoModel = (EmpOrgRelInfoModel)((DataDiv)div).getT();
                ValidateContext context = ((DataDiv)div).getContext();
                List<String> transferErrorMsg = context.getSaveBaseModel().getTransferErrorMsg();
                String positionNumber = Optional.ofNullable(empOrgRelInfoModel).map(EmpOrgRelInfoModel::getPositionNumber).orElse(null);
                String stdPositionNumber = Optional.ofNullable(empOrgRelInfoModel).map(EmpOrgRelInfoModel::getStdpositionNumber).orElse(null);
                String jobNumber = Optional.ofNullable(empOrgRelInfoModel).map(EmpOrgRelInfoModel::getJobNumber).orElse(null);
                if (CommonServiceUtil.isOverOneInput((String[])new String[]{positionNumber, stdPositionNumber, jobNumber})) {
                    context.setSuccess(false);
                    transferErrorMsg.add(ResManager.loadKDString((String)"\u5165\u53c2\u4efb\u804c\u7ecf\u5386\u5458\u5de5\u7684\u5c97\u4f4dNumber/\u6807\u51c6\u5c97\u4f4dNumber/\u804c\u4f4dNumber\u6709\u4e14\u5fc5\u987b\u586b\u4e00\u4e2a ; ", (String)"AbsPersonSaveBaseController_3", (String)"hrmp-hrpi-mservice", (Object[])new Object[0]));
                }
            }
        });
    }
}

