/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.model.util;

import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.DateConverter;

public class ModelUtils {
    private static final Log LOG = LogFactory.getLog(ModelUtils.class);
    private static final Map<String, String> cacheMap = Maps.newHashMap();

    private ModelUtils() {
    }

    public static <T> List<T> transfer2Objects(List<Map<String, Object>> list, Class<T> clazz) {
        if (null == list || list.size() == 0) {
            return new ArrayList();
        }
        ArrayList<T> resList = new ArrayList<T>(list.size());
        try {
            ModelUtils.preExecuted(list);
            for (Map<String, Object> map : list) {
                T instance = clazz.newInstance();
                ConvertUtils.register((Converter)new DateConverter(null), Date.class);
                BeanUtils.copyProperties(instance, map);
                resList.add(instance);
            }
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            LOG.error("occur error :", (Throwable)e);
            throw new KDBizException("Transfer process occur exception : " + e.getMessage());
        }
        finally {
            ModelUtils.clear();
        }
        return resList;
    }

    private static void clear() {
        Optional<Map<String, String>> optionalMap = Optional.ofNullable(cacheMap);
        optionalMap.ifPresent(Map::clear);
    }

    private static void preExecuted(List<Map<String, Object>> list) {
        for (Map<String, Object> map : list) {
            if (!ModelUtils.hasDotKey(map)) break;
            ModelUtils.changeDot2UpperCase(map);
        }
    }

    private static void changeDot2UpperCase(Map<String, Object> map) {
        List keysNeed2BReplace = map.keySet().stream().filter(key -> key.contains(".")).collect(Collectors.toList());
        for (String oldKey : keysNeed2BReplace) {
            map.put(ModelUtils.getNewKey(oldKey), map.remove(oldKey));
        }
    }

    private static String getNewKey(String oldKey) {
        if (null != cacheMap.get(oldKey)) {
            return cacheMap.get(oldKey);
        }
        String newKey = ModelUtils.transferOldKey(oldKey);
        cacheMap.put(oldKey, newKey);
        return newKey;
    }

    private static String transferOldKey(String oldKey) {
        String[] partStrings = oldKey.split("\\.");
        boolean isHead = true;
        StringBuilder bd = new StringBuilder();
        for (String part : partStrings) {
            if (isHead) {
                bd.append(part);
                isHead = false;
                continue;
            }
            bd.append(part.substring(0, 1).toUpperCase()).append(part.substring(1));
        }
        return bd.toString();
    }

    private static boolean hasDotKey(Map<String, Object> map) {
        return map.keySet().stream().anyMatch(temp -> temp.contains("."));
    }
}

