/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.mservice.webapi.transfer.converters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hrmp.hrpi.mservice.webapi.transfer.converters.Converter;

public abstract class AbsConverter
implements Converter {
    protected static final Log LOG = LogFactory.getLog(AbsConverter.class);
    protected static final ThreadLocal<Map<String, Object>> CACHE_MAP = ThreadLocal.withInitial(HashMap::new);
    private static final String IS_CURR = "iscurrentversion";
    private static final String NUMBER = "number";
    private static final String ID = "id";

    @Override
    public void queryData() {
        HRBaseServiceHelper service = this.getServiceHelper();
        DynamicObject[] objects = service.query(this.getSelectProperties(), this.getFilters());
        Map<String, Object> dataMap = Arrays.stream(objects).collect(Collectors.toMap(obj -> obj.getString(this.getKey()), obj -> obj.get(this.getValue()), (v1, v2) -> v1));
        if (this.dataNeedToChange(service) && this.changeNothing(dataMap)) {
            LOG.warn("all the number input can't find the match id .");
        }
        CACHE_MAP.get().put(service.getEntityName(), dataMap);
    }

    private boolean changeNothing(Map<String, Object> dataMap) {
        return null == dataMap || dataMap.size() == 0;
    }

    private boolean dataNeedToChange(HRBaseServiceHelper service) {
        return null != CACHE_MAP.get().get(service.getEntityName()) && !((Set)CACHE_MAP.get().get(service.getEntityName())).isEmpty();
    }

    @Override
    public Converter fillDataEnterParams(Set<String> strings) {
        CACHE_MAP.get().put(this.getServiceHelper().getEntityName(), strings);
        return this;
    }

    private String getValue() {
        return ID;
    }

    private String getKey() {
        return NUMBER;
    }

    private String getSelectProperties() {
        return "number,id";
    }

    private QFilter[] getFilters() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getServiceHelper().getEntityName());
        IDataEntityProperty property = entityType.findProperty(IS_CURR);
        QFilter numberFilter = new QFilter(NUMBER, "in", CACHE_MAP.get().get(this.getServiceHelper().getEntityName()));
        if (null != property) {
            QFilter currentFilter = new QFilter(IS_CURR, "=", (Object)"1");
            return new QFilter[]{currentFilter, numberFilter};
        }
        return new QFilter[]{numberFilter};
    }

    protected abstract HRBaseServiceHelper getServiceHelper();

    @Override
    public Map<String, Object> getCache() {
        return CACHE_MAP.get();
    }

    @Override
    public void cacheClear() {
        CACHE_MAP.get().remove(this.getServiceHelper().getEntityName());
    }
}

