/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.formplugin.web.chargeperson;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.privacy.PrivacyCenterUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.lang.Lang;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.privacy.PrivacyCenterServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRImageUrlUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;

public class ChargePersonCardPlugin
extends HRDataBaseEdit
implements HRPIChargePersonConstants {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long id = Long.valueOf((String)this.getView().getFormShowParameter().getCustomParam("id"));
        this.setUserInfoToPage(id);
    }

    private void setUserInfoToPage(Long id) {
        DynamicObject chargePerson = HRPIChargePersonRepository.getInstance().loadOneById(id.longValue());
        if (chargePerson == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"chargeinfo"});
            return;
        }
        Long chargePersonId = chargePerson.getLong("chargeperson.id");
        ArrayList<Long> chargePersonlList = new ArrayList<Long>(1);
        chargePersonlList.add(chargePersonId);
        DynamicObject[] ermanFileByDepempArr = (DynamicObject[])HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getErmanFileByDepempId", (Object[])new Object[]{chargePersonlList});
        if (ermanFileByDepempArr.length == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"chargeinfo"});
            return;
        }
        Long fileId = ermanFileByDepempArr[0].getLong("id");
        ArrayList<Long> fileIdS = new ArrayList<Long>(1);
        fileIdS.add(fileId);
        List personMapList = (List)HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMService", (String)"getCardFields", (Object[])new Object[]{fileIdS});
        if (CollectionUtils.isEmpty((Collection)personMapList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"chargeinfo"});
            return;
        }
        Map personMap = (Map)personMapList.get(0);
        Image image = (Image)this.getView().getControl("headsculpture");
        image.setUrl(HRImageUrlUtil.getImageFullUrl((String)((String)personMap.get("headsculpture"))));
        this.setLeaderInfo(personMap);
        this.setPrivacyToPage(personMap);
        this.setInfoToPage(personMap);
    }

    private void setInfoToPage(Map<String, Object> personMap) {
        Label nameLable = (Label)this.getView().getControl("name");
        nameLable.setText((String)personMap.get("name"));
        Label numberLable = (Label)this.getView().getControl("number");
        numberLable.setText((String)personMap.get("number"));
        if (HRStringUtils.isNotEmpty((String)((String)personMap.get("position")))) {
            Label positionLable = (Label)this.getView().getControl("position");
            positionLable.setText((String)personMap.get("position"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"position"});
        }
        if (HRStringUtils.isNotEmpty((String)((String)personMap.get("gender")))) {
            Label genderLable = (Label)this.getView().getControl("gender");
            genderLable.setText((String)personMap.get("gender"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap_sex"});
        }
        if (HRStringUtils.isNotEmpty((String)((String)personMap.get("phone")))) {
            Label phoneLable = (Label)this.getView().getControl("phone");
            phoneLable.setText((String)personMap.get("phone"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap_phone"});
        }
        if (HRStringUtils.isNotEmpty((String)((String)personMap.get("peremail")))) {
            Label peremailLable = (Label)this.getView().getControl("peremail");
            peremailLable.setText((String)personMap.get("peremail"));
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"vectorap_email"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"leader_more", "view_desensitize"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        String clickingButton = source.getKey();
        if (HRStringUtils.equals((String)clickingButton, (String)"leader_more")) {
            FormShowParameter showPersonInfoParameter = new FormShowParameter();
            showPersonInfoParameter.getOpenStyle().setShowType(ShowType.Modal);
            showPersonInfoParameter.setCustomParam("leader_more", (Object)this.getView().getPageCache().get("leader_more"));
            showPersonInfoParameter.setCustomParam("leader_number", (Object)this.getView().getPageCache().get("leader_number"));
            showPersonInfoParameter.setFormId("hrpi_chargepersoncardmore");
            this.getView().showForm(showPersonInfoParameter);
        } else if (HRStringUtils.equals((String)clickingButton, (String)"view_desensitize")) {
            this.setDesensitizeToMap();
        }
    }

    private void setDesensitizeToMap() {
        String personInfo = this.getView().getPageCache().get("person");
        Map personMap = (Map)JSONObject.parse((String)personInfo);
        boolean nameClickView = this.checkClickView("hrpi_person", "name");
        boolean personnumberClickView = this.checkClickView("hrpi_person", "number");
        boolean genderClickView = this.checkClickView("hrpi_percre", "gender");
        boolean positionClickView = this.checkClickView("hrpi_depemp", "position");
        boolean phoneClickView = this.checkClickView("hrpi_percontact", "phone");
        boolean peremailClickView = this.checkClickView("hrpi_percontact", "peremail");
        this.getView().setVisible(Boolean.FALSE, new String[]{"view_desensitize"});
        if (nameClickView) {
            Label nameLable = (Label)this.getView().getControl("name");
            nameLable.setText((String)personMap.get("name"));
        }
        if (personnumberClickView) {
            Label numberLable = (Label)this.getView().getControl("number");
            numberLable.setText((String)personMap.get("number"));
        }
        if (positionClickView) {
            Label positionLable = (Label)this.getView().getControl("position");
            positionLable.setText((String)personMap.get("position"));
        }
        if (genderClickView) {
            Label genderLable = (Label)this.getView().getControl("gender");
            genderLable.setText((String)personMap.get("gender"));
        }
        if (phoneClickView) {
            Label phoneLable = (Label)this.getView().getControl("phone");
            phoneLable.setText((String)personMap.get("phone"));
        }
        if (peremailClickView) {
            Label peremailLable = (Label)this.getView().getControl("peremail");
            peremailLable.setText((String)personMap.get("peremail"));
        }
    }

    private boolean checkClickView(String entityNumber, String fieldName) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)entityType);
        FilterField filterField = FilterField.create((MainEntityType)entityType, (String)fieldName);
        String strategy = PrivacyCenterUtils.getDesensitizeStrategy((IDataEntityProperty)filterField.getFieldProp(), (String)"LIST", (DynamicObject)dynamicObject);
        return "CLICKVIEW".equals(strategy);
    }

    private void setLeaderInfo(Map<String, Object> personMap) {
        List chargeInfoMapList = (List)personMap.get("chargeinfo");
        if (CollectionUtils.isEmpty((Collection)chargeInfoMapList)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"chargeinfo"});
        } else if (chargeInfoMapList.size() == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"leader_photo1", "leader_name1", "leader_more"});
        } else if (chargeInfoMapList.size() == 2) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"leader_more"});
        }
        if (!CollectionUtils.isEmpty((Collection)chargeInfoMapList)) {
            for (int i = 0; i < 2; ++i) {
                Map leaderMap = (Map)chargeInfoMapList.get(i);
                String leaderPhoto = "leader_photo" + i;
                String leaderName = "leader_name" + i;
                Image photo = (Image)this.getView().getControl(leaderPhoto);
                photo.setUrl(HRImageUrlUtil.getImageFullUrl((String)((String)leaderMap.get("headsculpture"))));
                Label name = (Label)this.getView().getControl(leaderName);
                name.setText((String)leaderMap.get("name"));
            }
            Label number = (Label)this.getView().getControl("leader_number");
            number.setText("(" + chargeInfoMapList.size() + ")");
            this.getView().getPageCache().put("leader_more", JSON.toJSONString((Object)chargeInfoMapList));
            this.getView().getPageCache().put("leader_number", String.valueOf(chargeInfoMapList.size()));
        }
    }

    private void setPrivacyToPage(Map<String, Object> personMap) {
        boolean namePrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", null);
        boolean personnumberPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_person", (String)"number", (String)Lang.get().toString(), (String)"LIST", null);
        boolean genderPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_percre", (String)"gender", (String)Lang.get().toString(), (String)"LIST", null);
        boolean positionPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_depemp", (String)"position", (String)Lang.get().toString(), (String)"LIST", null);
        boolean phonePrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_percontact", (String)"phone", (String)Lang.get().toString(), (String)"LIST", null);
        boolean peremailPrivacy = PrivacyCenterServiceHelper.isDesensitizeField((String)"hrpi_percontact", (String)"peremail", (String)Lang.get().toString(), (String)"LIST", null);
        if (namePrivacy || personnumberPrivacy || genderPrivacy || positionPrivacy || phonePrivacy || peremailPrivacy) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"view_desensitize"});
            boolean nameClickView = this.checkClickView("hrpi_person", "name");
            boolean personnumberClickView = this.checkClickView("hrpi_person", "number");
            boolean genderClickView = this.checkClickView("hrpi_percre", "gender");
            boolean positionClickView = this.checkClickView("hrpi_depemp", "position");
            boolean phoneClickView = this.checkClickView("hrpi_percontact", "phone");
            boolean peremailClickView = this.checkClickView("hrpi_percontact", "peremail");
            if (!(nameClickView || personnumberClickView || genderClickView || positionClickView || phoneClickView || peremailClickView)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"view_desensitize"});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"view_desensitize"});
        }
        HashMap personInfoMap = Maps.newHashMap();
        personInfoMap.put("name", personMap.get("name"));
        personInfoMap.put("number", personMap.get("number"));
        personInfoMap.put("position", personMap.get("position"));
        personInfoMap.put("gender", personMap.get("gender"));
        personInfoMap.put("phone", personMap.get("phone"));
        personInfoMap.put("peremail", personMap.get("peremail"));
        this.getView().getPageCache().put("person", JSON.toJSONString((Object)personInfoMap));
        if (namePrivacy) {
            String personName = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"name", (String)Lang.get().toString(), (String)"LIST", null, (Object)personMap.get("name"));
            personMap.put("name", personName);
        }
        if (personnumberPrivacy) {
            String personNumber = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_person", (String)"number", (String)Lang.get().toString(), (String)"LIST", null, (Object)personMap.get("number"));
            personMap.put("number", personNumber);
        }
        if (genderPrivacy) {
            String gender = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_percre", (String)"gender", (String)Lang.get().toString(), (String)"LIST", null, (Object)personMap.get("gender"));
            personMap.put("gender", gender);
        }
        if (positionPrivacy) {
            String posName = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_depemp", (String)"position", (String)Lang.get().toString(), (String)"LIST", null, (Object)personMap.get("position"));
            personMap.put("position", posName);
        }
        if (phonePrivacy) {
            String phone = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_percontact", (String)"phone", (String)Lang.get().toString(), (String)"LIST", null, (Object)personMap.get("phone"));
            personMap.put("phone", phone);
        }
        if (peremailPrivacy) {
            String peremail = (String)PrivacyCenterServiceHelper.getDesensitizeValue((String)"hrpi_percontact", (String)"peremail", (String)Lang.get().toString(), (String)"LIST", null, (Object)personMap.get("peremail"));
            personMap.put("peremail", peremail);
        }
    }
}

