/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.formplugin.web.chargeperson;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.AuthorizedOrgResult;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseEdit;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.business.helper.SystemParamHelper;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;
import kd.hrmp.hrpi.formplugin.web.chargeperson.ext.DefChargePersonF7Extend;
import kd.sdk.hr.hrmp.hrpi.extpoint.IChargePersonF7Extend;

public class ChargePersonEditPlugin
extends HRDataBaseEdit
implements BeforeF7SelectListener,
HRPIChargePersonConstants {
    private static final Log LOGGER = LogFactory.getLog(ChargePersonEditPlugin.class);
    private static String REMOVE_TIP = "removetip";
    private static String CONFIRM_CALL_BACK_REMOVE_RESULT = "call_back_result_remove";
    private AuthorizedOrgResult permResult;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit person = (BasedataEdit)this.getView().getControl("mulperson");
        person.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void preOpenForm(PreOpenFormEventArgs event) {
        super.preOpenForm(event);
        String operateType = (String)event.getFormShowParameter().getCustomParam("operatetype");
        if (event.getFormShowParameter().getStatus().equals((Object)OperationStatus.ADDNEW)) {
            event.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u6dfb\u52a0\u8d1f\u8d23\u4eba", (String)"ChargePersonEditPlugin_0", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]));
        } else if ("1".equals(operateType)) {
            event.getFormShowParameter().setCaption(ResManager.loadKDString((String)"\u53d6\u6d88\u8d1f\u8d23\u4eba", (String)"ChargePersonEditPlugin_1", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterLoadData(EventObject eventObject) {
        Object chargePerson = this.getModel().getValue("chargeperson");
        if (chargePerson != null) {
            DynamicObjectCollection mulPerson = (DynamicObjectCollection)this.getModel().getValue("mulperson");
            DynamicObject depEmpDyn = new DynamicObject(mulPerson.getDynamicObjectType());
            depEmpDyn.set("fbasedataid", chargePerson);
            mulPerson.add((Object)depEmpDyn);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"mulperson"});
            DateEdit control = (DateEdit)this.getControl("effdt");
            this.addTips(control, "effdt");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String properName = event.getProperty().getName();
        Object adminOrg = this.getModel().getValue("adminorg");
        Long orgId = ((DynamicObject)adminOrg).getLong("org.id");
        boolean chooseChargePersonParameter = SystemParamHelper.getChooseChargePersonParameter((Long)orgId);
        if ("mulperson".equals(properName)) {
            this.getHrPermOrg();
            ListShowParameter listShowParameter = (ListShowParameter)event.getFormShowParameter();
            listShowParameter.setMultiSelect(true);
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            formShowParameter.setCustomParam("customHREntityNumber", (Object)"hrpi_chargeperson");
            formShowParameter.setCustomParam("custom_parent_f7_prop", (Object)"adminorg");
            formShowParameter.setCustomParam("customHRPermItemId", (Object)"47150e89000000ac");
            this.getView().cacheFormShowParameter();
            PluginProxy proxy = PluginProxy.create((Object)new DefChargePersonF7Extend(), IChargePersonF7Extend.class, (String)"kd.hrmp.hrpi.formplugin.web.chargeperson.ChargePersonEditPlugin.point");
            if (adminOrg != null) {
                HasPermOrgResult permOrg;
                Long adminOrgId = ((DynamicObject)adminOrg).getLong("id");
                QFilter filter = new QFilter("iscurrentversion", "=", (Object)Character.valueOf('1'));
                filter.and("initstatus", "=", (Object)"2");
                DynamicObject[] chargePersonInfoArr = HRPIChargePersonRepository.getInstance().queryEffChargeByOrgId("chargeperson", Collections.singletonList(adminOrgId), new Date());
                Set depEmpIds = Arrays.stream(chargePersonInfoArr).map(chargePerson -> chargePerson.getLong("chargeperson.id")).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(depEmpIds)) {
                    filter.and("id", "not in", depEmpIds);
                }
                List isCustom = proxy.callAfter(IChargePersonF7Extend::isCustomFilter);
                proxy.callAfter(plugin -> {
                    if (plugin.isCustomFilter()) {
                        filter.and(plugin.getChargePersonF7Filter());
                    }
                    return null;
                });
                if (isCustom.stream().noneMatch(flag -> flag) && !chooseChargePersonParameter) {
                    filter.and("adminorg", "=", (Object)adminOrgId);
                }
                if (!this.permResult.isHasAllOrgPerm()) {
                    filter.and("adminorg", "in", (Object)this.permResult.getHasPermOrgs());
                }
                if (!(permOrg = this.getPermOrg()).hasAllOrgPerm()) {
                    filter.and("adminorg.org", "in", (Object)permOrg.getHasPermOrgs());
                }
                listShowParameter.getListFilterParameter().getQFilters().add(filter);
            }
            QFilter empFilter = new QFilter("hrpi_empentrel.labrelstatusprd", "=", (Object)1010L);
            empFilter.and("hrpi_empposorgrel.startdate", "<=", (Object)new Date());
            empFilter.and("hrpi_empposorgrel.sysenddate", ">", (Object)new Date());
            listShowParameter.getListFilterParameter().getQFilters().add(empFilter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object adminOrg = this.getView().getFormShowParameter().getCustomParams().get("adminorg");
        if (adminOrg != null) {
            this.getModel().setValue("adminorg", (Object)Long.parseLong(adminOrg.toString()));
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object selectIdObject = this.getView().getFormShowParameter().getCustomParams().get("selectIds");
        String operateType = (String)this.getView().getFormShowParameter().getCustomParams().get("operatetype");
        if ("1".equals(operateType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"btnsave"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"mulperson"});
            DateEdit lEffDt = (DateEdit)this.getControl("leffdt");
            lEffDt.setMaxDate(new Date());
            this.addTips(lEffDt, "leffdt");
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"effdt"});
            if (selectIdObject != null) {
                List selectIds = JSON.parseArray((String)selectIdObject.toString(), Long.class);
                String tip = ResManager.loadKDString((String)"\u5df2\u9009\u62e9%1$s\u6761\u6570\u636e\u5c06\u53d6\u6d88\u90e8\u95e8\u8d1f\u8d23\u4eba\uff0c\u662f\u5426\u786e\u8ba4\u64cd\u4f5c\uff1f", (String)"ChargePersonEditPlugin_2", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]);
                this.getModel().setValue(REMOVE_TIP, (Object)String.format(tip, selectIds.size()));
                this.setPersonF7();
            }
        } else {
            ((DateEdit)this.getControl("effdt")).setMaxDate(new Date());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"removeconfirm"});
            if (!"0".equals(operateType) && !"1".equals(this.getModel().getDataEntity().getString("datastatus"))) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"effdt", "leffdt", "explain", "ismain"});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"modifyconfirm"});
            } else {
                this.getModel().setValue("leffdt", (Object)HRBaseUtils.getMaxEndDate());
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"leffdt"});
            }
        }
        this.getModel().setDataChanged(false);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean showConfirm;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        Object selectIds = this.getView().getFormShowParameter().getCustomParams().get("selectIds");
        if (selectIds != null) {
            formOperate.getOption().setVariableValue("selectIds", JSON.toJSONString(selectIds));
        }
        if ("donothing_removeconfirm".equals(operateKey) && (showConfirm = this.showRemoveConfirm())) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        FormOperate formOperate = (FormOperate)eventArgs.getSource();
        String operateKey = formOperate.getOperateKey();
        if (!"close".equals(operateKey)) {
            this.getModel().setDataChanged(false);
        }
        if (eventArgs.getOperationResult().isSuccess()) {
            if ("donothing_removeconfirm".equals(operateKey) || "donothing_savenew".equals(operateKey)) {
                this.getView().returnDataToParent((Object)eventArgs.getOperationResult());
                this.getView().close();
            } else if ("save".equals(operateKey)) {
                this.getView().returnDataToParent((Object)eventArgs.getOperationResult());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if ("mulperson".equals(e.getProperty().getName())) {
            int ordinal = this.getModel().getDataEntity().getDynamicObjectType().getProperty("mulperson").getOrdinal();
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        switch (messageBoxClosedEvent.getCallBackId()) {
            case "donothing_removeconfirm": {
                if (!messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) break;
                this.getView().getFormShowParameter().setCustomParam(CONFIRM_CALL_BACK_REMOVE_RESULT, (Object)true);
                this.getView().invokeOperation("donothing_removeconfirm");
                break;
            }
        }
    }

    private boolean showRemoveConfirm() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam(CONFIRM_CALL_BACK_REMOVE_RESULT);
        if (customParam != null) {
            boolean isOk = (Boolean)customParam;
            this.getView().getFormShowParameter().setCustomParam(CONFIRM_CALL_BACK_REMOVE_RESULT, null);
            return !isOk;
        }
        DynamicObject pageDy = this.getView().getModel().getDataEntity();
        DynamicObjectCollection depEmpCol = pageDy.getDynamicObjectCollection("mulperson");
        Set depEmpSet = depEmpCol.stream().map(person -> person.getLong("fbasedataid.id")).collect(Collectors.toSet());
        DynamicObject[] chargePersons = HRPIChargePersonRepository.getInstance().queryOriginalChargeByDepEmps("effdt, chargeperson.id, chargeperson.person.name", depEmpSet);
        Date lEffectDate = pageDy.getDate("leffdt");
        List checkFailChargePersonList = Arrays.stream(chargePersons).filter(chargePerson -> lEffectDate.before(chargePerson.getDate("effdt"))).collect(Collectors.toList());
        if (checkFailChargePersonList.size() != 0) {
            String lEffDtStr = HRDateTimeUtils.format((Date)lEffectDate, (String)"yyyy-MM-dd");
            String tail = ResManager.loadKDString((String)"\u7cfb\u7edf\u5c06\u8ba4\u4e3a\u8be5\u8d1f\u8d23\u4eba\u5728\u672c\u90e8\u95e8\u4e2d\u4ece\u672a\u751f\u6548\u8fc7\uff0c\u786e\u5b9a\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"ChargePersonEditPlugin_4", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]);
            String msg = checkFailChargePersonList.stream().map(chargePerson -> {
                String effDtStr = HRDateTimeUtils.format((Date)chargePerson.getDate("effdt"), (String)"yyyy-MM-dd");
                return String.format(ResManager.loadKDString((String)"\u60a8\u586b\u5199\u7684\u53d6\u6d88\u65e5\u671f\u201c%1$s\u201d\u65e9\u4e8e\u8d1f\u8d23\u4eba\u201c%2$s\u201d\u7684\u5f53\u524d\u751f\u6548\u65e5\u671f\u201c%3$s\u201d\u3002", (String)"ChargePersonEditPlugin_3", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]), lEffDtStr, chargePerson.getString("chargeperson.person.name"), effDtStr);
            }).collect(Collectors.joining(";" + System.lineSeparator(), "", ";" + System.lineSeparator() + tail));
            this.getView().showConfirm(msg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("donothing_removeconfirm"));
            return true;
        }
        return false;
    }

    private void setPersonF7() {
        DynamicObjectCollection personF7 = this.getModel().getDataEntity().getDynamicObjectCollection("mulperson");
        DynamicObjectType personType = (DynamicObjectType)((BasedataProp)personF7.getDynamicObjectType().getProperty("fbasedataid")).getComplexType();
        String chargePersonIds = (String)this.getView().getFormShowParameter().getCustomParams().get("selectIds");
        DynamicObject[] chargePersonDys = HRPIChargePersonRepository.getInstance().queryOriginalByIdList("id, chargeperson.id", JSON.parseArray((String)chargePersonIds, Long.class));
        Set depEmpSet = Arrays.stream(chargePersonDys).map(dy -> dy.getLong("chargeperson.id")).collect(Collectors.toSet());
        DynamicObject[] personDys = (DynamicObject[])depEmpSet.stream().map(id -> {
            DynamicObject dynamicObject = new DynamicObject(personType);
            dynamicObject.set("id", id);
            return dynamicObject;
        }).toArray(DynamicObject[]::new);
        Arrays.stream(personDys).map(personDy -> {
            DynamicObject personF7Col = new DynamicObject(personF7.getDynamicObjectType());
            personF7Col.set("fbasedataid", personDy);
            return personF7Col;
        }).forEach(arg_0 -> ((DynamicObjectCollection)personF7).add(arg_0));
    }

    private void addTips(DateEdit dateEdit, String controlKey) {
        Tips tips = new Tips();
        List tipsStr = (List)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSService", (String)"queryPromptForString", (Object[])new Object[]{"hrpi_chargeperson", controlKey, this.getModel().getDataEntity()});
        if (!CollectionUtils.isEmpty((Collection)tipsStr)) {
            tips.setContent(new LocaleString((String)tipsStr.get(0)));
            tips.setType("text");
            tips.setTriggerType("hover");
            tips.setIsConfirm(false);
            tips.setShowIcon(true);
            dateEdit.addTips(tips);
        }
    }

    private void getHrPermOrg() {
        this.permResult = (AuthorizedOrgResult)HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSBizDataPermissionService", (String)"getAuthorizedAdminOrgSet", (Object[])new Object[]{RequestContext.get().getCurrUserId(), "homs", "homs_adminorgdetail", "47150e89000000ac", "boid"});
        LOGGER.info("getHrPermOrg#permResult={}", (Object)this.permResult);
    }

    private HasPermOrgResult getPermOrg() {
        return PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"21", (String)"homs", (String)"homs_adminorgdetail", (String)"47150e89000000ac", (boolean)false);
    }
}

