/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.formplugin.web.chargeperson;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.util.ReflectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class ChargePersonImportPlugin
extends BatchImportPlugin {
    private static final Log LOG = LogFactory.getLog(ChargePersonImportPlugin.class);
    private static final String IMPORT_PROP = "importprop";

    public BatchImportPlugin setContext(RequestContext rc, ImportContext ctx, List<String> startArgs) {
        try {
            Field view = ctx.getClass().getDeclaredField("view");
            ReflectionUtils.makeAccessible((Field)view);
            try {
                FormView formView = (FormView)view.get(ctx);
                formView.setVisible(Boolean.valueOf(false), new String[]{"radiofield1", "radiofield2"});
            }
            catch (IllegalAccessException e) {
                LOG.error((Throwable)e);
            }
        }
        catch (NoSuchFieldException e) {
            LOG.error((Throwable)e);
        }
        return super.setContext(rc, ctx, startArgs);
    }

    protected void beforeSave(List<ImportBillData> billDatas, ImportLogger logger) {
        Set numbers = billDatas.stream().map(i -> i.getData().getJSONObject("person").getString("number")).collect(Collectors.toSet());
        DynamicObject[] dynamicObjects = (DynamicObject[])HRMServiceHelper.invokeBizService((String)"hr", (String)"hspm", (String)"IHSPMService", (String)"listPrimaryErmanFilesByEmpnumber", (Object[])new Object[]{new ArrayList(numbers)});
        Map ermanFileMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(dy -> dy.getString("number"), Function.identity()));
        billDatas.forEach(importBillData -> {
            String number;
            DynamicObject ermanfile;
            JSONObject data = importBillData.getData();
            JSONObject personJsonObject = data.getJSONObject("person");
            String importProp = personJsonObject.getString(IMPORT_PROP);
            if ("number".equals(importProp) && (ermanfile = (DynamicObject)ermanFileMap.get(number = personJsonObject.getString("number"))) != null) {
                personJsonObject.put(IMPORT_PROP, (Object)"id");
                personJsonObject.put("id", (Object)ermanfile.getLong("person.id"));
                personJsonObject.put("number", (Object)number);
            }
        });
        super.beforeSave(billDatas, logger);
    }
}

