/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.formplugin.web.chargeperson;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.workflow.engine.impl.util.CollectionUtil;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisEffDateCommonService;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPIPersonRepository;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;

public class ChargePersonListPlugin
extends HRDataBaseList
implements HRPIChargePersonConstants {
    private static final String NEW_REMOVE_CLOSE_CALL_BACK = "newOrRemoveCloseCallBack";
    private Map<Long, DynamicObject> perNonTsPropMap = Maps.newHashMapWithExpectedSize((int)16);

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void setFilter(SetFilterEvent event) {
        List<QFilter> effDtFilter = event.getQFilters().stream().filter(filter -> filter.getProperty().equals("leffdt") && ("is not null".equals(filter.getCP()) || filter.getValue() != null && "EMPTY".equals(filter.getValue().toString()))).collect(Collectors.toList());
        effDtFilter.forEach(filter -> {
            if ("is not null".equals(filter.getCP())) {
                filter.__setCP("!=");
            } else if ("is null".equals(filter.getCP())) {
                filter.__setCP("=");
            }
            filter.__setValue((Object)HRBaseUtils.getMaxEndDate());
        });
        event.getQFilters().add(new QFilter("datastatus", "in", (Object)new String[]{"1", "2"}));
        event.setOrderBy("datastatus asc,effdt desc,chargeperson.number asc,id desc");
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection pageData = event.getPageData();
        Date date2999 = HisEffDateCommonService.getInstance().getDate2999(null);
        HashSet personIds = Sets.newHashSetWithExpectedSize((int)16);
        for (DynamicObject pageDatum : pageData) {
            if (pageDatum.getDynamicObjectType().getProperty("leffdt") != null) {
                pageDatum.set("leffdt", date2999.equals(pageDatum.getDate("leffdt")) ? null : pageDatum.getDate("leffdt"));
            }
            if (pageDatum.getDynamicObjectType().getProperty("chargeperson") == null) continue;
            personIds.add(pageDatum.getLong("chargeperson.person.id"));
        }
        if (!CollectionUtils.isEmpty((Collection)personIds)) {
            DynamicObject[] perNonTsPropArr = HRPIPersonRepository.listPernontsprops(new ArrayList(personIds));
            this.perNonTsPropMap = Arrays.stream(perNonTsPropArr).collect(Collectors.toMap(nonTsPropInfo -> nonTsPropInfo.getLong("person.id"), nonTsPropInfo -> nonTsPropInfo, (o1, o2) -> o1));
        }
    }

    public void packageData(PackageDataEvent event) {
        super.packageData(event);
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        DynamicObject rowData = event.getRowData();
        if (!CollectionUtils.isEmpty(this.perNonTsPropMap)) {
            DynamicObject nonTsPropInfo = this.perNonTsPropMap.get(rowData.getLong("chargeperson.person.id"));
            if (nonTsPropInfo != null && "pernontsprop.gender.name".equals(columnDesc.getFieldKey())) {
                event.setFormatValue((Object)nonTsPropInfo.getString("gender.name"));
            } else if (nonTsPropInfo != null && "pernontsprop.headsculpture".equals(columnDesc.getFieldKey())) {
                event.setFormatValue((Object)nonTsPropInfo.getString("headsculpture"));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        List<Long> selectIds;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if ("donothing_new".equals(operateKey)) {
            this.showChargePersonPage(null, "0");
        } else if ("donothing_removecharge".equals(operateKey) && this.validSelectDataStatus(selectIds = this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).map(pkObj -> Long.valueOf(pkObj.toString())).collect(Collectors.toList()))) {
            this.showChargePersonPage(selectIds, "1");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey;
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && "viewchargepersonlog".equals(operateKey = afterDoOperationEventArgs.getOperateKey())) {
            this.showChargePersonLogPage();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        OperationResult operationResult = (OperationResult)closedCallBackEvent.getReturnData();
        if (operationResult != null && operationResult.isSuccess()) {
            BillList billList = (BillList)this.getView().getControl("billlistap");
            if (NEW_REMOVE_CLOSE_CALL_BACK.equals(actionId)) {
                this.getView().invokeOperation("refresh");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"ChargePersonListPlugin_2", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]));
            } else if ("modify".equals(actionId)) {
                billList.refreshData();
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        parentView.close();
        this.getView().sendFormAction(parentView);
    }

    private boolean validSelectDataStatus(List<Long> selectIds) {
        if (CollectionUtil.isEmpty(selectIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"ChargePersonListPlugin_0", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]));
            return false;
        }
        DynamicObject[] chargePersonDys = HRPIChargePersonRepository.getInstance().queryOriginalByIdList("id, chargeperson.person.name, datastatus", selectIds);
        List<DynamicObject> failList = Arrays.stream(chargePersonDys).filter(dy -> HRStringUtils.equals((String)dy.getString("datastatus"), (String)"2")).collect(Collectors.toList());
        if (failList.size() > 0) {
            failList.forEach(dy -> {
                String chargePersonListPlugin_1 = ResManager.loadKDString((String)"%s\u5df2\u53d6\u6d88\u90e8\u95e8\u8d1f\u8d23\u4eba\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ChargePersonListPlugin_1", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]);
                this.getView().showTipNotification(String.format(chargePersonListPlugin_1, dy.getString("chargeperson.person.name")));
            });
            return false;
        }
        return true;
    }

    private void showChargePersonPage(List<Long> selectIds, String operateType) {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("0".equals(operateType) ? "hrpi_chargeperson_add" : "hrpi_chargeperson");
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        baseShowParameter.setStatus("0".equals(operateType) ? OperationStatus.ADDNEW : OperationStatus.EDIT);
        if (!CollectionUtils.isEmpty(selectIds)) {
            baseShowParameter.getCustomParams().put("selectIds", JSON.toJSONString(selectIds));
        }
        baseShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NEW_REMOVE_CLOSE_CALL_BACK));
        baseShowParameter.getCustomParams().put("operatetype", operateType);
        Object adminOrg = this.getView().getFormShowParameter().getCustomParam("adminorg");
        Object org = this.getView().getFormShowParameter().getCustomParam("org");
        baseShowParameter.setCustomParam("adminorg", adminOrg);
        baseShowParameter.setCustomParam("org", org);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    private void showChargePersonLogPage() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("hrpi_chargepersonlog");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Object adminOrg = this.getView().getFormShowParameter().getCustomParam("adminorg");
        if (adminOrg != null) {
            listShowParameter.setCustomParam("adminOrgIds", (Object)JSON.toJSONString(Collections.singletonList(adminOrg)));
        }
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        String fieldName = args.getFieldName();
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        Long id = (Long)list.getFocusRowPkId();
        args.getHyperLinkClickEvent().getRowData();
        if (HRStringUtils.equals((String)fieldName, (String)"open_info")) {
            FormShowParameter showPersonInfoParameter = new FormShowParameter();
            showPersonInfoParameter.getOpenStyle().setShowType(ShowType.Modal);
            showPersonInfoParameter.setCustomParam("id", (Object)String.valueOf(id));
            showPersonInfoParameter.setCustomParam("number", (Object)String.valueOf(id));
            showPersonInfoParameter.setFormId("hrpi_chargepersoncard");
            this.getView().showForm(showPersonInfoParameter);
        } else {
            BaseShowParameter showParameter = new BaseShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setPkId((Object)id);
            showParameter.setBillStatus(BillOperationStatus.EDIT);
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.setFormId("hrpi_chargeperson_add");
            showParameter.setCustomParam("operatetype", (Object)"2");
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "modify"));
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }
}

