/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.formplugin.web.chargeperson;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.application.impl.charge.ChargeApplicationImpl;
import kd.hrmp.hrpi.common.HRPIChargePersonConstants;

public class ChargePersonLogListPlugin
extends AbstractListPlugin
implements HRPIChargePersonConstants {
    private static final String SECOND_INIT = "secondInit";
    private Map<Long, String> contentMap;

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        CommonBaseDataFilterColumn argsFilterColumn = (CommonBaseDataFilterColumn)args.getFilterColumn("creator.name");
        argsFilterColumn.setConstantDefaultValue((Object)"103");
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String adminOrgIdStr = (String)formShowParameter.getCustomParam("adminOrgIds");
        String first = this.getPageCache().get(SECOND_INIT);
        if (HRStringUtils.isNotEmpty((String)adminOrgIdStr) && HRStringUtils.isEmpty((String)first)) {
            List orgFilterColumn = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : orgFilterColumn) {
                if (!HRStringUtils.equals((String)filterColumn.getFieldName(), (String)"adminorg.name")) continue;
                List adminOrgIds = JSON.parseArray((String)adminOrgIdStr, String.class);
                filterColumn.setDefaultValues(adminOrgIds.toArray());
                this.getPageCache().put(SECOND_INIT, SECOND_INIT);
                break;
            }
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        super.beforePackageData(event);
        DynamicObjectCollection pageData = event.getPageData();
        if (CollectionUtils.isEmpty((Collection)pageData)) {
            return;
        }
        ChargeApplicationImpl chargePersonLogApplication = new ChargeApplicationImpl();
        this.contentMap = chargePersonLogApplication.getLogContent(pageData);
    }

    public void packageData(PackageDataEvent event) {
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        DynamicObject rowData = event.getRowData();
        Long rowId = rowData.getLong("id");
        String content = this.contentMap.get(rowId);
        if ("operatelog".equals(columnDesc.getFieldKey()) && HRStringUtils.isNotEmpty((String)content)) {
            event.setFormatValue((Object)content);
        }
    }

    public void setFilter(SetFilterEvent event) {
        List<String> selectOrgIds = this.getSelectOrgIds();
        String secondInit = this.getPageCache().get(SECOND_INIT);
        if (!CollectionUtils.isEmpty(selectOrgIds) && HRStringUtils.isEmpty((String)secondInit)) {
            Set adminOrgIds = selectOrgIds.stream().map(Long::parseLong).collect(Collectors.toSet());
            event.getCustomQFilters().add(new QFilter("adminorg.id", "in", adminOrgIds));
            this.getPageCache().put(SECOND_INIT, SECOND_INIT);
        }
    }

    public List<String> getSelectOrgIds() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String adminOrgIdStr = (String)formShowParameter.getCustomParam("adminOrgIds");
        if (HRStringUtils.isNotEmpty((String)adminOrgIdStr)) {
            return JSON.parseArray((String)adminOrgIdStr, String.class);
        }
        return null;
    }
}

