/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.formplugin.web.person;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.formplugin.web.query.QueryListPlugin;
import kd.hrmp.hrpi.business.domian.repository.HRPIChargePersonRepository;
import kd.hrmp.hrpi.business.infrastructure.utils.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class AdminOrgQueryListPlugin
extends QueryListPlugin {
    private static final Log logger = LogFactory.getLog(AdminOrgQueryListPlugin.class);
    private Map<Long, List<DynamicObject>> chargePersonInfoMap;
    private List<String> isMainChargeList = Lists.newArrayListWithExpectedSize((int)16);

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        QFilter filter = this.getCustomFilter();
        setFilterEvent.getQFilters().add(filter);
        setFilterEvent.setOrderBy("hrpi_personrolerel.mainpeoincharge desc,hrpi_person.number asc");
    }

    private QFilter getCustomFilter() {
        Object currentObject = this.getView().getFormShowParameter().getCustomParam("currentObjectPKId");
        Date date = this.getSearchDate();
        String formId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        logger.info("entityId is {},object is {}, querydate is {}", new Object[]{formId, currentObject, date});
        Long currentId = currentObject == null ? 0L : Long.parseLong((String)currentObject);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        currentFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"1", "2", "0"}));
        currentFilter.and(this.getEntityFilter(formId, currentId));
        if (date == null || DateUtil.dayEquals((Date)date, (Date)new Date())) {
            currentFilter.and(new QFilter("businessstatus", "=", (Object)"1"));
        } else {
            QFilter startQf = new QFilter("startdate", "<=", (Object)date);
            QFilter endDateQf = new QFilter("enddate", ">=", (Object)date);
            currentFilter.and(startQf).and(endDateQf);
        }
        return currentFilter;
    }

    private Date getSearchDate() {
        Object searchDate;
        Map custParamMap = (Map)this.getView().getFormShowParameter().getCustomParam("customvariables");
        Date date = HRDateTimeUtils.dateFormatDate((Date)new Date());
        if (custParamMap != null && !custParamMap.isEmpty() && (searchDate = custParamMap.get("searchdate")) != null) {
            try {
                date = HRDateTimeUtils.parseDate((String)((String)searchDate));
            }
            catch (ParseException e) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3002", (String)"AdminOrgQueryListPlugin_1", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]));
            }
        }
        return date;
    }

    private QFilter getEntityFilter(String entityId, Long id) {
        String field = "";
        if ("hrpi_empposorgrellist".equals(entityId)) {
            field = "adminorg.id";
        }
        if ("hrpi_positionlist".equals(entityId)) {
            field = "position.id";
        }
        if ("hrpi_joblist".equals(entityId)) {
            field = "job.id";
        }
        return new QFilter(field, "=", (Object)id);
    }

    public void afterExportFile(ExportFileEvent evt) {
        super.afterExportFile(evt);
        evt.setFileName(this.getView().getFormShowParameter().getCaption());
        BillList billList = (BillList)this.getControl("billlistap");
        List listFields = billList.getListFields();
        int mainChargeIndex = 0;
        for (int i = 0; i < listFields.size(); ++i) {
            ListField field = (ListField)listFields.get(i);
            if (!"ismaincharge".equals(field.getListFieldKey())) continue;
            mainChargeIndex = i;
        }
        File file = evt.getFile();
        try (FileInputStream in = new FileInputStream(file);
             XSSFWorkbook workbook = new XSSFWorkbook((InputStream)in);
             FileOutputStream out = new FileOutputStream(file);){
            Sheet sheet = workbook.getSheetAt(0);
            int index = 0;
            for (Row row : sheet) {
                if (row.getRowNum() == 0) continue;
                String isMainCharge = this.isMainChargeList.get(index);
                row.createCell(mainChargeIndex).setCellValue(isMainCharge);
                ++index;
            }
            workbook.write((OutputStream)out);
        }
        catch (IOException e) {
            logger.error("afterExportFile IOException:", (Throwable)e);
        }
    }

    public void beforePackageData(BeforePackageDataEvent event) {
        DynamicObjectCollection pageData = event.getPageData();
        Set depEmpIds = pageData.stream().filter(pageDatum -> pageDatum.getDynamicObjectType().getProperty("depemp") != null).map(data -> data.getLong("depemp.boid")).collect(Collectors.toSet());
        Date searchDate = this.getSearchDate();
        if (searchDate != null && !CollectionUtils.isEmpty(depEmpIds)) {
            long searchDateSecond = searchDate.getTime();
            DynamicObject[] chargePersonInfoArr = HRPIChargePersonRepository.getInstance().queryOriginalChargeByDepEmps("id, chargeperson, effdt, leffdt", depEmpIds);
            this.chargePersonInfoMap = Arrays.stream(chargePersonInfoArr).filter(chargePerson -> {
                long effDt = chargePerson.getDate("effdt").getTime();
                long lEffDt = chargePerson.getDate("leffdt").getTime();
                return effDt <= searchDateSecond && lEffDt > searchDateSecond;
            }).collect(Collectors.groupingBy(chargePerson -> chargePerson.getLong("chargeperson")));
        }
    }

    public void packageData(PackageDataEvent event) {
        DynamicObject rowData = event.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)event.getSource();
        if ("ismaincharge".equals(columnDesc.getFieldKey())) {
            long chargePersonId = rowData.getLong("depemp.boid");
            List<DynamicObject> chargePersonInfos = this.chargePersonInfoMap.get(chargePersonId);
            String message = !CollectionUtils.isEmpty(chargePersonInfos) ? ResManager.loadKDString((String)"\u662f", (String)"AdminOrgQueryListPlugin_2", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"AdminOrgQueryListPlugin_3", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]);
            this.isMainChargeList.add(message);
            event.setFormatValue((Object)message);
        }
    }
}

