/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.formplugin.web.person;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.BaseDataColumnDesc;
import kd.bos.form.events.SetFilterEvent;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmpposRepository;
import kd.hrmp.hrpi.formplugin.web.person.InitDataCheckCommonListPlugin;

public class EmpSupRelInitDataCheckCommonListPlugin
extends InitDataCheckCommonListPlugin {
    private Map<Long, String> idVsJobNameMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, String> idVsParentJobNameMap = Maps.newHashMapWithExpectedSize((int)16);

    @Override
    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        setFilterEvent.setOrderBy("person.number,startdate desc");
    }

    public void beforePackageData(BeforePackageDataEvent e) {
        super.beforePackageData(e);
        DynamicObjectCollection pageDataCol = e.getPageData();
        List depEmpIdList = pageDataCol.stream().map(dyn -> dyn.getLong("depemp.id")).collect(Collectors.toList());
        depEmpIdList.addAll(pageDataCol.stream().map(dyn -> dyn.getLong("superiordepemp.id")).collect(Collectors.toList()));
        DynamicObject[] empPosRelDynArr = HRPIEmpposRepository.batchQueryAllEmpPosByDepEmp(depEmpIdList, (String)"id, depemp, apositiontype, job");
        Map<Long, String> depEmpIdVsJobNameMap = Arrays.stream(empPosRelDynArr).filter(dyn -> HRStringUtils.equals((String)dyn.getString("apositiontype"), (String)"2")).collect(Collectors.toMap(dyn -> dyn.getLong("depemp.id"), dyn -> dyn.getString("job.name"), (o1, o2) -> o1));
        for (DynamicObject pageData : pageDataCol) {
            long id = pageData.getLong("id");
            Long depEmpId = pageData.getLong("depemp.id");
            Long parentDepEmpId = pageData.getLong("superiordepemp.id");
            String jobName = depEmpIdVsJobNameMap.get(depEmpId);
            String parentJobName = depEmpIdVsJobNameMap.get(parentDepEmpId);
            this.idVsJobNameMap.put(id, jobName);
            this.idVsParentJobNameMap.put(id, parentJobName);
        }
    }

    public void packageData(PackageDataEvent e) {
        super.packageData(e);
        Object source = e.getSource();
        if (source instanceof BaseDataColumnDesc) {
            String parentJobName;
            BaseDataColumnDesc colum = (BaseDataColumnDesc)e.getSource();
            Long id = e.getRowData().getLong("id");
            if ("job.name".equals(colum.getKey())) {
                String jobName = this.idVsJobNameMap.get(id);
                if (HRStringUtils.isNotEmpty((String)jobName)) {
                    e.setFormatValue((Object)jobName);
                }
            } else if ("parent_job.name".equals(colum.getKey()) && HRStringUtils.isNotEmpty((String)(parentJobName = this.idVsParentJobNameMap.get(id)))) {
                e.setFormatValue((Object)parentJobName);
            }
        }
    }
}

