/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.formplugin.web.person;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.service.query.HRQueryExactMatchListDataProvider;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hrmp.hrpi.business.domian.repository.HRPIEmployeeRepository;
import kd.hrmp.hrpi.common.HRPIValueConstants;

public class PersonF7DistinctListPlugin
extends AbstractListPlugin
implements ItemClickListener {
    private static final Log LOGGER = LogFactory.getLog(PersonF7DistinctListPlugin.class);
    private static final String HRPI_PERSONF7QUERYLIST = "hrpi_personf7querylist";
    private static final String HRPI_EMPLOYEEF7QUERYLIST = "hrpi_employeef7querylist";
    private static final String HRPI_DEPEMPF7QUERYLIST = "hrpi_depempf7querylist";
    private static final String HRPI_DEPPROMEMBERF7LIST = "hrpi_deppromemberf7list";
    private static final String HRPI_EMPLOYEEQUITF7LIST = "hrpi_employeequitf7list";
    private static final String HRPI_EMPLOYEELIST = "hrpi_employeelist";
    private static final String HRPI_LATESTEMPLOYEELIST = "hrpi_latestemployeelist";
    private static final Set<Long> LABORREL_STATUS = new HashSet<Long>();
    private static final Set<Long> LABORREL_STATUS_STP;
    private static final String SEARCH = "search";
    private static final String LIST_MODEL = "listmodel";
    private static final String QUERY_LAST_ONBRD = "querylastonbrd";

    public void preOpenForm(PreOpenFormEventArgs event) {
        ListShowParameter formShowParameter;
        String billFormId;
        super.preOpenForm(event);
        if (event.getFormShowParameter() instanceof ListShowParameter && (HRPI_EMPLOYEELIST.equals(billFormId = (formShowParameter = (ListShowParameter)event.getFormShowParameter()).getBillFormId()) || HRPI_LATESTEMPLOYEELIST.equals(billFormId))) {
            String tip = ResManager.loadKDString((String)"\u4eba\u5458", (String)"PersonF7DistinctListPlugin_0", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]);
            event.getFormShowParameter().setCaption(tip);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String listModel = (String)formShowParameter.getCustomParam(LIST_MODEL);
        IListView view = (IListView)this.getView();
        String billFormId = view.getBillFormId();
        String queryLastOnBrd = (String)formShowParameter.getCustomParam(QUERY_LAST_ONBRD);
        if (HRPI_EMPLOYEEQUITF7LIST.equals(billFormId) && SEARCH.equals(listModel) && QUERY_LAST_ONBRD.equals(queryLastOnBrd)) {
            args.setListDataProvider((IListDataProvider)new HRQueryExactMatchListTestDataProvider());
            return;
        }
        super.beforeCreateListDataProvider(args);
    }

    public void packageData(PackageDataEvent dataEvent) {
        Date endDate;
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)dataEvent.getSource();
        String fieldKey = columnDesc.getFieldKey();
        if (("lastworkdate".equals(fieldKey) || "hrpi_empposorgrel.sysenddate".equals(fieldKey) || "hrpi_empposorgrel.lastworkdate".equals(fieldKey) || "hrpi_empentrel.sysenddate".equals(fieldKey) || "hrpi_empentrel.enddate".equals(fieldKey) || "hrpi_empposorgrel.enddate".equals(fieldKey) || "hrpi_empentrel.lastworkdate".equals(fieldKey)) && (endDate = dataEvent.getRowData().getDate(fieldKey)) != null) {
            try {
                if (PersonF7DistinctListPlugin.getMaxDate(endDate)) {
                    dataEvent.setFormatValue((Object)" ");
                }
            }
            catch (Exception ec) {
                LOGGER.error("packageEndDataException", (Throwable)ec);
            }
        }
    }

    public void setFilter(SetFilterEvent setFilterEvent) {
        super.setFilter(setFilterEvent);
        QFilter filter = this.getCustomFilter();
        setFilterEvent.getQFilters().add(filter);
    }

    public static boolean getMaxDate(Date endDate) {
        if (endDate == null) {
            return false;
        }
        try {
            endDate = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.format((Date)endDate));
            return HRDateTimeUtils.dayAfter((Date)endDate, (Date)HRDateTimeUtils.getSysMaxDate()) || HRDateTimeUtils.dayAfter((Date)endDate, (Date)HRDateTimeUtils.addDay((Date)HRDateTimeUtils.getSysMaxDate(), (long)-1L)) || HRDateTimeUtils.dayEquals((Date)endDate, (Date)HRDateTimeUtils.getSysMaxDate()) || HRDateTimeUtils.dayEquals((Date)endDate, (Date)HRDateTimeUtils.addDay((Date)HRDateTimeUtils.getSysMaxDate(), (long)-1L));
        }
        catch (Exception esc) {
            LOGGER.error("listGetMaxDateError", (Throwable)esc);
            return false;
        }
    }

    private QFilter getCustomFilter() {
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter initFinishFilter = new QFilter("initstatus", "=", (Object)"2");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        currentFilter.and(initFinishFilter).and(dataStatusFilter);
        IListView view = (IListView)this.getView();
        String billFormId = view.getBillFormId();
        if (HRStringUtils.equals((String)HRPI_DEPEMPF7QUERYLIST, (String)billFormId)) {
            QFilter otclassifyFilter = new QFilter("otclassify", "=", (Object)HRPIValueConstants.OTCLASSIFY_1010);
            currentFilter.and(otclassifyFilter);
        } else if (HRStringUtils.equals((String)HRPI_EMPLOYEEF7QUERYLIST, (String)billFormId)) {
            QFilter businessStatusFilter = new QFilter("businessstatus", "=", (Object)"1");
            QFilter islatestrecordFilter = new QFilter("islatestrecord", "=", (Object)"1");
            QFilter lastFilter = new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"1");
            QFilter cFilter = new QFilter("hrpi_empposorgrel.iscurrentversion", "=", (Object)"1");
            currentFilter.and(businessStatusFilter).and(islatestrecordFilter).and(lastFilter).and(cFilter);
        } else if (HRStringUtils.equals((String)HRPI_PERSONF7QUERYLIST, (String)billFormId)) {
            QFilter islatestrecordFilter = new QFilter("hrpi_empentrel.islatestrecord", "=", (Object)"1");
            QFilter empposingFilter = new QFilter("hrpi_empposorgrel.empposing", "=", (Object)"1");
            QFilter bus = new QFilter("hrpi_empentrel.laborrelstatus", "in", LABORREL_STATUS);
            Object isAllowInfoClassifyEdit = this.getView().getFormShowParameter().getCustomParam("isAllowInfoClassifyEdit");
            if (isAllowInfoClassifyEdit != null && ((Boolean)isAllowInfoClassifyEdit).booleanValue()) {
                QFilter bus1 = new QFilter("hrpi_empentrel.laborrelstatus", "in", LABORREL_STATUS_STP);
                bus = bus.or(bus1);
                QFilter lastFilter = new QFilter("hrpi_empposorgrel.islatestrecord", "=", (Object)"1");
                QFilter busFilter = new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"2");
                lastFilter.and(busFilter).or(new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"1"));
                currentFilter.and(lastFilter);
            } else {
                QFilter lastFilter = new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"1");
                currentFilter.and(lastFilter);
            }
            currentFilter.and(islatestrecordFilter).and(empposingFilter).and(bus);
        } else if (HRStringUtils.equals((String)HRPI_DEPPROMEMBERF7LIST, (String)billFormId)) {
            QFilter otclassifyFilter = new QFilter("otclassify", "=", (Object)HRPIValueConstants.OTCLASSIFY_1020);
            currentFilter.and(otclassifyFilter);
        } else if (HRStringUtils.equals((String)HRPI_EMPLOYEEQUITF7LIST, (String)billFormId)) {
            QFilter bus = new QFilter("laborrelstatus", "in", LABORREL_STATUS_STP);
            QFilter lastFilter = new QFilter("hrpi_empposorgrel.islatestrecord", "=", (Object)"1");
            currentFilter.and(bus).and(lastFilter);
        } else if (HRStringUtils.equals((String)HRPI_EMPLOYEELIST, (String)billFormId)) {
            QFilter cFilter = new QFilter("hrpi_empposorgrel.iscurrentversion", "=", (Object)"1");
            currentFilter.and(cFilter);
        } else if (HRStringUtils.equals((String)HRPI_LATESTEMPLOYEELIST, (String)billFormId)) {
            QFilter islatestrecordFilter = new QFilter("islatestrecord", "=", (Object)"1");
            QFilter lastFilter = new QFilter("hrpi_empposorgrel.islatestrecord", "=", (Object)"1").or(new QFilter("hrpi_empposorgrel.businessstatus", "=", (Object)"1"));
            currentFilter.and(islatestrecordFilter).and(lastFilter);
        } else {
            QFilter bus = new QFilter("hrpi_empposorgrel.employee.laborrelstatus", "in", LABORREL_STATUS);
            currentFilter.and(bus);
        }
        return currentFilter;
    }

    static {
        QFilter qFilter = new QFilter("labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_ING);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        Map entityCfMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"id", (QFilter[])new QFilter[]{qFilter, enableFilter});
        if (!CollectionUtils.isEmpty((Map)entityCfMap)) {
            entityCfMap.values().forEach(labrel -> LABORREL_STATUS.add(labrel.getLong("id")));
        }
        LABORREL_STATUS_STP = new HashSet<Long>();
        QFilter sFilter = new QFilter("labrelstatusprd", "=", (Object)HRPIValueConstants.LABRELSTATUSPRD_END);
        Map stpMap = BusinessDataServiceHelper.loadFromCache((String)"hbss_laborrelstatus", (String)"id", (QFilter[])new QFilter[]{sFilter, enableFilter});
        if (!CollectionUtils.isEmpty((Map)stpMap)) {
            stpMap.values().forEach(labrel -> LABORREL_STATUS_STP.add(labrel.getLong("id")));
        }
    }

    static class HRQueryExactMatchListTestDataProvider
    extends HRQueryExactMatchListDataProvider {
        HRQueryExactMatchListTestDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection data = super.getData(start, limit);
            if (CollectionUtils.isEmpty((Collection)data)) {
                return data;
            }
            List employeeIdList = data.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            DynamicObjectCollection pidByEmployeeIds = HRPIEmployeeRepository.getPidByEmployeeIds(employeeIdList);
            Map<Object, Object> employeeAndPidMap = new HashMap(employeeIdList.size());
            Set<Object> onBoardPidSet = new HashSet(employeeIdList.size());
            if (!CollectionUtils.isEmpty((Collection)pidByEmployeeIds)) {
                employeeAndPidMap = pidByEmployeeIds.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getLong("person.personindexid"), (k1, k2) -> k1));
                DynamicObjectCollection onBoardEmployeeByPid = HRPIEmployeeRepository.getOnBoardEmployeeByPid(new ArrayList<Object>(employeeAndPidMap.values()));
                onBoardPidSet = onBoardEmployeeByPid.stream().map(dy -> dy.getLong("person.personindexid")).collect(Collectors.toSet());
            }
            DynamicObjectCollection tmpDys = new DynamicObjectCollection();
            tmpDys.addAll((Collection)data);
            tmpDys.sort(Comparator.comparingLong(dy1 -> dy1.getDate("startdate").getTime()).reversed());
            HashSet<Long> pidSet = new HashSet<Long>(tmpDys.size());
            HashSet<Long> employeeIdSet = new HashSet<Long>(tmpDys.size());
            HashSet<Long> onBoradEmployeeSet = new HashSet<Long>(tmpDys.size());
            for (DynamicObject filterData : tmpDys) {
                long employeeId = filterData.getLong("id");
                Long pid = (Long)employeeAndPidMap.get(employeeId);
                if (onBoardPidSet.contains(pid)) {
                    onBoradEmployeeSet.add(employeeId);
                    continue;
                }
                if (!pidSet.contains(pid)) {
                    employeeIdSet.add(employeeId);
                }
                if (pid == null || pid == 0L) continue;
                pidSet.add(pid);
            }
            LOGGER.info("getDataInfo--->{},->{},->{},->{},->{}", new Object[]{employeeAndPidMap, onBoardPidSet, employeeIdSet, onBoradEmployeeSet, pidSet});
            Iterator iterator = data.iterator();
            while (iterator.hasNext()) {
                DynamicObject next = (DynamicObject)iterator.next();
                long empId = next.getLong("id");
                if (!onBoradEmployeeSet.contains(empId) && employeeIdSet.contains(empId)) continue;
                iterator.remove();
            }
            return data;
        }
    }
}

