/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.formplugin.web.person;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.business.servicehelper.org.util.OrgTreeUtils;
import kd.hr.hbp.common.constants.org.OrgTreeDynEnum;
import kd.hr.hbp.common.constants.org.OrgTreeSearchParam;
import kd.hr.hbp.common.constants.org.TreeTemplateConstants;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.org.model.OrgTreeModel;
import kd.hr.hbp.formplugin.web.query.HRPersonF7AdminOrgTreeListNewPlugin;
import kd.hr.hbp.formplugin.web.template.IHRF7AdminOrgTreeListPlugin;
import kd.sdk.hr.hrmp.hrpi.extpoint.F7TreeExtParam;
import kd.sdk.hr.hrmp.hrpi.extpoint.IPersonF7TreeListExt;

public class PersonF7TreeListPlugin
extends HRPersonF7AdminOrgTreeListNewPlugin
implements IHRF7AdminOrgTreeListPlugin {
    private static final String FIELDORGID = "adminorg.id";

    public PersonF7TreeListPlugin() {
        super(new OrgTreeModel(OrgTreeDynEnum.ADMIN_STRUCT.getDynEntity(), OrgTreeDynEnum.ADMIN_MAIN_ENTITY.getDynEntity(), Boolean.FALSE, Boolean.TRUE, Boolean.FALSE.booleanValue()));
    }

    public ITreeModel getTreeModel() {
        return super.getTreeModel();
    }

    public IDataModel getModel() {
        return super.getModel();
    }

    public QFilter buildNodeClickFilter(BuildTreeListFilterEvent ent) {
        String focusNodeId = ent.getNodeId().toString();
        ArrayList allOrgBoIdList = null;
        QFilter nodeClicFilter = null;
        if (!this.getTreeModel().getRoot().getId().equals(focusNodeId)) {
            String entityId;
            QFilter cFilter = new QFilter("iscurrentversion", "=", (Object)"1");
            QFilter iFilter = new QFilter("initstatus", "=", (Object)"2");
            ArrayList<String> dataStatusList = new ArrayList<String>();
            dataStatusList.add("1");
            dataStatusList.add("2");
            QFilter dFilter = new QFilter("datastatus", "in", dataStatusList);
            QFilter focusNodeFilter = new QFilter(FIELDORGID, "=", (Object)Long.valueOf(focusNodeId));
            DynamicObject focusNodeDy = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryOne("structlongnumber", new QFilter[]{focusNodeFilter, cFilter, iFilter, dFilter});
            String focusNodeLongNumber = (String)focusNodeDy.get("structlongnumber");
            QFilter filter = new QFilter("structlongnumber", "like", (Object)(focusNodeLongNumber + "%"));
            DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)this.getEntityName()).queryColl("adminorg.id adminorg", new QFilter[]{filter, cFilter, iFilter, dFilter}, null);
            HashSet<Long> ids = new HashSet<Long>(dyColl.size());
            ids.add(Long.valueOf(focusNodeId));
            int size = dyColl.size();
            for (int idx = 0; idx < size; ++idx) {
                ids.add(((DynamicObject)dyColl.get(idx)).getLong("adminorg"));
            }
            switch (entityId = this.getView().getEntityId()) {
                case "hrpi_depemptreelistf7": 
                case "hrpi_deppromembertreef7": {
                    nodeClicFilter = new QFilter(FIELDORGID, "in", ids);
                    break;
                }
                case "hrpi_employeetreelistf7": 
                case "hrpi_persontreelistf7": 
                case "hrpi_employeelisttreef7": 
                case "hrpi_employeequittreef7": {
                    nodeClicFilter = new QFilter("hrpi_empposorgrel.adminorg.id", "in", ids);
                    break;
                }
            }
            if (!CollectionUtils.isEmpty((Collection)this.getPluginProxy().getPlugins())) {
                allOrgBoIdList = new ArrayList(ids);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)this.getPluginProxy().getPlugins())) {
            return this.getExtQFilter(allOrgBoIdList);
        }
        return nodeClicFilter;
    }

    private String getOrgProperty() {
        String entityId = this.getView().getEntityId();
        String orgProperty = null;
        switch (entityId) {
            case "hrpi_depemptreelistf7": 
            case "hrpi_deppromembertreef7": {
                orgProperty = FIELDORGID;
                break;
            }
            case "hrpi_employeetreelistf7": 
            case "hrpi_persontreelistf7": 
            case "hrpi_employeelisttreef7": 
            case "hrpi_employeequittreef7": {
                orgProperty = "hrpi_empposorgrel.adminorg.id";
                break;
            }
        }
        return orgProperty;
    }

    private HRPluginProxy<IPersonF7TreeListExt> getPluginProxy() {
        return new HRPluginProxy(null, IPersonF7TreeListExt.class, "kd.sdk.hr.hrmp.hrpi.extpoint.IPersonF7TreeListExt", null);
    }

    private QFilter getExtQFilter(List<Long> allOrgBoIdList) {
        String orgProperty;
        Object currentNodId = this.getTreeModel().getCurrentNodeId();
        QFilter qFilter = null;
        if (currentNodId == null) {
            return null;
        }
        Long nodeId = Long.valueOf(currentNodId.toString());
        Set[] orgSet = new Set[1];
        F7TreeExtParam param = new F7TreeExtParam(nodeId, allOrgBoIdList);
        this.getPluginProxy().callReplace(plugin -> {
            LOGGER.info(String.format("proxy plugin: %s", plugin.getClass()));
            orgSet[0] = plugin.getOrgSetByCurrentNode(param);
            return null;
        });
        if (!CollectionUtils.isEmpty((Collection)orgSet[0]) && (orgProperty = this.getOrgProperty()) != null) {
            qFilter = new QFilter(orgProperty, "in", (Object)orgSet[0]);
        }
        return qFilter;
    }

    public void expendTreeNode(TreeNodeEvent e) {
        String parentPageId = this.getView().getFormShowParameter().getParentPageId();
        IFormView parentview = this.getView().getViewNoPlugin(parentPageId);
        String openFlag = this.getPageCache().get("page_open_flag");
        if (!HRStringUtils.equals((String)"1", (String)openFlag) && parentview != null && parentview.getFormShowParameter().getCustomParam("adminorg") != null) {
            this.getView().getPageCache().put("page_open_flag", "1");
            Long curNodeId = Long.parseLong((String)parentview.getFormShowParameter().getCustomParam("adminorg"));
            TreeNode treeNode = (TreeNode)this.getSearchNodesBySearchId(curNodeId).get(0);
            OrgTreeSearchParam searchParam = new OrgTreeSearchParam(treeNode.getText(), (ListView)this.getView());
            ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
            treeNodes.add(treeNode);
            this.searchFromLazyOrgTree(searchParam, treeNodes);
            TreeView treeView = this.getTreeListView().getTreeView();
            treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            treeView.focusNode(treeNode);
        }
    }

    private void searchFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        this.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes, 0);
    }

    private TreeNode searchExistsNodeFromLazyOrgTree(OrgTreeSearchParam searchParam, List<TreeNode> treeNodes, int recursionCount) {
        if (CollectionUtils.isEmpty(treeNodes) || recursionCount > 20) {
            return null;
        }
        TreeNode node = treeNodes.get(0);
        if (node == null) {
            return null;
        }
        String parentId = node.getParentid();
        TreeNode parentNode = OrgTreeUtils.getNode((TreeNode)searchParam.getRootNode(), (Object)parentId);
        if (OrgTreeUtils.isChildNode((TreeNode)parentNode, (TreeNode)node)) {
            HashSet loopController = Sets.newHashSetWithExpectedSize((int)16);
            ArrayList expendIds = Lists.newArrayListWithCapacity((int)16);
            OrgTreeUtils.expandParentNode((OrgTreeSearchParam)searchParam, (String)parentId, (Set)loopController, (List)expendIds, (int)0);
            for (int i = expendIds.size() - 1; i >= 0; --i) {
                searchParam.getTreeView().expand((String)expendIds.get(i));
            }
        } else {
            this.queryTreeNodeWithParent(searchParam, node);
        }
        node = OrgTreeUtils.getNode((TreeNode)searchParam.getRootNode(), (Object)node.getId());
        if (node == null) {
            TreeNode removeNode = treeNodes.remove(0);
            String subNodeLongNumber = removeNode.getLongNumber() + "!";
            ArrayList removeSubNodes = Lists.newArrayList();
            for (TreeNode subNode : treeNodes) {
                if (subNode.getLongNumber() == null || !subNode.getLongNumber().startsWith(subNodeLongNumber)) continue;
                removeSubNodes.add(subNode);
            }
            treeNodes.removeAll(removeSubNodes);
            return this.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes, recursionCount);
        }
        return node;
    }

    private void queryTreeNodeWithParent(OrgTreeSearchParam searchParam, TreeNode node) {
        Object currentNodeId = this.getTreeModel().getCurrentNodeId();
        TreeNode curTreeNode = OrgTreeUtils.getNode((TreeNode)this.getTreeModel().getRoot(), (Object)currentNodeId.toString());
        String structLongNumber = node.getLongNumber();
        int nextLongNumberLength = curTreeNode.getLongNumber().length() + TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH;
        if (structLongNumber.length() < nextLongNumberLength) {
            return;
        }
        String newParentStructLongNumber = structLongNumber.substring(0, nextLongNumberLength);
        String notLoadParentLongNumber = newParentStructLongNumber.substring(newParentStructLongNumber.lastIndexOf(33) + 1);
        int layerCount = (structLongNumber.length() - newParentStructLongNumber.length()) / TreeTemplateConstants.LONG_NUMBER_AND_SPLIT_LENGTH;
        ArrayList<String> structNumbers = new ArrayList<String>();
        structNumbers.add(notLoadParentLongNumber);
        this.getView().getFormShowParameter().setCustomParam("layerCount", (Object)layerCount);
        this.queryTreeNodeChildrenByStructNumbers(searchParam, structNumbers, node);
    }
}

