/*
 * Decompiled with CFR 0.152.
 */
package kd.hrmp.hrpi.formplugin.web.task;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.BeforePackageDataEvent;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.column.ListOperationColumnDesc;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.formplugin.web.HRDataBaseList;
import kd.hrmp.hrpi.business.domian.repository.HRPICallInfResultRepository;
import kd.hrmp.hrpi.business.domian.repository.HRPINumberReuseInfRepository;

public class CallInfResultList
extends HRDataBaseList {
    private static final Log LOG = LogFactory.getLog(CallInfResultList.class);
    private HRBaseServiceHelper callInfResultServiceHelper = new HRBaseServiceHelper("hrpi_callinfresult");
    Map<Long, Boolean> idVsRetryVisibleMap = Maps.newHashMapWithExpectedSize((int)16);
    String OPERATIONRESULT_FAIL = "0";
    String OPERATIONRESULT_SUCCESS = "1";
    String OPERATIONRESULT_IN_PROGRESS = "2";

    public void beforePackageData(BeforePackageDataEvent e) {
        DynamicObjectCollection pageDataCol = e.getPageData();
        for (DynamicObject pageData : pageDataCol) {
            long id = pageData.getLong("id");
            String operationResult = pageData.getString("operationresult");
            if (HRStringUtils.equals((String)operationResult, (String)this.OPERATIONRESULT_FAIL)) {
                this.idVsRetryVisibleMap.put(id, Boolean.TRUE);
                continue;
            }
            this.idVsRetryVisibleMap.put(id, Boolean.FALSE);
        }
    }

    public void packageData(PackageDataEvent e) {
        Long id;
        Boolean retryVisibleFlag;
        Object source = e.getSource();
        if (!(source instanceof ListOperationColumnDesc) || !(retryVisibleFlag = this.idVsRetryVisibleMap.get(id = Long.valueOf(e.getRowData().getLong("id")))).booleanValue()) {
            // empty if block
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"donothing_retry")) {
            Long id = (Long)((Donothing)afterDoOperationEventArgs.getSource()).getListFocusRow().getPrimaryKeyValue();
            DynamicObject curResultDyn = HRPICallInfResultRepository.getInstance().loadById(id);
            String infParamStr = curResultDyn.getString("infparam");
            Map infParam = (Map)SerializationUtils.fromJsonString((String)infParamStr, Map.class);
            int retryCount = curResultDyn.getInt("retrycount");
            Date curDate = new Date();
            String operationResult = curResultDyn.getString("operationresult");
            if (HRStringUtils.equals((String)this.OPERATIONRESULT_FAIL, (String)operationResult)) {
                DynamicObjectCollection infListCol = curResultDyn.getDynamicObjectCollection("inflist");
                List infIdList = infListCol.stream().map(inf -> inf.getLong("fbasedataid.id")).collect(Collectors.toList());
                DynamicObject[] infDynArr = HRPINumberReuseInfRepository.getInstance().listInfInfoById(infIdList);
                HashMap idVsFlagMap = Maps.newHashMapWithExpectedSize((int)infDynArr.length);
                Boolean successFlag = Boolean.TRUE;
                for (DynamicObject interfaceDyn : infDynArr) {
                    long infId = interfaceDyn.getLong("id");
                    String cloudId = interfaceDyn.getString("cloudid");
                    String appId = interfaceDyn.getString("appid");
                    String serviceName = interfaceDyn.getString("servicename");
                    String methodName = interfaceDyn.getString("methodname");
                    Boolean curFlag = Boolean.FALSE;
                    try {
                        Map<String, Object> resultList = this.invokeService(infParam, cloudId, appId, serviceName, methodName);
                        curFlag = (Boolean)resultList.get("success");
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                        LOG.error("EmpNumberReUseUpgradeTask.callinf.error.cloudId:{}, appId:{}, serviceName:{}", new Object[]{cloudId, appId, serviceName});
                        successFlag = successFlag & curFlag;
                    }
                    idVsFlagMap.put(infId, curFlag);
                }
                curResultDyn.set("operationresult", (Object)(successFlag != false ? this.OPERATIONRESULT_SUCCESS : this.OPERATIONRESULT_FAIL));
                curResultDyn.set("retrycount", (Object)(++retryCount));
                curResultDyn.set("latestoperatetime", (Object)curDate);
                this.callInfResultServiceHelper.save(new DynamicObject[]{curResultDyn});
                this.getView().updateView();
                LOG.error("EmpNumberReUseUpgradeTask.callinf.finally:{}", (Object)idVsFlagMap);
            } else if (HRStringUtils.equals((String)this.OPERATIONRESULT_SUCCESS, (String)operationResult)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u5747\u6210\u529f\uff0c\u4e0d\u80fd\u91cd\u8bd5\u3002", (String)"CallInfResultList_0", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]));
            } else if (HRStringUtils.equals((String)this.OPERATIONRESULT_IN_PROGRESS, (String)operationResult)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u4e2d\uff0c\u8bf7\u4e0d\u8981\u91cd\u8bd5\u3002", (String)"CallInfResultList_1", (String)"hrmp-hrpi-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Map<String, Object> invokeService(Map<String, Object> infParamMap, String cloudId, String appId, String serviceName, String methodName) {
        return (Map)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{infParamMap});
    }
}

