/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrptc.business.datamerge.DataCompareAbstract;
import kd.hr.hrptc.business.datamerge.DataCompareFactory;
import kd.hr.hrptc.business.datamerge.DataMergeFactory;
import kd.hr.hrptc.business.subscribe.SubscribeService;
import kd.hr.hrptc.common.model.datamerge.CompDataGroupBo;

public class DataCompMergeService {
    private static final Log LOGGER = LogFactory.getLog(DataCompMergeService.class);

    public static void doCompMerge() {
        SubscribeService subscribeService = SubscribeService.getInstance();
        Map<Long, List<String>> reportStoresMap = subscribeService.queryEffEsIdxGrpByRpt();
        DataCompMergeService.compareData(reportStoresMap, "detail");
        LOGGER.info("compare_detail_data_end size:{}", (Object)reportStoresMap.size());
        Map<Long, List<String>> reportBdStoresMap = subscribeService.queryEffBdEsIdxGrpByRpt();
        DataCompMergeService.compareData(reportBdStoresMap, "basedata");
        LOGGER.info("compare_basedata_data_end size:{}", (Object)reportBdStoresMap.size());
        long time1 = System.currentTimeMillis();
        DataMergeFactory.getDataCompareService("es_basedata").doMerge();
        long time2 = System.currentTimeMillis();
        LOGGER.info("merge_basedata_data_end time:{}ms", (Object)(time2 - time1));
        DataMergeFactory.getDataCompareService("es_detail").doMerge();
        long time3 = System.currentTimeMillis();
        LOGGER.info("merge_detail_data_end time:{}ms", (Object)(time3 - time2));
    }

    private static void compareData(Map<Long, List<String>> reportStoresMap, String dataType) {
        List<CompDataGroupBo> compDataGroupBos = DataCompMergeService.compDataGroup(reportStoresMap);
        long startTime = System.currentTimeMillis();
        DataCompareAbstract dataCompare = DataCompareFactory.getDataCompareService("ES");
        for (CompDataGroupBo compDataGroupBo : compDataGroupBos) {
            dataCompare.doCompare(compDataGroupBo.getDataAStore(), compDataGroupBo.getDataBStore(), compDataGroupBo.getReportId(), dataType);
        }
        long endTime = System.currentTimeMillis();
        LOGGER.info("all_data_comp end dataType:{}, row\uff1a{} cost:{} ms.", new Object[]{dataType, compDataGroupBos.size(), endTime - startTime});
    }

    private static List<CompDataGroupBo> compDataGroup(Map<Long, List<String>> reportStoresMap) {
        ArrayList<CompDataGroupBo> pairs = new ArrayList<CompDataGroupBo>(10);
        reportStoresMap.forEach((key, value) -> {
            List distinctList = value.stream().distinct().collect(Collectors.toList());
            for (int i = 0; i < distinctList.size(); ++i) {
                for (int j = i + 1; j < distinctList.size(); ++j) {
                    CompDataGroupBo compDataGroup = new CompDataGroupBo();
                    compDataGroup.setReportId(key);
                    compDataGroup.setDataAStore((String)distinctList.get(i));
                    compDataGroup.setDataBStore((String)distinctList.get(j));
                    pairs.add(compDataGroup);
                }
            }
        });
        return pairs;
    }
}

