/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.datamerge.EsIdxRefConfigEnum;
import kd.hr.hrptc.business.datamerge.EsIdxRefEntityOpService;
import org.apache.commons.collections.CollectionUtils;

public class EsIdxRefEntityHolder {
    private static final Log LOGGER = LogFactory.getLog(EsIdxRefEntityHolder.class);

    public static void batchModifyRef(List<String> oldEsPkList, String nowEsPk) {
        EsIdxRefEntityOpService instance = EsIdxRefEntityOpService.getInstance();
        for (EsIdxRefConfigEnum esIdxRefConfig : EsIdxRefConfigEnum.values()) {
            String entityNumber = esIdxRefConfig.getEntityNumber();
            String refField = esIdxRefConfig.getRefField();
            instance.batchModifyRef(entityNumber, refField, oldEsPkList, nowEsPk);
        }
    }

    public static void recordEsIdxClearLog(EsIdxRefConfigEnum esIdxRefConfig, Map<Long, String> entityIdIdxMap) {
        EsIdxRefEntityOpService instance = EsIdxRefEntityOpService.getInstance();
        if (esIdxRefConfig == null) {
            throw new KDBizException("EsIdxRefConfigEnum is null");
        }
        instance.recordEsIdxClearLog(esIdxRefConfig, entityIdIdxMap);
    }

    public static Set<String> findNotExistsRefIdx(Set<String> refEsIdx) {
        HashSet<String> notExistsIdx = new HashSet<String>(refEsIdx);
        for (EsIdxRefConfigEnum esIdxRefConfig : EsIdxRefConfigEnum.values()) {
            String entityNumber = esIdxRefConfig.getEntityNumber();
            String refField = esIdxRefConfig.getRefField();
            Set<String> existsIdx = EsIdxRefEntityHolder.findExistsIdx(entityNumber, refField, refEsIdx);
            notExistsIdx.removeAll(existsIdx);
        }
        return notExistsIdx;
    }

    private static Set<String> findExistsIdx(String entityNumber, String refField, Set<String> refEsIdx) {
        LOGGER.info("findNotExistsRefIdx param:[entityNumber:{}, refField:{}, refEsIdx:{}]", new Object[]{entityNumber, refField, refEsIdx});
        if (CollectionUtils.isEmpty(refEsIdx) || HRStringUtils.isEmpty((String)entityNumber) || HRStringUtils.isEmpty((String)refField)) {
            throw new KDBizException("findNotExistsRefIdx param error");
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(refField, "in", refEsIdx)};
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObject[] dynamicObjects = serviceHelper.queryOriginalArray(refField, qFilters);
        return Arrays.stream(dynamicObjects).map(dyo -> dyo.getString(refField)).collect(Collectors.toSet());
    }

    public static boolean existsRef(Set<String> refEsIdx) {
        for (EsIdxRefConfigEnum esIdxRefConfig : EsIdxRefConfigEnum.values()) {
            String refField;
            String entityNumber = esIdxRefConfig.getEntityNumber();
            if (!EsIdxRefEntityHolder.existsRef(entityNumber, refField = esIdxRefConfig.getRefField(), refEsIdx)) continue;
            return true;
        }
        return false;
    }

    private static boolean existsRef(String entityNumber, String refField, Set<String> refEsIdx) {
        LOGGER.info("existsRef param:[entityNumber:{}, refField:{}, refEsIdx:{}]", new Object[]{entityNumber, refField, refEsIdx});
        if (CollectionUtils.isEmpty(refEsIdx) || HRStringUtils.isEmpty((String)entityNumber) || HRStringUtils.isEmpty((String)refField)) {
            throw new KDBizException("existsRef param error");
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(refField, "in", refEsIdx)};
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        return serviceHelper.isExists(qFilters);
    }
}

