/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.datamerge.EsIdxRefConfigEnum;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class EsIdxRefEntityOpService {
    private static final Log LOGGER = LogFactory.getLog(EsIdxRefEntityOpService.class);
    private final String esRefModLogEntityNumber = "hrptmc_esrefmodlog";
    private final HRBaseServiceHelper esRefModLogService = new HRBaseServiceHelper("hrptmc_esrefmodlog");

    private EsIdxRefEntityOpService() {
    }

    public static EsIdxRefEntityOpService getInstance() {
        return new EsIdxRefEntityOpService();
    }

    public void batchModifyRef(String entityNumber, String refField, List<String> oldEsPkList, String nowEsPk) {
        LOGGER.info("batchModifyRef param:[entityNumber:{}, refField:{}, nowEsPk:{}, oldEsPkList:{}]", new Object[]{entityNumber, refField, nowEsPk, oldEsPkList});
        if (CollectionUtils.isEmpty(oldEsPkList) || HRStringUtils.isEmpty((String)nowEsPk) || HRStringUtils.isEmpty((String)entityNumber) || HRStringUtils.isEmpty((String)refField)) {
            LOGGER.warn("batchModifyRef param error");
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter(refField, "in", oldEsPkList)};
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(entityNumber);
        DynamicObject[] dynamicObjects = serviceHelper.query("id," + refField, qFilters);
        if (dynamicObjects.length == 0) {
            return;
        }
        DynamicObjectCollection modLogDyoColl = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObject modLogDyo = this.esRefModLogService.generateEmptyDynamicObject();
            modLogDyo.set("entitynumber", (Object)entityNumber);
            modLogDyo.set("reffield", (Object)refField);
            modLogDyo.set("oldesidx", dynamicObject.getDynamicObject(refField).getPkValue());
            modLogDyo.set("nowesidx", (Object)nowEsPk);
            modLogDyo.set("entitypk", (Object)dynamicObject.getLong("id"));
            HRBaseUtils.setSysField((DynamicObject)modLogDyo);
            modLogDyoColl.add((Object)modLogDyo);
            dynamicObject.set(refField, (Object)nowEsPk);
        }
        this.esRefModLogService.save(modLogDyoColl);
        serviceHelper.save(dynamicObjects);
    }

    public void recordEsIdxClearLog(EsIdxRefConfigEnum esIdxRefConfig, Map<Long, String> entityIdIdxMap) {
        LOGGER.info("recordEsIdxClearLog param:[esIdxRefConfig:{}, entityIdIdxMap:{}]", (Object)esIdxRefConfig, entityIdIdxMap);
        if (MapUtils.isEmpty(entityIdIdxMap) || esIdxRefConfig == null) {
            LOGGER.warn("recordEsIdxClearLog param error");
            return;
        }
        DynamicObjectCollection modLogDyoColl = new DynamicObjectCollection();
        entityIdIdxMap.forEach((pk, index) -> {
            DynamicObject modLogDyo = this.esRefModLogService.generateEmptyDynamicObject();
            modLogDyo.set("entitynumber", (Object)esIdxRefConfig.getEntityNumber());
            modLogDyo.set("reffield", (Object)esIdxRefConfig.getRefField());
            modLogDyo.set("oldesidx", index);
            modLogDyo.set("nowesidx", (Object)Character.valueOf(' '));
            modLogDyo.set("entitypk", pk);
            HRBaseUtils.setSysField((DynamicObject)modLogDyo);
            modLogDyoColl.add((Object)modLogDyo);
        });
        this.esRefModLogService.save(modLogDyoColl);
    }
}

