/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datamerge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrptc.business.datamerge.EsDataClearService;
import kd.hr.hrptc.business.datamerge.EsIIndexService;
import kd.hr.hrptc.business.datamerge.EsIdxModLogService;
import kd.hr.hrptc.business.datamerge.EsIdxRefConfigEnum;
import kd.hr.hrptc.business.datamerge.EsIdxRefEntityHolder;
import kd.hr.hrptc.business.share.ReportShareService;
import kd.hr.hrptc.business.subscribe.SubscribeService;
import kd.hr.hrptc.common.model.datamerge.EsIdxModifyBo;
import org.apache.commons.collections.CollectionUtils;

public class SubscribeDataClearService {
    private static final Log LOGGER = LogFactory.getLog(SubscribeDataClearService.class);

    public static void doClear(EsIdxRefConfigEnum esIdxRefConfigEnum, Map<Long, String> subIdIdxMap) {
        LOGGER.info("start doClear SubscribeData subIdIdxMap:{}", subIdIdxMap);
        SubscribeService subscribeService = new SubscribeService();
        EsIIndexService esIIndexService = new EsIIndexService();
        EsIdxModLogService esIdxModLogService = new EsIdxModLogService();
        ReportShareService reportShareService = ReportShareService.getInstance();
        try (TXHandle txHandle = TX.requiresNew();){
            if (EsIdxRefConfigEnum.SUBSCRIBE == esIdxRefConfigEnum) {
                subscribeService.clearEsIdx(subIdIdxMap.keySet());
            } else if (EsIdxRefConfigEnum.SHARERE == esIdxRefConfigEnum) {
                reportShareService.clearEsIdx(subIdIdxMap.keySet());
            }
            EsIdxRefEntityHolder.recordEsIdxClearLog(esIdxRefConfigEnum, subIdIdxMap);
            SubscribeDataClearService.deleteIdxData(subIdIdxMap, esIIndexService, esIdxModLogService);
        }
    }

    private static void deleteIdxData(Map<Long, String> subIdIdxMap, EsIIndexService esIIndexService, EsIdxModLogService esIdxModLogService) {
        ArrayList<String> esIdxList = new ArrayList<String>(subIdIdxMap.values());
        DynamicObject[] esIdxDyoArr = esIIndexService.queryByPks(esIdxList);
        Set<String> deleteIdxList = Arrays.stream(esIdxDyoArr).map(dyo -> dyo.getString("id")).collect(Collectors.toSet());
        Set<String> notExistsRefIdx = EsIdxRefEntityHolder.findNotExistsRefIdx(deleteIdxList);
        LOGGER.info("check can delIdx total:{},candel:{} detail[all:{},del:{}]", new Object[]{deleteIdxList.size(), notExistsRefIdx.size(), deleteIdxList, notExistsRefIdx});
        if (CollectionUtils.isEmpty(notExistsRefIdx)) {
            return;
        }
        Map esIdxDyoMap = Arrays.stream(esIdxDyoArr).collect(Collectors.toMap(dyo -> dyo.getString("id"), Function.identity()));
        esIIndexService.deleteEsIdx(notExistsRefIdx);
        ArrayList<EsIdxModifyBo> idxModifyBoList = new ArrayList<EsIdxModifyBo>(esIdxDyoArr.length);
        for (String existsRefIdx : notExistsRefIdx) {
            DynamicObject esIdxDyo = (DynamicObject)esIdxDyoMap.get(existsRefIdx);
            String mainDataIdx = esIdxDyo.getString("id");
            String bdIdx = esIdxDyo.getString("basedataesindex");
            EsIdxModifyBo esIdxModifyBo = new EsIdxModifyBo(mainDataIdx, bdIdx, " ", "delete");
            idxModifyBoList.add(esIdxModifyBo);
        }
        esIdxModLogService.writeModLogBatch(idxModifyBoList);
        EsDataClearService.deleteUserDelData();
    }
}

