/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.datastore;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.org.OrgViewSchemeProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.query.es.EsBatchValue;
import kd.hr.hbp.business.service.query.es.EsDataType;
import kd.hr.hbp.business.service.query.es.EsMappingProperty;
import kd.hr.hbp.business.service.query.es.EsPropertyValue;
import kd.hr.hbp.business.service.query.es.storage.EsStorage;
import kd.hr.hbp.business.service.query.es.storage.EsStorageFactory;
import kd.hr.hbp.business.service.query.es.storage.highlevel.EsStorageImpl;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.model.complexobj.FieldControlType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.datastore.model.CenterEsSaveDataBo;
import kd.hr.hrptc.business.datastore.model.EsMappingBo;
import kd.hr.hrptc.business.servicehelper.ReportCenterServiceHelper;
import kd.hr.hrptc.business.servicehelper.ScheduleTaskServiceHelper;
import kd.hr.hrptmc.business.anobj.AnObjEnumFieldHandler;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.center.servicehelper.ReportEsServiceHelper;
import kd.hr.hrptmc.business.datastore.metadata.util.RptMetaFieldTransferUtil;
import kd.hr.hrptmc.business.datastore.queryservice.ReportDataExtractQueryService;
import kd.hr.hrptmc.business.repcalculate.model.CalResult;
import kd.hr.hrptmc.business.repcalculate.model.ReportResult;
import kd.hr.hrptmc.business.repdesign.ReportManageService;
import kd.hr.hrptmc.business.repdesign.datastore.FieldDataStoreBO;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreFieldService;
import kd.hr.hrptmc.business.repdesign.datastore.ReportDataStoreServiceHelper;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.common.constant.center.ReportCenterConstants;

public abstract class AbstractCenterDataStoreService
implements ReportCenterConstants {
    private static final Log LOGGER = LogFactory.getLog(AbstractCenterDataStoreService.class);
    private static EsStorage ES_STORAGE = EsStorageFactory.getStorage((String)"hr");
    private static final Integer MAX_SIZE = 100000;
    protected String esIndex;
    protected String baseDataEsIndex;
    protected final DynamicObject report;
    private final QFilter permissionQFilter;
    private final Map<String, QFilter> f7PermissionQFilter;
    private FieldDataStoreBO dataStoreBO;
    private static final Integer MAX_SIZE_BASE_DATA = 10000;

    protected AbstractCenterDataStoreService(Long reportId, QFilter permissionQFilter, Map<String, QFilter> f7PermissionQFilter) {
        this.permissionQFilter = permissionQFilter;
        this.f7PermissionQFilter = f7PermissionQFilter;
        this.report = ReportManageService.getRptManage((Long)reportId);
        if (ES_STORAGE == null) {
            ES_STORAGE = new EsStorageImpl("hr");
        }
    }

    protected boolean beforeExecute() {
        this.esIndex = this.generateEsIndex();
        long anObjId = this.report.getLong("anobjid.id");
        AnalyseObjectService instance = AnalyseObjectService.getInstance();
        List joinEntityBos = instance.queryAndAssembleJoinEntities(Long.valueOf(anObjId));
        ReportDataStoreFieldService reportDataStoreFieldService = new ReportDataStoreFieldService(this.report, joinEntityBos, true);
        this.dataStoreBO = reportDataStoreFieldService.getField();
        RptMetaFieldTransferUtil.addBaseDataIdFieldForReport((List)this.dataStoreBO.getStoreFieldInfoList(), (MainEntityTypeUtil)new MainEntityTypeUtil());
        RptMetaFieldTransferUtil.addJoinEntityIdFieldForReport((long)anObjId, (List)this.dataStoreBO.getStoreFieldInfoList());
        this.addBaseDataOtherField(this.dataStoreBO.getStoreFieldInfoList());
        this.handleBaseDataAndEnum(this.esIndex, this.dataStoreBO);
        this.createIndex(this.esIndex, this.baseDataEsIndex);
        ES_STORAGE.createIndex("hr", this.esIndex, null);
        this.saveEsMapping(this.esIndex, this.dataStoreBO);
        return true;
    }

    public void execute() {
        try {
            if (this.beforeExecute()) {
                this.saveData(this.esIndex, this.report, this.dataStoreBO, this.permissionQFilter);
            }
            this.endExecute();
        }
        catch (Exception ex) {
            LOGGER.error("AbstractCenterDataStoreService_execute_error:", (Throwable)ex);
            this.writeErrorEsIndex();
            throw ex;
        }
    }

    protected void endExecute() {
    }

    protected abstract String generateEsIndex();

    protected abstract String generateBaseDataEsIndex(String var1);

    protected abstract List<String> getStopKeyList();

    protected void writeCount(int count) {
    }

    public void writeErrorEsIndex() {
        DynamicObject dynamicObject;
        if (HRStringUtils.isNotEmpty((String)this.esIndex) && (dynamicObject = ReportCenterServiceHelper.queryEsIndex(this.esIndex)) != null) {
            dynamicObject.set("status", (Object)"2");
            ReportCenterServiceHelper.saveEsIndex(dynamicObject);
        }
    }

    private void saveData(String esIndex, DynamicObject reportDyn, FieldDataStoreBO dataStoreBO, QFilter permissionQFilter) {
        int querySize;
        long time0 = System.currentTimeMillis();
        long anObjId = reportDyn.getLong("anobjid.id");
        long reportId = reportDyn.getLong("id");
        List<EsMappingBo> fieldMapList = this.queryFieldMapList(esIndex);
        HashSet addNumberSet = Sets.newHashSetWithExpectedSize((int)fieldMapList.size());
        Map<String, EsMappingBo> mappingFieldMap = fieldMapList.stream().filter(fm -> addNumberSet.add(fm.getFieldAlias())).collect(Collectors.toMap(EsMappingBo::getFieldNumberAlias, mi -> mi));
        Map customSortMap = ReportDataStoreServiceHelper.getCustomSortMap((long)reportId);
        AnalyseObjectService instance = AnalyseObjectService.getInstance();
        List allQueryFieldBoList = instance.queryAndAssembleQueryFields(Long.valueOf(anObjId));
        List qFilters = instance.getQueryQFilter(Long.valueOf(anObjId), allQueryFieldBoList);
        List dataFilters = ReportDataStoreServiceHelper.getDataFilter((String)reportDyn.getString("datafilter"), (List)allQueryFieldBoList);
        qFilters.addAll(dataFilters);
        if (permissionQFilter != null) {
            qFilters.add(permissionQFilter);
        }
        long time1 = System.currentTimeMillis();
        LOGGER.info("ICenterDataStoreService_saveData_prepare_time:{}", (Object)(time1 - time0));
        ReportDataExtractQueryService queryService = new ReportDataExtractQueryService();
        int fieldSize = dataStoreBO.getStoreFieldInfoList().size();
        int queryCount = MAX_SIZE / fieldSize;
        int start = 0;
        while (true) {
            List<String> stopKeyList;
            if (ScheduleTaskServiceHelper.isStop(stopKeyList = this.getStopKeyList())) {
                return;
            }
            CenterEsSaveDataBo bo = new CenterEsSaveDataBo(anObjId, reportId, dataStoreBO, customSortMap, qFilters, queryService, start, queryCount, esIndex, mappingFieldMap);
            querySize = this.saveData(bo);
            if (querySize < queryCount) break;
            start += queryCount;
        }
        this.writeCount(start += querySize);
        long time2 = System.currentTimeMillis();
        LOGGER.info("ICenterDataStoreService_saveData_queryAndSave_time:{}", (Object)(time2 - time1));
        this.saveDataWithBaseData(this.baseDataEsIndex, dataStoreBO, anObjId);
        long time3 = System.currentTimeMillis();
        LOGGER.info("ICenterDataStoreService_saveData_saveDataWithBaseData_time:{}", (Object)(time3 - time2));
        LOGGER.info("ICenterDataStoreService_saveData_time:{}", (Object)(time3 - time0));
    }

    private int saveData(CenterEsSaveDataBo bo) {
        long anObjId = bo.getAnObjId();
        long reportId = bo.getReportId();
        FieldDataStoreBO dataStoreBO = bo.getDataStoreBO();
        ReportDataExtractQueryService queryService = bo.getQueryService();
        int start = bo.getStart();
        int limit = bo.getLimit();
        List<QFilter> newQFilterList = bo.getNewQFilterList();
        LOGGER.info("ICenterDataStoreService_saveData_qfilters: {}", newQFilterList);
        long time0 = System.currentTimeMillis();
        ReportResult reportResult = queryService.queryDetailData(anObjId, reportId, dataStoreBO.getStoreFieldInfoList(), start, limit, newQFilterList);
        long time1 = System.currentTimeMillis();
        LOGGER.info("ICenterDataStoreService_saveData_singleQuery_time:{},start:{},limit:{}", new Object[]{time1 - time0, start, limit});
        List storeFieldList = dataStoreBO.getStoreFieldInfoList();
        Map<String, FieldInfo> rep2AnoMapping = storeFieldList.stream().collect(Collectors.toMap(FieldInfo::getNumberAlias, sf -> sf));
        List calResultList = reportResult.getCalResultList();
        if (calResultList.isEmpty()) {
            return 0;
        }
        ArrayList esBatchValueList = Lists.newArrayListWithExpectedSize((int)calResultList.size());
        for (CalResult calResult : calResultList) {
            Row rowData = calResult.getRowData();
            ArrayList esPropertyValueList = Lists.newArrayListWithExpectedSize((int)calResultList.size());
            for (Map.Entry<String, EsMappingBo> entry : bo.getMappingFieldMap().entrySet()) {
                String key = entry.getKey();
                FieldInfo fieldInfo = rep2AnoMapping.get(key);
                EsMappingBo value = entry.getValue();
                String esFieldKey = value.getEsFieldKey();
                String fieldAlias = value.getFieldAlias();
                Object newValue = null;
                if (key.endsWith("\u03b9index")) {
                    Map<Object, Integer> idMap = bo.getCustomSortMap().get(fieldInfo.getRowFieldId());
                    if (idMap != null) {
                        String numberAliasKey = key.substring(0, key.length() - 6);
                        FieldInfo sortOriginField = rep2AnoMapping.get(numberAliasKey);
                        if (FieldComplexType.BASE_DATA.getValue().equals(sortOriginField.getComplexType())) {
                            numberAliasKey = numberAliasKey.substring(0, numberAliasKey.lastIndexOf(".")) + ".id";
                        }
                        newValue = idMap.get(rowData.get(numberAliasKey));
                    }
                } else {
                    newValue = ReportDataStoreServiceHelper.convertValue((String)fieldAlias, (Object)rowData.get(key));
                }
                EsPropertyValue esPropertyValue = new EsPropertyValue(esFieldKey, this.getDataType(fieldInfo.getValueType()), newValue);
                esPropertyValueList.add(esPropertyValue);
            }
            EsBatchValue esBatchValue = new EsBatchValue((Object)start++, esPropertyValueList.toArray(new EsPropertyValue[0]));
            esBatchValueList.add(esBatchValue);
        }
        ES_STORAGE.batchSave(bo.getEsIndex(), "t_data", esBatchValueList.toArray(new EsBatchValue[0]));
        return calResultList.size();
    }

    private List<EsMappingBo> queryFieldMapList(String esIndex) {
        DynamicObject[] esMappings = ReportCenterServiceHelper.getEsMappings(esIndex);
        ArrayList fieldMaps = Lists.newArrayListWithCapacity((int)esMappings.length);
        for (DynamicObject fieldMapDy : esMappings) {
            String numberAlias = fieldMapDy.getString("numberalias");
            String fieldAlias = fieldMapDy.getString("fieldalias");
            String esFieldKey = fieldMapDy.getString("esfieldkey");
            EsMappingBo esMappingBo = new EsMappingBo(fieldAlias, numberAlias, esFieldKey);
            fieldMaps.add(esMappingBo);
        }
        return fieldMaps;
    }

    private void saveEsMapping(String esIndex, FieldDataStoreBO fieldDataStoreBO) {
        List storeFieldInfoList = fieldDataStoreBO.getStoreFieldInfoList();
        ArrayList esMappingPropertyList = Lists.newArrayListWithExpectedSize((int)storeFieldInfoList.size());
        DynamicObjectCollection collection = new DynamicObjectCollection();
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLang = intService.getEnabledLang();
        HashSet addNumberSet = Sets.newHashSetWithExpectedSize((int)storeFieldInfoList.size());
        for (FieldInfo fieldInfo : storeFieldInfoList) {
            String number = fieldInfo.getNumber();
            String newAlias = ReportEsServiceHelper.replaceSpecChar((String)number);
            collection.add((Object)this.buildMapping(fieldInfo, esIndex, newAlias));
            if (!addNumberSet.add(number)) continue;
            String valueType = fieldInfo.getValueType();
            EsMappingProperty esMappingProperty = new EsMappingProperty(newAlias, this.getDataType(valueType));
            if (DataTypeEnum.LOCALESTRING.getDataTypeKey().equals(valueType)) {
                EsMappingProperty langMappingProperty = new EsMappingProperty(newAlias + "_l", EsDataType.OBJECT);
                ArrayList langPropertyList = Lists.newArrayListWithExpectedSize((int)enabledLang.size());
                for (EnabledLang lang : enabledLang) {
                    langPropertyList.add(new EsMappingProperty(lang.getNumber(), EsDataType.KEYWORD));
                }
                langMappingProperty.nests.addAll(langPropertyList);
                langMappingProperty.nests.add(this.getGLangMappingProp());
                esMappingPropertyList.add(langMappingProperty);
            }
            esMappingPropertyList.add(esMappingProperty);
        }
        ES_STORAGE.addMappingIndex(esIndex, "t_data", "strict", esMappingPropertyList.toArray(new EsMappingProperty[0]));
        ReportCenterServiceHelper.saveEsMappings(collection);
    }

    private EsDataType getDataType(String valueType) {
        EsDataType dataType = null;
        switch (DataTypeEnum.of((String)valueType)) {
            case LONG: {
                dataType = EsDataType.LONG;
                break;
            }
            case BIGDECIMAL: {
                dataType = EsDataType.DOUBLE;
                break;
            }
            case BOOLEAN: {
                dataType = EsDataType.BOOLEAN;
                break;
            }
            case STRING: 
            case LOCALESTRING: {
                dataType = EsDataType.KEYWORD;
                break;
            }
            case DATETIME: {
                dataType = EsDataType.DATE;
                break;
            }
            case INTEGER: {
                dataType = EsDataType.INTEGER;
                break;
            }
        }
        return dataType;
    }

    private DynamicObject buildMapping(FieldInfo fieldInfo, String esIndex, String esFieldKey) {
        DynamicObject dynamicObject = ReportCenterServiceHelper.ES_MAPPINGS_HELPER.generateEmptyDynamicObject();
        dynamicObject.set("numberalias", (Object)fieldInfo.getNumberAlias());
        dynamicObject.set("fieldalias", (Object)fieldInfo.getNumber());
        dynamicObject.set("esfieldkey", (Object)esFieldKey);
        dynamicObject.set("esindex", (Object)esIndex);
        return dynamicObject;
    }

    private void createIndex(String esIndex, String baseDataEsIndex) {
        DynamicObject dynamicObject = ReportCenterServiceHelper.ES_INDEX_HELPER.generateEmptyDynamicObject();
        dynamicObject.set("id", (Object)esIndex);
        dynamicObject.set("basedataesindex", (Object)baseDataEsIndex);
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("status", (Object)"0");
        ReportCenterServiceHelper.saveEsIndex(dynamicObject);
    }

    private void handleBaseDataAndEnum(String esIndex, FieldDataStoreBO fieldDataStoreBO) {
        List storeFieldInfoList = fieldDataStoreBO.getStoreFieldInfoList();
        boolean hasBaseDataOrEnum = false;
        for (FieldInfo fieldInfo : storeFieldInfoList) {
            String controlType = fieldInfo.getControlType();
            String fieldAlias = fieldInfo.getNumber();
            if (ReportDataStoreServiceHelper.isBaseDataNameOrNum((String)fieldInfo.getComplexType(), (String)fieldAlias)) {
                hasBaseDataOrEnum = true;
                break;
            }
            if (!FieldControlType.COMBO.getValue().equals(controlType) && !FieldControlType.MUL_COMBO.getValue().equals(controlType)) continue;
            hasBaseDataOrEnum = true;
            break;
        }
        if (hasBaseDataOrEnum) {
            this.baseDataEsIndex = this.generateBaseDataEsIndex(esIndex);
            ES_STORAGE.createIndex("hr", this.baseDataEsIndex, null);
            EsMappingProperty langMappingProperty = new EsMappingProperty("name_l", EsDataType.OBJECT);
            InteServiceImpl intService = new InteServiceImpl();
            List enabledLang = intService.getEnabledLang();
            for (EnabledLang lang : enabledLang) {
                EsMappingProperty nestProperty = new EsMappingProperty(lang.getNumber(), EsDataType.KEYWORD);
                langMappingProperty.nests.add(nestProperty);
            }
            langMappingProperty.nests.add(this.getGLangMappingProp());
            EsMappingProperty[] esMappingProperties = new EsMappingProperty[]{new EsMappingProperty("id", EsDataType.KEYWORD), new EsMappingProperty("number", EsDataType.KEYWORD), new EsMappingProperty("fieldalias", EsDataType.KEYWORD), new EsMappingProperty("baseDataNum", EsDataType.KEYWORD), new EsMappingProperty("type", EsDataType.KEYWORD), new EsMappingProperty("name", EsDataType.KEYWORD), langMappingProperty};
            ES_STORAGE.addMappingIndex(this.baseDataEsIndex, "t_data", "strict", esMappingProperties);
        }
    }

    private void saveDataWithBaseData(String baseDataEsIndex, FieldDataStoreBO fieldDataStoreBO, long anObjId) {
        List storeFieldInfoList = fieldDataStoreBO.getStoreFieldInfoList();
        AnObjEnumFieldHandler anObjEnumFieldHandler = new AnObjEnumFieldHandler(anObjId, new MainEntityTypeUtil());
        int id = 0;
        ArrayList enumBatchValueList = Lists.newArrayListWithExpectedSize((int)storeFieldInfoList.size());
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLang = intService.getEnabledLang();
        HashMap baseDataFilterMap = Maps.newHashMapWithExpectedSize((int)storeFieldInfoList.size());
        HashMap fieldAliasMap = Maps.newHashMapWithExpectedSize((int)storeFieldInfoList.size());
        for (FieldInfo fieldInfo : storeFieldInfoList) {
            String controlType = fieldInfo.getControlType();
            String fieldAlias = fieldInfo.getNumber();
            if (ReportDataStoreServiceHelper.isBaseDataNameOrNum((String)fieldInfo.getComplexType(), (String)fieldAlias)) {
                String baseDataNum = fieldInfo.getBaseDataNum();
                this.handleOrgBaseData(fieldInfo.getEntityNumber(), baseDataNum, fieldAlias);
                if ("haos_adminorghr".equals(baseDataNum)) continue;
                String type = HisCommonService.getInstance().entityInhRelation(baseDataNum);
                QFilter qFilter = null;
                if (!EnumEntityTpl.COMMON_TPL.getNumber().equals(type)) {
                    qFilter = new QFilter("iscurrentversion", "=", (Object)true);
                }
                Set fieldAliasSet = fieldAliasMap.getOrDefault(baseDataNum, Sets.newHashSetWithExpectedSize((int)storeFieldInfoList.size()));
                fieldAliasSet.add(fieldAlias);
                fieldAliasMap.put(baseDataNum, fieldAliasSet);
                baseDataFilterMap.put(baseDataNum, qFilter);
                continue;
            }
            if (!FieldControlType.COMBO.getValue().equals(controlType) && !FieldControlType.MUL_COMBO.getValue().equals(controlType)) continue;
            List enumItems = anObjEnumFieldHandler.getEnumItems(fieldAlias, fieldInfo.getEntityNumber());
            for (AnObjEnumFieldHandler.AnObjEnumItem enumItem : enumItems) {
                EsPropertyValue idProperty = new EsPropertyValue("id", EsDataType.KEYWORD, (Object)enumItem.getValue());
                EsPropertyValue typeProperty = new EsPropertyValue("type", EsDataType.KEYWORD, (Object)"1");
                EsPropertyValue aliasProperty = new EsPropertyValue("fieldalias", EsDataType.KEYWORD, (Object)fieldAlias);
                EsPropertyValue nameProperty = new EsPropertyValue("name", EsDataType.KEYWORD, enumItem.getName().get((Object)"GLang"));
                EsPropertyValue langProperty = new EsPropertyValue("name_l", EsDataType.NESTED, null);
                this.addMultiLangProp(enabledLang, (ILocaleString)enumItem.getName(), langProperty);
                EsPropertyValue[] esPropertyValues = new EsPropertyValue[]{idProperty, typeProperty, aliasProperty, nameProperty, langProperty};
                EsBatchValue esBatchValue = new EsBatchValue((Object)id++, esPropertyValues);
                enumBatchValueList.add(esBatchValue);
            }
        }
        ES_STORAGE.batchSave(baseDataEsIndex, "t_data", enumBatchValueList.toArray(new EsBatchValue[0]));
        this.saveBaseData(baseDataEsIndex, baseDataFilterMap, fieldAliasMap, id);
    }

    private void handleOrgBaseData(String entityNum, String baseDataNum, String fieldAlias) {
        if ("bos_org".equals(baseDataNum)) {
            DynamicProperty prop;
            OrgProp orgProp;
            OrgViewSchemeProp orgViewScheme;
            String orgViewSchemeNumber;
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityNum);
            String pre = fieldAlias.substring(0, fieldAlias.lastIndexOf("."));
            int lastIndex = pre.lastIndexOf(".");
            if (lastIndex != -1) {
                pre = pre.substring(lastIndex + 1);
            }
            String string = orgViewSchemeNumber = (orgViewScheme = (orgProp = (OrgProp)(prop = (DynamicProperty)dataEntityType.getAllFields().get(pre))).getOrgViewScheme()) == null ? null : orgViewScheme.getNumber();
            if (HRStringUtils.isNotEmpty((String)orgViewSchemeNumber)) {
                List orgIdList = OrgUnitServiceHelper.getAllOrgByViewNumber((String)orgViewSchemeNumber, (boolean)true);
                QFilter qFilter = new QFilter("id", "in", (Object)orgIdList);
                if (this.f7PermissionQFilter != null) {
                    QFilter oldQFilter = this.f7PermissionQFilter.get(fieldAlias);
                    if (oldQFilter != null) {
                        qFilter.and(oldQFilter);
                    }
                    this.f7PermissionQFilter.put(fieldAlias, qFilter);
                }
            }
        }
    }

    private void saveBaseData(String baseDataEsIndex, Map<String, QFilter> baseDataFilterMap, Map<String, Set<String>> fieldAliasMap, int id) {
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLang = intService.getEnabledLang();
        for (Map.Entry<String, QFilter> entry : baseDataFilterMap.entrySet()) {
            List<String> stopKeyList = this.getStopKeyList();
            if (ScheduleTaskServiceHelper.isStop(stopKeyList)) {
                return;
            }
            Set<String> fieldAliasSet = fieldAliasMap.get(entry.getKey());
            id = this.saveBaseData(baseDataEsIndex, entry.getKey(), fieldAliasSet, entry.getValue(), enabledLang, id);
        }
    }

    private int saveBaseData(String baseDataEsIndex, String baseDataNum, Set<String> fieldAliasSet, QFilter qFilter, List<EnabledLang> enabledLang, int id) {
        DynamicObject[] load;
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)2);
        if (qFilter != null) {
            qFilterList.add(qFilter);
        }
        QFilter permissionQFilter = null;
        if (this.f7PermissionQFilter != null) {
            for (String fieldAlias : fieldAliasSet) {
                QFilter subPermissionQFilter = this.f7PermissionQFilter.get(fieldAlias);
                if (subPermissionQFilter == null) continue;
                if (permissionQFilter != null) {
                    permissionQFilter.or(subPermissionQFilter);
                    continue;
                }
                permissionQFilter = subPermissionQFilter;
            }
            if (permissionQFilter != null) {
                qFilterList.add(permissionQFilter);
            }
        }
        QFilter[] qFilters = qFilterList.toArray(new QFilter[0]);
        int pageIndex = 0;
        do {
            List<String> stopKeyList;
            if (ScheduleTaskServiceHelper.isStop(stopKeyList = this.getStopKeyList())) {
                return id;
            }
            load = BusinessDataServiceHelper.load((String)baseDataNum, (String)"id,number,name", (QFilter[])qFilters, null, (int)pageIndex, (int)MAX_SIZE_BASE_DATA);
            if (load.length == 0) break;
            ArrayList esBatchValueList = Lists.newArrayListWithExpectedSize((int)load.length);
            for (DynamicObject dynamicObject : load) {
                EsPropertyValue nameProperty;
                String normalName;
                EsPropertyValue[] esPropertyValues;
                Object idValue = dynamicObject.get("id");
                String number = dynamicObject.getString("number");
                Object name = dynamicObject.get("name");
                EsPropertyValue idProperty = new EsPropertyValue("id", EsDataType.KEYWORD, (Object)idValue.toString());
                EsPropertyValue numProperty = new EsPropertyValue("number", EsDataType.KEYWORD, (Object)number);
                EsPropertyValue typeProperty = new EsPropertyValue("type", EsDataType.KEYWORD, (Object)"0");
                EsPropertyValue baseDataNumProperty = new EsPropertyValue("baseDataNum", EsDataType.KEYWORD, (Object)baseDataNum);
                if (name instanceof ILocaleString) {
                    esPropertyValues = new EsPropertyValue[6];
                    normalName = (String)((ILocaleString)name).get((Object)"GLang");
                    EsPropertyValue langProperty = new EsPropertyValue("name_l", EsDataType.NESTED, null);
                    this.addMultiLangProp(enabledLang, (ILocaleString)name, langProperty);
                    esPropertyValues[5] = langProperty;
                } else {
                    esPropertyValues = new EsPropertyValue[5];
                    normalName = name + "";
                }
                esPropertyValues[0] = idProperty;
                esPropertyValues[1] = numProperty;
                esPropertyValues[2] = typeProperty;
                esPropertyValues[3] = baseDataNumProperty;
                esPropertyValues[4] = nameProperty = new EsPropertyValue("name", EsDataType.KEYWORD, (Object)normalName);
                EsBatchValue esBatchValue = new EsBatchValue((Object)id++, esPropertyValues);
                esBatchValueList.add(esBatchValue);
            }
            ES_STORAGE.batchSave(baseDataEsIndex, "t_data", esBatchValueList.toArray(new EsBatchValue[0]));
            ++pageIndex;
        } while (load.length >= MAX_SIZE_BASE_DATA);
        return id;
    }

    private void addMultiLangProp(List<EnabledLang> enabledLang, ILocaleString multiLang, EsPropertyValue langProperty) {
        for (EnabledLang lang : enabledLang) {
            String number = lang.getNumber();
            String value = (String)multiLang.get((Object)number);
            EsPropertyValue nestProperty = new EsPropertyValue(number, EsDataType.KEYWORD, (Object)value);
            langProperty.nests.add(nestProperty);
        }
        String gLangValue = (String)multiLang.get((Object)"GLang");
        EsPropertyValue nestProperty = new EsPropertyValue("GLang", EsDataType.KEYWORD, (Object)gLangValue);
        langProperty.nests.add(nestProperty);
    }

    private EsMappingProperty getGLangMappingProp() {
        return new EsMappingProperty("GLang", EsDataType.KEYWORD);
    }

    private void addBaseDataOtherField(List<FieldInfo> fieldInfoList) {
        HashSet numAndNameFieldSet = Sets.newHashSetWithExpectedSize((int)fieldInfoList.size());
        HashMap otherFieldMap = Maps.newHashMapWithExpectedSize((int)fieldInfoList.size());
        for (FieldInfo fieldInfo : fieldInfoList) {
            String fieldAlias;
            String complexType = fieldInfo.getComplexType();
            if (!ReportDataStoreServiceHelper.isBaseDataNameOrNum((String)complexType, (String)(fieldAlias = fieldInfo.getNumber())) || !numAndNameFieldSet.add(fieldAlias)) continue;
            otherFieldMap.remove(fieldAlias);
            String pre = fieldAlias.substring(0, fieldAlias.lastIndexOf("."));
            String otherKey = fieldAlias.endsWith(".number") ? pre + ".name" : pre + ".number";
            if (numAndNameFieldSet.contains(otherKey)) continue;
            otherFieldMap.put(otherKey, fieldInfo);
        }
        for (Map.Entry entry : otherFieldMap.entrySet()) {
            FieldInfo fieldInfo = (FieldInfo)entry.getValue();
            FieldInfo otherField = new FieldInfo();
            otherField.setNumber((String)entry.getKey());
            otherField.setNumberAlias((String)entry.getKey());
            otherField.setName(new LocaleString((String)entry.getKey()));
            otherField.setDisplayName(otherField.getName());
            otherField.setBaseDataNum(fieldInfo.getBaseDataNum());
            if (((String)entry.getKey()).endsWith(".name")) {
                otherField.setControlType(FieldControlType.MUL_LANG_TEXT.getValue());
            } else {
                otherField.setControlType(FieldControlType.TEXT.getValue());
            }
            otherField.setValueType(fieldInfo.getValueType());
            otherField.setComplexType(fieldInfo.getComplexType());
            otherField.setEntityNumber(fieldInfo.getEntityNumber());
            otherField.setFieldPath((String)entry.getKey());
            otherField.setType(fieldInfo.getType());
            fieldInfoList.add(otherField);
        }
    }
}

