/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.share;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.share.ShareReportDataStoreService;
import kd.hr.hrptc.business.subscribe.ReportMySubscribeService;
import kd.hr.hrptc.common.constant.share.ReportShareConstants;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.repdesign.RptPermService;
import kd.hr.hrptmc.common.constant.repdesign.filter.FilterType;
import kd.hr.hrptmc.common.model.reportcenter.share.ReportShareConfigBo;
import kd.hr.hrptmc.common.model.reportcenter.share.ReportShareFilterRangeBo;

public class ReportShareConfigService
implements ReportShareConstants {
    private final HRBaseServiceHelper shareConfigHelper = new HRBaseServiceHelper("hrptmc_sharerecord");
    private final HRBaseServiceHelper shareFilterRangeHelper = new HRBaseServiceHelper("hrptmc_sharefilterrange");
    private static final Log LOGGER = LogFactory.getLog(ReportShareConfigService.class);

    public ReportShareConfigBo getReportShareConfigBo(long shareConfigId) {
        DynamicObject configDy = this.shareConfigHelper.loadSingle((Object)shareConfigId);
        if (configDy == null) {
            return null;
        }
        return this.buildReportShareConfigBo(configDy);
    }

    public ReportShareConfigBo getReportShareConfigBo(long reportId, long shareUser) {
        DynamicObject configDy = this.shareConfigHelper.loadDynamicObject(new QFilter[]{new QFilter("report", "=", (Object)reportId), new QFilter("shareuser", "=", (Object)shareUser)});
        if (configDy == null) {
            return null;
        }
        return this.buildReportShareConfigBo(configDy);
    }

    public DynamicObject queryExpirationAndStatus(long shareConfigId) {
        return this.shareConfigHelper.queryOriginalOne("expiration, sharestatus, sharesource, runstatus", new QFilter[]{new QFilter("id", "=", (Object)shareConfigId)});
    }

    public DynamicObject queryRunStatusAndEsIndex(long shareId) {
        return this.shareConfigHelper.queryOriginalOne("runstatus, esindex", new QFilter[]{new QFilter("id", "=", (Object)shareId)});
    }

    private DynamicObject loadReportShareConfigDy(long id) {
        return this.shareConfigHelper.loadSingle((Object)id);
    }

    private ReportShareConfigBo buildReportShareConfigBo(DynamicObject configDy) {
        DynamicObject esIndexDy;
        ReportShareConfigBo configBo = new ReportShareConfigBo();
        long reportId = configDy.getLong("report");
        configBo.setReportId(Long.valueOf(reportId));
        configBo.setReportNumber(configDy.getString("reportnumber"));
        configBo.setReportName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)((OrmLocaleValue)configDy.getLocaleString("reportname"))));
        configBo.setShareUserId(Long.valueOf(configDy.getDynamicObject("shareuser").getLong("id")));
        List receiveUsers = configDy.getDynamicObjectCollection("receiveuser").stream().map(dy -> dy.getDynamicObject("fbasedataid")).map(bd -> bd.getLong("id")).collect(Collectors.toList());
        configBo.setReceiveUsers(receiveUsers);
        configBo.setOnlyQueryResult(configDy.getBoolean("onlyqueryresult"));
        configBo.setExpiration(configDy.getDate("expiration"));
        configBo.setNoticeType(configDy.getString("noticetype"));
        configBo.setShareTime(configDy.getDate("createtime"));
        configBo.setUserPermQFilterStr(configDy.getString("userpermfilter"));
        configBo.setReportQFilterStr(configDy.getString("reportfilter"));
        configBo.setF7QFilter(configDy.getString("f7qfilter"));
        configBo.setAdminOrgF7QFilter(configDy.getString("admorgf7qfilter"));
        OrmLocaleValue content = (OrmLocaleValue)configDy.getLocaleString("content");
        if (content != null) {
            LocaleString localeString = AnalyseObjectUtil.getLocaleString((OrmLocaleValue)content);
            configBo.setContent(localeString);
        }
        if ((esIndexDy = configDy.getDynamicObject("esindex")) != null) {
            configBo.setEsIndex(esIndexDy.getString("id"));
            configBo.setBaseDataEsIndex(esIndexDy.getString("basedataesindex"));
        }
        DynamicObject[] dys = this.shareFilterRangeHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("sharerecord", "=", (Object)configDy.getLong("id"))});
        ArrayList shareFilterRangeBoList = Lists.newArrayListWithCapacity((int)10);
        for (DynamicObject dy2 : dys) {
            ReportShareFilterRangeBo filterRangeBo = new ReportShareFilterRangeBo();
            filterRangeBo.setFieldAlias(dy2.getString("fieldalias"));
            filterRangeBo.setFilterType(dy2.getString("filtertype"));
            filterRangeBo.setFilterRange(dy2.getString("filterrange"));
            filterRangeBo.setFilterDefault(dy2.getString("filterdefault"));
            filterRangeBo.setDateFilterType(dy2.getString("datefiltertype"));
            filterRangeBo.setDateFilterText(dy2.getString("datefiltertext"));
            filterRangeBo.setFilterStartDateDefault(dy2.getString("startdatedefault"));
            filterRangeBo.setFilterEndDateDefault(dy2.getString("enddatedefault"));
            filterRangeBo.setOpt(dy2.getString("opt"));
            DynamicObject userDisplaySchemeDy = dy2.getDynamicObject("userdissche");
            if (userDisplaySchemeDy != null) {
                filterRangeBo.setUserDisplayScheme(Long.valueOf(userDisplaySchemeDy.getLong("id")));
            }
            filterRangeBo.setContainSub(Boolean.valueOf(dy2.getBoolean("containsub")));
            shareFilterRangeBoList.add(filterRangeBo);
        }
        configBo.setShareFilterRangeBoList((List)shareFilterRangeBoList);
        return configBo;
    }

    public void saveReportShareConfigBo(ReportShareConfigBo reportShareConfigBo, String mySubscribeEsIndexId) {
        DynamicObject shareConfigDy = this.shareConfigHelper.generateEmptyDynamicObject();
        shareConfigDy.set("id", (Object)ID.genLongId());
        shareConfigDy.set("report", (Object)reportShareConfigBo.getReportId());
        shareConfigDy.set("reportname", (Object)reportShareConfigBo.getReportName());
        shareConfigDy.set("reportnumber", (Object)reportShareConfigBo.getReportNumber());
        shareConfigDy.set("shareuser", (Object)reportShareConfigBo.getShareUserId());
        List receiveUsers = reportShareConfigBo.getReceiveUsers();
        DynamicObjectCollection receiveUserCol = new DynamicObjectCollection();
        if (receiveUsers != null && !receiveUsers.isEmpty()) {
            DynamicObject[] receiveUserDys = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)receiveUsers)});
            DynamicObjectType dynamicObjectType = shareConfigDy.getDynamicObjectCollection("receiveuser").getDynamicObjectType();
            for (DynamicObject receiveUserDy : receiveUserDys) {
                DynamicObject newUser = new DynamicObject(dynamicObjectType);
                newUser.set("fbasedataid", (Object)receiveUserDy);
                receiveUserCol.add((Object)newUser);
            }
        }
        shareConfigDy.set("receiveuser", (Object)receiveUserCol);
        Date expiration = reportShareConfigBo.getExpiration();
        shareConfigDy.set("expiration", (Object)expiration);
        shareConfigDy.set("onlyqueryresult", (Object)reportShareConfigBo.isOnlyQueryResult());
        shareConfigDy.set("noticetype", (Object)reportShareConfigBo.getNoticeType());
        shareConfigDy.set("content", (Object)reportShareConfigBo.getContent());
        this.sendShareMessage(reportShareConfigBo);
        shareConfigDy.set("sharesource", (Object)reportShareConfigBo.getShareSource());
        shareConfigDy.set("createtime", (Object)new Date());
        shareConfigDy.set("starttime", (Object)new Date());
        if (HRStringUtils.equals((String)reportShareConfigBo.getShareSource(), (String)"ReportSubscribe")) {
            shareConfigDy.set("endtime", (Object)new Date());
            shareConfigDy.set("runstatus", (Object)"3");
            shareConfigDy.set("reportsubscribe", (Object)reportShareConfigBo.getReportSubscribeId());
            shareConfigDy.set("esindex", (Object)mySubscribeEsIndexId);
        } else {
            shareConfigDy.set("runstatus", (Object)"5");
        }
        shareConfigDy.set("sharestatus", (Object)"normal");
        ArrayList baseDataFieldAliasList = Lists.newArrayListWithCapacity((int)10);
        ArrayList adminOrgFieldAliasList = Lists.newArrayListWithCapacity((int)10);
        this.saveShareFilterRange(reportShareConfigBo, shareConfigDy, baseDataFieldAliasList, adminOrgFieldAliasList);
        QFilter queryQFilter = this.getQueryQFilter(shareConfigDy, reportShareConfigBo);
        Map<Object, Object> f7PermQFilters = Maps.newHashMapWithExpectedSize((int)16);
        if (HRStringUtils.equals((String)reportShareConfigBo.getShareSource(), (String)"ReportCenter")) {
            f7PermQFilters = this.getReportCenterF7PermQFilters(reportShareConfigBo.getReportId(), baseDataFieldAliasList);
            Map<String, Map<Long, String>> adminOrgF7PermQFilters = this.getReportCenterAdminOrgF7PermQFilters(reportShareConfigBo.getReportId(), adminOrgFieldAliasList);
            this.setF7PermQFilters(f7PermQFilters, adminOrgF7PermQFilters, shareConfigDy);
        } else {
            ReportMySubscribeService mySubscribeService = new ReportMySubscribeService();
            Map<String, String> mySubscribeF7QFilters = mySubscribeService.getMySubscribeF7QFilters(reportShareConfigBo.getReportSubscribeId());
            shareConfigDy.set("f7qfilter", (Object)mySubscribeF7QFilters.get("f7qfilter"));
            shareConfigDy.set("admorgf7qfilter", (Object)mySubscribeF7QFilters.get("admorgf7qfilter"));
        }
        DynamicObject saveDy = (DynamicObject)this.shareConfigHelper.saveOne(shareConfigDy);
        if (HRStringUtils.equals((String)reportShareConfigBo.getShareSource(), (String)"ReportCenter")) {
            this.executeShareDataStore(reportShareConfigBo.getReportId(), saveDy, queryQFilter, f7PermQFilters);
        }
    }

    private void setF7PermQFilters(Map<String, QFilter> f7PermQFilters, Map<String, Map<Long, String>> adminOrgF7PermQFilters, DynamicObject shareConfigDy) {
        if (f7PermQFilters != null && !f7PermQFilters.isEmpty()) {
            HashMap f7PermQFilterStrMap = Maps.newHashMapWithExpectedSize((int)16);
            f7PermQFilters.forEach((fieldAlias, qFilter) -> f7PermQFilterStrMap.put(fieldAlias, qFilter.toSerializedString()));
            shareConfigDy.set("f7qfilter", (Object)SerializationUtils.toJsonString((Object)f7PermQFilterStrMap));
        }
        if (adminOrgF7PermQFilters != null && !adminOrgF7PermQFilters.isEmpty()) {
            shareConfigDy.set("admorgf7qfilter", (Object)SerializationUtils.toJsonString(adminOrgF7PermQFilters));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private void shareUserDisplayScheme(ReportShareConfigBo reportShareConfigBo, List<Long> receiveUsers) {
        List shareFilterRangeBoList = reportShareConfigBo.getShareFilterRangeBoList();
        if (shareFilterRangeBoList == null || shareFilterRangeBoList.isEmpty()) {
            return;
        }
        Optional<ReportShareFilterRangeBo> userDisplayFilterRangeOp = shareFilterRangeBoList.stream().filter(filterRangeBo -> "userdispscm".equals(filterRangeBo.getFieldAlias())).findAny();
        if (!userDisplayFilterRangeOp.isPresent()) {
            return;
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_userdispscm");
        ReportShareFilterRangeBo userDisplayFilterRangeBo = userDisplayFilterRangeOp.get();
        DynamicObject userDisplaySchemeDy = helper.loadSingle((Object)userDisplayFilterRangeBo.getUserDisplayScheme());
        if (userDisplaySchemeDy == null) {
            return;
        }
        DynamicObjectCollection shareUserDisplaySchemeCol = new DynamicObjectCollection();
        for (Long receiveUser : receiveUsers) {
            DynamicObject copyDy = helper.generateEmptyDynamicObject();
            HRDynamicObjectUtils.copy((DynamicObject)userDisplaySchemeDy, (DynamicObject)copyDy);
            copyDy.set("id", null);
            copyDy.set("user", (Object)receiveUser);
            shareUserDisplaySchemeCol.add((Object)copyDy);
        }
        helper.save(shareUserDisplaySchemeCol);
    }

    private void saveShareFilterRange(ReportShareConfigBo reportShareConfigBo, DynamicObject shareRecordDy, List<String> baseDataFieldAliasList, List<String> adminOrgFieldAliasList) {
        List shareFilterRangeBoList = reportShareConfigBo.getShareFilterRangeBoList();
        if (shareFilterRangeBoList != null && !shareFilterRangeBoList.isEmpty()) {
            DynamicObjectCollection filterRangeCol = new DynamicObjectCollection();
            for (ReportShareFilterRangeBo shareFilterRangeBo : shareFilterRangeBoList) {
                DynamicObject filterRangeDy = this.shareFilterRangeHelper.generateEmptyDynamicObject();
                filterRangeDy.set("sharerecord", (Object)shareRecordDy);
                filterRangeDy.set("fieldalias", (Object)shareFilterRangeBo.getFieldAlias());
                filterRangeDy.set("filtertype", (Object)shareFilterRangeBo.getFilterType());
                if (HRStringUtils.equals((String)shareFilterRangeBo.getFilterType(), (String)FilterType.ADMIN_ORG.getValue())) {
                    adminOrgFieldAliasList.add(shareFilterRangeBo.getFieldAlias());
                } else if (HRStringUtils.equals((String)shareFilterRangeBo.getFilterType(), (String)FilterType.BASE_DATA_ENUM.getValue()) || HRStringUtils.equals((String)shareFilterRangeBo.getFilterType(), (String)FilterType.BASE_DATA.getValue()) || HRStringUtils.equals((String)shareFilterRangeBo.getFilterType(), (String)FilterType.HIS_BASE_DATA.getValue())) {
                    baseDataFieldAliasList.add(shareFilterRangeBo.getFieldAlias());
                }
                filterRangeDy.set("filterrange", (Object)shareFilterRangeBo.getFilterRange());
                filterRangeDy.set("filterdefault", (Object)shareFilterRangeBo.getFilterDefault());
                filterRangeDy.set("datefiltertype", (Object)shareFilterRangeBo.getDateFilterType());
                filterRangeDy.set("datefiltertext", (Object)shareFilterRangeBo.getDateFilterText());
                filterRangeDy.set("startdatedefault", (Object)shareFilterRangeBo.getFilterStartDateDefault());
                filterRangeDy.set("enddatedefault", (Object)shareFilterRangeBo.getFilterEndDateDefault());
                filterRangeDy.set("opt", (Object)shareFilterRangeBo.getOpt());
                filterRangeDy.set("userdissche", (Object)shareFilterRangeBo.getUserDisplayScheme());
                filterRangeDy.set("containsub", (Object)shareFilterRangeBo.getContainSub());
                filterRangeCol.add((Object)filterRangeDy);
            }
            this.shareFilterRangeHelper.save(filterRangeCol);
        }
    }

    private Map<String, QFilter> getReportCenterF7PermQFilters(long reportId, List<String> baseDataFieldAliasList) {
        HashMap f7PermQFilters = Maps.newHashMapWithExpectedSize((int)16);
        long userId = RequestContext.get().getCurrUserId();
        LOGGER.info("ReportShareConfigService getReportCenterF7PermQFilters reportId: {}, userId: {}, baseDataFieldAliasList: {}", new Object[]{reportId, userId, baseDataFieldAliasList});
        for (String fieldAlias : baseDataFieldAliasList) {
            QFilter baseDataQFilter = RptPermService.getQueryFieldPerm((long)userId, (long)reportId, (String)fieldAlias);
            if (baseDataQFilter == null) continue;
            f7PermQFilters.put(fieldAlias, baseDataQFilter);
        }
        LOGGER.info("ReportShareConfigService getReportCenterF7PermQFilters basedata: {}", (Object)f7PermQFilters);
        return f7PermQFilters;
    }

    private Map<String, Map<Long, String>> getReportCenterAdminOrgF7PermQFilters(long reportId, List<String> adminOrgFieldAliasList) {
        long userId = RequestContext.get().getCurrUserId();
        Map fieldIdMap = AnalyseObjectService.getInstance().queryFieldIdByFieldAlias(reportId, adminOrgFieldAliasList);
        boolean isSuperUser = PermissionServiceHelper.isSuperUser((long)userId);
        HashMap adminOrgF7QFilterMap = Maps.newHashMapWithExpectedSize((int)16);
        for (String adminOrgFieldAlias : adminOrgFieldAliasList) {
            Long fieldId = (Long)fieldIdMap.get(adminOrgFieldAlias);
            LOGGER.info("getReportCenterF7PermQFilters getAdminOrgStruct userId = {},reportId = {},fieldId = {}", new Object[]{userId, reportId, fieldId});
            ArrayList structIds = !isSuperUser ? Lists.newArrayList((Iterable)RptPermService.getStructIds((long)userId, (long)reportId, (long)fieldId)) : Lists.newArrayListWithExpectedSize((int)0);
            HashMap structQFilter = Maps.newHashMapWithExpectedSize((int)structIds.size());
            for (Long structId : structIds) {
                if (isSuperUser) continue;
                QFilter qFilter = RptPermService.getQueryFieldPerm((long)userId, (long)Long.parseLong(String.valueOf(reportId)), (long)Long.parseLong(String.valueOf(fieldId)), (long)structId);
                LOGGER.info("getReportCenterF7PermQFilters getQueryFieldPerm qFilter={}", (Object)qFilter);
                if (qFilter == null) continue;
                structQFilter.put(structId, qFilter.toSerializedString());
            }
            adminOrgF7QFilterMap.put(adminOrgFieldAlias, structQFilter);
        }
        LOGGER.info("ReportShareConfigService getReportCenterF7PermQFilters adminorg: {}", (Object)adminOrgF7QFilterMap);
        return adminOrgF7QFilterMap;
    }

    private void executeShareDataStore(long reportId, DynamicObject shareConfigDy, QFilter queryQFilter, Map<String, QFilter> f7PermQFilters) {
        long shareConfigId = shareConfigDy.getLong("id");
        ThreadPools.executeOnce((String)"ReportShareConfigService.executeShareDataStore", () -> {
            try {
                ShareReportDataStoreService service = new ShareReportDataStoreService(reportId, shareConfigId, shareConfigDy, queryQFilter, f7PermQFilters);
                service.execute();
            }
            catch (Exception exception) {
                DynamicObject shareDy = this.loadReportShareConfigDy(shareConfigId);
                shareDy.set("endtime", (Object)new Date());
                shareDy.set("runstatus", (Object)"2");
                shareDy.set("traceid", (Object)RequestContext.get().getTraceId());
                StringBuilder errorMsg = new StringBuilder();
                errorMsg.append("message: ").append(exception.getMessage()).append("\r\n");
                for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                    errorMsg.append(stackTraceElement.getClassName()).append("  ").append(stackTraceElement.getMethodName()).append(": ").append(stackTraceElement.getLineNumber());
                    errorMsg.append("\r\n");
                    if (errorMsg.length() > 1000) break;
                }
                if (errorMsg.length() > 1000) {
                    shareDy.set("errormsg", (Object)errorMsg.substring(0, 1000));
                } else {
                    shareDy.set("errormsg", (Object)errorMsg.toString());
                }
                this.shareConfigHelper.saveOne(shareDy);
            }
        });
    }

    private QFilter getQueryQFilter(DynamicObject shareConfigDy, ReportShareConfigBo reportShareConfigBo) {
        QFilter currentUserReportPermQFilter;
        QFilter whereQFilters;
        QFilter queryQFilter = null;
        if (reportShareConfigBo.isOnlyQueryResult() && (whereQFilters = this.getWhereQFilters(reportShareConfigBo)) != null) {
            LOGGER.info("ReportShareConfigService getQueryQFilter whereQFilter: {}", (Object)whereQFilters);
            queryQFilter = whereQFilters;
            shareConfigDy.set("reportfilter", (Object)reportShareConfigBo.getReportQFilterStr());
        }
        if ((currentUserReportPermQFilter = this.getCurrentUserReportPermQFilter(reportShareConfigBo.getReportId())) != null) {
            shareConfigDy.set("userpermfilter", (Object)currentUserReportPermQFilter.toSerializedString());
            String shareSource = reportShareConfigBo.getShareSource();
            if (HRStringUtils.equals((String)shareSource, (String)"ReportCenter")) {
                if (queryQFilter == null) {
                    queryQFilter = currentUserReportPermQFilter;
                } else {
                    queryQFilter.and(currentUserReportPermQFilter);
                }
                LOGGER.info("ReportShareConfigService getQueryQFilter currentUserReportPermQFilter: {}", (Object)currentUserReportPermQFilter);
            }
        }
        return queryQFilter;
    }

    private QFilter getCurrentUserReportPermQFilter(long reportId) {
        long currUserId = RequestContext.get().getCurrUserId();
        LOGGER.info("ReportShareConfigService getCurrentUserReportPermQFilter userId: {}, reportId: {}", (Object)currUserId, (Object)reportId);
        QFilter permQFilter = RptPermService.getRptPerm((long)currUserId, (long)reportId);
        LOGGER.info("ReportShareConfigService getCurrentUserReportPermQFilter: {}", (Object)permQFilter);
        return permQFilter;
    }

    public QFilter getWhereQFilters(ReportShareConfigBo reportShareConfigBo) {
        String userPermQFilterStr = reportShareConfigBo.getReportQFilterStr();
        if (HRStringUtils.isEmpty((String)userPermQFilterStr)) {
            return null;
        }
        List filterStrList = (List)SerializationUtils.fromJsonString((String)userPermQFilterStr, List.class);
        if (filterStrList.isEmpty()) {
            return null;
        }
        QFilter first = QFilter.fromSerializedString((String)((String)filterStrList.get(0)));
        for (int i = 1; i < filterStrList.size(); ++i) {
            QFilter qFilter = QFilter.fromSerializedString((String)((String)filterStrList.get(i)));
            first.and(qFilter);
        }
        return first;
    }

    public void cancelShare(long shareId) {
        DynamicObject shareDy = this.shareConfigHelper.queryOne("id, sharestatus, sharesource, report", new QFilter[]{new QFilter("id", "=", (Object)shareId)});
        if (shareDy != null) {
            shareDy.set("sharestatus", (Object)"cancel");
            this.shareConfigHelper.saveOne(shareDy);
        }
    }

    public Map<String, String> getMsgCenterEnableMsgChannels() {
        HRBaseServiceHelper msgChannelHelper = new HRBaseServiceHelper("msg_channel");
        DynamicObjectCollection channelCol = msgChannelHelper.queryOriginalCollection("number, name, enable", new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        HashMap result = Maps.newHashMapWithExpectedSize((int)channelCol.size());
        for (DynamicObject dy : channelCol) {
            result.put(dy.getString("number"), dy.getString("name"));
        }
        return result;
    }

    public boolean sendShareMessage(ReportShareConfigBo reportShareConfigBo) {
        MessageInfo messageInfo = new MessageInfo();
        String title = ResManager.loadKDString((String)"\u6709\u4eba\u7ed9\u60a8\u5206\u4eab\u4e86\u4e00\u5f20\u62a5\u8868\uff0c\u8bf7\u53ca\u65f6\u67e5\u770b", (String)"ReportShareConfigService_1", (String)"hrmp-hrptc-business", (Object[])new Object[0]);
        messageInfo.setMessageTitle((ILocaleString)new LocaleString(title));
        if (reportShareConfigBo.getContent() == null || reportShareConfigBo.getContent().getLocaleValue() == null) {
            messageInfo.setMessageContent((ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u8bf7\u8fdb\u5165\u62a5\u8868\u4e2d\u5fc3\u67e5\u770b\u3002", (String)"ReportShareConfigService_4", (String)"hrmp-hrptc-business", (Object[])new Object[0])));
        } else {
            messageInfo.setMessageContent((ILocaleString)reportShareConfigBo.getContent());
        }
        messageInfo.setSenderName(ResManager.loadKDString((String)"HR\u62a5\u8868\u4e2d\u5fc3", (String)"ReportShareConfigService_2", (String)"hrmp-hrptc-business", (Object[])new Object[0]));
        messageInfo.setEntityNumber("hrptmc_reportmanage");
        messageInfo.setNestAppid("2VKJ94YEM7AU");
        messageInfo.setTag(ResManager.loadKDString((String)"\u901a\u77e5", (String)"ReportShareConfigService_3", (String)"hrmp-hrptc-business", (Object[])new Object[0]));
        messageInfo.setNestEntityNumber("hrptmc_reportmanage");
        messageInfo.setBizDataId(reportShareConfigBo.getReportId());
        messageInfo.setUserIds(reportShareConfigBo.getReceiveUsers());
        messageInfo.setType("message");
        String noticeType = reportShareConfigBo.getNoticeType();
        StringBuilder notifyType = new StringBuilder();
        for (String noticeTypeItem : noticeType.split(",")) {
            if (!HRStringUtils.isNotEmpty((String)noticeTypeItem)) continue;
            MessageChannels channel = MessageChannels.getChannelValueOf((String)noticeTypeItem);
            notifyType.append(channel).append(",");
        }
        messageInfo.setNotifyType(notifyType.toString());
        ArrayList messageInfoList = Lists.newArrayListWithExpectedSize((int)1);
        messageInfoList.add(messageInfo);
        Map result = MessageCenterServiceHelper.batchSendMessages((List)messageInfoList);
        Boolean success = (Boolean)result.get("success");
        LOGGER.info("ReportShareConfigService.sendShareMessage result: {}", (Object)success);
        if (success != null && success.booleanValue()) {
            return true;
        }
        Map data = (Map)result.get("data");
        Map failMsgs = (Map)data.get("failMsgs");
        if (failMsgs != null) {
            for (String msg : failMsgs.values()) {
                LOGGER.error(msg);
            }
        }
        return false;
    }
}

