/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.subscribe;

import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrptc.common.constant.subscribe.ReportSubscribeConstants;
import kd.hr.hrptc.common.model.subscribe.ReportMySubscribeBo;
import kd.hr.hrptc.common.model.subscribe.ReportSubscribeConfigBo;
import kd.hr.hrptmc.business.repdesign.hisversion.ReportHisVersionService;

public class ReportMySubscribeService
implements ReportSubscribeConstants {
    private final HRBaseServiceHelper mySubscribeHelper = new HRBaseServiceHelper("hrptmc_mysubscribe");
    private static final Log LOGGER = LogFactory.getLog(ReportMySubscribeService.class);

    public ReportMySubscribeBo getMySubscribeBo(long subscribeId) {
        DynamicObject dy = this.mySubscribeHelper.loadSingle((Object)subscribeId);
        if (dy == null) {
            return null;
        }
        ReportMySubscribeBo mySubscribeBo = new ReportMySubscribeBo();
        mySubscribeBo.setId(Long.valueOf(dy.getLong("id")));
        long reportId = dy.getLong("report");
        mySubscribeBo.setReportId(Long.valueOf(reportId));
        Timestamp timestamp = (Timestamp)dy.getDate("createtime");
        mySubscribeBo.setSubscribeTime(new Date(timestamp.getTime()));
        Map reportNumberAndName = ReportHisVersionService.getInstance().getReportNumberAndName(reportId, mySubscribeBo.getSubscribeTime());
        mySubscribeBo.setReportNumber((String)reportNumberAndName.get("number"));
        LocaleString reportName = (LocaleString)reportNumberAndName.get("name");
        mySubscribeBo.setReportName(reportName.getLocaleValue());
        OrmLocaleValue name = (OrmLocaleValue)dy.getLocaleString("name");
        mySubscribeBo.setSubscribeName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)name));
        mySubscribeBo.setSubscribeUserId(Long.valueOf(dy.getDynamicObject("user").getLong("id")));
        DynamicObject subscribeDy = dy.getDynamicObject("subscriberecord");
        if (subscribeDy != null) {
            ReportSubscribeConfigBo subscribeConfigBo = new ReportSubscribeConfigBo();
            subscribeConfigBo.setId(Long.valueOf(dy.getDynamicObject("subscriberecord").getLong("id")));
            subscribeConfigBo.setReportId(Long.valueOf(dy.getDynamicObject("subscriberecord").getLong("report.id")));
            subscribeConfigBo.setReportNumber(dy.getDynamicObject("subscriberecord").getString("report.number"));
            mySubscribeBo.setSubscribeRecord(subscribeConfigBo);
        }
        mySubscribeBo.setRunStatus(dy.getString("runstatus"));
        mySubscribeBo.setStartTime(dy.getDate("starttime"));
        mySubscribeBo.setEndTime(dy.getDate("endtime"));
        mySubscribeBo.setTraceId(dy.getString("traceid"));
        mySubscribeBo.setSubscribeTime(dy.getDate("createtime"));
        mySubscribeBo.setCount(dy.getInt("count"));
        mySubscribeBo.setCycle(dy.getString("cycle"));
        if (dy.getDynamicObject("esindex") != null) {
            mySubscribeBo.setEsIndex(dy.getDynamicObject("esindex").getString("id"));
            mySubscribeBo.setBaseDataEsIndex(dy.getDynamicObject("esindex").getString("basedataesindex"));
        }
        mySubscribeBo.setDataQFilter(dy.getString("dataqfilter"));
        mySubscribeBo.setF7QFilter(dy.getString("f7qfilter"));
        mySubscribeBo.setAdminOrgF7QFilter(dy.getString("admorgf7qfilter"));
        return mySubscribeBo;
    }

    public Map<String, String> getMySubscribeF7QFilters(Long mySubscribeId) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        DynamicObject dy = this.mySubscribeHelper.queryOriginalOne("f7qfilter, admorgf7qfilter", (Object)mySubscribeId);
        if (dy != null) {
            resultMap.put("f7qfilter", dy.getString("f7qfilter"));
            resultMap.put("admorgf7qfilter", dy.getString("admorgf7qfilter"));
        }
        return resultMap;
    }

    public void saveMySubscribeBoList(List<ReportMySubscribeBo> mySubscribeBoList) {
        DynamicObjectCollection dys = new DynamicObjectCollection();
        for (ReportMySubscribeBo mySubscribeBo : mySubscribeBoList) {
            DynamicObject dy = this.generateMySubscribeDy(mySubscribeBo);
            dys.add((Object)dy);
        }
        this.mySubscribeHelper.save(dys);
    }

    public void saveMySubscribeBo(ReportMySubscribeBo mySubscribeBo) {
        DynamicObject dy = this.generateMySubscribeDy(mySubscribeBo);
        this.mySubscribeHelper.saveOne(dy);
    }

    private DynamicObject generateMySubscribeDy(ReportMySubscribeBo mySubscribeBo) {
        Long id = mySubscribeBo.getId();
        DynamicObject dy = this.mySubscribeHelper.generateEmptyDynamicObject();
        if (id != null && id != 0L) {
            if (this.mySubscribeHelper.isExists((Object)id)) {
                dy = this.mySubscribeHelper.loadSingle((Object)id);
            } else {
                dy.set("id", (Object)id);
            }
        }
        dy.set("name", (Object)mySubscribeBo.getSubscribeName());
        dy.set("createtime", (Object)mySubscribeBo.getSubscribeTime());
        if (mySubscribeBo.getSubscribeRecord() != null) {
            dy.set("subscriberecord", (Object)mySubscribeBo.getSubscribeRecord().getId());
        }
        dy.set("user", (Object)mySubscribeBo.getSubscribeUserId());
        dy.set("starttime", (Object)mySubscribeBo.getStartTime());
        dy.set("endtime", (Object)mySubscribeBo.getEndTime());
        dy.set("esindex", (Object)mySubscribeBo.getEsIndex());
        dy.set("report", (Object)mySubscribeBo.getReportId());
        dy.set("cycle", (Object)mySubscribeBo.getCycle());
        dy.set("runstatus", (Object)mySubscribeBo.getRunStatus());
        dy.set("count", (Object)mySubscribeBo.getCount());
        dy.set("traceid", (Object)mySubscribeBo.getTraceId());
        dy.set("errormsg", (Object)mySubscribeBo.getErrorMsg());
        dy.set("dataqfilter", (Object)mySubscribeBo.getDataQFilter());
        dy.set("f7qfilter", (Object)mySubscribeBo.getF7QFilter());
        return dy;
    }
}

