/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.subscribe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.server.ScheduleService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptc.business.servicehelper.ScheduleTaskServiceHelper;
import kd.hr.hrptc.common.constant.subscribe.ReportSubscribeConstants;
import kd.hr.hrptc.common.model.subscribe.ReportSubscribeConfigBo;

public class ReportSubscribeConfigService
implements ReportSubscribeConstants {
    private final HRBaseServiceHelper configHelper = new HRBaseServiceHelper("hrptmc_subscriberecord");
    private static final Log LOGGER = LogFactory.getLog(ReportSubscribeConfigService.class);
    private Random random = null;

    public Long getSubscribeReportId(long subscribeRecordId) {
        DynamicObject dy = this.configHelper.queryOriginalOne("report.id", (Object)subscribeRecordId);
        if (dy != null) {
            return dy.getLong("report.id");
        }
        return null;
    }

    public DynamicObject getSubscribeReportDy(long subscribeRecordId) {
        return this.configHelper.queryOriginalOne("report.id, report.name, report.number, reportgroup.id", (Object)subscribeRecordId);
    }

    public void saveReportSubscribeConfig(ReportSubscribeConfigBo reportSubscribeConfigBo) {
        DynamicObject reportSubscribeConfigDy = null;
        if (reportSubscribeConfigBo.getId() != null && this.configHelper.isExists((Object)reportSubscribeConfigBo.getId())) {
            reportSubscribeConfigDy = this.configHelper.loadSingle((Object)reportSubscribeConfigBo.getId());
        }
        if (reportSubscribeConfigDy == null) {
            reportSubscribeConfigDy = this.configHelper.generateEmptyDynamicObject();
        }
        reportSubscribeConfigDy.set("report", (Object)reportSubscribeConfigBo.getReportId());
        reportSubscribeConfigDy.set("reportgroup", (Object)reportSubscribeConfigBo.getReportGroupId());
        reportSubscribeConfigDy.set("user", (Object)reportSubscribeConfigBo.getUserId());
        reportSubscribeConfigDy.set("cycle", (Object)reportSubscribeConfigBo.getCycle());
        reportSubscribeConfigDy.set("cron", (Object)reportSubscribeConfigBo.getCronExpr());
        reportSubscribeConfigDy.set("cronlast", (Object)reportSubscribeConfigBo.getLastCronExpr());
        reportSubscribeConfigDy.set("scheplan", (Object)reportSubscribeConfigBo.getSchedulePlanId());
        reportSubscribeConfigDy.set("scheplanlast", (Object)reportSubscribeConfigBo.getSchedulePlanLastId());
        reportSubscribeConfigDy.set("schejob", (Object)reportSubscribeConfigBo.getScheduleJobId());
        reportSubscribeConfigDy.set("runstatus", (Object)reportSubscribeConfigBo.getRunStatus());
        this.configHelper.saveOne(reportSubscribeConfigDy);
    }

    public List<ReportSubscribeConfigBo> getReportSubscribeConfigs(long reportId, String cycle, String cron, String cronLast) {
        if (HRStringUtils.isEmpty((String)cronLast)) {
            cronLast = " ";
        }
        DynamicObject[] configDys = this.configHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("report", "=", (Object)reportId), new QFilter("cycle", "=", (Object)cycle), new QFilter("cron", "=", (Object)cron), new QFilter("cronlast", "=", (Object)cronLast)});
        ArrayList subscribeConfigBos = Lists.newArrayListWithExpectedSize((int)configDys.length);
        for (DynamicObject configDy : configDys) {
            ReportSubscribeConfigBo subscribeConfigBo = this.buildSubscribeConfigBo(configDy);
            subscribeConfigBos.add(subscribeConfigBo);
        }
        return subscribeConfigBos;
    }

    public ReportSubscribeConfigBo getReportSubscribeConfig(long reportId, long userId) {
        DynamicObject configDy = this.configHelper.loadDynamicObject(new QFilter[]{new QFilter("report", "=", (Object)reportId), new QFilter("user", "=", (Object)userId)});
        if (configDy == null) {
            return null;
        }
        return this.buildSubscribeConfigBo(configDy);
    }

    private ReportSubscribeConfigBo buildSubscribeConfigBo(DynamicObject configDy) {
        DynamicObject jobDy;
        DynamicObject planLastDy;
        ReportSubscribeConfigBo reportSubscribeConfigBo = new ReportSubscribeConfigBo();
        reportSubscribeConfigBo.setId(Long.valueOf(configDy.getLong("id")));
        reportSubscribeConfigBo.setReportId(Long.valueOf(configDy.getDynamicObject("report").getLong("id")));
        DynamicObject groupDy = configDy.getDynamicObject("reportgroup");
        if (groupDy != null) {
            reportSubscribeConfigBo.setReportGroupId(Long.valueOf(groupDy.getLong("id")));
        }
        reportSubscribeConfigBo.setUserId(Long.valueOf(configDy.getDynamicObject("user").getLong("id")));
        reportSubscribeConfigBo.setCycle(configDy.getString("cycle"));
        reportSubscribeConfigBo.setCronExpr(configDy.getString("cron"));
        reportSubscribeConfigBo.setLastCronExpr(configDy.getString("cronlast"));
        DynamicObject planDy = configDy.getDynamicObject("scheplan");
        if (planDy != null) {
            reportSubscribeConfigBo.setSchedulePlanId(planDy.getString("id"));
        }
        if ((planLastDy = configDy.getDynamicObject("scheplanlast")) != null) {
            reportSubscribeConfigBo.setSchedulePlanLastId(planLastDy.getString("id"));
        }
        if ((jobDy = configDy.getDynamicObject("schejob")) != null) {
            reportSubscribeConfigBo.setScheduleJobId(jobDy.getString("id"));
        }
        reportSubscribeConfigBo.setRunStatus(configDy.getString("runstatus"));
        return reportSubscribeConfigBo;
    }

    public void createSchedulePlan(ReportSubscribeConfigBo subscribeConfig, JobInfo jobInfo, long userId, String reportNumber, String reportName) {
        List<String> planIds = this.getPlanIdsByReportIdAndCycle(subscribeConfig.getReportId(), subscribeConfig.getCycle(), subscribeConfig.getCronExpr(), subscribeConfig.getLastCronExpr());
        ArrayList subscribeIds = Lists.newArrayListWithExpectedSize((int)1);
        subscribeIds.add(subscribeConfig.getId());
        if (planIds != null) {
            if (!HRStringUtils.equals((String)planIds.get(0), (String)subscribeConfig.getSchedulePlanId())) {
                this.deleteSchedulePlanForSubscribe(subscribeConfig.getSchedulePlanId(), subscribeIds);
            }
            if (!HRStringUtils.equals((String)planIds.get(1), (String)subscribeConfig.getSchedulePlanLastId())) {
                this.deleteSchedulePlanLastForSubscribe(subscribeConfig.getSchedulePlanLastId(), subscribeIds);
            }
            subscribeConfig.setSchedulePlanId(planIds.get(0));
            subscribeConfig.setSchedulePlanLastId(planIds.get(1));
        } else {
            boolean scheduleJobRefByOtherSubscribe = this.isSchedulePlanRefByOtherSubscribe(subscribeConfig.getSchedulePlanId(), subscribeConfig.getId());
            if (HRStringUtils.isNotEmpty((String)subscribeConfig.getSchedulePlanId()) && scheduleJobRefByOtherSubscribe) {
                subscribeConfig.setSchedulePlanId(null);
                subscribeConfig.setSchedulePlanLastId(null);
            }
            PlanInfo planInfo = this.generateSchedulePlanInfo(subscribeConfig.getSchedulePlanId(), jobInfo, subscribeConfig.getCycle(), userId, reportNumber, reportName, false);
            CronStruct cronParser = CronStruct.parse((String)subscribeConfig.getCronExpr());
            this.setSchedulePlanCron(planInfo, cronParser);
            String planInfoId = this.savePlanInfo(planInfo);
            subscribeConfig.setSchedulePlanId(planInfoId);
            if (HRStringUtils.isNotEmpty((String)subscribeConfig.getLastCronExpr())) {
                PlanInfo planInfoLast = this.generateSchedulePlanInfo(subscribeConfig.getSchedulePlanLastId(), jobInfo, subscribeConfig.getCycle(), userId, reportNumber, reportName, true);
                CronStruct cronLastParser = CronStruct.parse((String)subscribeConfig.getLastCronExpr());
                this.setSchedulePlanCron(planInfoLast, cronLastParser);
                String planInfoLastId = this.savePlanInfo(planInfoLast);
                subscribeConfig.setSchedulePlanLastId(planInfoLastId);
            } else if (HRStringUtils.isNotEmpty((String)subscribeConfig.getSchedulePlanLastId())) {
                this.deleteSchedulePlanLastForSubscribe(subscribeConfig.getSchedulePlanLastId(), subscribeIds);
                subscribeConfig.setSchedulePlanLastId(null);
            }
        }
    }

    private List<String> getPlanIdsByReportIdAndCycle(long reportId, String cycle, String cron, String cronLast) {
        DynamicObject subscribeDy;
        ArrayList planIdList = Lists.newArrayListWithExpectedSize((int)2);
        if (HRStringUtils.isEmpty((String)cronLast)) {
            cronLast = " ";
        }
        if ((subscribeDy = this.configHelper.queryOriginalOne("scheplan.id, scheplanlast.id", new QFilter[]{new QFilter("report", "=", (Object)reportId), new QFilter("cycle", "=", (Object)cycle), new QFilter("cron", "=", (Object)cron), new QFilter("cronlast", "=", (Object)cronLast)})) != null) {
            planIdList.add(subscribeDy.getString("scheplan.id"));
            planIdList.add(subscribeDy.getString("scheplanlast.id"));
            return planIdList;
        }
        return null;
    }

    private void deleteSchedulePlanForSubscribe(String planId, List<Long> subscribeIds) {
        if (HRStringUtils.isEmpty((String)planId)) {
            return;
        }
        DynamicObjectCollection subscribeDys = this.configHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("scheplan", "=", (Object)planId)});
        Set refIds = subscribeDys.stream().map(subscribeDy -> subscribeDy.getLong("id")).collect(Collectors.toSet());
        refIds.removeIf(subscribeIds::contains);
        if (refIds.isEmpty()) {
            this.deleteSchedulePlan(planId);
        }
    }

    private void deleteSchedulePlanLastForSubscribe(String planLastId, List<Long> subscribeIds) {
        if (HRStringUtils.isEmpty((String)planLastId)) {
            return;
        }
        DynamicObjectCollection subscribeDys = this.configHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("scheplanlast", "=", (Object)planLastId)});
        Set refIds = subscribeDys.stream().map(subscribeDy -> subscribeDy.getLong("id")).collect(Collectors.toSet());
        refIds.removeIf(subscribeIds::contains);
        if (refIds.isEmpty()) {
            this.deleteSchedulePlan(planLastId);
        }
    }

    public void deleteSubscribe(Long reportId) {
        DynamicObjectCollection subscribeConfigDys = this.configHelper.queryOriginalCollection("id, scheplan.id, scheplanlast.id, schejob.id", new QFilter[]{new QFilter("report", "=", (Object)reportId)});
        if (subscribeConfigDys.isEmpty()) {
            return;
        }
        List<Object> subscribeConfigIds = subscribeConfigDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Throwable throwable = null;
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                List<Long> subscribeIds = subscribeConfigDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
                for (DynamicObject subscribeConfigDy : subscribeConfigDys) {
                    String planId = subscribeConfigDy.getString("scheplan.id");
                    String planLastId = subscribeConfigDy.getString("scheplanlast.id");
                    String jobId = subscribeConfigDy.getString("schejob.id");
                    if (HRStringUtils.isNotEmpty((String)planId)) {
                        this.deleteSchedulePlanForSubscribe(planId, subscribeIds);
                    }
                    if (HRStringUtils.isNotEmpty((String)planLastId)) {
                        this.deleteSchedulePlanLastForSubscribe(planLastId, subscribeIds);
                    }
                    if (!HRStringUtils.isNotEmpty((String)jobId)) continue;
                    this.deleteScheduleJobForSubscribe(jobId, subscribeIds);
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
                throw new KDBizException((Throwable)exception, new ErrorCode("", "delete scheduleJob and schedulePlan error."), new Object[0]);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        this.configHelper.delete(subscribeConfigIds.toArray(new Object[0]));
        for (Long l : subscribeConfigIds) {
            ScheduleTaskServiceHelper.stop(l, false);
        }
    }

    public void cancelSubscribe(ReportSubscribeConfigBo reportSubscribeConfigBo) {
        try {
            this.deleteSchedulePlanAndJob(reportSubscribeConfigBo.getSchedulePlanId(), reportSubscribeConfigBo.getSchedulePlanLastId(), reportSubscribeConfigBo.getScheduleJobId(), reportSubscribeConfigBo.getId());
            this.configHelper.deleteOne((Object)reportSubscribeConfigBo.getId());
            ScheduleTaskServiceHelper.stop(reportSubscribeConfigBo.getId(), false);
        }
        catch (Exception exception) {
            LOGGER.error("ReportSubscribeConfigService cancelSubscribe error: ", (Throwable)exception);
        }
    }

    public void cancelSubscribeForCancelReportPerm(long userId, List<Long> reportIds) {
        DynamicObject[] configDys;
        for (DynamicObject configDy : configDys = this.configHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("report", "in", reportIds), new QFilter("user", "=", (Object)userId)})) {
            ReportSubscribeConfigBo reportSubscribeConfigBo = this.buildSubscribeConfigBo(configDy);
            this.cancelSubscribe(reportSubscribeConfigBo);
        }
    }

    public void cancelSubscribeForCancelUserPerm(long reportId, List<Long> userIds) {
        DynamicObject[] configDys;
        for (DynamicObject configDy : configDys = this.configHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("report", "=", (Object)reportId), new QFilter("user", "in", userIds)})) {
            ReportSubscribeConfigBo reportSubscribeConfigBo = this.buildSubscribeConfigBo(configDy);
            this.cancelSubscribe(reportSubscribeConfigBo);
        }
    }

    public void deleteSchedulePlanAndJob(String planId, String planLastId, String jobId, Long subscribeId) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                ArrayList subscribeIds = Lists.newArrayListWithExpectedSize((int)1);
                subscribeIds.add(subscribeId);
                if (HRStringUtils.isNotEmpty((String)planId)) {
                    this.deleteSchedulePlanForSubscribe(planId, subscribeIds);
                }
                if (HRStringUtils.isNotEmpty((String)planLastId)) {
                    this.deleteSchedulePlanLastForSubscribe(planLastId, subscribeIds);
                }
                if (HRStringUtils.isNotEmpty((String)jobId)) {
                    this.deleteScheduleJobForSubscribe(jobId, subscribeIds);
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
                LOGGER.error((Throwable)exception);
                throw new KDBizException("delete scheduleJob and schedulePlan error.");
            }
        }
    }

    public void deleteSchedulePlan(String planId) {
        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
        scheduleDao.delete(planId);
    }

    public void deleteScheduleJob(String jobId) {
        JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
        jobDao.delete(jobId);
    }

    public JobInfo createScheduleJob(long reportId, ReportSubscribeConfigBo subscribeConfig, String reportNumber, String reportName) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId("hrptmc");
        jobInfo.setJobType(JobType.BIZ);
        String suffix = this.getRandomInt(10);
        jobInfo.setName("hrptmc_" + reportName + "_" + suffix);
        if (jobInfo.getName().length() > 50) {
            jobInfo.setName(jobInfo.getName().substring(0, 50));
        }
        jobInfo.setNumber("hrptmc_" + reportNumber + "_" + suffix);
        if (jobInfo.getNumber().length() > 50) {
            jobInfo.setNumber(jobInfo.getNumber().substring(0, 50));
        }
        String id = ID.genStringId();
        jobInfo.setId(id);
        jobInfo.setTaskDefineId("4917Y29EFG8/");
        this.setScheduleJobParams(jobInfo, reportId, subscribeConfig);
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        proxy.createJob(jobInfo);
        return jobInfo;
    }

    public void setScheduleJobParams(JobInfo jobInfo, long reportId, ReportSubscribeConfigBo subscribeConfig) {
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("reportId", String.valueOf(reportId));
        params.put("cycle", subscribeConfig.getCycle());
        params.put("cron", subscribeConfig.getCronExpr());
        params.put("cronLast", subscribeConfig.getLastCronExpr());
        jobInfo.setParams((Map)params);
    }

    public String getScheduleJobByReportAndCycle(long reportId, String cycle, String cron, String cronLast) {
        DynamicObject subscribeDy;
        if (HRStringUtils.isEmpty((String)cronLast)) {
            cronLast = " ";
        }
        if ((subscribeDy = this.configHelper.queryOriginalOne("schejob.id", new QFilter[]{new QFilter("report", "=", (Object)reportId), new QFilter("cycle", "=", (Object)cycle), new QFilter("cron", "=", (Object)cron), new QFilter("cronlast", "=", (Object)cronLast)})) != null) {
            return subscribeDy.getString("schejob.id");
        }
        return null;
    }

    public void deleteScheduleJobForSubscribe(String jobId, List<Long> subscribeIds) {
        if (subscribeIds == null) {
            return;
        }
        subscribeIds.removeIf(Objects::isNull);
        if (subscribeIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection subscribeDys = this.configHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("schejob", "=", (Object)jobId)});
        Set refIds = subscribeDys.stream().map(subscribeDy -> subscribeDy.getLong("id")).collect(Collectors.toSet());
        refIds.removeIf(subscribeIds::contains);
        if (refIds.isEmpty()) {
            this.deleteScheduleJob(jobId);
        }
    }

    public boolean isSchedulePlanRefByOtherSubscribe(String planId, Long currentSubscribeId) {
        if (HRStringUtils.isEmpty((String)planId) || currentSubscribeId == null || currentSubscribeId == 0L) {
            return false;
        }
        DynamicObjectCollection subscribeDys = this.configHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("scheplan", "=", (Object)planId)});
        Set refIds = subscribeDys.stream().map(subscribeDy -> subscribeDy.getLong("id")).collect(Collectors.toSet());
        refIds.removeIf(currentSubscribeId::equals);
        return !refIds.isEmpty();
    }

    public boolean isScheduleJobRefByOtherSubscribe(String jobId, Long currentSubscribeId) {
        if (HRStringUtils.isEmpty((String)jobId) || currentSubscribeId == null || currentSubscribeId == 0L) {
            return false;
        }
        DynamicObjectCollection subscribeDys = this.configHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("schejob", "=", (Object)jobId)});
        Set refIds = subscribeDys.stream().map(subscribeDy -> subscribeDy.getLong("id")).collect(Collectors.toSet());
        refIds.removeIf(currentSubscribeId::equals);
        return !refIds.isEmpty();
    }

    public OrmLocaleValue getReportName(long reportId) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObject reportDy = helper.queryOne("name", new QFilter[]{new QFilter("id", "=", (Object)reportId)});
        return (OrmLocaleValue)reportDy.getLocaleString("name");
    }

    private String savePlanInfo(PlanInfo planInfo) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
        if (HRStringUtils.isNotEmpty((String)planInfo.getId()) && scheduleDao.existed(planInfo.getId())) {
            return proxy.updatePlan(planInfo);
        }
        return proxy.createPlan(planInfo);
    }

    private void setSchedulePlanCron(PlanInfo planInfo, CronStruct cronParser) {
        planInfo.setCronExpression(cronParser.toString());
        planInfo.setDaysExp(HRStringUtils.equals((String)cronParser.getDayOfMonth(), (String)"?") ? null : cronParser.getDayOfMonth());
        planInfo.setMonthsExp(cronParser.getMonth());
        planInfo.setWeekdaysExp(HRStringUtils.equals((String)cronParser.getDayOfWeek(), (String)"?") ? null : cronParser.getDayOfWeek());
    }

    private PlanInfo generateSchedulePlanInfo(String planId, JobInfo jobInfo, String cycle, long userId, String reportNumber, String reportName, boolean isLast) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setId(planId);
        planInfo.setJobId(jobInfo.getId());
        String suffix = this.getRandomInt(10);
        String name = "hrptmc_" + reportName + "_" + suffix;
        if (isLast) {
            name = "L_" + name;
        }
        planInfo.setName(name);
        if (planInfo.getName().length() > 50) {
            planInfo.setName(planInfo.getName().substring(0, 50));
        }
        String number = "hrptmc_" + reportNumber + "_" + suffix;
        if (isLast) {
            number = "L_" + number;
        }
        planInfo.setNumber(number);
        if (planInfo.getNumber().length() > 50) {
            planInfo.setNumber(planInfo.getNumber().substring(0, 50));
        }
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.set(2099, 11, 31);
        planInfo.setStartTime(startCalendar);
        planInfo.setEndTime(endCalendar);
        planInfo.setRepeatMode(this.getRepeatMode(cycle));
        return planInfo;
    }

    private RepeatModeEnum getRepeatMode(String cycle) {
        RepeatModeEnum repeatMode = RepeatModeEnum.NONE;
        switch (cycle) {
            case "day": {
                repeatMode = RepeatModeEnum.ByDays;
                break;
            }
            case "week": {
                repeatMode = RepeatModeEnum.ByWeeks;
                break;
            }
            case "month": {
                repeatMode = RepeatModeEnum.ByMonths;
                break;
            }
            case "quarter": 
            case "year": {
                repeatMode = RepeatModeEnum.ByYears;
                break;
            }
        }
        return repeatMode;
    }

    private String getRandomInt(int len) {
        if (this.random == null) {
            try {
                this.random = SecureRandom.getInstanceStrong();
            }
            catch (NoSuchAlgorithmException e) {
                throw new KDBizException((Throwable)e, new ErrorCode("100", "SecureRandom error."), new Object[]{"SecureRandom error."});
            }
        }
        StringBuilder rs = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            rs.append(this.random.nextInt(10));
        }
        return rs.toString();
    }
}

