/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.subscribe;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections.CollectionUtils;

public class SubscribeService {
    private static final Log LOGGER = LogFactory.getLog(SubscribeService.class);
    private static final String entityMySubscribe = "hrptmc_mysubscribe";
    private final HRBaseServiceHelper mySubService = new HRBaseServiceHelper("hrptmc_mysubscribe");
    private static final String fieldRunStatus = "runstatus";
    private static final String runStatusFinish = "3";
    private static final String runStatusMerge = "1";

    public static SubscribeService getInstance() {
        return Instance.INSTANCE;
    }

    public Map<Long, List<String>> queryEffEsIdxGrpByRpt() {
        QFilter statusFilter = new QFilter(fieldRunStatus, "in", (Object)new String[]{runStatusFinish, runStatusMerge});
        DynamicObject[] dynamicObjects = this.mySubService.queryOriginalArray("esindex,report", new QFilter[]{statusFilter});
        Map<Long, List<String>> reportEsIdxMap = Arrays.stream(dynamicObjects).filter(dyo -> HRStringUtils.isNotEmpty((String)dyo.getString("esindex"))).collect(Collectors.groupingBy(dyo -> dyo.getLong("report"), Collectors.mapping(dyo -> dyo.getString("esindex"), Collectors.toList())));
        return reportEsIdxMap;
    }

    public Map<Long, List<String>> queryEffBdEsIdxGrpByRpt() {
        QFilter statusFilter = new QFilter(fieldRunStatus, "in", (Object)new String[]{runStatusFinish, runStatusMerge});
        DynamicObject[] dynamicObjects = this.mySubService.queryOriginalArray("esindex.basedataesindex,report", new QFilter[]{statusFilter});
        Map<Long, List<String>> reportEsIdxMap = Arrays.stream(dynamicObjects).filter(dyo -> HRStringUtils.isNotEmpty((String)dyo.getString("esindex.basedataesindex"))).collect(Collectors.groupingBy(dyo -> dyo.getLong("report"), Collectors.mapping(dyo -> dyo.getString("esindex.basedataesindex"), Collectors.toList())));
        return reportEsIdxMap;
    }

    public DynamicObject[] querySubData(Long reportId, Date startTime, Date endTime) {
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(10);
        qFilterList.add(new QFilter("report", "=", (Object)reportId));
        qFilterList.add(new QFilter("esindex", "!=", (Object)Character.valueOf(' ')));
        if (startTime != null) {
            qFilterList.add(new QFilter("createtime", ">=", (Object)startTime));
        }
        if (endTime != null) {
            qFilterList.add(new QFilter("createtime", "<=", (Object)endTime));
        }
        return this.mySubService.queryOriginalArray("id,name,createtime,user.name,esindex,count", qFilterList.toArray(new QFilter[0]));
    }

    public void clearEsIdx(Set<Long> pkSet) {
        LOGGER.info("clearEsIdx pkSet:{}", pkSet);
        if (CollectionUtils.isEmpty(pkSet)) {
            return;
        }
        DynamicObject[] dynamicObjects = this.mySubService.query("id,modifier,modifytime,esindex,errormsg", new QFilter[]{new QFilter("id", "in", pkSet)});
        if (dynamicObjects.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            dynamicObject.set("esindex", (Object)" ");
            HRBaseUtils.setModifyField((DynamicObject)dynamicObject);
            dynamicObject.set("errormsg", (Object)("clear;" + dynamicObject.getString("errormsg")));
        }
        this.mySubService.update(dynamicObjects);
    }

    private static class Instance {
        private static final SubscribeService INSTANCE = new SubscribeService();

        private Instance() {
        }
    }
}

