/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.task;

import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hrptc.business.datamerge.EsDataClearService;
import org.apache.commons.lang3.StringUtils;

public class EsDataClearTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(EsDataClearTask.class);
    private String paramBeforeDay = "beforeday";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.info("EsDataClearTask_param:{}", map);
        Object paramVal = map.get(this.paramBeforeDay);
        int beforeDay = 30;
        try {
            if (paramVal != null && StringUtils.isNumeric((CharSequence)paramVal.toString())) {
                beforeDay = Integer.parseInt(paramVal.toString());
            }
        }
        catch (Exception exception) {
            LOGGER.error("EsDataClearTask_param parse error,", (Throwable)exception);
        }
        LOGGER.info("EsDataClearTask Clear data from {} days ago ", (Object)beforeDay);
        Date curDate = new Date();
        if (beforeDay > 0) {
            beforeDay = -beforeDay;
        } else if (beforeDay == 0) {
            beforeDay = -1;
        }
        curDate = HRDateTimeUtils.addDays((int)beforeDay, (Date)curDate);
        LOGGER.info("EsDataClearTask Clear data before :{} ", (Object)HRDateTimeUtils.format((Date)curDate));
        EsDataClearService.deleteUselessData(curDate);
    }
}

