/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptc.business.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.list.IListView;
import kd.hr.hbp.common.util.HRStringUtils;

public class HRTreeSearchTool {
    private static TreeNode currentNode = null;

    private HRTreeSearchTool() {
    }

    public static void doSearchNode(IFormView view, TreeNode rootNode, IPageCache pageCache, String searchText) {
        List treeNodes;
        boolean flag;
        if (HRStringUtils.isEmpty((String)searchText)) {
            return;
        }
        String searchNodesCacheKey = view.getPageId() + "_searchNodes";
        String matchNodesCacheKey = view.getPageId() + "_matchNodes";
        String oldSearchTextCacheKey = view.getPageId() + "_oldSearchText";
        String searchIndexCacheKey = view.getPageId() + "_searchIndex";
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        String matchNodesCache = pageCache.get(matchNodesCacheKey);
        boolean bl = flag = (oldSearchText == null || oldSearchText.equals(searchText)) && !StringUtils.isBlank((CharSequence)matchNodesCache);
        if (flag) {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            treeNodes = StringUtils.isBlank((CharSequence)searchNodesCache) ? SerializationUtils.fromJsonStringToList((String)matchNodesCache, TreeNode.class) : SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
        } else {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> {}, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        }
        if (treeNodes.isEmpty()) {
            treeNodes = rootNode.getTreeNodeListByText(new LinkedList(), searchText, node -> {}, 16);
            pageCache.put(matchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
            pageCache.put(searchIndexCacheKey, String.valueOf(0));
        } else {
            TreeView treeView = ((IListView)view).getTreeListView().getTreeView();
            if (StringUtils.isNotEmpty((CharSequence)pageCache.get(searchIndexCacheKey))) {
                int indexCache = Integer.parseInt(pageCache.get(searchIndexCacheKey));
                if (indexCache == treeNodes.size()) {
                    indexCache = 0;
                }
                HRTreeSearchTool.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(indexCache));
                pageCache.put(searchIndexCacheKey, String.valueOf(++indexCache));
            } else {
                HRTreeSearchTool.focusNode(treeView, rootNode, (TreeNode)treeNodes.get(0));
                pageCache.put(searchIndexCacheKey, String.valueOf(0));
            }
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString((Object)treeNodes));
        }
    }

    public static List<TreeNode> getChildrenNodes(ITreeModel tv1) {
        String currentNodeId = (String)tv1.getCurrentNodeId();
        HRTreeSearchTool.findNodeById(currentNodeId, tv1.getRoot());
        return currentNode == null ? new ArrayList() : currentNode.getChildren();
    }

    public static List<TreeNode> getChildrenNodes(ITreeModel tv1, String currentNodeId) {
        HRTreeSearchTool.findNodeById(currentNodeId, tv1.getRoot());
        return currentNode == null ? new ArrayList() : currentNode.getChildren();
    }

    public static void resetCurrentNode() {
        currentNode = null;
    }

    private static void findNodeById(String nodeId, TreeNode node) {
        if (HRStringUtils.equals((String)node.getId(), (String)nodeId)) {
            currentNode = node;
        } else {
            List children = node.getChildren();
            if (children == null || children.size() == 0) {
                return;
            }
            for (TreeNode child : node.getChildren()) {
                HRTreeSearchTool.findNodeById(nodeId, child);
            }
        }
    }

    private static void focusNode(TreeView treeView, TreeNode rootNode, TreeNode treeNode) {
        HRTreeSearchTool.expandParents(treeView, rootNode, treeNode);
        treeView.showNode(treeNode.getParentid());
        treeView.focusNode(treeNode);
        treeView.treeNodeClick(treeNode.getParentid(), treeNode.getId());
    }

    private static void expandParents(TreeView treeView, TreeNode rootNode, TreeNode node) {
        String parentid = node.getParentid();
        if (StringUtils.isNotBlank((CharSequence)parentid)) {
            TreeNode pt = rootNode.getTreeNode(parentid, 20);
            if (pt != null) {
                HRTreeSearchTool.expandParents(treeView, rootNode, pt);
                treeView.expand(parentid);
                if (pt == rootNode) {
                    treeView.updateNode(node);
                }
            } else {
                treeView.updateNode(node);
            }
        } else {
            treeView.updateNode(node);
        }
    }
}

