/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.bizcorehr.business.preindex.service.haos;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.preindex.IPresetIndexService;
import kd.hr.hrptmc.business.preindex.model.PresetIndexBusinessServiceParam;
import kd.hr.hrptmc.common.model.preindex.DimMapEntryBo;

public class StaffPresetIndexCommonService
implements IPresetIndexService {
    private static final Log LOGGER = LogFactory.getLog(StaffPresetIndexCommonService.class);
    private static final String ROW_FIELD_MONTH = "month!fn_month";
    private static final String PARAM_QUERYDATE = "querydate";
    private static final String PARAM_DIM_ADMINORG_NUMBER = "adminorgnumber";
    private static final String PARAM_DIM_ADMINORG_NAME = "adminorgname";
    private static final String PARAM_DIM_FIELD = "dutyworkrole";
    private static final Map<String, String> preindexNumberToKeyMap = ImmutableMap.of((Object)"kdhr_staff_presetindex_hold", (Object)"holdStaff", (Object)"kdhr_staff_presetindex_remain", (Object)"remainStaffNum", (Object)"kdhr_staff_presetindex_entryin", (Object)"entryInTransit", (Object)"kdhr_staff_presetindex_transferin", (Object)"transferInTransit", (Object)"kdhr_staff_presetindex_transferout", (Object)"transferOutTransit", (Object)"kdhr_staff_presetindex_departin", (Object)"departInTransit");
    private String queryYear;
    private String queryMonth;
    private int keyDimFiled_index = -1;
    private int monthField_index = -1;
    private boolean iswrong;
    private boolean queryOrgStaff = true;
    private String preIndexValueKey;
    private String traceId;
    private static Map<String, Map<String, Map<String, Map<String, Object>>>> cache = Maps.newConcurrentMap();
    private static Set<String> requestContextCache = Sets.newConcurrentHashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> calculate(PresetIndexBusinessServiceParam presetIndexBusinessServiceParam) {
        Map<String, Integer> idDateKeyToValueMap;
        LOGGER.info("staff_preindex_calculate");
        this.init(presetIndexBusinessServiceParam);
        if (this.iswrong) {
            return Lists.newArrayList();
        }
        List valueList = presetIndexBusinessServiceParam.getValueList();
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)valueList.size());
        HashMap dateToIdsMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap indexKeyMap = Maps.newHashMapWithExpectedSize((int)valueList.size());
        for (int i = 0; i < valueList.size(); ++i) {
            Object[] object = (Object[])valueList.get(i);
            long keyDimFiledId = (Long)object[this.keyDimFiled_index];
            String month = this.monthField_index == -1 ? this.queryMonth : (String)object[this.monthField_index];
            Date date = this.getDate(this.queryYear, month);
            List keyDimFiledIdList = dateToIdsMap.getOrDefault(date, new ArrayList());
            keyDimFiledIdList.add(keyDimFiledId);
            dateToIdsMap.put(date, keyDimFiledIdList);
            String key = this.getKey(String.valueOf(keyDimFiledId), date);
            indexKeyMap.put(i, key);
        }
        try {
            idDateKeyToValueMap = this.getPresetIndexValue(dateToIdsMap);
        }
        catch (Exception e2) {
            LOGGER.error("staff_preindex_calculate_error :" + e2);
            ArrayList keyDimFiledId = resultList;
            return keyDimFiledId;
        }
        finally {
            cache.remove(this.getCacheKey());
            requestContextCache.removeIf(e -> e.startsWith(this.getCacheKey()));
        }
        for (int i = 0; i < valueList.size(); ++i) {
            String key = (String)indexKeyMap.get(i);
            int value = idDateKeyToValueMap.getOrDefault(key, 0);
            resultList.add(value);
        }
        return resultList;
    }

    private void init(PresetIndexBusinessServiceParam presetIndexBusinessServiceParam) {
        List rowList = presetIndexBusinessServiceParam.getRowList();
        if (CollectionUtils.isEmpty((Collection)rowList)) {
            this.iswrong = true;
            return;
        }
        List valueList = presetIndexBusinessServiceParam.getValueList();
        if (CollectionUtils.isEmpty((Collection)valueList)) {
            this.iswrong = true;
            return;
        }
        Date queryDate = this.findQueryDate(presetIndexBusinessServiceParam);
        if (queryDate == null) {
            this.iswrong = true;
            return;
        }
        this.keyDimFiled_index = this.findDimKeyIndex(presetIndexBusinessServiceParam);
        if (this.keyDimFiled_index == -1) {
            this.iswrong = true;
            return;
        }
        this.queryYear = HRDateTimeUtils.format((Date)queryDate, (String)"yyyy");
        this.monthField_index = presetIndexBusinessServiceParam.getRowList().indexOf(ROW_FIELD_MONTH);
        if (this.monthField_index == -1) {
            this.queryMonth = HRDateTimeUtils.format((Date)queryDate, (String)"MM");
        }
        String preindexnumber = presetIndexBusinessServiceParam.getDimMapBo().getPreIndexNumber();
        this.preIndexValueKey = preindexNumberToKeyMap.get(preindexnumber);
        this.traceId = presetIndexBusinessServiceParam.getTraceId();
    }

    private Date getDate(String year, String month) {
        String monthValue = month.substring(0, 2);
        String date = year + "-" + monthValue + "-" + HRDateTimeUtils.daysOfMonth((int)Integer.parseInt(year), (int)Integer.parseInt(monthValue));
        try {
            return HRDateTimeUtils.parseDate((String)date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private Map<String, Integer> getPresetIndexValue(Map<Date, List<Long>> dateToIdsMap) {
        HashMap idDateKeyToValueMap = Maps.newHashMap();
        while (dateToIdsMap.size() > 0) {
            Iterator<Map.Entry<Date, List<Long>>> iterator = dateToIdsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map<String, Map<String, Object>> occupyResultMap;
                Map.Entry<Date, List<Long>> next = iterator.next();
                Date date = next.getKey();
                List<Long> ids = next.getValue();
                String dateKey = this.getDateStr(date);
                boolean hasLock = requestContextCache.add(this.getCacheKey() + dateKey);
                hasLock = true;
                if (hasLock) {
                    occupyResultMap = this.getPresetIndexValueFromService(date, ids);
                    iterator.remove();
                } else {
                    Map<String, Map<String, Map<String, Object>>> cacheMap = cache.get(this.getCacheKey());
                    if (cacheMap == null || (occupyResultMap = cacheMap.get(dateKey)) == null) continue;
                    iterator.remove();
                }
                occupyResultMap.forEach((id, valueMap) -> {
                    int value = valueMap.getOrDefault(this.preIndexValueKey, 0);
                    if (HRStringUtils.equals((String)this.preIndexValueKey, (String)"holdStaff")) {
                        int inTranHoldStaff = valueMap.getOrDefault("inTranHoldStaff", 0);
                        int inTranReleaseStaff = valueMap.getOrDefault("inTranReleaseStaff", 0);
                        value = value + inTranHoldStaff + inTranReleaseStaff;
                    }
                    String key = this.getKey((String)id, date);
                    idDateKeyToValueMap.put(key, value);
                });
            }
        }
        return idDateKeyToValueMap;
    }

    private Map<String, Map<String, Object>> getPresetIndexValueFromService(Date date, List<Long> ids) {
        Map<Object, Object> cacheMap = cache.get(this.getCacheKey());
        if (cacheMap == null) {
            cacheMap = Maps.newConcurrentMap();
            Map<String, Map<String, Map<String, Object>>> oldMap = cache.putIfAbsent(this.getCacheKey(), (Map<String, Map<String, Map<String, Object>>>)cacheMap);
            if (oldMap != null) {
                cacheMap = oldMap;
            }
        }
        Map occupyResultMap = null;
        if (this.queryOrgStaff) {
            StaffResponse map = (StaffResponse)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"haos", (String)"IHAOSStaffService", (String)"queryUseStaffInfo", (Object[])new Object[]{date, ids});
            if (map != null) {
                occupyResultMap = (Map)map.getData();
            }
        } else {
            StaffResponse map = (StaffResponse)HRMServiceHelper.invokeBizService((String)"hrmp", (String)"haos", (String)"IHAOSStaffService", (String)"queryPositionStaffInfo", (Object[])new Object[]{date, ids});
            if (map != null) {
                occupyResultMap = (Map)map.getData();
            }
        }
        if (occupyResultMap == null) {
            occupyResultMap = Maps.newHashMap();
        }
        cacheMap.put(this.getDateStr(date), occupyResultMap);
        return occupyResultMap;
    }

    private String getDateStr(Date date) {
        return HRDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
    }

    private String getCacheKey() {
        return this.traceId;
    }

    private String getKey(String id, Date date) {
        return id + "|" + HRDateTimeUtils.format((Date)date);
    }

    private Date findQueryDate(PresetIndexBusinessServiceParam presetIndexBusinessServiceParam) {
        List paramList = presetIndexBusinessServiceParam.getParamList();
        for (QFilter qFilter : paramList) {
            if (HRStringUtils.equals((String)PARAM_QUERYDATE, (String)qFilter.getProperty())) {
                return (Date)qFilter.getValue();
            }
            List nestList = qFilter.getNests(false);
            if (nestList == null) continue;
            for (QFilter.QFilterNest nest : nestList) {
                QFilter qFilterNest = nest.getFilter();
                if (!HRStringUtils.equals((String)PARAM_QUERYDATE, (String)qFilterNest.getProperty())) continue;
                return (Date)qFilterNest.getValue();
            }
        }
        return null;
    }

    private int findDimKeyIndex(PresetIndexBusinessServiceParam presetIndexBusinessServiceParam) {
        List dimMapEntryBosList = presetIndexBusinessServiceParam.getDimMapBo().getDimMapEntryBos();
        if (CollectionUtils.isEmpty((Collection)dimMapEntryBosList)) {
            return -1;
        }
        List rowList = presetIndexBusinessServiceParam.getRowList();
        int adminorg_index = -1;
        for (DimMapEntryBo entryBo : dimMapEntryBosList) {
            String preindexparam = entryBo.getPreIndexParam();
            String dimNumber = entryBo.getDimNumber();
            String[] keySplit = dimNumber.split("\\.");
            String trueDimkey = keySplit[0] + ".id";
            if (HRStringUtils.equals((String)preindexparam, (String)PARAM_DIM_FIELD)) {
                this.queryOrgStaff = false;
                return rowList.indexOf(trueDimkey);
            }
            if (!HRStringUtils.equals((String)preindexparam, (String)PARAM_DIM_ADMINORG_NUMBER) && !HRStringUtils.equals((String)preindexparam, (String)PARAM_DIM_ADMINORG_NAME)) continue;
            adminorg_index = rowList.indexOf(trueDimkey);
        }
        return adminorg_index;
    }
}

