/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.bizcorehr.business.preindex.service.hpfs;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.model.org.staff.StaffResponse;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.preindex.IPresetIndexService;
import kd.hr.hrptmc.business.preindex.model.PresetIndexBusinessServiceParam;
import kd.hr.hrptmc.business.repdesign.info.AdminOrgSummaryInfo;

public class PersonStatisticsPresetIndexService
implements IPresetIndexService {
    private static final Log LOGGER = LogFactory.getLog(PersonStatisticsPresetIndexService.class);
    private static final String ALGO_KEY = "PersonflowPresetIndexService_calculate";

    public List<Object> calculate(PresetIndexBusinessServiceParam params) {
        long startTime = System.currentTimeMillis();
        List rowList = params.getRowList();
        List columnList = params.getColumnList();
        Map dimMap = params.getDimMap();
        List valueList = params.getValueList();
        List paramList = params.getParamList();
        AdminOrgSummaryInfo adminOrgSummaryInfo = params.getAdminOrgSummaryInfo();
        LOGGER.info("PersonStatisticsPresetIndexService calculate params.getRowList():{}", (Object)rowList);
        LOGGER.info("PersonStatisticsPresetIndexService calculate params.getColumnList():{}", (Object)columnList);
        LOGGER.info("PersonStatisticsPresetIndexService calculate params.getDimMap():{}", (Object)dimMap);
        LOGGER.info("PersonStatisticsPresetIndexService calculate params.getParamList():{}", (Object)paramList);
        LOGGER.info("PersonStatisticsPresetIndexService calculate params.getValueList():{}", (Object)SerializationUtils.toJsonString((Object)valueList));
        ArrayList resultList = Lists.newArrayListWithExpectedSize((int)(valueList != null ? valueList.size() : 16));
        if (CollectionUtils.isEmpty((Map)dimMap) || CollectionUtils.isEmpty((Collection)paramList) || CollectionUtils.isEmpty((Collection)valueList)) {
            return resultList;
        }
        Object dateStr = null;
        for (QFilter qFilter : paramList) {
            QFilter.QFilterNest nest;
            if (!Objects.isNull(dateStr) || !Objects.isNull(dateStr = this.analyzeFilter(qFilter))) break;
            List nestList = qFilter.getNests(false);
            Iterator iterator = nestList.iterator();
            while (iterator.hasNext() && Objects.isNull(dateStr = this.analyzeFilter((nest = (QFilter.QFilterNest)iterator.next()).getFilter()))) {
            }
        }
        LOGGER.info("PersonStatisticsPresetIndexService calculate dateStr():{}", dateStr);
        if (Objects.isNull(dateStr)) {
            return resultList;
        }
        int index = this.parseSelectField(params);
        LOGGER.info("PersonStatisticsPresetIndexService calculate index():{}", (Object)index);
        ArrayList orgIds = Lists.newArrayListWithCapacity((int)16);
        for (Object[] objects : valueList) {
            Object object = objects[index];
            if (!(object instanceof Long) || orgIds.contains(object)) continue;
            orgIds.add((Long)object);
        }
        LOGGER.info("PersonStatisticsPresetIndexService calculate orgIds():{}", (Object)orgIds);
        try {
            Map data;
            StaffResponse staffResponse;
            Date date = HRDateTimeUtils.parseDate((String)HRDateTimeUtils.formatDate((Date)((Date)dateStr)), (String)"yyyy-MM");
            if (!this.checkNeedOrgGroup(adminOrgSummaryInfo)) {
                LOGGER.info("PersonStatisticsPresetIndexService not sub");
                staffResponse = (StaffResponse)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStaffService", (String)"queryUseStaffInfo", (Object[])new Object[]{date, orgIds});
                LOGGER.info("PersonStatisticsPresetIndexService 0 staffResponse.toString());" + staffResponse.toString());
                if (staffResponse.isSuccess()) {
                    data = (Map)staffResponse.getData();
                    for (int i = 0; i < valueList.size(); ++i) {
                        if (valueList.get(i) == null) continue;
                        Object object = ((Object[])valueList.get(i))[index];
                        String str = String.valueOf(object);
                        Map stringObjectMap = (Map)data.get(str);
                        if (stringObjectMap != null) {
                            int staffNum = (Integer)stringObjectMap.get("staffNum");
                            resultList.add(i, staffNum);
                            continue;
                        }
                        resultList.add(i, 0);
                    }
                } else {
                    LOGGER.error(staffResponse.getErrorMsg().toString());
                }
            } else {
                staffResponse = (StaffResponse)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSStaffService", (String)"queryIncludeSubStaffInfo", (Object[])new Object[]{date, orgIds});
                LOGGER.info("PersonStatisticsPresetIndexService 0 staffResponse.toString());" + staffResponse.toString());
                if (staffResponse.isSuccess()) {
                    data = (Map)staffResponse.getData();
                    for (int i = 0; i < valueList.size(); ++i) {
                        Object object = ((Object[])valueList.get(i))[index];
                        String str = String.valueOf(object);
                        Integer staffNum = (Integer)data.get(Long.parseLong(str));
                        resultList.add(i, staffNum);
                    }
                } else {
                    LOGGER.error(staffResponse.getErrorMsg().toString());
                }
            }
        }
        catch (ParseException e) {
            LOGGER.error((Throwable)e);
        }
        LOGGER.info("PersonStatisticsPresetIndexService doHandler end resultList.size():{},costTime:{}", (Object)resultList.size(), (Object)(System.currentTimeMillis() - startTime));
        return resultList;
    }

    private Object analyzeFilter(QFilter qFilter) {
        String properties = qFilter.getProperty();
        Object value = null;
        if (HRStringUtils.equals((String)properties, (String)"querydate")) {
            value = qFilter.getValue();
        }
        return value;
    }

    private int parseSelectField(PresetIndexBusinessServiceParam params) {
        String[] split;
        Map dimRelationMap;
        int i;
        List rowList = params.getRowList();
        List columnList = params.getColumnList();
        Map dimMap = params.getDimMap();
        int currIndex = -1;
        String indexStr = null;
        if (!CollectionUtils.isEmpty((Collection)rowList)) {
            for (i = 0; i < rowList.size(); ++i) {
                dimRelationMap = (Map)dimMap.get(rowList.get(i));
                if (CollectionUtils.isEmpty((Map)dimRelationMap) || !HRStringUtils.equals((String)((String)dimRelationMap.get("preindexparam")), (String)"adminorg")) continue;
                split = ((String)rowList.get(i)).split("\\.");
                indexStr = split[0];
                break;
            }
            for (i = 0; i < rowList.size(); ++i) {
                if (!HRStringUtils.equals((String)((String)rowList.get(i)), (String)(indexStr + ".id"))) continue;
                currIndex = i;
                break;
            }
        }
        if (Objects.isNull(indexStr) && !CollectionUtils.isEmpty((Collection)columnList)) {
            for (i = 0; i < columnList.size(); ++i) {
                dimRelationMap = (Map)dimMap.get(columnList.get(i));
                if (CollectionUtils.isEmpty((Map)dimRelationMap) || !HRStringUtils.equals((String)((String)dimRelationMap.get("preindexparam")), (String)"adminorg")) continue;
                split = ((String)columnList.get(i)).split("\\.");
                indexStr = split[0];
                break;
            }
            for (i = 0; i < columnList.size(); ++i) {
                dimRelationMap = (Map)dimMap.get(columnList.get(i));
                if (CollectionUtils.isEmpty((Map)dimRelationMap) || !HRStringUtils.equals((String)((String)columnList.get(i)), (String)(indexStr + ".id"))) continue;
                currIndex = i;
                break;
            }
        }
        return currIndex;
    }

    private boolean checkNeedOrgGroup(AdminOrgSummaryInfo adminOrgSummaryInfo) {
        Method[] methods;
        if (adminOrgSummaryInfo == null) {
            return false;
        }
        Class<AdminOrgSummaryInfo> adminOrgSummaryInfoClass = AdminOrgSummaryInfo.class;
        for (Method method : methods = adminOrgSummaryInfoClass.getMethods()) {
            if (HRStringUtils.equals((String)method.getName(), (String)"isIncludeSubOrg")) {
                try {
                    Method isIncludeSubOrg = adminOrgSummaryInfoClass.getMethod("isIncludeSubOrg", new Class[0]);
                    boolean invoke = (Boolean)isIncludeSubOrg.invoke((Object)adminOrgSummaryInfo, new Object[0]);
                    return invoke;
                }
                catch (NoSuchMethodException e) {
                    LOGGER.error((Throwable)e);
                    continue;
                }
                catch (IllegalAccessException e) {
                    LOGGER.error((Throwable)e);
                    continue;
                }
                catch (InvocationTargetException e) {
                    LOGGER.error((Throwable)e);
                    continue;
                }
            }
            if (!HRStringUtils.equals((String)method.getName(), (String)"getIncludeSubOrg")) continue;
            try {
                Method getIncludeSubOrg = adminOrgSummaryInfoClass.getMethod("getIncludeSubOrg", new Class[0]);
                boolean invoke = (Boolean)getIncludeSubOrg.invoke((Object)adminOrgSummaryInfo, new Object[0]);
                return invoke;
            }
            catch (NoSuchMethodException e) {
                LOGGER.error((Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Throwable)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.error((Throwable)e);
            }
        }
        return false;
    }
}

