/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDao;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.formplugin.CronStruct;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.FieldComplexType;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.datastore.metadata.model.RptMetaFieldMap;
import kd.hr.hrptmc.business.repdesign.info.FieldInfo;
import kd.hr.hrptmc.business.repdesign.info.RowFieldInfo;
import kd.hr.hrptmc.common.constant.anobj.AnalyseObjectConstants;
import kd.hr.hrptmc.common.constant.dataextract.AnObjExtractConstants;
import kd.hr.hrptmc.common.model.dataextract.AnObjExtractConfigBo;

public class AnObjDataExtractService
implements AnalyseObjectConstants,
AnObjExtractConstants {
    private final HRBaseServiceHelper extractHelper = new HRBaseServiceHelper("hrptmc_anobjextract");
    private final HRBaseServiceHelper storeFieldMapHelper = new HRBaseServiceHelper("hrptmc_anobjfieldmap");
    private static volatile AnObjDataExtractService service = null;
    private static final Log LOGGER = LogFactory.getLog(AnObjDataExtractService.class);

    private AnObjDataExtractService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnObjDataExtractService getInstance() {
        if (service != null) return service;
        Class<AnObjDataExtractService> clazz = AnObjDataExtractService.class;
        synchronized (AnObjDataExtractService.class) {
            if (service != null) return service;
            service = new AnObjDataExtractService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public Map<String, List<String>> getReportsTableIndexes(long anObjId, String tableName, List<RptMetaFieldMap> metaFieldMapList) {
        HashMap indexFieldsMap = Maps.newHashMapWithExpectedSize((int)16);
        HRBaseServiceHelper rptHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObjectCollection reportDys = rptHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("anobjid", "=", (Object)anObjId)});
        List<Long> reportIds = reportDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        Map<String, RptMetaFieldMap> fieldMap = metaFieldMapList.stream().collect(Collectors.toMap(RptMetaFieldMap::getFieldAlias, Function.identity(), (k1, k2) -> k1));
        this.collectReportFiltersIndexFields(tableName, reportIds, indexFieldsMap, fieldMap);
        this.collectReportRowColIndexFields(tableName, reportIds, indexFieldsMap, fieldMap);
        indexFieldsMap.entrySet().removeIf(map -> ((List)map.getValue()).isEmpty());
        LOGGER.info("AnObjDataExtractService.getReportsTableIndexes anObjId: {}, indexFieldsMap: {}", (Object)anObjId, (Object)indexFieldsMap);
        return indexFieldsMap;
    }

    private void collectReportRowColIndexFields(String tableName, List<Long> reportIds, Map<String, List<String>> resultMap, Map<String, RptMetaFieldMap> fieldMap) {
        HRBaseServiceHelper workPageHelper = new HRBaseServiceHelper("hrptmc_workreport");
        DynamicObject[] workPageDys = workPageHelper.query("row, column, rptmanage", new QFilter[]{new QFilter("rptmanage", "in", reportIds)});
        Map<Long, List<DynamicObject>> workPageDyMap = Arrays.stream(workPageDys).collect(Collectors.groupingBy(workPageDy -> workPageDy.getDynamicObject("rptmanage").getLong("id")));
        String rowIndexNamePrefix = "IDX_ROW_";
        AtomicInteger rowCount = new AtomicInteger();
        String colIndexNamePrefix = "IDX_COL_";
        AtomicInteger colCount = new AtomicInteger();
        workPageDyMap.forEach((reportId, workPageDyList) -> {
            for (DynamicObject workPageDy : workPageDyList) {
                Object fields;
                ArrayList rowIndexFields = Lists.newArrayListWithCapacity((int)10);
                String rowStr = workPageDy.getString("row");
                List rows = Lists.newArrayListWithCapacity((int)10);
                if (HRStringUtils.isNotEmpty((String)rowStr)) {
                    rows = SerializationUtils.fromJsonStringToList((String)rowStr, RowFieldInfo.class);
                }
                for (RowFieldInfo row : rows) {
                    String sort = row.getGroupName().getSort();
                    if (sort != null) {
                        this.addIndexField(rowIndexFields, row.getGroupName().getNumber(), fieldMap);
                    }
                    if ((fields = row.getFields()) == null || fields.isEmpty()) continue;
                    this.recursive((List<FieldInfo>)fields, field -> {
                        if (field.getSort() != null) {
                            this.addIndexField(rowIndexFields, field.getNumber(), fieldMap);
                        }
                    });
                }
                if (resultMap.values().stream().noneMatch(list -> new HashSet(list).containsAll(rowIndexFields) && list.size() == rowIndexFields.size())) {
                    String indexName = rowIndexNamePrefix + tableName + "_" + rowCount.getAndIncrement();
                    resultMap.put(indexName, rowIndexFields);
                }
                ArrayList colIndexFields = Lists.newArrayListWithCapacity((int)10);
                String colStr = workPageDy.getString("column");
                List cols = Lists.newArrayListWithCapacity((int)10);
                if (HRStringUtils.isNotEmpty((String)colStr)) {
                    cols = SerializationUtils.fromJsonStringToList((String)colStr, FieldInfo.class);
                }
                fields = cols.iterator();
                while (fields.hasNext()) {
                    List<FieldInfo> fields2;
                    FieldInfo colField = (FieldInfo)fields.next();
                    String sort = colField.getSort();
                    if (sort != null) {
                        this.addIndexField(colIndexFields, colField.getNumber(), fieldMap);
                    }
                    if ((fields2 = colField.getFields()) == null || fields2.isEmpty()) continue;
                    this.recursive(fields2, field -> {
                        if (field.getSort() != null) {
                            this.addIndexField(colIndexFields, field.getNumber(), fieldMap);
                        }
                    });
                }
                if (!resultMap.values().stream().noneMatch(list -> new HashSet(list).containsAll(colIndexFields) && list.size() == colIndexFields.size())) continue;
                String indexName = colIndexNamePrefix + tableName + "_" + colCount.getAndIncrement();
                resultMap.put(indexName, colIndexFields);
            }
        });
    }

    private void recursive(List<FieldInfo> fields, Consumer<FieldInfo> consumer) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        for (FieldInfo children : fields) {
            if (!"0".equals(children.getType())) {
                consumer.accept(children);
            }
            if (!CollectionUtils.isNotEmpty(children.getFields())) continue;
            this.recursive(children.getFields(), consumer);
        }
    }

    private void collectReportFiltersIndexFields(String tableName, List<Long> reportIds, Map<String, List<String>> resultMap, Map<String, RptMetaFieldMap> fieldMap) {
        HRBaseServiceHelper filterHelper = new HRBaseServiceHelper("hrptmc_filter");
        DynamicObject[] filterDys = filterHelper.query("anobjfield, groupdate, begindate, enddate, splitdate, isgroupfield, groupfield, ismust, rptmanage", new QFilter[]{new QFilter("rptmanage", "in", reportIds)});
        Map<Long, List<DynamicObject>> filterDyMap = Arrays.stream(filterDys).collect(Collectors.groupingBy(filterDy -> filterDy.getDynamicObject("rptmanage").getLong("id")));
        String indexNamePrefix = "IDX_FILTER_";
        AtomicInteger count = new AtomicInteger();
        filterDyMap.forEach((reportId, filterDyList) -> {
            ArrayList filterIndexFields = Lists.newArrayListWithCapacity((int)10);
            List mustInputFilterDys = filterDyList.stream().filter(filterDy -> filterDy.getBoolean("ismust")).collect(Collectors.toList());
            if (!mustInputFilterDys.isEmpty()) {
                for (DynamicObject filterDy2 : mustInputFilterDys) {
                    if (filterDy2.getBoolean("isgroupfield")) {
                        DynamicObject groupFieldDy = filterDy2.getDynamicObject("groupfield");
                        if (groupFieldDy == null) continue;
                        this.addIndexField(filterIndexFields, groupFieldDy.getString("number"), fieldMap);
                        continue;
                    }
                    if (HRStringUtils.equals((String)filterDy2.getString("groupdate"), (String)"1")) {
                        DynamicObject endDateDy;
                        DynamicObject startDateDy = filterDy2.getDynamicObject("begindate");
                        if (startDateDy != null) {
                            this.addIndexField(filterIndexFields, startDateDy.getString("fieldalias"), fieldMap);
                        }
                        if ((endDateDy = filterDy2.getDynamicObject("enddate")) == null) continue;
                        this.addIndexField(filterIndexFields, endDateDy.getString("fieldalias"), fieldMap);
                        continue;
                    }
                    DynamicObject fieldDy = filterDy2.getDynamicObject("anobjfield");
                    if (fieldDy == null) continue;
                    this.addIndexField(filterIndexFields, fieldDy.getString("fieldalias"), fieldMap);
                }
            } else {
                filterDyList.stream().filter(filterDy -> {
                    DynamicObject fieldDy = filterDy.getDynamicObject("anobjfield");
                    if (fieldDy != null) {
                        String complexType = fieldDy.getString("complextype");
                        String fieldAlias = fieldDy.getString("fieldalias");
                        return HRStringUtils.equals((String)FieldComplexType.ADMIN_ORG.getValue(), (String)complexType) && (fieldAlias.endsWith(".name") || fieldAlias.endsWith(".number"));
                    }
                    return false;
                }).findFirst().ifPresent(filterDy -> this.addIndexField(filterIndexFields, filterDy.getDynamicObject("anobjfield").getString("fieldalias"), fieldMap));
            }
            if (resultMap.values().stream().noneMatch(list -> new HashSet(list).containsAll(filterIndexFields) && list.size() == filterIndexFields.size())) {
                String indexName = indexNamePrefix + tableName + "_" + count.getAndIncrement();
                resultMap.put(indexName, filterIndexFields);
            }
        });
    }

    private void addIndexField(List<String> filterIndexes, String fieldAlias, Map<String, RptMetaFieldMap> fieldMap) {
        RptMetaFieldMap rptMetaFieldMap = fieldMap.get(fieldAlias);
        if (rptMetaFieldMap != null && !filterIndexes.contains(rptMetaFieldMap.getMetaFieldNumber())) {
            filterIndexes.add(rptMetaFieldMap.getTableFieldName());
        }
    }

    public Map<String, Map<Long, Set<String>>> getReportCustomSortSyncMsg() {
        HashMap customSortSyncMsg = Maps.newHashMapWithExpectedSize((int)1);
        try {
            Map<Long, String> anObjEntityMap = this.getAllExtractConfigAnObjIds();
            Map<Long, Long> configCustomSortReports = this.getConfigCustomSortReports(anObjEntityMap.keySet());
            HashMap reportMap = Maps.newHashMapWithExpectedSize((int)configCustomSortReports.size());
            configCustomSortReports.forEach((reportId, anObjId) -> {
                HashSet entityNums = Sets.newHashSetWithExpectedSize((int)1);
                entityNums.add(anObjEntityMap.get(anObjId));
                reportMap.put(reportId, entityNums);
            });
            customSortSyncMsg.put("hros:hrom", reportMap);
        }
        catch (Exception exception) {
            LOGGER.error("AnObjDataExtractService getReportCustomSortSyncMsg error: ", (Throwable)exception);
        }
        return customSortSyncMsg;
    }

    private Map<Long, String> getAllExtractConfigAnObjIds() {
        DynamicObjectCollection anObjConfigCol = this.extractHelper.queryOriginalCollection("anobj.id, metadatanum", new QFilter[]{new QFilter("openextract", "=", (Object)Boolean.TRUE), new QFilter("metadatanum", "is not null", null), new QFilter("metadatanum", "!=", (Object)" ")});
        return anObjConfigCol.stream().filter(dy -> HRStringUtils.isNotEmpty((String)dy.getString("metadatanum"))).collect(Collectors.toMap(dy -> dy.getLong("anobj.id"), dy -> dy.getString("metadatanum")));
    }

    private Map<Long, Long> getConfigCustomSortReports(Set<Long> anObjIds) {
        HRBaseServiceHelper reportManageHelper = new HRBaseServiceHelper("hrptmc_reportmanage");
        DynamicObjectCollection reportCol = reportManageHelper.queryOriginalCollection("id,anobjid", new QFilter[]{new QFilter("anobjid", "in", anObjIds)});
        List reportIds = reportCol.stream().map(reportDy -> reportDy.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper customSortHelper = new HRBaseServiceHelper("hrptmc_customsort");
        DynamicObjectCollection customSortDys = customSortHelper.queryOriginalCollection("rptmanage.id", new QFilter[]{new QFilter("rptmanage", "in", reportIds)});
        List configCustomSortReportIds = customSortDys.stream().map(dy -> dy.getLong("rptmanage.id")).collect(Collectors.toList());
        HashMap reportIdMap = Maps.newHashMapWithExpectedSize((int)reportCol.size());
        for (DynamicObject reportDy2 : reportCol) {
            long reportId = reportDy2.getLong("id");
            if (!configCustomSortReportIds.contains(reportId)) continue;
            reportIdMap.put(reportId, reportDy2.getLong("anobjid"));
        }
        return reportIdMap;
    }

    public boolean isAnObjOpenExtractConfig(long anObjId) {
        DynamicObject configDy = this.extractHelper.queryOriginalOne("openextract", new QFilter("anobj", "=", (Object)anObjId));
        return configDy != null && configDy.getBoolean("openextract");
    }

    public AnObjExtractConfigBo getAnObjExtractConfig(long anObjId) {
        DynamicObject jobDy;
        DynamicObject planLastDy;
        DynamicObject configDy = this.extractHelper.loadDynamicObject(new QFilter("anobj", "=", (Object)anObjId));
        if (configDy == null) {
            return null;
        }
        AnObjExtractConfigBo anObjExtractConfigBo = new AnObjExtractConfigBo();
        anObjExtractConfigBo.setId(Long.valueOf(configDy.getLong("id")));
        anObjExtractConfigBo.setAnObjId(Long.valueOf(anObjId));
        anObjExtractConfigBo.setOpenExtract(configDy.getBoolean("openextract"));
        anObjExtractConfigBo.setExecuteNow(configDy.getBoolean("executenow"));
        anObjExtractConfigBo.setCycle(configDy.getString("cycle"));
        anObjExtractConfigBo.setCronExpr(configDy.getString("cronexpr"));
        DynamicObject planDy = configDy.getDynamicObject("scheplan");
        if (planDy != null) {
            anObjExtractConfigBo.setSchedulePlanId(planDy.getString("id"));
        }
        if ((planLastDy = configDy.getDynamicObject("scheplanlast")) != null) {
            anObjExtractConfigBo.setSchedulePlanLastId(planLastDy.getString("id"));
        }
        if ((jobDy = configDy.getDynamicObject("schejob")) != null) {
            anObjExtractConfigBo.setScheduleJobId(jobDy.getString("id"));
        }
        anObjExtractConfigBo.setMetadataNum(configDy.getString("metadatanum"));
        anObjExtractConfigBo.setRunStatus(configDy.getString("runstatus"));
        return anObjExtractConfigBo;
    }

    public String getStoreMetadataNumber(long anObjId) {
        DynamicObject configDy = this.extractHelper.queryOriginalOne("id, openextract, runstatus, metadatanum", new QFilter("anobj", "=", (Object)anObjId));
        if (configDy == null) {
            return null;
        }
        if (HRStringUtils.equals((String)configDy.getString("runstatus"), (String)"1")) {
            return null;
        }
        if (configDy.getBoolean("openextract")) {
            return configDy.getString("metadatanum");
        }
        return null;
    }

    public List<RptMetaFieldMap> queryFieldMapList(long anObjId) {
        DynamicObject[] dyCol = this.storeFieldMapHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        ArrayList fieldMaps = Lists.newArrayListWithCapacity((int)dyCol.length);
        for (DynamicObject fieldMapDy : dyCol) {
            String fieldAlias = fieldMapDy.getString("fieldalias");
            String fieldNumber = fieldMapDy.getString("fieldnum");
            String tableFieldName = fieldMapDy.getString("fieldname");
            int fieldLength = fieldMapDy.getInt("fieldlength");
            String fieldControlType = fieldMapDy.getString("controltype");
            String tableFieldType = fieldMapDy.getString("tablefieldtype");
            RptMetaFieldMap rptMetaFieldMapBo = new RptMetaFieldMap(fieldAlias, null, fieldNumber, tableFieldName, fieldLength, fieldControlType, tableFieldType);
            fieldMaps.add(rptMetaFieldMapBo);
        }
        return fieldMaps;
    }

    public void deleteFieldMapList(long anObjId) {
        this.storeFieldMapHelper.deleteByFilter(new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
    }

    public void saveAnObjExtractConfig(AnObjExtractConfigBo anObjExtractConfig) {
        DynamicObject anObjExtractConfigDy = anObjExtractConfig.getId() != null ? this.extractHelper.loadSingle((Object)anObjExtractConfig.getId()) : this.extractHelper.generateEmptyDynamicObject();
        anObjExtractConfigDy.set("anobj", (Object)anObjExtractConfig.getAnObjId());
        anObjExtractConfigDy.set("cycle", (Object)anObjExtractConfig.getCycle());
        anObjExtractConfigDy.set("cronexpr", (Object)anObjExtractConfig.getCronExpr());
        anObjExtractConfigDy.set("metadatanum", (Object)anObjExtractConfig.getMetadataNum());
        anObjExtractConfigDy.set("runstatus", (Object)anObjExtractConfig.getRunStatus());
        anObjExtractConfigDy.set("openextract", (Object)anObjExtractConfig.isOpenExtract());
        anObjExtractConfigDy.set("executenow", (Object)anObjExtractConfig.isExecuteNow());
        anObjExtractConfigDy.set("scheplan", (Object)anObjExtractConfig.getSchedulePlanId());
        anObjExtractConfigDy.set("scheplanlast", (Object)anObjExtractConfig.getSchedulePlanLastId());
        anObjExtractConfigDy.set("schejob", (Object)anObjExtractConfig.getScheduleJobId());
        this.extractHelper.saveOne(anObjExtractConfigDy);
    }

    public JobInfo createScheduleJob(long anObjId, String anObjName, String anObjNum) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setAppId("hrptmc");
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setName("hrptmc_" + anObjName + "_SKDJ_S");
        jobInfo.setNumber("hrptmc_" + anObjNum + "_SKDJ_S");
        String id = ID.genStringId();
        jobInfo.setId(id);
        jobInfo.setTaskDefineId("408V8JH1AOMP");
        HashMap params = Maps.newHashMapWithExpectedSize((int)1);
        params.put("anObjId", String.valueOf(anObjId));
        jobInfo.setParams((Map)params);
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        proxy.createJob(jobInfo);
        return jobInfo;
    }

    public void saveSchedulePlan(AnObjExtractConfigBo anObjExtractConfig, JobInfo jobInfo, String cycle, String cronExpr, String anObjName, String anObjNum) {
        PlanInfo planInfo = this.generateSchedulePlanInfo(anObjExtractConfig.getSchedulePlanId(), jobInfo, cycle, anObjName, anObjNum);
        CronStruct cronParser = CronStruct.parse((String)cronExpr);
        String dayOfMonth = cronParser.getDayOfMonth();
        ArrayList dayNoLast = Lists.newArrayListWithCapacity((int)10);
        StringBuilder dayLast = new StringBuilder();
        Arrays.stream(dayOfMonth.split(",")).forEach(day -> {
            if (HRStringUtils.equals((String)day, (String)"L")) {
                dayLast.append((String)day);
            } else {
                dayNoLast.add(day);
            }
        });
        if (dayLast.length() > 0 && dayNoLast.size() > 0) {
            cronParser.setDayOfMonth(String.join((CharSequence)",", dayNoLast));
            this.setSchedulePlanCron(planInfo, cronParser);
            PlanInfo planInfoLast = this.generateSchedulePlanInfo(anObjExtractConfig.getSchedulePlanLastId(), jobInfo, cycle, anObjName + "_L", anObjNum + "_L");
            cronParser.setDayOfMonth("L");
            this.setSchedulePlanCron(planInfoLast, cronParser);
            String planInfoLastId = this.savePlanInfo(planInfoLast);
            anObjExtractConfig.setSchedulePlanLastId(planInfoLastId);
        } else {
            this.setSchedulePlanCron(planInfo, cronParser);
            if (HRStringUtils.isNotEmpty((String)anObjExtractConfig.getSchedulePlanLastId())) {
                this.deleteSchedulePlan(anObjExtractConfig.getSchedulePlanLastId());
                anObjExtractConfig.setSchedulePlanLastId(null);
            }
        }
        String planInfoId = this.savePlanInfo(planInfo);
        anObjExtractConfig.setSchedulePlanId(planInfoId);
    }

    private PlanInfo generateSchedulePlanInfo(String planId, JobInfo jobInfo, String cycle, String anObjName, String anObjNum) {
        PlanInfo planInfo = new PlanInfo();
        planInfo.setId(planId);
        planInfo.setJobId(jobInfo.getId());
        planInfo.setName("hrptmc_" + anObjName + "_SKDP_S");
        planInfo.setNumber("hrptmc_" + anObjNum + "_SKDP_S");
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.set(2099, 11, 31);
        planInfo.setStartTime(startCalendar);
        planInfo.setEndTime(endCalendar);
        planInfo.setRepeatMode(this.getRepeatMode(cycle));
        return planInfo;
    }

    private String savePlanInfo(PlanInfo planInfo) {
        JobDispatcherProxy proxy = new JobDispatcherProxy();
        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
        if (HRStringUtils.isNotEmpty((String)planInfo.getId()) && scheduleDao.existed(planInfo.getId())) {
            return proxy.updatePlan(planInfo);
        }
        return proxy.createPlan(planInfo);
    }

    public void deleteSchedulePlanAndJob(String planId, String planLastId, String jobId) {
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if (HRStringUtils.isNotEmpty((String)planId)) {
                    this.deleteSchedulePlan(planId);
                }
                if (HRStringUtils.isNotEmpty((String)planLastId)) {
                    this.deleteSchedulePlan(planLastId);
                }
                if (HRStringUtils.isNotEmpty((String)jobId)) {
                    this.deleteScheduleJob(jobId);
                }
            }
            catch (Exception exception) {
                txHandle.markRollback();
                LOGGER.error((Throwable)exception);
                throw new KDBizException("delete scheduleJob and schedulePlan error.");
            }
        }
    }

    public void deleteSchedulePlan(String planId) {
        ScheduleDao scheduleDao = ScheduleService.getInstance().getObjectFactory().getScheduleDao();
        scheduleDao.delete(planId);
    }

    public void deleteScheduleJob(String jobId) {
        JobDao jobDao = ScheduleService.getInstance().getObjectFactory().getJobDao();
        jobDao.delete(jobId);
    }

    private void setSchedulePlanCron(PlanInfo planInfo, CronStruct cronParser) {
        planInfo.setCronExpression(cronParser.toString());
        planInfo.setDaysExp(HRStringUtils.equals((String)cronParser.getDayOfMonth(), (String)"?") ? null : cronParser.getDayOfMonth());
        planInfo.setMonthsExp(cronParser.getMonth());
        planInfo.setWeekdaysExp(HRStringUtils.equals((String)cronParser.getDayOfWeek(), (String)"?") ? null : cronParser.getDayOfWeek());
    }

    private RepeatModeEnum getRepeatMode(String cycle) {
        RepeatModeEnum repeatMode = RepeatModeEnum.NONE;
        switch (cycle) {
            case "hour": {
                repeatMode = RepeatModeEnum.ByHours;
                break;
            }
            case "day": {
                repeatMode = RepeatModeEnum.ByDays;
                break;
            }
            case "week": {
                repeatMode = RepeatModeEnum.ByWeeks;
                break;
            }
            case "month": {
                repeatMode = RepeatModeEnum.ByMonths;
                break;
            }
        }
        return repeatMode;
    }
}

