/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrptmc.business.anobj;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.field.ComboItem;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.complexobj.util.MainEntityTypeUtil;
import kd.hr.hbp.business.service.labelandreport.AnalyseObjectUtil;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.complexobj.DataTypeEnum;
import kd.hr.hbp.common.model.complexobj.labelandreport.QueryFieldCommonBo;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrptmc.business.anobj.AnalyseObjectService;
import kd.hr.hrptmc.business.repdesign.info.AnObjDetailInfo;
import kd.hr.hrptmc.common.constant.anobj.AnObjGroupFieldConstants;
import kd.hr.hrptmc.common.model.anobj.AnObjGroupField;
import kd.hr.hrptmc.common.model.anobj.QueryFieldBo;
import kd.hr.hrptmc.common.model.calfield.CalculateFieldBo;
import kd.hr.hrptmc.common.model.repdesign.filter.FilterBo;

public class AnObjGroupFieldService
implements AnObjGroupFieldConstants {
    private static volatile AnObjGroupFieldService service = null;
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("hrptmc_anobjgroupfield");
    private static final Log LOGGER = LogFactory.getLog(AnObjGroupFieldService.class);

    private AnObjGroupFieldService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnObjGroupFieldService getInstance() {
        if (service != null) return service;
        Class<AnObjGroupFieldService> clazz = AnObjGroupFieldService.class;
        synchronized (AnObjGroupFieldService.class) {
            if (service != null) return service;
            service = new AnObjGroupFieldService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public void addGroupFieldEnumsToFilterBo(AnObjDetailInfo anObjInfo, FilterBo filterBo, String textFilterRange, Map<String, Object> customParams, List<ComboItem> list) {
        String[] split = textFilterRange.split(",");
        Boolean isVersion = (Boolean)customParams.get("isVersion");
        List<Map<String, Object>> groupFieldEnums = isVersion != null && isVersion != false ? this.getGroupFieldEnums(anObjInfo, filterBo.getFieldAlias()) : this.getGroupFieldEnums(Long.parseLong(filterBo.getGroupFieldId()));
        if (split.length > 0) {
            for (Map<String, Object> groupFieldEnum : groupFieldEnums) {
                String number = (String)groupFieldEnum.get("number");
                if (!textFilterRange.contains(number)) continue;
                list.add(new ComboItem((LocaleString)groupFieldEnum.get("name"), (String)groupFieldEnum.get("number")));
            }
        } else {
            for (Map<String, Object> groupFieldEnum : groupFieldEnums) {
                list.add(new ComboItem((LocaleString)groupFieldEnum.get("name"), (String)groupFieldEnum.get("number")));
            }
        }
    }

    public Map<String, List<ValueMapItem>> getGroupFieldEnumsForReport(List<Long> groupFieldIds, List<QueryFieldBo> loadQueryFields) {
        List<AnObjGroupField> groupFields = this.getGroupFields(groupFieldIds, loadQueryFields);
        HashMap groupFieldMap = Maps.newHashMapWithExpectedSize((int)16);
        for (AnObjGroupField groupField : groupFields) {
            List group = groupField.getGroup();
            ArrayList valueMapItems = Lists.newArrayListWithExpectedSize((int)group.size());
            for (AnObjGroupField.GroupItem groupItem : group) {
                ValueMapItem valueMapItem = new ValueMapItem("", groupItem.getItemNumber(), new LocaleString(groupItem.getItemName().getLocaleValue()));
                valueMapItems.add(valueMapItem);
            }
            groupFieldMap.put(groupField.getNumber(), valueMapItems);
        }
        return groupFieldMap;
    }

    public List<Map<String, Object>> getGroupFieldEnums(AnObjDetailInfo anObjInfo, String fieldAlias) {
        ArrayList groupFieldEnums = Lists.newArrayListWithExpectedSize((int)10);
        List<AnObjGroupField> anObjGroupFields = anObjInfo.getAnObjGroupFields();
        Optional<AnObjGroupField> groupField = anObjGroupFields.stream().filter(field -> HRStringUtils.equals((String)field.getNumber(), (String)fieldAlias)).findAny();
        return groupField.map(this::buildGroupFieldEnumMaps).orElse(groupFieldEnums);
    }

    public List<Map<String, Object>> getGroupFieldEnums(long groupFieldId) {
        AnObjGroupField groupField = this.getGroupField(groupFieldId);
        return this.buildGroupFieldEnumMaps(groupField);
    }

    private List<Map<String, Object>> buildGroupFieldEnumMaps(AnObjGroupField groupField) {
        ArrayList groupFieldEnums = Lists.newArrayListWithExpectedSize((int)10);
        List group = groupField.getGroup();
        for (AnObjGroupField.GroupItem groupItem : group) {
            HashMap groupItemMap = Maps.newHashMapWithExpectedSize((int)16);
            groupItemMap.put("name", groupItem.getItemName());
            groupItemMap.put("number", groupItem.getItemNumber());
            groupFieldEnums.add(groupItemMap);
        }
        return groupFieldEnums;
    }

    public List<QFilter> getGroupFieldQFilter(List<Map<Long, String>> groupFieldInfo, List<AnObjGroupField> groupFields, boolean isEqual) {
        ArrayList qFilterList = Lists.newArrayListWithCapacity((int)10);
        if (groupFieldInfo.isEmpty()) {
            return qFilterList;
        }
        Map groupFieldMap = groupFields.stream().collect(Collectors.toMap(field -> Long.valueOf(field.getId()), Function.identity()));
        for (Map<Long, String> groupFieldInfoMap : groupFieldInfo) {
            for (Map.Entry<Long, String> groupFieldInfoEntry : groupFieldInfoMap.entrySet()) {
                Long groupFieldId = groupFieldInfoEntry.getKey();
                AnObjGroupField groupField = (AnObjGroupField)groupFieldMap.get(groupFieldId);
                String selectIds = groupFieldInfoEntry.getValue();
                QFilter groupFieldQFilter = this.getGroupFieldQFilter(selectIds, groupField, isEqual);
                if (groupFieldQFilter == null) continue;
                qFilterList.add(groupFieldQFilter);
            }
        }
        return qFilterList;
    }

    public String findGroupItemIdByName(String groupItemName, AnObjGroupField groupField) {
        List group = groupField.getGroup();
        Optional<AnObjGroupField.GroupItem> any = group.stream().filter(groupItem -> HRStringUtils.equals((String)groupItemName, (String)groupItem.getItemName().getLocaleValue())).findAny();
        if (any.isPresent()) {
            return any.get().getItemNumber();
        }
        return groupItemName;
    }

    public QFilter getGroupFieldQFilter(String selectIds, AnObjGroupField groupField) {
        return this.getGroupFieldQFilter(selectIds, groupField, true);
    }

    public QFilter getGroupFieldQFilter(String selectIds, AnObjGroupField groupField, boolean isEqual) {
        ArrayList qFilterList = Lists.newArrayListWithExpectedSize((int)10);
        ArrayList groupItemIds = Lists.newArrayListWithCapacity((int)10);
        if (selectIds.contains(",")) {
            String[] split = selectIds.split(",");
            groupItemIds.addAll(Arrays.stream(split).collect(Collectors.toList()));
        } else {
            groupItemIds.add(selectIds);
        }
        groupItemIds.remove("");
        Set allGroupItemIds = groupField.getGroup().stream().map(AnObjGroupField.GroupItem::getItemNumber).collect(Collectors.toSet());
        groupItemIds.forEach(allGroupItemIds::remove);
        if (allGroupItemIds.isEmpty()) {
            if (isEqual) {
                return QFilter.of((String)"1=1", (Object[])new Object[0]);
            }
            return QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        this.handleGroupItemQFilter(groupField, groupItemIds, qFilterList, isEqual);
        QFilter resultQFilter = null;
        for (QFilter qFilter : qFilterList) {
            if (resultQFilter == null) {
                resultQFilter = qFilter;
                continue;
            }
            if (isEqual) {
                resultQFilter.or(qFilter);
                continue;
            }
            resultQFilter.and(qFilter);
        }
        return resultQFilter;
    }

    private void handleGroupItemQFilter(AnObjGroupField groupField, List<String> groupItemIds, List<QFilter> qFilterList, boolean isEqual) {
        String fieldAlias = this.getFieldAlias(groupField);
        for (String groupItemId : groupItemIds) {
            groupField.getGroup().stream().filter(groupItem -> HRStringUtils.equals((String)groupItemId, (String)groupItem.getItemNumber())).findAny().ifPresent(groupItem -> {
                if (groupItem.getUnGroupItem() != null && groupItem.getUnGroupItem().booleanValue()) {
                    this.handleUnGroupItemQFilter(groupField, qFilterList, isEqual);
                    return;
                }
                String itemCondition = groupItem.getItemCondition();
                String type = groupField.getType();
                QFilter qFilter = QFilter.of((String)"1=1", (Object[])new Object[0]);
                switch (type) {
                    case "baseData": {
                        ArrayList ids = Lists.newArrayListWithExpectedSize((int)10);
                        itemCondition = this.transferItemConditionForSave(groupField, itemCondition);
                        String[] baseDataIds = itemCondition.split(",");
                        String fieldIdAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf(46)) + ".id";
                        for (String baseDataId : baseDataIds) {
                            if (HRStringUtils.equals((String)groupField.getAnObjField().getBaseDataIdType(), (String)"string")) {
                                ids.add(baseDataId);
                                continue;
                            }
                            ids.add(Long.valueOf(baseDataId));
                        }
                        if (isEqual) {
                            qFilter = new QFilter(fieldIdAlias, "in", (Object)ids);
                            break;
                        }
                        qFilter = new QFilter(fieldIdAlias, "not in", (Object)ids);
                        break;
                    }
                    case "enum": {
                        itemCondition = this.transferItemConditionForSave(groupField, itemCondition);
                        String[] enums = itemCondition.split(",");
                        if (isEqual) {
                            qFilter = new QFilter(fieldAlias, "in", (Object)enums);
                            break;
                        }
                        qFilter = new QFilter(fieldAlias, "not in", (Object)enums);
                        break;
                    }
                    case "number": {
                        JSONObject numMap = JSON.parseObject((String)itemCondition);
                        List value = (List)numMap.get("value");
                        List op = (List)numMap.get("op");
                        if (isEqual) {
                            qFilter = new QFilter(fieldAlias, this.getReversOp((String)op.get(0), false), (Object)Long.valueOf((String)value.get(0)));
                            qFilter.and(new QFilter(fieldAlias, (String)op.get(1), (Object)Long.valueOf((String)value.get(1))));
                            break;
                        }
                        qFilter = new QFilter(fieldAlias, this.getOpForUnGroupItem((String)op.get(0)), (Object)Long.valueOf((String)value.get(0)));
                        qFilter.or(new QFilter(fieldAlias, this.getReversOp((String)op.get(1), true), (Object)Long.valueOf((String)value.get(1))));
                        break;
                    }
                    case "datetime": {
                        String[] dateArr = (String[])JSON.parseObject((String)itemCondition, String[].class);
                        try {
                            if (isEqual) {
                                qFilter = new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.parseDate((String)dateArr[0]));
                                qFilter.and(new QFilter(fieldAlias, "<=", (Object)HRDateTimeUtils.parseDate((String)dateArr[1])));
                                break;
                            }
                            qFilter = new QFilter(fieldAlias, "<", (Object)HRDateTimeUtils.parseDate((String)dateArr[0]));
                            qFilter.or(new QFilter(fieldAlias, ">", (Object)HRDateTimeUtils.parseDate((String)dateArr[1])));
                        }
                        catch (ParseException e) {
                            LOGGER.error((Throwable)e);
                        }
                        break;
                    }
                }
                qFilterList.add(qFilter);
            });
        }
    }

    private void handleUnGroupItemQFilter(AnObjGroupField groupField, List<QFilter> qFilterList, boolean isEqual) {
        List group = groupField.getGroup();
        String fieldAlias = this.getFieldAlias(groupField);
        QFilter finalQFilter = null;
        for (AnObjGroupField.GroupItem groupItem : group) {
            if (groupItem.getUnGroupItem() != null && groupItem.getUnGroupItem().booleanValue()) continue;
            String itemCondition = groupItem.getItemCondition();
            String type = groupField.getType();
            QFilter qFilter = null;
            switch (type) {
                case "baseData": {
                    ArrayList ids = Lists.newArrayListWithExpectedSize((int)10);
                    itemCondition = this.transferItemConditionForSave(groupField, itemCondition);
                    String[] baseDataIds = itemCondition.split(",");
                    String fieldIdAlias = fieldAlias.substring(0, fieldAlias.lastIndexOf(46)) + ".id";
                    for (String baseDataId : baseDataIds) {
                        if (HRStringUtils.equals((String)groupField.getAnObjField().getBaseDataIdType(), (String)"string")) {
                            ids.add(baseDataId);
                            continue;
                        }
                        ids.add(Long.valueOf(baseDataId));
                    }
                    if (isEqual) {
                        qFilter = new QFilter(fieldIdAlias, "not in", (Object)ids);
                        break;
                    }
                    qFilter = new QFilter(fieldIdAlias, "in", (Object)ids);
                    break;
                }
                case "enum": {
                    itemCondition = this.transferItemConditionForSave(groupField, itemCondition);
                    String[] enums = itemCondition.split(",");
                    if (isEqual) {
                        qFilter = new QFilter(fieldAlias, "not in", (Object)enums);
                        break;
                    }
                    qFilter = new QFilter(fieldAlias, "in", (Object)enums);
                    break;
                }
                case "number": {
                    JSONObject numMap = JSON.parseObject((String)itemCondition);
                    List value = (List)numMap.get("value");
                    List op = (List)numMap.get("op");
                    if (isEqual) {
                        qFilter = new QFilter(fieldAlias, this.getOpForUnGroupItem((String)op.get(0)), (Object)Long.valueOf((String)value.get(0)));
                        qFilter.or(new QFilter(fieldAlias, this.getReversOp((String)op.get(1), true), (Object)Long.valueOf((String)value.get(1))));
                        break;
                    }
                    qFilter = new QFilter(fieldAlias, this.getReversOp((String)op.get(0), false), (Object)Long.valueOf((String)value.get(0)));
                    qFilter.and(new QFilter(fieldAlias, (String)op.get(1), (Object)Long.valueOf((String)value.get(1))));
                    break;
                }
                case "datetime": {
                    String[] dateArr = (String[])JSON.parseObject((String)itemCondition, String[].class);
                    try {
                        if (isEqual) {
                            qFilter = new QFilter(fieldAlias, "<", (Object)HRDateTimeUtils.parseDate((String)dateArr[0]));
                            qFilter.or(new QFilter(fieldAlias, ">", (Object)HRDateTimeUtils.parseDate((String)dateArr[1])));
                            break;
                        }
                        qFilter = new QFilter(fieldAlias, ">=", (Object)HRDateTimeUtils.parseDate((String)dateArr[0]));
                        qFilter.and(new QFilter(fieldAlias, "<=", (Object)HRDateTimeUtils.parseDate((String)dateArr[1])));
                    }
                    catch (ParseException e) {
                        LOGGER.error((Throwable)e);
                    }
                    break;
                }
            }
            if (finalQFilter == null) {
                finalQFilter = qFilter;
                continue;
            }
            if (isEqual) {
                finalQFilter.and(qFilter);
                continue;
            }
            finalQFilter.or(qFilter);
        }
        if (finalQFilter != null) {
            qFilterList.add(finalQFilter);
        }
    }

    private String getReversOp(String op, boolean withEqual) {
        if (HRStringUtils.equals((String)op, (String)"<")) {
            return withEqual ? ">=" : ">";
        }
        if (HRStringUtils.equals((String)op, (String)"<=")) {
            return withEqual ? ">" : ">=";
        }
        if (HRStringUtils.equals((String)op, (String)">")) {
            return withEqual ? "<=" : "<";
        }
        if (HRStringUtils.equals((String)op, (String)">=")) {
            return withEqual ? "<" : "<=";
        }
        return op;
    }

    private String getOpForUnGroupItem(String op) {
        if (HRStringUtils.equals((String)op, (String)"<")) {
            return "<=";
        }
        if (HRStringUtils.equals((String)op, (String)"<=")) {
            return "<";
        }
        if (HRStringUtils.equals((String)op, (String)">")) {
            return ">=";
        }
        if (HRStringUtils.equals((String)op, (String)">=")) {
            return ">";
        }
        return op;
    }

    public CalculateFieldBo transferGroupField(List<CalculateFieldBo> anObjCalculateFields, List<QueryFieldBo> queryFields, AnObjGroupField groupField) {
        CalculateFieldBo calFieldBo = new CalculateFieldBo(groupField.getName(), groupField.getNumber());
        calFieldBo.setAnObjId(groupField.getAnObjId());
        String fieldType = groupField.getFieldType();
        if (HRStringUtils.equals((String)fieldType, (String)"field")) {
            boolean isBaseData;
            calFieldBo.setOrder(Integer.valueOf(0));
            String fieldAlias = groupField.getAnObjField().getFieldAlias();
            QueryFieldBo queryFieldBo = queryFields.stream().filter(field -> HRStringUtils.equals((String)field.getFieldAlias(), (String)fieldAlias)).findAny().get();
            ArrayList refEntityFields = Lists.newArrayListWithExpectedSize((int)1);
            refEntityFields.add(fieldAlias);
            boolean bl = isBaseData = AnalyseObjectUtil.isBaseDataType((String)queryFieldBo.getComplexType()) && (fieldAlias.endsWith(".name") || fieldAlias.endsWith(".number"));
            if (isBaseData) {
                refEntityFields.add(fieldAlias.substring(0, fieldAlias.lastIndexOf(46)) + ".id");
            }
            calFieldBo.setRefEntityFields((List)refEntityFields);
        } else {
            CalculateFieldBo anObjCalField = groupField.getAnObjCalField();
            calFieldBo.setOrder(Integer.valueOf(anObjCalField.getOrder() + 1));
            ArrayList refCalculateFields = Lists.newArrayListWithExpectedSize((int)1);
            anObjCalculateFields.stream().filter(field -> HRStringUtils.equals((String)field.getFieldNumber(), (String)anObjCalField.getFieldNumber())).findAny().ifPresent(refCalculateFields::add);
            calFieldBo.setRefCalculateFields((List)refCalculateFields);
        }
        calFieldBo.setValueType(DataTypeEnum.STRING.getDataTypeKey());
        calFieldBo.setSource("anobj");
        calFieldBo.setType("complex");
        calFieldBo.setSelected(Boolean.valueOf(true));
        calFieldBo.setGroupField(Boolean.valueOf(true));
        calFieldBo.setGroupFieldId(groupField.getId());
        this.transferCalculateExpr(calFieldBo, groupField);
        return calFieldBo;
    }

    private void transferCalculateExpr(CalculateFieldBo calFieldBo, AnObjGroupField groupField) {
        StringBuilder runExprSb = new StringBuilder();
        List group = groupField.getGroup();
        Optional<AnObjGroupField.GroupItem> unGroupItemOp = group.stream().filter(groupItem -> groupItem.getUnGroupItem() != null && groupItem.getUnGroupItem() != false).findFirst();
        Collections.reverse(group);
        for (AnObjGroupField.GroupItem groupItem2 : group) {
            String fieldAlias;
            if (groupItem2.getUnGroupItem() != null && groupItem2.getUnGroupItem().booleanValue()) continue;
            String itemCondition = groupItem2.getItemCondition();
            itemCondition = this.transferItemConditionForSave(groupField, itemCondition);
            runExprSb.append("IF(");
            if (HRStringUtils.equals((String)groupField.getType(), (String)"baseData")) {
                String[] baseDataIds = itemCondition.split(",");
                fieldAlias = groupField.getAnObjField().getFieldAlias();
                String string = fieldAlias.substring(0, fieldAlias.lastIndexOf(46)) + ".id";
                String[] stringArray = baseDataIds;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String baseDataId = stringArray[i];
                    runExprSb.append("$").append(string).append("$").append("=");
                    if (HRStringUtils.equals((String)groupField.getAnObjField().getBaseDataIdType(), (String)"string")) {
                        runExprSb.append("\"").append(baseDataId).append("\"");
                    } else {
                        runExprSb.append(baseDataId);
                    }
                    runExprSb.append(" or ");
                }
                runExprSb.delete(runExprSb.length() - 4, runExprSb.length());
            } else if (HRStringUtils.equals((String)groupField.getType(), (String)"enum")) {
                String[] enums = itemCondition.split(",");
                fieldAlias = groupField.getAnObjField().getFieldAlias();
                for (String anEnum : enums) {
                    runExprSb.append("$").append(fieldAlias).append("$").append("=");
                    runExprSb.append("\"").append(anEnum).append("\"").append(" or ");
                }
                runExprSb.delete(runExprSb.length() - 4, runExprSb.length());
            } else if (HRStringUtils.equals((String)groupField.getType(), (String)"datetime")) {
                String[] dateArr = (String[])JSON.parseObject((String)itemCondition, String[].class);
                fieldAlias = this.getFieldAlias(groupField);
                runExprSb.append("DATEDIF(").append("\"").append(dateArr[0]).append("\"").append(", ").append("$").append(fieldAlias).append("$").append(", ");
                runExprSb.append("\"").append("D").append("\")").append(" >= 0 and DATEDIF(").append("$").append(fieldAlias).append("$").append(", ");
                runExprSb.append("\"").append(dateArr[1]).append("\"").append(", ").append("\"").append("D").append("\") >= 0");
            } else {
                JSONObject numMap = JSON.parseObject((String)itemCondition);
                List value = (List)numMap.get("value");
                List list = (List)numMap.get("op");
                String fieldAlias2 = this.getFieldAlias(groupField);
                runExprSb.append(value.get(0)).append(list.get(0)).append("$").append(fieldAlias2).append("$").append(" and ");
                runExprSb.append("$").append(fieldAlias2).append("$").append(list.get(1)).append(value.get(1));
            }
            runExprSb.append(", ").append("\"").append(groupItem2.getItemName().getLocaleValue()).append("\"").append(", ");
        }
        unGroupItemOp.ifPresent(groupItem -> runExprSb.append("\"").append(groupItem.getItemName()).append("\""));
        for (int i = 0; i < group.size() - 1; ++i) {
            runExprSb.append(")");
        }
        calFieldBo.setExpr(runExprSb.toString());
        calFieldBo.setViewExpr(runExprSb.toString());
    }

    private String getFieldAlias(AnObjGroupField groupField) {
        if (HRStringUtils.equals((String)groupField.getFieldType(), (String)"field")) {
            return groupField.getAnObjField().getFieldAlias();
        }
        return groupField.getAnObjCalField().getFieldNumber();
    }

    public AnObjGroupField getGroupField(long groupFieldId) {
        if (groupFieldId == 0L) {
            return null;
        }
        DynamicObject groupFieldDy = HELPER.loadDynamicObject(new QFilter[]{new QFilter("id", "=", (Object)groupFieldId)});
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        return this.assembleGroupField(groupFieldDy, Maps.newHashMapWithExpectedSize((int)16), mainEntityTypeUtil);
    }

    public List<AnObjGroupField> getGroupFields(Collection<Long> groupFieldIds, List<QueryFieldBo> loadQueryFields) {
        DynamicObject[] groupFields = HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", groupFieldIds)});
        return this.getGroupFieldBos(groupFields, loadQueryFields);
    }

    public DynamicObjectCollection getGroupFieldDys(long anObjId) {
        return HELPER.queryOriginalCollection("id, name, number", new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
    }

    public List<AnObjGroupField> getGroupFields(Long anObjId, List<QueryFieldBo> loadQueryFields) {
        if (anObjId == null || anObjId == 0L) {
            return Lists.newArrayListWithCapacity((int)10);
        }
        DynamicObject[] groupFields = HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        return this.getGroupFieldBos(groupFields, loadQueryFields);
    }

    private List<AnObjGroupField> getGroupFieldBos(DynamicObject[] groupFields, List<QueryFieldBo> loadQueryFields) {
        Map<String, QueryFieldBo> loadQueryFieldMap = loadQueryFields.stream().collect(Collectors.toMap(QueryFieldCommonBo::getFieldAlias, Function.identity()));
        ArrayList result = Lists.newArrayListWithExpectedSize((int)groupFields.length);
        MainEntityTypeUtil mainEntityTypeUtil = new MainEntityTypeUtil();
        for (DynamicObject groupFieldDy : groupFields) {
            AnObjGroupField groupField = this.assembleGroupField(groupFieldDy, loadQueryFieldMap, mainEntityTypeUtil);
            result.add(groupField);
        }
        return result.stream().sorted(Comparator.comparingInt(AnObjGroupField::getIndex)).collect(Collectors.toList());
    }

    private AnObjGroupField assembleGroupField(DynamicObject groupFieldDy, Map<String, QueryFieldBo> loadQueryFieldMap, MainEntityTypeUtil mainEntityTypeUtil) {
        AnObjGroupField groupField = new AnObjGroupField();
        groupField.setId(groupFieldDy.getString("id"));
        groupField.setIndex(Integer.valueOf(groupFieldDy.getInt("index")));
        OrmLocaleValue groupFieldName = (OrmLocaleValue)groupFieldDy.getLocaleString("name");
        groupField.setName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)groupFieldName));
        groupField.setNumber(groupFieldDy.getString("number"));
        groupField.setNumberLock(Boolean.valueOf(true));
        groupField.setAnObjId(groupFieldDy.getDynamicObject("anobj").getString("id"));
        String type = groupFieldDy.getString("type");
        groupField.setFieldType(type);
        if (HRStringUtils.equals((String)type, (String)"field")) {
            DynamicObject anObjFieldDy = groupFieldDy.getDynamicObject("anobjfield");
            QueryFieldBo queryFieldBo = loadQueryFieldMap.get(anObjFieldDy.getString("fieldalias"));
            if (queryFieldBo == null) {
                ArrayList queryFieldIds = Lists.newArrayListWithExpectedSize((int)1);
                queryFieldIds.add(anObjFieldDy.getLong("id"));
                List<QueryFieldBo> queryFieldBos = AnalyseObjectService.getInstance().queryAndAssembleQueryFields(queryFieldIds);
                queryFieldBo = queryFieldBos.get(0);
            }
            groupField.setAnObjField(queryFieldBo);
            groupField.setType(this.getDependQueryFieldTyp(queryFieldBo.getFieldAlias(), queryFieldBo.getValueType(), queryFieldBo.getComplexType(), queryFieldBo.getControlType()));
        }
        DynamicObjectCollection groupItemEntry = groupFieldDy.getDynamicObjectCollection("group");
        ArrayList groupItemList = Lists.newArrayListWithExpectedSize((int)groupItemEntry.size());
        for (DynamicObject groupItemDy : groupItemEntry) {
            AnObjGroupField.GroupItem groupItem = new AnObjGroupField.GroupItem();
            OrmLocaleValue itemName = (OrmLocaleValue)groupItemDy.getLocaleString("itemname");
            groupItem.setItemName(AnalyseObjectUtil.getLocaleString((OrmLocaleValue)itemName));
            groupItem.setItemNumber(groupItemDy.getString("itemnumber"));
            String itemCondition = groupItemDy.getString("itemcondition");
            itemCondition = this.transferItemConditionForGet(groupField, itemCondition, mainEntityTypeUtil);
            groupItem.setItemCondition(itemCondition);
            groupItem.setUnGroupItem(Boolean.valueOf(groupItemDy.getBoolean("isungroupitem")));
            groupItemList.add(groupItem);
        }
        groupField.setGroup((List)groupItemList);
        return groupField;
    }

    public String getDependQueryFieldTyp(String fieldAlias, String valueType, String complexType, String controlType) {
        boolean isBaseData;
        boolean bl = isBaseData = AnalyseObjectUtil.isBaseDataType((String)complexType) && (fieldAlias.endsWith(".name") || fieldAlias.endsWith(".number"));
        String type = AnalyseObjectUtil.isEnumType((String)controlType) ? "enum" : (isBaseData ? "baseData" : (HRStringUtils.equals((String)valueType, (String)DataTypeEnum.DATETIME.getDataTypeKey()) ? "datetime" : "number"));
        return type;
    }

    public void saveGroupFields(Long anObjId, List<AnObjGroupField> anObjGroupFields, List<QueryFieldBo> queryFields, List<CalculateFieldBo> calculatedFields) {
        DynamicObject[] groupFields = HELPER.loadDynamicObjectArray(new QFilter[]{new QFilter("anobj", "=", (Object)anObjId)});
        Map groupFieldMap = Arrays.stream(groupFields).collect(Collectors.toMap(field -> field.getString("id"), Function.identity()));
        List allIds = Arrays.stream(groupFields).map(field -> field.getString("id")).collect(Collectors.toList());
        DynamicObjectCollection saveCol = new DynamicObjectCollection();
        long newIdCount = anObjGroupFields.stream().filter(anObjGroupField -> HRStringUtils.isEmpty((String)anObjGroupField.getId())).count();
        long[] newIds = new long[1];
        int idIndex = 0;
        if (newIdCount > 0L) {
            newIds = ID.genLongIds((int)Integer.parseInt(String.valueOf(newIdCount)));
        }
        int index = 0;
        for (AnObjGroupField anObjGroupField2 : anObjGroupFields) {
            String id;
            DynamicObject groupFieldDy = (DynamicObject)groupFieldMap.get(anObjGroupField2.getId());
            DynamicObjectCollection groupItemEntry = new DynamicObjectCollection();
            if (groupFieldDy == null) {
                groupFieldDy = HELPER.generateEmptyDynamicObject();
                groupItemEntry = groupFieldDy.getDynamicObjectCollection("group");
                long newId = newIds[idIndex++];
                groupFieldDy.set("id", (Object)newId);
                anObjGroupField2.setId(String.valueOf(newId));
                groupFieldDy.set("number", (Object)anObjGroupField2.getNumber());
            }
            groupFieldDy.set("type", (Object)anObjGroupField2.getFieldType());
            if (HRStringUtils.equals((String)anObjGroupField2.getFieldType(), (String)"field")) {
                id = anObjGroupField2.getAnObjField().getId();
                if (HRStringUtils.isEmpty((String)id)) {
                    QueryFieldBo queryFieldBo = queryFields.stream().filter(field -> HRStringUtils.equals((String)anObjGroupField2.getAnObjField().getFieldAlias(), (String)field.getFieldAlias())).findFirst().get();
                    groupFieldDy.set("anobjfield", (Object)Long.parseLong(queryFieldBo.getId()));
                } else {
                    groupFieldDy.set("anobjfield", (Object)Long.parseLong(id));
                }
            } else {
                id = anObjGroupField2.getAnObjCalField().getId();
                if (HRStringUtils.isEmpty((String)id)) {
                    CalculateFieldBo calculateFieldBo = calculatedFields.stream().filter(field -> HRStringUtils.equals((String)anObjGroupField2.getAnObjCalField().getFieldNumber(), (String)field.getFieldNumber())).findFirst().get();
                    groupFieldDy.set("anobjcalfield", (Object)Long.parseLong(calculateFieldBo.getId()));
                } else {
                    groupFieldDy.set("anobjcalfield", (Object)Long.valueOf(id));
                }
            }
            groupFieldDy.set("name", (Object)anObjGroupField2.getName());
            for (AnObjGroupField.GroupItem groupItem : anObjGroupField2.getGroup()) {
                DynamicObject groupItemDy = HELPER.generateEmptyEntryDynamicObject("group");
                groupItemDy.set("itemname", (Object)groupItem.getItemName());
                groupItemDy.set("itemnumber", (Object)groupItem.getItemNumber());
                String itemCondition = groupItem.getItemCondition();
                itemCondition = this.transferItemConditionForSave(anObjGroupField2, itemCondition);
                groupItemDy.set("itemcondition", (Object)itemCondition);
                groupItemDy.set("isungroupitem", (Object)groupItem.getUnGroupItem());
                groupItemEntry.add((Object)groupItemDy);
            }
            groupFieldDy.set("group", (Object)groupItemEntry);
            groupFieldDy.set("anobj", (Object)anObjId);
            groupFieldDy.set("index", (Object)index++);
            saveCol.add((Object)groupFieldDy);
        }
        if (allIds.size() > 0) {
            List currentIDs = anObjGroupFields.stream().map(AnObjGroupField::getId).collect(Collectors.toList());
            allIds.removeAll(currentIDs);
            if (!allIds.isEmpty()) {
                HELPER.delete(allIds.stream().map(Long::parseLong).distinct().toArray());
            }
        }
        HELPER.save(saveCol);
    }

    public void deleteGroupFieldsByAnObjId(List<Object> anObjIds) {
        HELPER.deleteByFilter(new QFilter[]{new QFilter("anobj", "in", anObjIds)});
    }

    private String transferItemConditionForSave(AnObjGroupField anObjGroupField, String itemCondition) {
        if (HRStringUtils.isEmpty((String)itemCondition)) {
            return itemCondition;
        }
        if (HRStringUtils.equals((String)anObjGroupField.getType(), (String)"baseData") || HRStringUtils.equals((String)anObjGroupField.getType(), (String)"enum")) {
            List dataList = (List)JSON.parseObject((String)itemCondition, List.class);
            List ids = dataList.stream().map(map -> (String)map.get("id")).collect(Collectors.toList());
            return String.join((CharSequence)",", ids);
        }
        return itemCondition;
    }

    private String transferItemConditionForGet(AnObjGroupField anObjGroupField, String itemCondition, MainEntityTypeUtil mainEntityTypeUtil) {
        if (HRStringUtils.isEmpty((String)itemCondition)) {
            return itemCondition;
        }
        ArrayList dataList = Lists.newArrayListWithExpectedSize((int)10);
        if (HRStringUtils.equals((String)anObjGroupField.getType(), (String)"baseData")) {
            DynamicObjectCollection dys;
            String baseDataNum = anObjGroupField.getAnObjField().getBaseDataNum();
            HRBaseServiceHelper baseDataHelper = new HRBaseServiceHelper(baseDataNum);
            String baseDataIdType = anObjGroupField.getAnObjField().getBaseDataIdType();
            List strIds = Arrays.stream(itemCondition.split(",")).collect(Collectors.toList());
            if (!HRStringUtils.equals((String)baseDataIdType, (String)"string")) {
                List longIds = strIds.stream().map(Long::parseLong).collect(Collectors.toList());
                dys = baseDataHelper.queryOriginalCollection("id, name", new QFilter[]{new QFilter("id", "in", (Object)longIds)});
            } else {
                dys = baseDataHelper.queryOriginalCollection("id, name", new QFilter[]{new QFilter("id", "in", strIds)});
            }
            for (DynamicObject dy : dys) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)2);
                map.put("id", dy.getString("id"));
                map.put("name", dy.getString("name"));
                dataList.add(map);
            }
            return SerializationUtils.toJsonString((Object)dataList);
        }
        if (HRStringUtils.equals((String)anObjGroupField.getType(), (String)"enum")) {
            String fieldAlias;
            String baseDataNum = anObjGroupField.getAnObjField().getBaseDataNum();
            if (HRStringUtils.isEmpty((String)baseDataNum)) {
                baseDataNum = anObjGroupField.getAnObjField().getEntityNumber();
            }
            if ((fieldAlias = anObjGroupField.getAnObjField().getFieldAlias()).contains(".")) {
                fieldAlias = fieldAlias.substring(fieldAlias.lastIndexOf(".") + 1);
            }
            MainEntityType mainEntityType = mainEntityTypeUtil.getMainEntityType(baseDataNum);
            ComboProp comboProp = (ComboProp)mainEntityType.getAllFields().get(fieldAlias);
            List comboItems = comboProp.getComboItems();
            Map<String, String> idToNameMap = comboItems.stream().collect(Collectors.toMap(ValueMapItem::getValue, item -> item.getName().getLocaleValue()));
            List strIds = Arrays.stream(itemCondition.split(",")).collect(Collectors.toList());
            for (String strId : strIds) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)2);
                map.put("id", strId);
                map.put("name", idToNameMap.get(strId));
                dataList.add(map);
            }
            return SerializationUtils.toJsonString((Object)dataList);
        }
        return itemCondition;
    }
}

